<?php
/*
* Template Name: Compare Vehicles
*/

$cars_in_compare = array();
if ( ! empty( $_COOKIE['autoroyal_compare_ids'] ) ) {
    $cars_in_compare = $_COOKIE['autoroyal_compare_ids'];
}

$car_already_added_to_compare = '';
$car_compare_status           = esc_html__( 'Add to compare', 'autoroyal' );

$postID = get_the_ID();

if (has_post_thumbnail( $postID ) ) {
    $image = wp_get_attachment_image_src( get_post_thumbnail_id( $postID ), 'full' );
} else {
    $image = "";
}

get_header(); ?>

    <div class="autoroyal-front-dashboard compare-page">

        <div id="primary" class="content-area">

            <main id="main" class="site-main">

                <div class="autoroyal-page-title" <?php if(!empty($image)) { ?>style="background-image: url('<?php echo esc_url($image[0]); ?>')"<?php } ?>>

                    <div class="container">

                        <h2><?php the_title(); ?></h2>
                        
                    </div>

                </div>

                <div class="container">

                    <div class="row">

                        <div class="autoroyal-full-width-page col-md-12">

                            <?php

                                if (empty($_COOKIE['autoroyal_compare_ids'])) {
                                    $autoroyal_autoroyal_compare_ids = array();
                                } else {
                                    $autoroyal_autoroyal_compare_ids = $_COOKIE['autoroyal_compare_ids'];
                                }

                                $empty_listings = 3 - count($autoroyal_autoroyal_compare_ids);
                                $counter = 0;

                            if (!empty($autoroyal_autoroyal_compare_ids) or count($autoroyal_autoroyal_compare_ids) != 0): ?>
                                
                                <?php $args = array(
                                    'post_type' => 'vehicle',
                                    'post_status' => 'publish',
                                    'posts_per_page' => 3,
                                    'post__in' => $autoroyal_autoroyal_compare_ids,
                                );
                                $compares = new WP_Query($args);

                                if ($compares->have_posts()): ?>

                                    <div class="row listing-listing-row autoroyal-listing-compare-row d-none d-sm-flex">
                                        
                                        <div class="col-md-3 col-sm-3 d-none d-sm-inline-block"></div>

                                        <?php while ($compares->have_posts()): $compares->the_post(); $counter++; ?>

                                            <?php

                                                $car_ID = $post->ID;

                                                $vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
                                                $vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
                                                $vehicle_image_url = "";

                                                if(!empty($vehicle_image_gallery[0]['url'])) {

                                                    $vehicle_image_url = $vehicle_image_gallery[0]['url'];

                                                } elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

                                                    $vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

                                                }

                                                $vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
                                                if(!empty($vehicle_cover_image)) {
                                                    $vehicle_image_url = $vehicle_cover_image;
                                                }

                                                $vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
                                                $vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
                                                $vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));

                                                $vehicle_name = $vehicle_year . " " . $vehicle_make_desc_init . " " . $vehicle_model;

                                            ?>

                                            <!--Compare listing description-->
                                            <div class="d-sm-none d-sm-block col-md-3 col-sm-3 compare-col-autoroyal compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>">
                                                
                                                <a class="compare-vehicle-image" href="<?php the_permalink(); ?>" <?php if(!empty($vehicle_image_url)) { ?>style="background-image: url(<?php echo esc_url($vehicle_image_url); ?>);"<?php } ?>>
                                                    <?php if(empty($vehicle_image_url)) { ?>
                                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 181.6 120.2" style="enable-background:new 0 0 181.6 120.2;" xml:space="preserve">
                                                          <g>
                                                            <path class="st0" d="M181.2,53.6c-0.1-5.6-4.2-10.4-9.6-11.3l-7.5-1.7c-2.4-2.3-15.6-14.8-23.9-17.4c-5.7-1.8-13-1.6-20.2-1.5
                                                              c-0.2,0-0.5,0-0.7,0c-0.1,0-0.1,0-0.1,0L88,22.4c-17.7,0.4-33.8,7.5-46.6,20.6l-0.2,0c-0.3,0-0.6,0.1-0.8,0.2l-0.7,0.1
                                                              c-13,2.1-30.8,5-36.5,11.5C-1.2,59.6,0,70.2,0.7,76.4c0.1,1,0.2,1.9,0.3,2.6c0.4,4.2,3.7,7.5,7.9,7.8l0.5,0
                                                              c1.5,8.2,5.2,10.5,8.2,10.9c0,0,0,0,0,0c0,0,0,0,0,0l12.6,1.1c0,0,0.1,0,0.1,0c0.1,0,0.2,0,0.3-0.1c0.2,0,0.4,0,0.5,0
                                                              c0,0,0.1,0,0.1,0c3.5-0.1,6.5-3.9,7.9-10l22.6,1.5c1,8.7,5,14.2,10.3,14.2c0,0,0,0,0,0l12.8,1.5c0.1,0,0.1,0,0.2,0
                                                              c0.1,0,0.2,0,0.4-0.1c0.2,0,0.4,0,0.5,0c0,0,0.1,0,0.1,0c3.1-0.1,5.8-2.4,7.7-6.7c1.5-3.4,2.4-7.7,2.5-12.2l5.3-0.5
                                                              c1.6,2.2,3.4,3.5,5.4,3.5c0,0,0.1,0,0.1,0l12.1-0.2c0.1,0,0.2,0,0.3-0.1c0.2,0,0.3,0.1,0.5,0.1c0,0,0.1,0,0.1,0
                                                              c2.5-0.1,4.8-2.1,6.4-5.6l16.2-1.5c1,7.8,4.5,13.1,8.9,13.1c0,0,0.1,0,0.1,0l10.7-0.2c2.6-0.1,5-2,6.5-5.6c1.2-2.7,1.9-6.2,2-9.9
                                                              l0.2,0c5.9-0.6,10.5-5.7,10.4-11.6L181.2,53.6z M139.2,26.6c5.8,1.8,14.9,9.6,19.6,13.9L132,41.1c-0.4-6.9-2.1-12.8-3.1-15.8
                                                              C132.6,25.3,136.2,25.7,139.2,26.6z M120.1,25.3c2.3,0,4.6-0.1,6.8-0.1c1,2.7,2.8,8.8,3.2,15.9l-37,0.8
                                                              C98.9,32.3,109.8,25.5,120.1,25.3z M88,25.9l17.7-0.4c-6.9,3.6-13,9.4-16.6,16.4l-42.5,0.9C58.3,32.1,72.5,26.3,88,25.9z M17.9,96
                                                              c-4-0.6-5.8-4.9-6.6-9l11.3,0.8c0.9,4,2.4,7.2,4.3,9.1L17.9,96z M31.3,97.1C31.3,97.1,31.3,97.1,31.3,97.1c-2.8,0-5.5-3.7-6.8-9.2
                                                              l13,0.9C36.2,93.8,33.9,97.1,31.3,97.1z M72.5,101.1c0,0-0.1,0-0.1,0c0,0-0.1,0-0.1,0c0,0-0.1,0-0.1,0c-3.2,0-5.9-4.3-6.7-10.8
                                                              l10-1.1c0.5,5.2,2,9.6,4,12.7L72.5,101.1z M90.7,98c-1.3,2.9-2.9,4.5-4.5,4.5c-3.3,0.1-7.2-6.8-7.4-16.8c-0.1-4.7,0.7-9.2,2.2-12.5
                                                              c1.3-2.9,2.9-4.5,4.5-4.5c0,0,0,0,0,0c3.3,0,7.1,6.9,7.3,16.8C92.9,90.3,92.2,94.7,90.7,98z M107.1,88.4c-1.2,0.1-2.3-0.6-3.4-1.9
                                                              l10.3-1c0.7,1.1,1.4,2,2.1,2.7L107.1,88.4z M120.2,88.2c-1.4,0-2.8-1-4.1-2.8l8.5-0.8C123.3,86.8,121.8,88.1,120.2,88.2z
                                                               M151.8,92.3C151.8,92.3,151.8,92.3,151.8,92.3C151.7,92.3,151.7,92.3,151.8,92.3c-2.1,0-4.5-3.9-5.3-9.8l7-0.7
                                                              c0.3,3.2,1.1,6.2,2.3,8.5c0.3,0.7,0.7,1.3,1.1,1.9L151.8,92.3z M167.5,78.7C167.5,78.7,167.5,78.7,167.5,78.7
                                                              C167.5,78.7,167.5,78.7,167.5,78.7c0.1,3.8-0.5,7.3-1.7,10c-1,2.2-2.2,3.5-3.4,3.5c-1.1,0.1-2.4-1.2-3.5-3.3
                                                              c-1.3-2.6-2-6.1-2.1-9.9c-0.2-8.3,2.8-13.4,5.1-13.5c0,0,0,0,0,0C164.2,65.4,167.3,70.4,167.5,78.7
                                                              C167.5,78.7,167.5,78.7,167.5,78.7z M171,76.6c-0.7-8.5-4.4-14.7-9-14.7c0,0-0.1,0-0.1,0c-5,0.1-8.6,7.1-8.6,16.4l-57,5.4
                                                              c-0.7-10.8-5.2-18.6-10.9-18.5c-3.1,0.1-5.8,2.4-7.7,6.7c-1.7,3.8-2.5,8.7-2.5,13.9l-11.8,1.2L9.2,83.3c-2.5-0.2-4.4-2.1-4.6-4.5
                                                              C4.5,78,4.4,77.1,4.3,76c-0.6-5.3-1.8-15.2,1.5-18.9c4.9-5.5,22.7-8.4,34.4-10.3l2-0.3L163,44l7.9,1.8c3.8,0.7,6.7,4,6.8,7.9
                                                              l0.3,14.9C178.1,72.6,175,76.1,171,76.6z"></path>
                                                            <path class="st0" d="M55.6,61.5c-2.9,0.1-5.3,3.3-5.2,7.2c0,1.8,0.6,3.6,1.6,4.9c1,1.4,2.4,2.1,3.8,2.1c0,0,0.1,0,0.1,0
                                                              c2.9-0.1,5.3-3.3,5.2-7.2c0-1.8-0.6-3.6-1.6-4.9C58.5,62.2,57,61.5,55.6,61.5z M55.8,74c-0.8,0.1-1.8-0.5-2.5-1.4
                                                              c-0.8-1-1.2-2.4-1.2-3.9c-0.1-2.9,1.5-5.4,3.5-5.4c0,0,0,0,0,0c0.9,0,1.7,0.5,2.4,1.4c0.8,1,1.2,2.4,1.2,3.9
                                                              C59.4,71.5,57.8,73.9,55.8,74z"></path>
                                                            <path class="st0" d="M13.2,59.6c-1.2,0-2.4,0.7-3.2,1.9c-0.8,1.1-1.2,2.6-1.1,4.1c0.1,3.2,2.1,5.8,4.5,5.8c0,0,0,0,0.1,0
                                                              c2.5-0.1,4.4-2.7,4.3-6C17.7,62.1,15.7,59.6,13.2,59.6z M13.4,69.6c-1.5,0-2.7-1.8-2.8-4c0-1.1,0.3-2.2,0.8-3
                                                              c0.5-0.7,1.1-1.1,1.8-1.1c0,0,0,0,0,0c1.4,0,2.7,1.8,2.7,4C16.1,67.7,14.9,69.6,13.4,69.6z"></path>
                                                            <path class="st0" d="M134.8,47.2l-8.9,0.2c-0.5,0-0.9,0.4-0.9,0.9c0,0.5,0.4,0.9,0.9,0.9c0,0,0,0,0,0l8.9-0.2
                                                              c0.5,0,0.9-0.4,0.9-0.9C135.7,47.6,135.3,47.3,134.8,47.2z"></path>
                                                            <path class="st0" d="M159.7,46.7l-7.1,0.1c-0.5,0-0.9,0.4-0.9,0.9c0,0.5,0.4,0.9,0.9,0.9c0,0,0,0,0,0l7.1-0.1
                                                              c0.5,0,0.9-0.4,0.9-0.9C160.6,47.1,160.3,46.8,159.7,46.7z"></path>
                                                            <path class="st0" d="M43.8,67.3l-21.8-1.3c-0.5,0-0.9,0.3-0.9,0.8c0,0.5,0.3,0.9,0.8,0.9l21.8,1.3c0,0,0,0,0.1,0
                                                              c0.5,0,0.9-0.4,0.9-0.8C44.6,67.8,44.3,67.4,43.8,67.3z"></path>
                                                            <path class="st0" d="M39,70.1l-12.5-0.7c-0.5,0-0.9,0.3-0.9,0.8c0,0.5,0.3,0.9,0.8,0.9l12.5,0.7c0,0,0,0,0.1,0
                                                              c0.5,0,0.9-0.4,0.9-0.8C39.9,70.5,39.5,70.1,39,70.1z"></path>
                                                          </g>
                                                        </svg>
                                                    <?php } ?>
                                                </a>

                                                <a class="compare-vehicle-price" href="<?php the_permalink(); ?>">

                                                    <h4 class="vehicle-grid-title-v2">
                                                        <span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?>
                                                    </h4>

                                                </a>

                                                <?php 

                                                    $listing_id = $car_ID; 

                                                    if ( ! empty( $cars_in_compare ) and in_array( $listing_id, $cars_in_compare ) ) {
                                                        $car_compare_status           = esc_html__( 'Remove from compare', 'autoroyal' );
                                                    } else {
                                                        $car_compare_status           = esc_html__( 'Add to compare', 'autoroyal' );
                                                    }

                                                ?>

                                                <a href="#" class="fav-button btn btn-danger pull-right add-to-compare" data-id="<?php echo esc_attr($listing_id); ?>" data-title="<?php echo esc_attr($vehicle_name); ?>" data-toggle="tooltip" data-placement="top"  data-original-title="<?php echo esc_attr($car_compare_status); ?>">
                                                    <i class="fa fas fa-tachometer-alt" aria-hidden="true"></i>
                                                </a>

                                            </div> <!--md-3-->

                                        <?php endwhile; ?>

                                        <?php for ($i = 0; $i < $empty_listings; $i++) { ?>
                                            <div class="col-md-3 col-sm-3 compare-col-autoroyal-empty">
                                                
                                                <a class="compare-vehicle-image empty-slot" href="#">
                                                    <div class="vehicle-grid-image"><i class="fa fa-ban" aria-hidden="true"></i></div>
                                                </a>
                                                <div class="h4"><?php esc_html_e('Add listing to compare', 'autoroyal'); ?></div>

                                            </div>
                                        <?php } ?>

                                    </div> <!--row-->

                                <?php endif; ?>

                                <?php if ($compares->have_posts()): ?>
                                    <div class="row autoroyal-compare-row">
                                        <div class="d-none d-sm-inline-block col-md-3 col-sm-3">
                                            <div class="compare-options">
                                                <table>
                                                    <tr>
                                                        <td data-value="compare-value-price">
                                                            <?php esc_html_e('Price', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-condition">
                                                            <?php esc_html_e('Condition', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-body-style">
                                                            <?php esc_html_e('Body Style', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-status">
                                                            <?php esc_html_e('Seats', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-doors">
                                                            <?php esc_html_e('Doors', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-interior">
                                                            <?php esc_html_e('Interior', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-mileage">
                                                            <?php esc_html_e('Mileage', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-fule-type">
                                                            <?php esc_html_e('Fuel Type', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-engine-volume">
                                                            <?php esc_html_e('Engine volume (L)', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-power-hp">
                                                            <?php esc_html_e('Power (hp)', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-power-kw">
                                                            <?php esc_html_e('Power (kw)', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-transmission">
                                                            <?php esc_html_e('Transmission', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-drive">
                                                            <?php esc_html_e('Drive', 'autoroyal'); ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-fuel-consumption">
                                                            <?php 
                                                                esc_html_e('Fuel consumption', 'autoroyal'); 
                                                                $measurement_type = get_option( 'autoroyal_measurement_type' ); 
                                                                if($measurement_type == "metric") { 
                                                                    esc_html_e('l/100km', 'autoroyal' ); 
                                                                } else { 
                                                                    esc_html_e('mpg', 'autoroyal' ); 
                                                                } 
                                                            ?>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>

                                        <?php while ($compares->have_posts()): $compares->the_post(); ?>

                                            <?php

                                                $car_ID = $post->ID;

                                                $vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
                                                $vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
                                                $vehicle_image_url = "";

                                                if(!empty($vehicle_image_gallery[0]['url'])) {

                                                    $vehicle_image_url = $vehicle_image_gallery[0]['url'];

                                                } elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

                                                    $vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

                                                }

                                                $vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
                                                if(!empty($vehicle_cover_image)) {
                                                    $vehicle_image_url = $vehicle_cover_image;
                                                }

                                                $vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
                                                $vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
                                                $vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));

                                                $vehicle_name = $vehicle_year . " " . $vehicle_make_desc_init . " " . $vehicle_model;

                                            ?>

                                            <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>">
                                                
                                                <div class="d-sm-none visible-sm compare-vehicle-visible">
                                                    
                                                    <a class="compare-vehicle-image" href="<?php the_permalink(); ?>" <?php if(!empty($vehicle_image_url)) { ?>style="background-image: url(<?php echo esc_url($vehicle_image_url); ?>);"<?php } ?>>
                                                        <?php if(empty($vehicle_image_url)) { ?>
                                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 181.6 120.2" style="enable-background:new 0 0 181.6 120.2;" xml:space="preserve">
                                                              <g>
                                                                <path class="st0" d="M181.2,53.6c-0.1-5.6-4.2-10.4-9.6-11.3l-7.5-1.7c-2.4-2.3-15.6-14.8-23.9-17.4c-5.7-1.8-13-1.6-20.2-1.5
                                                                  c-0.2,0-0.5,0-0.7,0c-0.1,0-0.1,0-0.1,0L88,22.4c-17.7,0.4-33.8,7.5-46.6,20.6l-0.2,0c-0.3,0-0.6,0.1-0.8,0.2l-0.7,0.1
                                                                  c-13,2.1-30.8,5-36.5,11.5C-1.2,59.6,0,70.2,0.7,76.4c0.1,1,0.2,1.9,0.3,2.6c0.4,4.2,3.7,7.5,7.9,7.8l0.5,0
                                                                  c1.5,8.2,5.2,10.5,8.2,10.9c0,0,0,0,0,0c0,0,0,0,0,0l12.6,1.1c0,0,0.1,0,0.1,0c0.1,0,0.2,0,0.3-0.1c0.2,0,0.4,0,0.5,0
                                                                  c0,0,0.1,0,0.1,0c3.5-0.1,6.5-3.9,7.9-10l22.6,1.5c1,8.7,5,14.2,10.3,14.2c0,0,0,0,0,0l12.8,1.5c0.1,0,0.1,0,0.2,0
                                                                  c0.1,0,0.2,0,0.4-0.1c0.2,0,0.4,0,0.5,0c0,0,0.1,0,0.1,0c3.1-0.1,5.8-2.4,7.7-6.7c1.5-3.4,2.4-7.7,2.5-12.2l5.3-0.5
                                                                  c1.6,2.2,3.4,3.5,5.4,3.5c0,0,0.1,0,0.1,0l12.1-0.2c0.1,0,0.2,0,0.3-0.1c0.2,0,0.3,0.1,0.5,0.1c0,0,0.1,0,0.1,0
                                                                  c2.5-0.1,4.8-2.1,6.4-5.6l16.2-1.5c1,7.8,4.5,13.1,8.9,13.1c0,0,0.1,0,0.1,0l10.7-0.2c2.6-0.1,5-2,6.5-5.6c1.2-2.7,1.9-6.2,2-9.9
                                                                  l0.2,0c5.9-0.6,10.5-5.7,10.4-11.6L181.2,53.6z M139.2,26.6c5.8,1.8,14.9,9.6,19.6,13.9L132,41.1c-0.4-6.9-2.1-12.8-3.1-15.8
                                                                  C132.6,25.3,136.2,25.7,139.2,26.6z M120.1,25.3c2.3,0,4.6-0.1,6.8-0.1c1,2.7,2.8,8.8,3.2,15.9l-37,0.8
                                                                  C98.9,32.3,109.8,25.5,120.1,25.3z M88,25.9l17.7-0.4c-6.9,3.6-13,9.4-16.6,16.4l-42.5,0.9C58.3,32.1,72.5,26.3,88,25.9z M17.9,96
                                                                  c-4-0.6-5.8-4.9-6.6-9l11.3,0.8c0.9,4,2.4,7.2,4.3,9.1L17.9,96z M31.3,97.1C31.3,97.1,31.3,97.1,31.3,97.1c-2.8,0-5.5-3.7-6.8-9.2
                                                                  l13,0.9C36.2,93.8,33.9,97.1,31.3,97.1z M72.5,101.1c0,0-0.1,0-0.1,0c0,0-0.1,0-0.1,0c0,0-0.1,0-0.1,0c-3.2,0-5.9-4.3-6.7-10.8
                                                                  l10-1.1c0.5,5.2,2,9.6,4,12.7L72.5,101.1z M90.7,98c-1.3,2.9-2.9,4.5-4.5,4.5c-3.3,0.1-7.2-6.8-7.4-16.8c-0.1-4.7,0.7-9.2,2.2-12.5
                                                                  c1.3-2.9,2.9-4.5,4.5-4.5c0,0,0,0,0,0c3.3,0,7.1,6.9,7.3,16.8C92.9,90.3,92.2,94.7,90.7,98z M107.1,88.4c-1.2,0.1-2.3-0.6-3.4-1.9
                                                                  l10.3-1c0.7,1.1,1.4,2,2.1,2.7L107.1,88.4z M120.2,88.2c-1.4,0-2.8-1-4.1-2.8l8.5-0.8C123.3,86.8,121.8,88.1,120.2,88.2z
                                                                   M151.8,92.3C151.8,92.3,151.8,92.3,151.8,92.3C151.7,92.3,151.7,92.3,151.8,92.3c-2.1,0-4.5-3.9-5.3-9.8l7-0.7
                                                                  c0.3,3.2,1.1,6.2,2.3,8.5c0.3,0.7,0.7,1.3,1.1,1.9L151.8,92.3z M167.5,78.7C167.5,78.7,167.5,78.7,167.5,78.7
                                                                  C167.5,78.7,167.5,78.7,167.5,78.7c0.1,3.8-0.5,7.3-1.7,10c-1,2.2-2.2,3.5-3.4,3.5c-1.1,0.1-2.4-1.2-3.5-3.3
                                                                  c-1.3-2.6-2-6.1-2.1-9.9c-0.2-8.3,2.8-13.4,5.1-13.5c0,0,0,0,0,0C164.2,65.4,167.3,70.4,167.5,78.7
                                                                  C167.5,78.7,167.5,78.7,167.5,78.7z M171,76.6c-0.7-8.5-4.4-14.7-9-14.7c0,0-0.1,0-0.1,0c-5,0.1-8.6,7.1-8.6,16.4l-57,5.4
                                                                  c-0.7-10.8-5.2-18.6-10.9-18.5c-3.1,0.1-5.8,2.4-7.7,6.7c-1.7,3.8-2.5,8.7-2.5,13.9l-11.8,1.2L9.2,83.3c-2.5-0.2-4.4-2.1-4.6-4.5
                                                                  C4.5,78,4.4,77.1,4.3,76c-0.6-5.3-1.8-15.2,1.5-18.9c4.9-5.5,22.7-8.4,34.4-10.3l2-0.3L163,44l7.9,1.8c3.8,0.7,6.7,4,6.8,7.9
                                                                  l0.3,14.9C178.1,72.6,175,76.1,171,76.6z"></path>
                                                                <path class="st0" d="M55.6,61.5c-2.9,0.1-5.3,3.3-5.2,7.2c0,1.8,0.6,3.6,1.6,4.9c1,1.4,2.4,2.1,3.8,2.1c0,0,0.1,0,0.1,0
                                                                  c2.9-0.1,5.3-3.3,5.2-7.2c0-1.8-0.6-3.6-1.6-4.9C58.5,62.2,57,61.5,55.6,61.5z M55.8,74c-0.8,0.1-1.8-0.5-2.5-1.4
                                                                  c-0.8-1-1.2-2.4-1.2-3.9c-0.1-2.9,1.5-5.4,3.5-5.4c0,0,0,0,0,0c0.9,0,1.7,0.5,2.4,1.4c0.8,1,1.2,2.4,1.2,3.9
                                                                  C59.4,71.5,57.8,73.9,55.8,74z"></path>
                                                                <path class="st0" d="M13.2,59.6c-1.2,0-2.4,0.7-3.2,1.9c-0.8,1.1-1.2,2.6-1.1,4.1c0.1,3.2,2.1,5.8,4.5,5.8c0,0,0,0,0.1,0
                                                                  c2.5-0.1,4.4-2.7,4.3-6C17.7,62.1,15.7,59.6,13.2,59.6z M13.4,69.6c-1.5,0-2.7-1.8-2.8-4c0-1.1,0.3-2.2,0.8-3
                                                                  c0.5-0.7,1.1-1.1,1.8-1.1c0,0,0,0,0,0c1.4,0,2.7,1.8,2.7,4C16.1,67.7,14.9,69.6,13.4,69.6z"></path>
                                                                <path class="st0" d="M134.8,47.2l-8.9,0.2c-0.5,0-0.9,0.4-0.9,0.9c0,0.5,0.4,0.9,0.9,0.9c0,0,0,0,0,0l8.9-0.2
                                                                  c0.5,0,0.9-0.4,0.9-0.9C135.7,47.6,135.3,47.3,134.8,47.2z"></path>
                                                                <path class="st0" d="M159.7,46.7l-7.1,0.1c-0.5,0-0.9,0.4-0.9,0.9c0,0.5,0.4,0.9,0.9,0.9c0,0,0,0,0,0l7.1-0.1
                                                                  c0.5,0,0.9-0.4,0.9-0.9C160.6,47.1,160.3,46.8,159.7,46.7z"></path>
                                                                <path class="st0" d="M43.8,67.3l-21.8-1.3c-0.5,0-0.9,0.3-0.9,0.8c0,0.5,0.3,0.9,0.8,0.9l21.8,1.3c0,0,0,0,0.1,0
                                                                  c0.5,0,0.9-0.4,0.9-0.8C44.6,67.8,44.3,67.4,43.8,67.3z"></path>
                                                                <path class="st0" d="M39,70.1l-12.5-0.7c-0.5,0-0.9,0.3-0.9,0.8c0,0.5,0.3,0.9,0.8,0.9l12.5,0.7c0,0,0,0,0.1,0
                                                                  c0.5,0,0.9-0.4,0.9-0.8C39.9,70.5,39.5,70.1,39,70.1z"></path>
                                                              </g>
                                                            </svg>
                                                        <?php } ?>
                                                    </a>

                                                    <a class="compare-vehicle-price" href="<?php the_permalink(); ?>">

                                                        <h4 class="vehicle-grid-title-v2">
                                                            <span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?>
                                                        </h4>

                                                    </a>

                                                    <?php 

                                                        $listing_id = $car_ID; 

                                                        if ( ! empty( $cars_in_compare ) and in_array( $listing_id, $cars_in_compare ) ) {
                                                            $car_compare_status           = esc_html__( 'Remove from compare', 'autoroyal' );
                                                        } else {
                                                            $car_compare_status           = esc_html__( 'Add to compare', 'autoroyal' );
                                                        }

                                                    ?>

                                                    <a href="#" class="fav-button btn btn-danger pull-right add-to-compare" data-id="<?php echo esc_attr($listing_id); ?>" data-title="<?php echo esc_attr($vehicle_name); ?>" data-toggle="tooltip" data-placement="top"  data-original-title="<?php echo esc_attr($car_compare_status); ?>">
                                                        <i class="fas fa-tachometer-alt" aria-hidden="true"></i>
                                                    </a>

                                                </div>
                                                <div class="compare-values">
                                                    <?php $post_meta_data = get_post_custom(get_the_ID()); ?>
                                                    <table>
                                                        <tr>
                                                            <td data-value="compare-value-price" class="compare-vehicles-price">
                                                                <?php
                                                                    $price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));
                                                                    if ( $price ){
                                                                        echo autoroyal_clean_price($price);
                                                                    } else {
                                                                        esc_html_e("N/A","autoroyal");
                                                                    }

                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-condition">
                                                                <?php
                                                                    $current_vehicle_condition = esc_attr(get_post_meta($car_ID, 'vehicle_condition',true));
                                                                    if( !empty($current_vehicle_condition) ) {
                                                                        echo esc_attr($current_vehicle_condition);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-body-style">
                                                                <?php
                                                                    $current_terms_vehicle_body_style = "";
                                                                    $current_vehicle_body_style = get_the_terms($car_ID, 'vehicle_body_style' );
                                                                    if ($current_vehicle_body_style && ! is_wp_error($current_vehicle_body_style)) :
                                                                        $term_vehicle_body_style = array();
                                                                            foreach ($current_vehicle_body_style as $term_cat) {
                                                                                $term_vehicle_body_style[] = $term_cat->name;
                                                                            }
                                                                        $current_terms_vehicle_body_style = join( " ", $term_vehicle_body_style);
                                                                    endif;
                                                                    if( !empty($current_terms_vehicle_body_style) ) {
                                                                        echo esc_attr($current_terms_vehicle_body_style);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-seats">
                                                                <?php
                                                                    $current_vehicle_seats = esc_attr(get_post_meta($car_ID, 'vehicle_seats',true));
                                                                    if( !empty($current_vehicle_seats) ) {
                                                                        echo esc_attr($current_vehicle_seats);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-doors">
                                                                <?php
                                                                    $current_vehicle_doors = esc_attr(get_post_meta($car_ID, 'vehicle_doors',true));
                                                                    if( !empty($current_vehicle_doors) ) {
                                                                        echo esc_attr($current_vehicle_doors);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-interior">
                                                                <?php
                                                                    $current_terms_vehicle_body_style = "";
                                                                    $current_vehicle_body_style = get_the_terms($car_ID, 'vehicle_interior_material' );
                                                                    if ($current_vehicle_body_style && ! is_wp_error($current_vehicle_body_style)) :
                                                                        $term_vehicle_body_style = array();
                                                                            foreach ($current_vehicle_body_style as $term_cat) {
                                                                                $term_vehicle_body_style[] = $term_cat->name;
                                                                            }
                                                                        $current_terms_vehicle_body_style = join( " ", $term_vehicle_body_style);
                                                                    endif;
                                                                    if( !empty($current_terms_vehicle_body_style) ) {
                                                                        echo esc_attr($current_terms_vehicle_body_style);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-mileage">
                                                                <?php
                                                                    $current_vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));
                                                                    $current_vehicle_meta_mileage = "";
                                                                    if(!empty($current_vehicle_mileage)) { 
                                                                        $current_vehicle_meta_mileage .= autoroyal_number($current_vehicle_mileage); 
                                                                        $unit_system = get_option( 'autoroyal_measurement_type' ); 
                                                                        if( empty($unit_system) OR $unit_system == "metric") { 
                                                                            $current_vehicle_meta_mileage .= " "; 
                                                                            $current_vehicle_meta_mileage .= __('Km', 'autoroyal' );
                                                                        } else { 
                                                                            $current_vehicle_meta_mileage .= " "; 
                                                                            $current_vehicle_meta_mileage .= __('Mi', 'autoroyal' );
                                                                        } 
                                                                    }
                                                                    if(!empty($current_vehicle_meta_mileage)) {
                                                                        echo esc_attr($current_vehicle_meta_mileage);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-fule-type">
                                                                <?php
                                                                    $current_terms_vehicle_body_style = "";
                                                                    $current_vehicle_body_style = get_the_terms($car_ID, 'vehicle_fuel_type' );
                                                                    if ($current_vehicle_body_style && ! is_wp_error($current_vehicle_body_style)) :
                                                                        $term_vehicle_body_style = array();
                                                                            foreach ($current_vehicle_body_style as $term_cat) {
                                                                                $term_vehicle_body_style[] = $term_cat->name;
                                                                            }
                                                                        $current_terms_vehicle_body_style = join( " ", $term_vehicle_body_style);
                                                                    endif;
                                                                    if( !empty($current_terms_vehicle_body_style) ) {
                                                                        echo esc_attr($current_terms_vehicle_body_style);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-engine-volume">
                                                                <?php
                                                                
                                                                    $current_vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));
                                                                    if( !empty($current_vehicle_engine_volume_l) ) {
                                                                        echo esc_attr($current_vehicle_engine_volume_l);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }

                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-power-hp">
                                                                <?php

                                                                    $current_vehicle_power_hp = esc_attr(get_post_meta($car_ID, 'vehicle_power_hp',true));
                                                                    if( !empty($current_vehicle_power_hp) ) {
                                                                        echo esc_attr($current_vehicle_power_hp);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }

                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-power-kw">
                                                                <?php

                                                                    $current_vehicle_power_kw = esc_attr(get_post_meta($car_ID, 'vehicle_power_kw',true));
                                                                    if( !empty($current_vehicle_power_kw) ) {
                                                                        echo esc_attr($current_vehicle_power_kw);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }

                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-transmission">
                                                                <?php
                                                                    $current_terms_vehicle_body_style = "";
                                                                    $current_vehicle_body_style = get_the_terms($car_ID, 'vehicle_transmission' );
                                                                    if ($current_vehicle_body_style && ! is_wp_error($current_vehicle_body_style)) :
                                                                        $term_vehicle_body_style = array();
                                                                            foreach ($current_vehicle_body_style as $term_cat) {
                                                                                $term_vehicle_body_style[] = $term_cat->name;
                                                                            }
                                                                        $current_terms_vehicle_body_style = join( " ", $term_vehicle_body_style);
                                                                    endif;
                                                                    if( !empty($current_terms_vehicle_body_style) ) {
                                                                        echo esc_attr($current_terms_vehicle_body_style);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-drive">
                                                                <?php
                                                                    $current_terms_vehicle_body_style = "";
                                                                    $current_vehicle_body_style = get_the_terms($car_ID, 'vehicle_drive' );
                                                                    if ($current_vehicle_body_style && ! is_wp_error($current_vehicle_body_style)) :
                                                                        $term_vehicle_body_style = array();
                                                                            foreach ($current_vehicle_body_style as $term_cat) {
                                                                                $term_vehicle_body_style[] = $term_cat->name;
                                                                            }
                                                                        $current_terms_vehicle_body_style = join( " ", $term_vehicle_body_style);
                                                                    endif;
                                                                    if( !empty($current_terms_vehicle_body_style) ) {
                                                                        echo esc_attr($current_terms_vehicle_body_style);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td data-value="compare-value-fuel-consumption">
                                                                <?php
                                                                    $current_vehicle_consumption_combined = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_combined',true));
                                                                    if( !empty($current_vehicle_consumption_combined) ) {
                                                                        echo esc_attr($current_vehicle_consumption_combined);
                                                                    } else {
                                                                        echo esc_html_e("N/A","autoroyal");
                                                                    }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                                <div class="d-sm-none visible-sm compare-vehicle-visible compare-vehicle-visible-additional-info">

                                                    <h4 class="autoroyal-compare-features"><?php esc_html_e('Safety', 'autoroyal'); ?></h4>

                                                    <?php 

                                                        $vehicle_safety = wp_get_post_terms( $car_ID, 'vehicle_safety', array( 'orderby' => 'name', 'order' => 'ASC') ); 
                                                        if( $vehicle_safety && ! is_wp_error($vehicle_safety) ) { 
                                                            ?><ul class="compare-list-style"><?php

                                                            foreach ($vehicle_safety as $vehicle_safety_item) {
                                                                $nume_cat = $vehicle_safety_item->name;
                                                                $id_cat = $vehicle_safety_item->term_id;
                                                            ?>
                                                                <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($nume_cat); ?></li>
                                                            <?php

                                                            } 
                                                            ?></ul><?php
                                                        } 
                                                    ?>
                                                    
                                                </div>
                                                <div class="d-sm-none visible-sm compare-vehicle-visible compare-vehicle-visible-additional-info">

                                                    <h4 class="autoroyal-compare-features"><?php esc_html_e('Comfort', 'autoroyal'); ?></h4>

                                                    <?php 

                                                        $vehicle_comfort = wp_get_post_terms( $car_ID, 'vehicle_comfort', array( 'orderby' => 'name', 'order' => 'ASC') ); 
                                                        if( $vehicle_comfort && ! is_wp_error($vehicle_comfort) ) { 
                                                            ?><ul class="compare-list-style"><?php

                                                            foreach ($vehicle_comfort as $vehicle_comfort_item) {
                                                                $nume_cat = $vehicle_comfort_item->name;
                                                                $id_cat = $vehicle_comfort_item->term_id;
                                                            ?>
                                                                <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($nume_cat); ?></li>
                                                            <?php

                                                            } 
                                                            ?></ul><?php
                                                        } 
                                                    ?>
                                                    
                                                </div>
                                                <div class="d-sm-none visible-sm compare-vehicle-visible compare-vehicle-visible-additional-info">

                                                    <h4 class="autoroyal-compare-features"><?php esc_html_e('Visibility', 'autoroyal'); ?></h4>

                                                    <?php 

                                                        $vehicle_visibility = wp_get_post_terms( $car_ID, 'vehicle_visibility', array( 'orderby' => 'name', 'order' => 'ASC') ); 
                                                        if( $vehicle_visibility && ! is_wp_error($vehicle_comfort) ) { 
                                                            ?><ul class="compare-list-style"><?php

                                                            foreach ($vehicle_visibility as $vehicle_visibility_item) {
                                                                $nume_cat = $vehicle_visibility_item->name;
                                                                $id_cat = $vehicle_visibility_item->term_id;
                                                            ?>
                                                                <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($nume_cat); ?></li>
                                                            <?php

                                                            } 
                                                            ?></ul><?php
                                                        } 
                                                    ?>
                                                    
                                                </div>
                                                <div class="d-sm-none visible-sm compare-vehicle-visible compare-vehicle-visible-additional-info">

                                                    <h4 class="autoroyal-compare-features"><?php esc_html_e('Multimedia', 'autoroyal'); ?></h4>

                                                    <?php 

                                                        $vehicle_multimedia = wp_get_post_terms( $car_ID, 'vehicle_multimedia', array( 'orderby' => 'name', 'order' => 'ASC') ); 
                                                        if( $vehicle_multimedia && ! is_wp_error($vehicle_multimedia) ) { 
                                                            ?><ul class="compare-list-style"><?php

                                                            foreach ($vehicle_multimedia as $vehicle_multimedia_item) {
                                                                $nume_cat = $vehicle_multimedia_item->name;
                                                                $id_cat = $vehicle_multimedia_item->term_id;
                                                            ?>
                                                                <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($nume_cat); ?></li>
                                                            <?php

                                                            } 
                                                            ?></ul><?php
                                                        } 
                                                    ?>
                                                    
                                                </div>
                                                <div class="d-sm-none visible-sm compare-vehicle-visible compare-vehicle-visible-additional-info">

                                                    <h4 class="autoroyal-compare-features"><?php esc_html_e('Exterior', 'autoroyal'); ?></h4>

                                                    <?php 

                                                        $vehicle_exterior = wp_get_post_terms( $car_ID, 'vehicle_exterior', array( 'orderby' => 'name', 'order' => 'ASC') ); 
                                                        if( $vehicle_exterior && ! is_wp_error($vehicle_exterior) ) { 
                                                            ?><ul class="compare-list-style"><?php

                                                            foreach ($vehicle_exterior as $vehicle_exterior_item) {
                                                                $nume_cat = $vehicle_exterior_item->name;
                                                                $id_cat = $vehicle_exterior_item->term_id;
                                                            ?>
                                                                <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($nume_cat); ?></li>
                                                            <?php

                                                            } 
                                                            ?></ul><?php
                                                        } 
                                                    ?>
                                                    
                                                </div>
                                                <div class="d-sm-none visible-sm compare-vehicle-visible compare-vehicle-visible-additional-info">

                                                    <h4 class="autoroyal-compare-features"><?php esc_html_e('Interior', 'autoroyal'); ?></h4>

                                                    <?php 

                                                        $vehicle_interior = wp_get_post_terms( $car_ID, 'vehicle_interior', array( 'orderby' => 'name', 'order' => 'ASC') ); 
                                                        if( $vehicle_interior && ! is_wp_error($vehicle_interior) ) { 
                                                            ?><ul class="compare-list-style"><?php

                                                            foreach ($vehicle_interior as $vehicle_interior_item) {
                                                                $nume_cat = $vehicle_interior_item->name;
                                                                $id_cat = $vehicle_interior_item->term_id;
                                                            ?>
                                                                <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($nume_cat); ?></li>
                                                            <?php

                                                            } 
                                                            ?></ul><?php
                                                        } 
                                                    ?>
                                                    
                                                </div>
                                            </div> <!--md-3-->
                                        <?php endwhile; ?>
                                        <?php for ($i = 0; $i < $empty_listings; $i++) { ?>
                                            <div class="d-none d-sm-inline-block col-md-3 col-sm-3">
                                                <div class="compare-options">
                                                    <table>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                        <tr>
                                                            <td>&nbsp;</td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    </div> <!--row-->
                                <?php endif; ?>
                                <?php wp_reset_postdata(); ?>

                            <?php else: //If empty listings, just everything without listings =) ?>
                                <div class="row listing-listing-row autoroyal-listing-compare-row">
                                    <div class="d-none d-sm-inline-block d-inline-block col-md-3 col-sm-3"></div>
                                    <?php for ($i = 0; $i < $empty_listings; $i++) { ?>
                                        <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-empty">
                                                
                                            <a class="compare-vehicle-image empty-slot" href="#">

                                                <div class="vehicle-grid-image"><i class="fa fa-ban" aria-hidden="true"></i></div>
                                                <div class="h4"><?php esc_html_e('Add vehicle to compare', 'autoroyal'); ?></div>

                                            </a>

                                        </div>
                                    <?php } ?>
                                </div> <!--row-->
                                <div class="row autoroyal-compare-row">
                                    <div class="d-inline-block col-md-3 col-sm-3 d-none d-sm-inline-block">
                                        <div class="compare-options">
                                            <table>
                                                <tr>
                                                    <td data-value="compare-value-price">
                                                        <?php esc_html_e('Price', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-condition">
                                                        <?php esc_html_e('Condition', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-body-style">
                                                        <?php esc_html_e('Body Style', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-seats">
                                                        <?php esc_html_e('Seats', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-doors">
                                                        <?php esc_html_e('Doors', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-interior">
                                                        <?php esc_html_e('Interior', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-mileage">
                                                        <?php esc_html_e('Mileage', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-fule-type">
                                                        <?php esc_html_e('Fuel Type', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-engine-volume">
                                                        <?php esc_html_e('Engine volume (L)', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-power-hp">
                                                        <?php esc_html_e('Power (hp)', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-power-kw">
                                                        <?php esc_html_e('Power (kw)', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-transmission">
                                                        <?php esc_html_e('Transmission', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-drive">
                                                        <?php esc_html_e('Drive', 'autoroyal'); ?>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td data-value="compare-value-fuel-consumption">
                                                        <?php 
                                                            esc_html_e('Fuel consumption', 'autoroyal'); 
                                                            $measurement_type = get_option( 'autoroyal_measurement_type' ); 
                                                            if($measurement_type == "metric") { 
                                                                esc_html_e('l/100km', 'autoroyal' ); 
                                                            } else { 
                                                                esc_html_e('mpg', 'autoroyal' ); 
                                                            } 
                                                        ?>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                    <?php for ($i = 0; $i < $empty_listings; $i++) { ?>
                                        <div class="d-inline-block col-md-3 col-sm-3">
                                            <div class="compare-options">
                                                <table>
                                                    <tr>
                                                        <td data-value="compare-value-condition">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-body-style">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-seats">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-doors">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-interior">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-mileage">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-fule-type">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-engine-volume">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-power-hp">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-power-kw">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-transmisiion">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-drive">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td data-value="compare-value-fuel-consumption">
                                                            &nbsp;
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div> <!--row-->
                            <?php endif; ?>

                            <!-- Safety -->
                            <?php if (!empty($compares)): ?>
                                <?php if ($compares->have_posts()): ?>
                                    <div class="row row-compare-features">
                                        <div class="d-inline-block col-md-3 col-sm-3">
                                            <h4 class="autoroyal-compare-features"><?php esc_html_e('Safety', 'autoroyal'); ?></h4>
                                        </div>
                                        <?php while ($compares->have_posts()): $compares->the_post(); ?>
                                            <?php $vehicle_safety = wp_get_post_terms( get_the_ID(), 'vehicle_safety', array( 'orderby' => 'name', 'order' => 'ASC') );  ?>
                                            <?php if( $vehicle_safety && ! is_wp_error($vehicle_safety) ) { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>">
                                                    <ul class="compare-list-style">
                                                        <?php foreach ($vehicle_safety as $vehicle_safety_item): ?>
                                                            <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($vehicle_safety_item->name); ?></li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </div>
                                            <?php } else { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>"></div>
                                            <?php } ?>
                                        <?php endwhile; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <!-- Comfort -->
                            <?php if (!empty($compares)): ?>
                                <?php if ($compares->have_posts()): ?>
                                    <div class="row row-compare-features">
                                        <div class="d-inline-block col-md-3 col-sm-3">
                                            <h4 class="autoroyal-compare-features"><?php esc_html_e('Comfort', 'autoroyal'); ?></h4>
                                        </div>
                                        <?php while ($compares->have_posts()): $compares->the_post(); ?>
                                            <?php $vehicle_comfort = wp_get_post_terms( get_the_ID(), 'vehicle_comfort', array( 'orderby' => 'name', 'order' => 'ASC') );  ?>
                                            <?php if( $vehicle_comfort && ! is_wp_error($vehicle_comfort) ) { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>">
                                                    <ul class="compare-list-style">
                                                        <?php foreach ($vehicle_comfort as $vehicle_comfort_item): ?>
                                                            <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($vehicle_comfort_item->name); ?></li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </div>
                                            <?php } else { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>"></div>
                                            <?php } ?>
                                        <?php endwhile; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <!-- Visibility -->
                            <?php if (!empty($compares)): ?>
                                <?php if ($compares->have_posts()): ?>
                                    <div class="row row-compare-features">
                                        <div class="d-inline-block col-md-3 col-sm-3">
                                            <h4 class="autoroyal-compare-features"><?php esc_html_e('Visibility', 'autoroyal'); ?></h4>
                                        </div>
                                        <?php while ($compares->have_posts()): $compares->the_post(); ?>
                                            <?php $vehicle_visibility = wp_get_post_terms( get_the_ID(), 'vehicle_visibility', array( 'orderby' => 'name', 'order' => 'ASC') );  ?>
                                            <?php if( $vehicle_visibility && ! is_wp_error($vehicle_visibility) ) { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>">
                                                    <ul class="compare-list-style">
                                                        <?php foreach ($vehicle_visibility as $vehicle_visibility_item): ?>
                                                            <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($vehicle_visibility_item->name); ?></li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </div>
                                            <?php } else { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>"></div>
                                            <?php } ?>
                                        <?php endwhile; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <!-- Multimedia -->
                            <?php if (!empty($compares)): ?>
                                <?php if ($compares->have_posts()): ?>
                                    <div class="row row-compare-features">
                                        <div class="d-inline-block col-md-3 col-sm-3">
                                            <h4 class="autoroyal-compare-features"><?php esc_html_e('Multimedia', 'autoroyal'); ?></h4>
                                        </div>
                                        <?php while ($compares->have_posts()): $compares->the_post(); ?>
                                            <?php $vehicle_multimedia = wp_get_post_terms( get_the_ID(), 'vehicle_multimedia', array( 'orderby' => 'name', 'order' => 'ASC') );  ?>
                                            <?php if( $vehicle_multimedia && ! is_wp_error($vehicle_multimedia) ) { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>">
                                                    <ul class="compare-list-style">
                                                        <?php foreach ($vehicle_multimedia as $vehicle_multimedia_item): ?>
                                                            <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($vehicle_multimedia_item->name); ?></li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </div>
                                            <?php } else { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>"></div>
                                            <?php } ?>
                                        <?php endwhile; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <!-- Exterior -->
                            <?php if (!empty($compares)): ?>
                                <?php if ($compares->have_posts()): ?>
                                    <div class="row row-compare-features">
                                        <div class="d-inline-block col-md-3 col-sm-3">
                                            <h4 class="autoroyal-compare-features"><?php esc_html_e('Exterior', 'autoroyal'); ?></h4>
                                        </div>
                                        <?php while ($compares->have_posts()): $compares->the_post(); ?>
                                            <?php $vehicle_exterior = wp_get_post_terms( get_the_ID(), 'vehicle_exterior', array( 'orderby' => 'name', 'order' => 'ASC') );  ?>
                                            <?php if( $vehicle_exterior && ! is_wp_error($vehicle_exterior) ) { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>">
                                                    <ul class="compare-list-style">
                                                        <?php foreach ($vehicle_exterior as $vehicle_exterior_item): ?>
                                                            <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($vehicle_exterior_item->name); ?></li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </div>
                                            <?php } else { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>"></div>
                                            <?php } ?>
                                        <?php endwhile; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <!-- Interior -->
                            <?php if (!empty($compares)): ?>
                                <?php if ($compares->have_posts()): ?>
                                    <div class="row row-compare-features">
                                        <div class="d-inline-block col-md-3 col-sm-3">
                                            <h4 class="autoroyal-compare-features"><?php esc_html_e('Interior', 'autoroyal'); ?></h4>
                                        </div>
                                        <?php while ($compares->have_posts()): $compares->the_post(); ?>
                                            <?php $vehicle_interior = wp_get_post_terms( get_the_ID(), 'vehicle_interior', array( 'orderby' => 'name', 'order' => 'ASC') );  ?>
                                            <?php if( $vehicle_interior && ! is_wp_error($vehicle_interior) ) { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>">
                                                    <ul class="compare-list-style">
                                                        <?php foreach ($vehicle_interior as $vehicle_interior_item): ?>
                                                            <li><i class="fa fa-check-square-o" aria-hidden="true"></i> <?php echo esc_attr($vehicle_interior_item->name); ?></li>
                                                        <?php endforeach; ?>
                                                    </ul>
                                                </div>
                                            <?php } else { ?>
                                                <div class="d-inline-block col-md-3 col-sm-3 compare-col-autoroyal-<?php echo esc_attr(get_the_ID()); ?>"></div>
                                            <?php } ?>
                                        <?php endwhile; ?>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                        </div>

                    </div>

                </div>

            </main><!-- #main -->

        </div><!-- #primary -->

    </div>

<?php
get_footer();
