<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package fantasy_themes
 */

get_header(); 

$user_id = get_the_author_meta('ID');
$website_type = get_option("autoroyal_webiste_type");

?>

	<div class="container single-car-page">

		<div class="row"> 

			<?php 

				global $post;

				// Car
				$vehicle_condition = esc_attr(get_post_meta($post->ID, 'vehicle_condition',true));
				$vehicle_year = esc_attr(get_post_meta($post->ID, 'vehicle_year',true));
				$vehicle_make = esc_attr(get_post_meta($post->ID, 'vehicle_make',true));
				$vehicle_model = esc_attr(get_post_meta($post->ID, 'vehicle_model',true));
				$vehicle_trim_id = esc_attr(get_post_meta($post->ID, 'vehicle_trim_id',true));
				$vehicle_trim_desc_init = esc_attr(get_post_meta($post->ID, 'vehicle_trim_desc_init',true));
				$vehicle_make_desc_init = esc_attr(get_post_meta($post->ID, 'vehicle_make_desc_init',true));
				$vehicle_vin = esc_attr(get_post_meta($post->ID, 'vehicle_vin',true));

				//
				$vehicle_body_style = esc_attr(get_post_meta($post->ID, 'vehicle_body_style',true));
				$vehicle_seats = esc_attr(get_post_meta($post->ID, 'vehicle_seats',true));

                $vehicle_doors = "";
                $vehicle_vehicle_doors = get_the_terms($post->ID, 'vehicle_doors' );
                if ($vehicle_vehicle_doors && ! is_wp_error($vehicle_vehicle_doors)) :
                    $vehicle_doors = $vehicle_vehicle_doors[0]->name;
                endif;

				//
				$vehicle_exterior_color = get_the_terms($post->ID, 'vehicle_exterior_color' );
				if(!empty($vehicle_exterior_color)) {
					$color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
					$color_id   = $vehicle_exterior_color[0]->term_id;
					$color_name = $vehicle_exterior_color[0]->name;
					$color_type = get_term_meta( $vehicle_exterior_color[0]->term_id, 'color_type', true );
				} else {
					$color_type = "";
				}

				//
				$vehicle_interior_color = get_the_terms($post->ID, 'vehicle_interior_color' );
				if(!empty($vehicle_interior_color)) {
					$color_interior      = autoroyal_get_term_color( $vehicle_interior_color[0]->term_id, true );
					$color_interior_id   = $vehicle_interior_color[0]->term_id;
					$color_interior_name = $vehicle_interior_color[0]->name;
					$color_interior_type = get_term_meta( $vehicle_interior_color[0]->term_id, 'color_type', true );
				} else {
					$color_interior_type = "";
				}

				//
				$vehicle_interior_material = get_the_terms($post->ID, 'vehicle_interior_material' );
				if(!empty($vehicle_interior_material)) {
					$material_interior      = autoroyal_get_term_color( $vehicle_interior_material[0]->term_id, true );
					$material_interior_id   = $vehicle_interior_material[0]->term_id;
					$material_interior_name = $vehicle_interior_material[0]->name;
				} else {
					$material_interior_type = "";
				}

				//
				$terms_vehicle_body_style = "";
                $terms_vehicle_body_style_name = "";
                $vehicle_body_style = get_the_terms($post->ID, 'vehicle_body_style' );
                if ($vehicle_body_style && ! is_wp_error($vehicle_body_style)) :
                    $terms_vehicle_body_style = $vehicle_body_style[0]->term_id;
                    $terms_vehicle_body_style_name = $vehicle_body_style[0]->name;
                endif;

				$terms_vehicle_fuel_type = "";
                $terms_vehicle_fuel_type_id = "";
                $vehicle_fuel_type = get_the_terms($post->ID, 'vehicle_fuel_type' );
                if ($vehicle_fuel_type && ! is_wp_error($vehicle_fuel_type)) :
                    $terms_vehicle_fuel_type = $vehicle_fuel_type[0]->name;
                    $terms_vehicle_fuel_type_id = $vehicle_fuel_type[0]->term_id;
                endif;

				$vehicle_drive = get_the_terms($post->ID, 'vehicle_drive' );
				$terms_vehicle_drive = $vehicle_drive[0]->name;

				$terms_vehicle_transmission = "";
                $terms_vehicle_transmission_id = "";
                $vehicle_transmission = get_the_terms($post->ID, 'vehicle_transmission' );
                if ($vehicle_transmission && ! is_wp_error($vehicle_transmission)) :
                    $terms_vehicle_transmission = $vehicle_transmission[0]->name;
                    $terms_vehicle_transmission_id = $vehicle_transmission[0]->term_id;
                endif;

				//
				$vehicle_engine_type = esc_attr(get_post_meta($post->ID, 'vehicle_engine_type',true));
				$vehicle_cilinders = esc_attr(get_post_meta($post->ID, 'vehicle_cilinders',true));
				$vehicle_emission_class = esc_attr(get_post_meta($post->ID, 'vehicle_emission_class',true));

				// Specifications
				$vehicle_engine_volume_l = esc_attr(get_post_meta($post->ID, 'vehicle_engine_volume_l',true));
				$vehicle_power_hp = esc_attr(get_post_meta($post->ID, 'vehicle_power_hp',true));
				$vehicle_power_kw = esc_attr(get_post_meta($post->ID, 'vehicle_power_kw',true));
				$vehicle_max_power_rpm = esc_attr(get_post_meta($post->ID, 'vehicle_max_power_rpm',true));
				$vehicle_torque_nm = esc_attr(get_post_meta($post->ID, 'vehicle_torque_nm',true));

				$vehicle_gears_num = esc_attr(get_post_meta($post->ID, 'vehicle_gears_num',true));

				$vehicle_consumption_combined = esc_attr(get_post_meta($post->ID, 'vehicle_consumption_combined',true));
				$vehicle_consumption_urban = esc_attr(get_post_meta($post->ID, 'vehicle_consumption_urban',true));
				$vehicle_consumption_highway = esc_attr(get_post_meta($post->ID, 'vehicle_consumption_highway',true));
				$vehicle_emissions = esc_attr(get_post_meta($post->ID, 'vehicle_emissions',true));
				$vehicle_emission_class = esc_attr(get_post_meta($post->ID, 'vehicle_emission_class',true));
				$vehicle_fuel_tank = esc_attr(get_post_meta($post->ID, 'vehicle_fuel_tank',true));

				$vehicle_length = esc_attr(get_post_meta($post->ID, 'vehicle_length',true));
				$vehicle_width = esc_attr(get_post_meta($post->ID, 'vehicle_width',true));
				$vehicle_height = esc_attr(get_post_meta($post->ID, 'vehicle_height',true));
				$vehicle_wheelbase = esc_attr(get_post_meta($post->ID, 'vehicle_wheelbase',true));
				$vehicle_weight = esc_attr(get_post_meta($post->ID, 'vehicle_weight',true));
				// End

				//
				$vehicle_retail_price = esc_attr(get_post_meta($post->ID, 'vehicle_retail_price',true));
				$vehicle_discounted_price = esc_attr(get_post_meta($post->ID, 'vehicle_discounted_price',true));
				$price = esc_attr(get_post_meta($post->ID, 'vehicle_price',true));

				// Gallery
				$vehicle_image_gallery = get_post_meta($post->ID, 'vehicle_image_gallery',true);
				$vehicle_image_extended_gallery = get_post_meta($post->ID, 'vehicle_image_extended_gallery',true);

				// Car Details
				$vehicle_engine_volume_ccm = esc_attr(get_post_meta($post->ID, 'vehicle_engine_volume_ccm',true));
				$vehicle_max_torque_rpm = esc_attr(get_post_meta($post->ID, 'vehicle_max_torque_rpm',true));
				$vehicle_gears_num = esc_attr(get_post_meta($post->ID, 'vehicle_gears_num',true));
				$vehicle_mileage = esc_attr(get_post_meta($post->ID, 'vehicle_mileage',true));
				$vehicle_owners = esc_attr(get_post_meta($post->ID, 'vehicle_owners',true));

				$vehicle_condition_num = esc_attr(get_post_meta($post->ID, 'vehicle_condition_num',true));
				$vehicle_description = get_post_field('post_content', $post->ID);

				$vehicle_stock = esc_attr(get_post_meta($post->ID, 'vehicle_stock',true));
				$vehicle_vin = esc_attr(get_post_meta($post->ID, 'vehicle_vin',true));
				$vehicle_carfax_link = esc_attr(get_post_meta($post->ID, 'vehicle_carfax_link',true));
				$vehicle_autocheck_link = esc_attr(get_post_meta($post->ID, 'vehicle_autocheck_link',true));
				$vehicle_pre_owned = esc_attr(get_post_meta($post->ID, 'vehicle_pre_owned',true));

				//
				$vehicle_length = esc_attr(get_post_meta($post->ID, 'vehicle_length',true));
				$vehicle_width = esc_attr(get_post_meta($post->ID, 'vehicle_width',true));
				$vehicle_height = esc_attr(get_post_meta($post->ID, 'vehicle_height',true));
				$vehicle_wheelbase = esc_attr(get_post_meta($post->ID, 'vehicle_wheelbase',true));
				$vehicle_weight = esc_attr(get_post_meta($post->ID, 'vehicle_weight',true));

				// Location
				$vehicle_location_name = "";
				$vehicle_location_phone = "";
				$vehicle_location_email = "";
				$vehicle_location_address = "";
				$vehicle_location_latitude = "";
				$vehicle_location_longitude = "";

				$vehicle_location = get_the_terms($post->ID, 'vehicle_location' );
				if(!empty($vehicle_location)) {
					$term_id = $vehicle_location[0]->term_id;
					$vehicle_location_name = get_term_meta( $term_id, 'vehicle_location_name', true );
					$vehicle_location_phone = get_term_meta( $term_id, 'vehicle_location_phone', true );
					$vehicle_location_email = get_term_meta( $term_id, 'vehicle_location_email', true );
					$vehicle_location_address = get_term_meta( $term_id, 'vehicle_location_address', true );
					$vehicle_location_latitude = get_term_meta( $term_id, 'vehicle_location_latitude', true );
					$vehicle_location_longitude = get_term_meta( $term_id, 'vehicle_location_longitude', true );
				}

				//
                $terms_vehicle_doors = "";
                $terms_vehicle_doors_name = "";
                $vehicle_vehicle_doors = get_the_terms($post->ID, 'vehicle_doors' );
                if ($vehicle_vehicle_doors && ! is_wp_error($vehicle_vehicle_doors)) :
                    $terms_vehicle_doors = $vehicle_vehicle_doors[0]->term_id;
                    $terms_vehicle_doors_name = $vehicle_vehicle_doors[0]->name;
                endif;

                //
                $terms_vehicle_seats = "";
                $terms_vehicle_seats_name = "";
                $vehicle_vehicle_seats = get_the_terms($post->ID, 'vehicle_seats' );
                if ($vehicle_vehicle_seats && ! is_wp_error($vehicle_vehicle_seats)) :
                    $terms_vehicle_seats = $vehicle_vehicle_seats[0]->term_id;
                    $terms_vehicle_seats_name = $vehicle_vehicle_seats[0]->name;
                endif;

                //
                $terms_vehicle_rent_age = "";
                $terms_vehicle_rent_age_name = "";
                $vehicle_vehicle_rent_age = get_the_terms($post->ID, 'vehicle_rent_age' );
                if ($vehicle_vehicle_rent_age && ! is_wp_error($vehicle_vehicle_rent_age)) :
                    $terms_vehicle_rent_age = $vehicle_vehicle_rent_age[0]->term_id;
                    $terms_vehicle_rent_age_name = $vehicle_vehicle_rent_age[0]->name;
                endif;

                //
                $terms_vehicle_luggages = "";
                $terms_vehicle_luggages_name = "";
                $vehicle_vehicle_luggages = get_the_terms($post->ID, 'vehicle_luggages' );
                if ($vehicle_vehicle_luggages && ! is_wp_error($vehicle_vehicle_luggages)) :
                    $terms_vehicle_luggages = $vehicle_vehicle_luggages[0]->term_id;
                    $terms_vehicle_luggages_name = $vehicle_vehicle_luggages[0]->name;
                endif;

                $vehicle_navigation = get_post_meta($post->ID, 'vehicle_navigation',true);
                $vehicle_ac = get_post_meta($post->ID, 'vehicle_ac',true);
                $rent_deposit = get_post_meta($post->ID, 'rent_deposit',true);
                $mileage_limit = get_post_meta($post->ID, 'mileage_limit',true);

                $autoroyal_currency = get_option( 'autoroyal_currency' );

				autoroyal_setPostViews(get_the_ID());
				autoroyal_setPostVisited(get_the_ID());

				// Enqueue styles
				wp_enqueue_style( 'jquery-ui' );
				wp_enqueue_style( 'bootstrap-select' );

				// Enqueue scripts
				wp_enqueue_script( 'jquery-ui-datepicker' );
				wp_enqueue_script( 'jquery-ui-autocomplete' );
				wp_enqueue_script( 'time-picker' );
				wp_enqueue_script( 'bootstrap-select' );

			?>

			<div class="col-md-8 fantasy-themes-content-width">

				<div id="primary" class="content-area">

					<main id="main" class="site-main">

						<article id="post-<?php the_ID(); ?>" <?php post_class( 'card mt-3r' ); ?>>
							
							<div class="card-body">

								<header class="entry-header">
									
									<h1 itemprop="name" class="entry-title card-title h2">
										<?php if(!empty($vehicle_year)){ ?><span><?php echo esc_attr($vehicle_year); ?></span><?php } ?>
										<?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?> <?php echo esc_attr($vehicle_trim_desc_init); ?> 
									</h1>

									<div class="text-uppercase sidebar-car-meta">

										<?php if(!empty($vehicle_stock)) { ?><span class="car-id"><?php esc_html_e('stock', 'autoroyal' ); ?> # <strong><?php echo esc_attr($vehicle_stock); ?></strong></span><?php } ?>

								      	<div class="car-color <?php if($color_type == "combined") { echo "car_combined_color"; } elseif($color_type == "na") { echo "car_na_color"; } ?>" <?php if(!empty($color)) { echo "style='background-color: ". $color .";'"; } ?>></div>

								      	<p>
								      		<?php if(!empty($color_name)) { echo esc_attr($color_name); echo " "; } ?>
								      		<?php if(!empty($terms_vehicle_body_style)) { echo esc_attr($terms_vehicle_body_style); echo ", "; } ?>
								      		<?php if(!empty($vehicle_seats)) { echo esc_attr($vehicle_seats); echo " "; esc_html_e('seats', 'autoroyal' ); echo ", "; } ?>
								      		<?php if(!empty($vehicle_doors)) { echo esc_attr($vehicle_doors); echo " "; esc_html_e('doors', 'autoroyal' ); echo ", "; } ?>
								      		<?php if(!empty($terms_vehicle_fuel_type)) { echo esc_attr($terms_vehicle_fuel_type); echo ", "; }  ?>
								      		<?php if(!empty($terms_vehicle_transmission)) { echo esc_attr($terms_vehicle_transmission); echo ", "; }  ?>
								      		<?php if(!empty($terms_vehicle_drive)) { echo esc_attr($terms_vehicle_drive); echo ", "; }  ?>
								      		<?php if(!empty($vehicle_emission_class)) { echo esc_attr($vehicle_emission_class); } ?>
								      	</p>

								    </div>

								</header><!-- .entry-header -->
								
								<div class="entry-content">

									<div class="single_car" itemscope itemtype="http://schema.org/Product">

										<?php 

											$vehicle_cover_image = get_post_meta($post->ID, 'vehicle_cover_image',true);
						                    if(!empty($vehicle_cover_image)) {
						                        $vehicle_image_url = $vehicle_cover_image;
						                    }

											if(!empty($vehicle_image_url)) { 
												$foto_large = autoroyal_get_resized_image( $vehicle_image_url, 'autoroyal-thumbnail-image' ); 
											} else { 
												$foto_large = ""; 
											}

										?>

										<meta itemprop="name" content="<?php if(!empty($vehicle_year)){ ?><?php echo esc_attr($vehicle_year); ?><?php } ?> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?> <?php echo esc_attr($vehicle_trim_desc_init); ?>">
										<meta itemprop="itemCondition" content="<?php echo esc_attr($vehicle_condition); ?>" >
										<meta itemprop="modelYear" content="<?php echo esc_attr($vehicle_year); ?>" >
										<meta itemprop="brand" content="<?php echo esc_attr($vehicle_make_desc_init); ?>" >
										<meta itemprop="manufacturer" content="<?php echo esc_attr($vehicle_make_desc_init); ?>" >
										<meta itemprop="model" content="<?php echo esc_attr($vehicle_model); ?>" >
										<meta itemprop="modelTrim" content="<?php echo esc_attr($vehicle_trim_desc_init); ?>" >
										<meta itemprop="sku" content="<?php echo esc_attr($vehicle_stock); ?>" >
										<meta itemprop="mpn" content="<?php echo esc_attr($vehicle_vin); ?>" >
										<meta itemprop="image" content="<?php echo esc_url($foto_large); ?>" >

										<?php

											if( !empty($website_type) ) {
												if( $website_type == "rentals" ) {

													$vehicle_rent_price_min = get_post_meta($post->ID, 'vehicle_rent_price_min',true);
		                    						$vehicle_rent_price_max = get_post_meta($post->ID, 'vehicle_rent_price_max',true);
														
										?>

										<div class="d-none" itemprop="offers" itemscope itemtype="http://schema.org/AggregateOffer" >
											<meta itemprop="offerCount" content="1" >
											<meta itemprop="lowPrice" content="<?php echo esc_attr($vehicle_rent_price_min); ?>" >
											<meta itemprop="highPrice" content="<?php echo esc_attr($vehicle_rent_price_max); ?>" >
											<meta itemprop="priceCurrency" content="<?php echo esc_attr($autoroyal_currency) ?>" >
										</div>

									    <?php } } ?>

									    <?php if( !empty($vehicle_discounted_price) AND $website_type != "rentals")  { ?>
											<div class="d-none" itemprop="offers" itemscope itemtype="http://schema.org/AggregateOffer" >
												<meta itemprop="offerCount" content="1" >
												<meta itemprop="lowPrice" content="<?php echo esc_attr($price); ?>" >
												<meta itemprop="highPrice" content="<?php echo esc_attr($vehicle_retail_price); ?>" >
												<meta itemprop="priceCurrency" content="<?php echo esc_attr($autoroyal_currency) ?>" >
											</div>
										<?php } else { ?>
											<meta itemprop="price" content="<?php echo esc_attr($price); ?>" >
										<?php } ?>

										<meta itemprop="priceCurrency" content="<?php echo esc_attr($autoroyal_currency) ?>" >

										<meta itemprop="description" content="<?php echo esc_attr($vehicle_description); ?>" >
										<meta itemprop="review" content="" >

										<div class="d-none" itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating" >
											<meta itemprop="ratingValue" content="4.7" >
											<meta itemprop="reviewCount" content="10" >
										</div>

										<div class="d-none" itemprop="review" itemscope itemtype="http://schema.org/Review" >
											<meta itemprop="ratingValue" content="5" >
											<meta itemprop="author" content="Ellie" >
											<meta itemprop="type" content="Person" >
										</div>

										<?php
											/**
											 * single_car_start hook
											 *
											 */
											do_action( 'single_car_start' );
										?>

									    <!-- carousel -->
									  	<div id="cd-item-slider" class="carousel slide" data-ride="carousel">

										    <!-- Wrapper for slides -->
										    <div class="carousel-inner rounded" role="listbox">
												
												<?php

													$i = 0;

													if(!empty($vehicle_image_gallery)) {

														foreach ($vehicle_image_gallery as $vehicle_image_gallery_item) {
															
															if( !empty($vehicle_image_gallery_item['url']) ) {

												?>

										      	<div class="carousel-item overlayed1 <?php if($i == 0) { ?>active<?php } ?>" data-bg="<?php echo esc_url($vehicle_image_gallery_item['url']); ?>"></div>

										      	<?php $i++; } } } ?>

										      	<?php

													if(!empty($vehicle_image_extended_gallery)) {

														foreach ($vehicle_image_extended_gallery as $vehicle_image_extended_gallery_item) {
															
															if( !empty($vehicle_image_extended_gallery_item['url']) ) {

												?>

										      	<div class="carousel-item overlayed1 <?php if($i == 0) { ?>active<?php } ?>" data-bg="<?php echo esc_url($vehicle_image_extended_gallery_item['url']); ?>"></div>

										      	<?php $i++; } } } ?>

										    </div>

										    <!-- Indicators -->
										    <ol class="carousel-indicators">
										      	
										      	<?php

													$i = 0;

													if(!empty($vehicle_image_gallery)) {

														foreach ($vehicle_image_gallery as $vehicle_image_gallery_item) {
															
															if( !empty($vehicle_image_gallery_item['url']) ) {

												?>

										      	<li class="thumbnail <?php if($i == 0) { ?>active<?php } ?>" data-target="#cd-item-slider" data-slide-to="<?php echo esc_attr($i); ?>" data-bg="<?php echo esc_url($vehicle_image_gallery_item['url']); ?>"></li>

										      	<?php $i++; } } } ?>

										      	<?php

													if(!empty($vehicle_image_extended_gallery)) {

														foreach ($vehicle_image_extended_gallery as $vehicle_image_extended_gallery_item) {
															
															if( !empty($vehicle_image_extended_gallery_item['url']) ) {

												?>

										      	<li class="thumbnail <?php if($i == 0) { ?>active<?php } ?>" data-target="#cd-item-slider" data-slide-to="<?php echo esc_attr($i); ?>" data-bg="<?php echo esc_url($vehicle_image_extended_gallery_item['url']); ?>"></li>

										      	<?php $i++; } } } ?>
										      	
										    </ol>

										    <div class="clearfix"></div>

									  	</div>
									  	<!-- /.carousel -->

									  	<div class="autoroyal-vehicle-content-info">

										  	<ul class="nav nav-tabs" role="tablist">
										  		<?php if(!empty($vehicle_description)) { ?>
											  	<li class="nav-item">
											    	<a class="nav-link active" href="#overview" role="tab" data-toggle="tab"><?php esc_html_e('Vehicle overview', 'autoroyal' ); ?></a>
											  	</li>
											  	<?php } ?>
											  	<li class="nav-item">
											    	<a class="nav-link <?php if(empty($vehicle_description)) { ?>active<?php } ?>" href="#specifications" role="tab" data-toggle="tab"><?php esc_html_e('Specifications', 'autoroyal' ); ?></a>
											  	</li>
											  	<li class="nav-item">
											    	<a class="nav-link" href="#features" role="tab" data-toggle="tab"><?php esc_html_e('Features', 'autoroyal' ); ?></a>
											  	</li>
											  	<?php

													if( !empty($website_type) ) {
														if( $website_type == "dealer" OR $website_type == "marketplace" OR $website_type == "rentals_dealer" ) {
																
												?>
											  	<li class="nav-item">
											    	<a class="nav-link" href="#contact" role="tab" data-toggle="tab"><?php esc_html_e('Contact', 'autoroyal' ); ?></a>
											  	</li>
											  <?php } } ?>
											  	<li class="nav-item">
											    	<a class="nav-link" href="#location" role="tab" data-toggle="tab"><?php esc_html_e('Location', 'autoroyal' ); ?></a>
											  	</li>
											</ul>

											<!-- Tab panes -->
											<div class="tab-content">

												<?php if(!empty($vehicle_description)) { ?>

											  	<div role="tabpanel" class="tab-pane fade in active show" id="overview">
											  		
											  		<div class="vehicle_description">
											      		<?php echo wpautop($vehicle_description, true); ?>
											      	</div>

											  	</div>
											  	<?php } ?>

											  	<div role="tabpanel" class="tab-pane fade <?php if(empty($vehicle_description)) { ?>in active show<?php } ?>" id="specifications">
											  		
											  		<div class="autoroyal-specifications-block">

											  			<div class="autoroyal-specifications-title">
											  				<svg class="svg-icon" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 15.4 12.1" style="enable-background:new 0 0 15.4 12.1;" xml:space="preserve">
												          		<path class="st0" d="M14.9,6.2c-0.3,0-0.5,0.2-0.5,0.5v0.6h-1.1V6.8c0-0.3-0.2-0.5-0.5-0.5h-0.7l-0.7-0.7V3.3c0-0.3-0.2-0.5-0.5-0.5
												            H5.1V1.5h1.8c0.3,0,0.5-0.2,0.5-0.5S7.1,0.5,6.9,0.5h-4C2.5,0.5,2.3,0.8,2.3,1s0.2,0.5,0.5,0.5h1.8v1.3H2.8C2.5,2.8,2.3,3,2.3,3.3
												            v2.8H1V4.4c0-0.3-0.2-0.5-0.5-0.5S0,4.1,0,4.4v4c0,0.3,0.2,0.5,0.5,0.5S1,8.7,1,8.4V6.6h1.3v3c0,0.3,0.2,0.5,0.5,0.5h1.3l0.3,0.3
												            v0.9c0,0.3,0.2,0.5,0.5,0.5h7.8c0.3,0,0.5-0.2,0.5-0.5v-0.5h1.1v0.7c0,0.3,0.2,0.5,0.5,0.5s0.5-0.2,0.5-0.5v-1.2V7.8V6.7
												            C15.4,6.5,15.2,6.2,14.9,6.2z M12.8,9.9c-0.3,0-0.5,0.2-0.5,0.5v0.5H5.5v-0.7c0-0.1-0.1-0.3-0.2-0.4L4.7,9.3
												            C4.6,9.2,4.4,9.1,4.3,9.1h-1V3.8h7.1v2.1c0,0.1,0.1,0.3,0.1,0.4l1,1c0.1,0.1,0.2,0.1,0.4,0.1h0.4v0.5c0,0.3,0.2,0.5,0.5,0.5h1.6v1.5
												            H12.8z"></path>
												          	</svg>
										                  	<h4 class="heading"><?php esc_html_e('Engine', 'autoroyal' ); ?></h4>
										                </div>

											  			<table>

															<tbody>
																
																<?php if(!empty($vehicle_cilinders)) { ?>
																<!-- Cilynders -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Number of cylinders', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_cilinders); ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_engine_volume_l)) { ?>
																<!-- Engine volume -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Engine volume (L)', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_engine_volume_l); ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_power_hp)) { ?>
																<!-- Horsepower -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Horsepower', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_power_hp); ?> <?php if(!empty($vehicle_power_kw)) { ?>(<?php echo esc_attr($vehicle_power_kw); ?> <?php esc_html_e('KW', 'autoroyal' ); ?>)<?php } ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_max_power_rpm)) { ?>
																<!-- RPM -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label">@ <?php esc_html_e('rpm', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_max_power_rpm); ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_torque_nm)) { ?>
																<!-- Torque -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Torque', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_torque_nm); ?></span>
																	</td>
																</tr>
																<?php } ?>
																
															</tbody>

														</table>

													</div>

													<div class="autoroyal-specifications-block">

														<div class="autoroyal-specifications-title">
											  				<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="200" width="200" fill="#000000" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve"><g><path d="M89.417,36.305c0.18-1.034-0.144-2.146-0.953-2.877l-11.045-9.943c-1.193-1.071-3.198-1.139-4.459-0.146l-1.392,1.098   l0.55-7.6c0.116-1.6-1.102-2.907-2.705-2.907h-4.241V7.292C65.172,3.281,61.892,0,57.88,0H17.819c-4.011,0-7.292,3.281-7.292,7.292   V92.71c0,4.009,3.281,7.29,7.292,7.29H57.88c4.012,0,7.292-3.281,7.292-7.29V70.482h0.241c1.604,0,2.915-1.312,2.915-2.916v-1.449   c1.66,0.897,3.29,2.75,3.75,6.534c0.553,4.566-0.074,8.193-0.579,11.107c-0.301,1.734-0.56,3.231-0.56,4.679   c0,6.78,4.317,10.439,8.38,10.439c2.228,0,4.346-1.059,5.812-2.9c1.49-1.877,2.278-4.481,2.278-7.539   c0-5.536-0.67-10.292-1.318-14.894c-0.787-5.587-1.537-10.905-1.138-17.48c1.454-0.025,2.705-1.127,2.854-2.608l1.653-16.373   C89.488,36.812,89.464,36.554,89.417,36.305z M27.008,35.317c-1.512,0-2.738-1.227-2.738-2.737c0-1.515,1.227-2.738,2.738-2.738   c1.513,0,2.738,1.224,2.738,2.738C29.746,34.091,28.521,35.317,27.008,35.317z M37.851,35.317c-1.511,0-2.737-1.227-2.737-2.737   c0-1.515,1.227-2.738,2.737-2.738c1.514,0,2.739,1.224,2.739,2.738C40.59,34.091,39.364,35.317,37.851,35.317z M48.694,35.317   c-1.512,0-2.737-1.227-2.737-2.737c0-1.515,1.226-2.738,2.737-2.738c1.513,0,2.739,1.224,2.739,2.738   C51.434,34.091,50.207,35.317,48.694,35.317z M59.258,19.937c0,1.604-1.313,2.916-2.917,2.916H19.359   c-1.604,0-2.916-1.312-2.916-2.916v-9.825c0-1.604,1.312-2.916,2.916-2.916h36.981c1.604,0,2.917,1.312,2.917,2.916V19.937z    M81.167,92.824c-1.734,2.182-5.164,0.629-5.164-4.387c0-1.012,0.226-2.311,0.485-3.813c0.531-3.07,1.259-7.277,0.616-12.583   c-0.829-6.815-4.753-10.178-8.776-11.322v-1.161c0-1.604-1.312-2.916-2.915-2.916h-0.241v-13.07h2.096   c1.604,0,3.011-1.308,3.127-2.907l0.331-4.587l7.198,3.511l-0.065,12.875c-0.008,1.316,0.871,2.512,2.067,2.993   c-0.468,7.242,0.35,13.108,1.15,18.797c0.653,4.629,1.27,9.003,1.27,14.185C82.346,90.31,81.927,91.868,81.167,92.824z"/></g></svg>
										                  	<h4 class="heading"><?php esc_html_e('Fuel Economy', 'autoroyal' ); ?></h4>
										                </div>

											  			<table>

															<tbody>
																
																<?php if(!empty($vehicle_consumption_urban)) { ?>
																<!-- City -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('City', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_consumption_urban); ?> <?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('l/100km', 'autoroyal' ); } else { esc_html_e('mpg', 'autoroyal' ); } ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_consumption_highway)) { ?>
																<!-- Highway -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Highway', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_consumption_highway); ?> <?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('l/100km', 'autoroyal' ); } else { esc_html_e('mpg', 'autoroyal' ); } ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_consumption_combined)) { ?>
																<!-- Combined -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Combined', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_consumption_combined); ?> <?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('l/100km', 'autoroyal' ); } else { esc_html_e('mpg', 'autoroyal' ); } ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_fuel_tank)) { ?>
																<!-- Fuel Tank -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Fuel Tank', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_fuel_tank); ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_emissions)) { ?>
																<!-- Emissions -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Emissions', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_emissions); ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_emission_class)) { ?>
																<!-- Emissions Class -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Emissions Class', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_emission_class); ?></span>
																	</td>
																</tr>
																<?php } ?>
																
															</tbody>

														</table>

													</div>

													<div class="autoroyal-specifications-block">

												        <div class="autoroyal-specifications-title">
											  				<svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"/><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"/><circle cx="70" cy="70" r="4"/></svg>
										                  	<h4 class="heading"><?php esc_html_e('Transmission', 'autoroyal' ); ?></h4>
										                </div>

											  			<table>

															<tbody>
																
																<?php if(!empty($terms_vehicle_transmission)) { ?>
																<!-- Type -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Type', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($terms_vehicle_transmission); ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($vehicle_gears_num)) { ?>
																<!-- Speeds -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Speeds', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($vehicle_gears_num); ?></span>
																	</td>
																</tr>
																<?php } ?>

																<?php if(!empty($terms_vehicle_drive)) { ?>
																<!-- Displacement -->
																<tr>
																	<td>
																		<span class="autoroyal-specifications-label"><?php esc_html_e('Displacement', 'autoroyal' ); ?></span>
																	</td>
																	<td class="text-right">
																		<span class="h6"><?php echo esc_attr($terms_vehicle_drive); ?></span>
																	</td>
																</tr>
																<?php } ?>
																
															</tbody>

														</table>

												  	</div>

											  	</div>

											  	<div role="tabpanel" class="tab-pane fade" id="features">
											  		
											  		<div class="listing-content">

												      	<div class="row columns-content">
												            <div class="col-sm-4">
												              
												              	<!-- consumption -->
												              	<div class="column-blk">

													                <div class="title">
													                  	<h4 class="heading"><?php esc_html_e('Consumption & Emissions', 'autoroyal' ); ?></h4>
													                </div>

													                <ol class="list-unstyled">

													                  	<li>
														                    <span class="pull-left">~<?php if(!empty($vehicle_consumption_combined)) { echo esc_attr($vehicle_consumption_combined); } ?><?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('l/100km', 'autoroyal' ); } else { esc_html_e('mpg', 'autoroyal' ); } ?> (<?php esc_html_e('combined', 'autoroyal' ); ?>)</span>
														                    <span class="pull-right"><?php if(!empty($vehicle_emissions)) { echo esc_attr($vehicle_emissions); ?><?php esc_html_e('g CO2/km', 'autoroyal' ); } ?></span>
													                  	</li>

													                  	<li class="clearfix"></li>

													                  	<li>
														                    <span class="pull-left">~<?php if(!empty($vehicle_consumption_urban)) { echo esc_attr($vehicle_consumption_urban); } ?><?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('l/100km', 'autoroyal' ); } else { esc_html_e('mpg', 'autoroyal' ); } ?> (<?php esc_html_e('urban', 'autoroyal' ); ?>)</span>
														                    <span class="pull-right"><?php if(!empty($vehicle_emission_class)) { echo esc_attr($vehicle_emission_class); } ?></span>
													                  	</li>

													                  	<li class="clearfix"></li>

													                  	<li>
													                    	<span class="pull-left">~<?php if(!empty($vehicle_consumption_highway)) { echo esc_attr($vehicle_consumption_highway); } ?><?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('l/100km', 'autoroyal' ); } else { esc_html_e('mpg', 'autoroyal' ); } ?> (<?php esc_html_e('extra-urban', 'autoroyal' ); ?>)</span>
													                  	</li>

													                  	<li class="clearfix"></li>

													                </ol>

												              	</div>

												              	<!-- safety -->
												              	<div class="column-blk">

													                <div class="title">
																		<h4 class="heading"><?php esc_html_e('Safety', 'autoroyal' ); ?></h4>
													                </div>

												                	<ul class="list-unstyled checked">
																		
																		<?php 

																			$vehicle_safety = wp_get_post_terms( $post->ID, 'vehicle_safety', array( 'orderby' => 'name', 'order' => 'ASC') ); 

																			if( $vehicle_safety && ! is_wp_error($vehicle_safety) ) { 

																				foreach ($vehicle_safety as $vehicle_safety_item) {

																					$nume_cat = $vehicle_safety_item->name;
																					$id_cat = $vehicle_safety_item->term_id;

																					if( !cd_category_has_children($id_cat) ) {

																					?>

															                    	<li><?php echo esc_attr($nume_cat); ?></li>

															                    	<?php

															                    	}

														                    	} 

													                    	} 

												                    	?>

												                	</ul>
												              	</div>

												              	<!-- exterior -->
												              	<div class="column-blk">
												                
													                <div class="title">
																		<h4 class="heading"><?php esc_html_e('Exterior', 'autoroyal' ); ?></h4>
													                </div>

													                <ul class="list-unstyled checked">

													                    <?php 

																			$vehicle_exterior = wp_get_post_terms( $post->ID, 'vehicle_exterior', array( 'orderby' => 'name', 'order' => 'ASC') ); 

																			if( $vehicle_exterior && ! is_wp_error($vehicle_exterior) ) { 

																				foreach ($vehicle_exterior as $vehicle_exterior_item) {

																					$nume_cat = $vehicle_exterior_item->name;
																					$id_cat = $vehicle_exterior_item->term_id;

																					if( !cd_category_has_children($id_cat) ) {

																					?>

															                    	<li><?php echo esc_attr($nume_cat); ?></li>

															                    	<?php

															                    	}

														                    	} 

													                    	} 

												                    	?>
													                    
													                </ul>

												              	</div>

												        	</div>

												            <div class="col-sm-4">
												              
												              	<!-- comfort -->
												              	<div class="column-blk">
												                
													                <div class="title">
													                  	<h4 class="heading"><?php esc_html_e('Comfort', 'autoroyal' ); ?></h4>
													                </div>

													                <ul class="list-unstyled checked">
													                  	
													                  	<?php 

																			$vehicle_comfort = wp_get_post_terms( $post->ID, 'vehicle_comfort', array( 'orderby' => 'name', 'order' => 'ASC') ); 

																			if( $vehicle_comfort && ! is_wp_error($vehicle_comfort) ) { 

																				foreach ($vehicle_comfort as $vehicle_comfort_item) {

																					$nume_cat = $vehicle_comfort_item->name;
																					$id_cat = $vehicle_comfort_item->term_id;

																					if( !cd_category_has_children($id_cat) ) {

																					?>

															                    	<li><?php echo esc_attr($nume_cat); ?></li>

															                    	<?php

															                    	}

														                    	} 

													                    	} 

												                    	?>

													                </ul>

												              	</div>

												              	<!-- interior -->
												              	<div class="column-blk">

													                <div class="title">
																		<h4 class="heading"><?php esc_html_e('Interior', 'autoroyal' ); ?></h4>
													                </div>

													                <ul class="list-unstyled checked">
														                  
													                	<?php 

																			$vehicle_interior = wp_get_post_terms( $post->ID, 'vehicle_interior', array( 'orderby' => 'name', 'order' => 'ASC') ); 

																			if( $vehicle_interior && ! is_wp_error($vehicle_interior) ) { 

																				foreach ($vehicle_interior as $vehicle_interior_item) {

																					$nume_cat = $vehicle_interior_item->name;
																					$id_cat = $vehicle_interior_item->term_id;

																					if( !cd_category_has_children($id_cat) ) {

																					?>

															                    	<li><?php echo esc_attr($nume_cat); ?></li>

															                    	<?php

															                    	}

														                    	} 

													                    	} 

												                    	?>

													                </ul>

												              	</div>

												              	<!-- visibility -->
												              	<div class="column-blk">

													                <div class="title">
																		<h4 class="heading"><?php esc_html_e('Visibility', 'autoroyal' ); ?></h4>
													                </div>
													                
													                <ul class="list-unstyled checked">
													                  	
													                  	<?php 

																			$vehicle_visibility = wp_get_post_terms( $post->ID, 'vehicle_visibility', array( 'orderby' => 'name', 'order' => 'ASC') ); 

																			if( $vehicle_visibility && ! is_wp_error($vehicle_visibility) ) { 

																				foreach ($vehicle_visibility as $vehicle_visibility_item) {

																					$nume_cat = $vehicle_visibility_item->name;
																					$id_cat = $vehicle_visibility_item->term_id;

																					if( !cd_category_has_children($id_cat) ) {

																					?>

															                    	<li><?php echo esc_attr($nume_cat); ?></li>

															                    	<?php

															                    	}

														                    	} 

													                    	} 

												                    	?>
													                  
													                </ul>

												              	</div>

												            </div>

												            <div class="col-sm-4">

												            	<!-- multimedia -->
												              	<div class="column-blk">

													                <div class="title">
													                	<h4 class="heading"><?php esc_html_e('Multimedia', 'autoroyal' ); ?></h4>
													                </div>

													                <ul class="list-unstyled checked">
													                  
													                  	<?php 

																			$vehicle_multimedia = wp_get_post_terms( $post->ID, 'vehicle_multimedia', array( 'orderby' => 'name', 'order' => 'ASC') ); 

																			if( $vehicle_multimedia && ! is_wp_error($vehicle_multimedia) ) { 

																				foreach ($vehicle_multimedia as $vehicle_multimedia_item) {

																					$nume_cat = $vehicle_multimedia_item->name;
																					$id_cat = $vehicle_multimedia_item->term_id;

																					if( !cd_category_has_children($id_cat) ) {

																					?>

															                    	<li><?php echo esc_attr($nume_cat); ?></li>

															                    	<?php

															                    	}

														                    	} 

													                    	} 

												                    	?>

													                </ul>

												              	</div>


												            </div>

												      	</div>

												  	</div>

											  	</div>

											  	<?php

													if( !empty($website_type) ) {
														if( $website_type == "dealer" OR $website_type == "marketplace" OR $website_type == "rentals_dealer" ) {
																
												?>

											  	<div role="tabpanel" class="tab-pane fade" id="contact">

											  		<div class="autoroyal-car-contact-form">

											  			<?php $thankyou_text = get_option( 'autoroyal_contact_form_thankyou_text' ); if(!empty($thankyou_text)) { ?>
														
														<h5 class="contact-message-sent-response heading"><?php echo wp_kses($thankyou_text, true); ?></h5>

														<?php } ?>

													    <form id="autoroyal-contact-dealer" class="contact-form" action="<?php echo admin_url('admin-ajax.php'); ?>" method="post">

													      	<div class="row">

													      		<div class="col-md-6">

														            <div class="form-group">
														              	<label for="userName"><?php esc_html_e('Your Name', 'autoroyal' ); ?> *</label>
														              	<input type="text" class="form-control" id="userName" name="userName" placeholder="John Doe">
														              	<?php $name_error_text = get_option( 'autoroyal_contact_form_name_error' ); if(!empty($name_error_text)) { ?>
														              	<label id="userName-error" class="error" for="userName"><?php echo esc_attr($name_error_text); ?></label>
														              	<?php } ?>
														            </div>

														            <div class="form-group">
														              	<label for="userMail"><?php esc_html_e('Email address', 'autoroyal' ); ?> *</label>
														              	<input type="email" class="form-control" id="userMail" name="userMail" placeholder="email@domain.com">
														              	<?php $email_error_text = get_option( 'autoroyal_contact_form_email_error' ); if(!empty($email_error_text)) { ?>
														              	<label id="userMail-error" class="error" for="userMail"><?php echo esc_attr($email_error_text); ?></label>
														              	<?php } ?>
														            </div>

														            <div class="form-group">
														              	<label for="userPhone"><?php esc_html_e('Phone number', 'autoroyal' ); ?> *</label>
														              	<input type="text" class="form-control" id="userPhone" name="userPhone" placeholder="+123 456 7890">
														              	<?php $phone_error_text = get_option( 'autoroyal_contact_form_phone_error' ); if(!empty($phone_error_text)) { ?>
														              	<label id="userPhone-error" class="error" for="userPhone"><?php echo esc_attr($phone_error_text); ?></label>
														              	<?php } ?>
														            </div>

														        </div>

														        <div class="col-md-6">

														            <div class="form-group">
														              	<label for="textMessage"><?php esc_html_e('Message', 'autoroyal' ); ?></label>
														              	<textarea class="form-control" cols="30" rows="7" id="textMessage" name="textMessage" ><?php $default_message = get_option( 'autoroyal_contact_form_default_message' ); if(!empty($default_message)) { echo wp_kses($default_message, true); } ?></textarea>
														            </div>

														            <button id="autoroyal-contact-dealer-submit" type="submit" class="btn btn-default">
														              	<?php esc_html_e('Send message', 'autoroyal' ); ?>
														              	<i class="fa fa-angle-right"></i>
														            </button>

														        </div>

														        <?php

																	if( !empty($website_type) AND $website_type == "marketplace" ) {

																		$user_id = get_the_author_meta('ID');
																		$user_info = get_userdata( $user_id );
																		$email_to = $user_info->user_email;

																		if(!empty($vehicle_location_email)) { 
																			$email_to = esc_attr($vehicle_location_email); 
																		}

																	} else {

																		if(!empty($vehicle_location_email)) { 
																			$email_to = esc_attr($vehicle_location_email); 
																		} else {
																			$email_to = get_option('admin_email');
																		}

																	}

														        ?>

													            <input type="hidden" name="car_name" value="<?php get_the_title(); ?>" />
													            <input type="hidden" name="car_url" value="<?php echo get_permalink(); ?>" />
													            <input type="hidden" name="dealer_email" value="<?php echo esc_attr($email_to); ?>" />

													            <input type="hidden" name="action" value="contactCarDealerForm" />
																<?php wp_nonce_field( 'contactCarDealerForm_html', 'contactCarDealerForm_nonce' ); ?>

													      	</div>

													      	<div class="clearfix"></div>

													    </form>

									              	</div>

											  	</div>
											  	<?php } } ?>
											  	<div role="tabpanel" class="tab-pane fade" id="location">
											  		
											  		<?php

												  		$website_type = get_option("autoroyal_webiste_type");
												  		if( !empty($website_type) AND $website_type == "marketplace" ) {

												  	?>

												  	<div class="listing-content">

												  		<div class="cd-map-wrapp">

												            <div class="cd-dealer-address">

												            	<?php

												            		// Dealer Info
												            		$user_id = get_the_author_meta('ID');

																	$dealer_name = get_user_meta( $user_id, 'dealer_name', true );
																	$office_phone = get_user_meta( $user_id, 'office_phone', true );

																	$dealer_address = get_user_meta( $user_id, 'dealer_address', true );
																	$dealer_address_latitude = get_user_meta( $user_id, 'dealer_address_latitude', true );
																	$dealer_address_longitude = get_user_meta( $user_id, 'dealer_address_longitude', true );

																	if( empty($dealer_name)) {

																		$user = get_userdata( $user_id ); 
																		$dealer_name = $user->user_nicename;

																	}

												            	?>
												              	
												              	<h4 class="heading"><a href="<?php echo get_author_posts_url($user_id); ?>"><?php echo esc_attr($dealer_name); ?></a></h4>
												              	
												              	<?php if( !empty($dealer_address)) { ?>
												              	<address><?php echo esc_attr($dealer_address); ?></address>
												              	<?php } ?>

												              	<ul class="list-unstyled phone-nrs">
												              		
												              		<?php if(!empty($vehicle_location_address)) { ?>
												                  	<li>
												                  		<i class="fa fa-map-marker" aria-hidden="true"></i>
												                   		<?php echo esc_attr($vehicle_location_address); ?>
												                  	</li>
												                  	<li class="clearfix"></li>
												                  	<?php } ?>
												                  	<?php if(!empty($vehicle_location_phone)) { ?>
												                  	<li>
												                  		<i class="fa fa-phone" aria-hidden="true"></i>
												                  		<span><?php esc_html_e('Phone', 'autoroyal' ); ?>:</span>
												                    	<a href="callto:<?php echo esc_attr($vehicle_location_phone); ?>" ><?php echo esc_attr($vehicle_location_phone); ?></a>
												                  	</li>
												                  	<li class="clearfix"></li>
												                  	<?php } ?>
												                  	<?php if(!empty($vehicle_location_email)) { ?>
												                  	<li>
												                  		<i class="fa fa-envelope" aria-hidden="true"></i>
												                  		<span><?php esc_html_e('Email', 'autoroyal' ); ?>:</span>
												                    	<a href="mailto:<?php echo esc_attr($vehicle_location_email); ?>" ><?php echo esc_attr($vehicle_location_email); ?></a>
												                  	</li>
												                  	<li class="clearfix"></li>
												                  	<?php } ?>
												                  	
												              	</ul>

												            </div>

												      	</div>

													</div>

												  	<?php } else { ?>

												  	<div class="listing-content">

												  		<div class="row">

												  			<div class="col-md-4">

												  				<div class="cd-dealer-address">
												              	
													              	<h4 class="heading">
																		<?php

																			$MODS = get_theme_mods();
																		    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

																		    if( strlen($MODS['logo']) > 0 ) {

																		        ?><img src='<?php echo esc_url($MODS['logo']); ?>' alt=''><?php

																			} else {
																		
																				?>
																                    <h2 class="site-title h3 mb-0"><?php bloginfo( 'name' ); ?></h2>
																                <?php

																				$description = get_bloginfo( 'description', 'display' );
															                    if ( $description || is_customize_preview() ) : ?>
															                        <p class="site-description"><?php echo esc_html( $description ); ?></p>
															                    <?php
															                    endif;

															                }

																		?>
													              	</h4>

													              	<ul class="list-unstyled phone-nrs">
													              		<?php if(!empty($vehicle_location_address)) { ?>
													                  	<li>
													                  		<i class="fa fa-map-marker" aria-hidden="true"></i>
													                   		<?php echo esc_attr($vehicle_location_address); ?>
													                  	</li>
													                  	<li class="clearfix"></li>
													                  	<?php } ?>
													                  	<?php if(!empty($vehicle_location_phone)) { ?>
													                  	<li>
													                  		<i class="fa fa-phone" aria-hidden="true"></i>
													                  		<span><?php esc_html_e('Phone', 'autoroyal' ); ?>:</span>
													                    	<a href="callto:<?php echo esc_attr($vehicle_location_phone); ?>" ><?php echo esc_attr($vehicle_location_phone); ?></a>
													                  	</li>
													                  	<li class="clearfix"></li>
													                  	<?php } ?>
													                  	<?php if(!empty($vehicle_location_email)) { ?>
													                  	<li>
													                  		<i class="fa fa-envelope" aria-hidden="true"></i>
													                  		<span><?php esc_html_e('Email', 'autoroyal' ); ?>:</span>
													                    	<a href="mailto:<?php echo esc_attr($vehicle_location_email); ?>" ><?php echo esc_attr($vehicle_location_email); ?></a>
													                  	</li>
													                  	<li class="clearfix"></li>
													                  	<?php } ?>
													              	</ul>

													            </div>

													        </div>

													        <div class="col-md-8">

														  		<div class="cd-map-wrapp">

														  			<input type="hidden" id="vehicle_location_latitude" name="vehicle_location_latitude" value="<?php echo esc_attr($vehicle_location_latitude); ?>" />
																	<input type="hidden" id="vehicle_location_longitude" name="vehicle_location_longitude" value="<?php echo esc_attr($vehicle_location_longitude); ?>" />

														            <div id="cd-map" class="rounded"></div>

														      	</div>

													      	</div>

													  	</div>

													</div>

													<?php } ?>

											  	</div>
											</div>

										</div>

										<?php

											if( !empty($website_type) ) {
												if( $website_type == "dealer" OR $website_type == "marketplace" OR $website_type == "rentals_dealer" ) {
														
										?>

										<?php if( get_autoroyal_vehicle_forms() != "1" ) { ?>

										<div class="autoroyal-vehicle-applications-block">

											<div class="row">

												<div class="col-lg-6 col-md-12">

													<div class="widget autoroyal-car-check-availability-alt">

												    	<a href="#" id="open-prequalify" data-toggle="modal" data-target="#pre-qualify">
												    		<i class="fa fa-paper-plane" aria-hidden="true"></i>
															<?php esc_html_e('Pre-Qualify', 'autoroyal' ); ?>
												    	</a>

												    </div>

												</div>

												<div class="col-lg-6 col-md-12">

													<div class="widget autoroyal-car-check-availability-alt">

												    	<a href="#" id="open-finance" data-toggle="modal" data-target="#financial-application">
												    		<i class="fa fa-dollar-sign" aria-hidden="true"></i>
															<?php esc_html_e('Financial Application', 'autoroyal' ); ?>
												    	</a>

												    </div>

												</div>

												<div class="col-lg-6 col-md-12">

													<div class="widget autoroyal-car-check-availability-alt">

												    	<a href="#" id="open-test-drive" data-toggle="modal" data-target="#test-drive">
												    		<i class="fa fas fa-tachometer-alt" aria-hidden="true"></i>
															<?php esc_html_e('Test Drive', 'autoroyal' ); ?>
												    	</a>

												    </div>

												</div>

												<div class="col-lg-6 col-md-12">

													<div class="widget autoroyal-car-check-availability-alt">

												    	<a href="#" id="open-trade-in" data-toggle="modal" data-target="#trade-in">
												    		<i class="fa fa-refresh" aria-hidden="true"></i>
															<?php esc_html_e('Trade-In', 'autoroyal' ); ?>
												    	</a>

												    </div>

												</div>

											</div>

										</div>
										
										<?php } ?>

										<?php } } ?>

										<?php
											/**
											 * single_car_end hook
											 */
											do_action( 'single_car_end' );
										?>

									</div>

								</div>

							</div>

						</article>

					</main><!-- #main -->

				</div><!-- #primary -->

			</div>
			<!-- /.col-md-8 -->

			<div class="col-md-4 fantasy-themes-sidebar-width fantasy-themes-sidebar-car">

				<div class="widget-area sidebar-1-area mt-3r">

				    <?php

						if( !empty($website_type) ) {
							if( $website_type == "dealer" OR $website_type == "marketplace" OR $website_type == "rentals_dealer" ) {
									
					?>

					<div itemprop="offers" itemscope itemtype="http://schema.org/Offer" class="widget autoroyal-price-list">
						<span class="price-text"><?php esc_html_e('Our Price', 'autoroyal' ); ?></span>
				      	<h2 itemprop="price" class="autoroyal-price"><?php echo autoroyal_price($price); ?> <?php if(!empty($vehicle_discounted_price)) { ?><s><?php echo autoroyal_price($vehicle_retail_price); ?></s><?php } ?></h2>
				    </div>

				    <div class="widget autoroyal-car-check-availability">

				    	<a href="#" id="open-check-availability" data-toggle="modal" data-target="#check-availability">
				    		<i class="fa fa-check" aria-hidden="true"></i>
							<?php esc_html_e('Check Availability', 'autoroyal' ); ?>
				    	</a>

				    </div>

				    <?php } } ?>

				    <?php

						$website_type = get_option("autoroyal_webiste_type");
						$vehicle_rent_price_set = get_post_meta($post->ID, 'vehicle_rent_price_set',true);

						if( !empty($website_type) AND !empty($vehicle_rent_price_set) ) {
							if( $website_type == "rentals" OR $website_type == "rentals_dealer" ) {
									
					?>

					<div class="widget autoroyal-rent-price-list">

						<span class="rent-price-title"><?php esc_html_e('Rent Prices', 'autoroyal' ); ?></span>
				      	<div id="car-price-sets-<?php echo esc_attr($post->ID); ?>">

                            <?php

                                $vehicle_rent_price_set = get_post_meta($post->ID, 'vehicle_rent_price_set',true);
                
                                $i = 0;

                                if(!empty($vehicle_rent_price_set)) {

                                    foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
                                        
                                        if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

                                            $i++;

                                            ?>

                                            <input type="hidden" id="price-set-period-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['period']); ?>">
                                            <input type="hidden" id="price-set-price-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['price']); ?>">

                                            <?php

                                        }

                                    }

                                }

                            ?>

                            <input type="hidden" class="total-sets" value="<?php echo esc_attr($i); ?>">

                        </div>

                        <ul id="rent-price-table-<?php echo esc_attr($post->ID); ?>">

                            <?php
                
                                $i = 0;

                                if(!empty($vehicle_rent_price_set)) {

                                    foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
                                        
                                        if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

                                            $i++;

                                            ?>

                                            <li class="clearfix">
                                                <span class="pull-left"><?php if($vehicle_rent_price_set_item['period'] == 1) { echo "24"; echo " "; echo esc_html_e('hours', 'autoroyal'); } else { echo esc_attr($vehicle_rent_price_set_item['period']); echo "+ "; echo esc_html_e('days', 'autoroyal'); } ?></span>
                                                <span class="pull-right">
                                                    <b><?php echo autoroyal_clean_price($vehicle_rent_price_set_item['price']); ?></b>
                                                </span>
                                            </li>

                                            <?php

                                        }

                                    }

                                }

                            ?>

                        </ul>
						
						<?php 

							$vehicle_cover_image = get_post_meta($post->ID, 'vehicle_cover_image',true);
		                    if(!empty($vehicle_cover_image)) {
		                        $vehicle_image_url = $vehicle_cover_image;
		                    }

							if(!empty($vehicle_image_url)) { 
								$foto_large = autoroyal_get_resized_image( $vehicle_image_url, 'autoroyal-thumbnail-image' ); 
							} else { 
								$foto_large = ""; 
							}

						?>

						<div id="car-rent-id-<?php echo esc_attr($post->ID); ?>" class="hidden">

							<div class="autoroyal-vehicle-block-meta">

								<a class="heading" href="<?php echo get_permalink( $post->ID ); ?>"><span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?></a>

	                            <ul class="autoroyal-vehicle-block-specs list-view-car-specs autoroyal-rent-subtitle">

	                                <?php if(!empty($terms_vehicle_seats_name)) { ?>
	                                    <li class="autoroyal-vehicle-stock">
	                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 350 350" style="enable-background:new 0 0 350 350;" xml:space="preserve"><path d="M175,171.173c38.914,0,70.463-38.318,70.463-85.586C245.463,38.318,235.105,0,175,0s-70.465,38.318-70.465,85.587
	        C104.535,132.855,136.084,171.173,175,171.173z"/><path d="M41.909,301.853C41.897,298.971,41.885,301.041,41.909,301.853L41.909,301.853z"/><path d="M308.085,304.104C308.123,303.315,308.098,298.63,308.085,304.104L308.085,304.104z"/><path d="M307.935,298.397c-1.305-82.342-12.059-105.805-94.352-120.657c0,0-11.584,14.761-38.584,14.761
	        s-38.586-14.761-38.586-14.761c-81.395,14.69-92.803,37.805-94.303,117.982c-0.123,6.547-0.18,6.891-0.202,6.131
	        c0.005,1.424,0.011,4.058,0.011,8.651c0,0,19.592,39.496,133.08,39.496c113.486,0,133.08-39.496,133.08-39.496
	        c0-2.951,0.002-5.003,0.005-6.399C308.062,304.575,308.018,303.664,307.935,298.397z"/></svg><?php echo esc_attr($terms_vehicle_seats_name); ?>
	                                    </li>
	                                <?php } ?>

	                                <?php if(!empty($terms_vehicle_luggages_name)) { ?>
	                                    <li class="autoroyal-vehicle-stock">
	                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="511.626px" height="511.627px" viewBox="0 0 511.626 511.627" style="enable-background:new 0 0 511.626 511.627;" xml:space="preserve"><path d="M18.842,128.48C6.28,141.043,0,156.08,0,173.588v237.537c0,17.515,6.28,32.552,18.842,45.111
	            c12.563,12.565,27.6,18.842,45.111,18.842h18.271V109.634H63.953C46.438,109.634,31.402,115.917,18.842,128.48z"/><path d="M365.446,63.955c0-7.614-2.663-14.084-7.994-19.414c-5.325-5.33-11.8-7.993-19.411-7.993H173.589
	            c-7.612,0-14.083,2.663-19.414,7.993c-5.33,5.327-7.994,11.799-7.994,19.414v45.679h-36.545v365.444h292.359V109.634h-36.549
	            V63.955z M328.904,109.634H182.725V73.091h146.179V109.634z"/><path d="M492.785,128.48c-12.563-12.562-27.601-18.846-45.111-18.846h-18.274v365.444h18.274c17.511,0,32.548-6.276,45.111-18.842
	            c12.559-12.56,18.842-27.597,18.842-45.111V173.588C511.626,156.08,505.343,141.043,492.785,128.48z"/></svg><?php echo esc_attr($terms_vehicle_luggages_name); ?>
	                                    </li>
	                                <?php } ?>

	                                <?php if(!empty($terms_vehicle_doors_name)) { ?>
	                                    <li class="autoroyal-vehicle-stock">
	                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M446.479,261.188l-55.826-93.043c2.393-1.956,4.013-4.81,4.013-8.145V74.667C394.667,68.771,389.896,64,384,64h-1.505
	            c-3.048-13.035-10.828-24.598-22.245-32.208L325.99,8.958C317.198,3.104,306.969,0,296.417,0h-80.833
	            C205.031,0,194.802,3.104,186,8.958l-34.25,22.833C140.333,39.402,132.555,50.965,129.507,64H128
	            c-5.896,0-10.667,4.771-10.667,10.667V160c0,3.335,1.62,6.189,4.013,8.145l-55.826,93.043c-3.031,5.042-1.396,11.604,3.656,14.625
	            c5.052,3.063,11.615,1.396,14.635-3.667L128,198.5v132.167v10.667c-5.896,0-10.667,4.771-10.667,10.667v85.333
	            c0,5.896,4.771,10.667,10.667,10.667h1.078c5.232,36.089,36.074,64,73.589,64h106.667c37.514,0,68.357-27.911,73.589-64H384
	            c5.896,0,10.667-4.771,10.667-10.667V352c0-5.896-4.771-10.667-10.667-10.667v-10.667V198.5l44.188,73.646
	            c3.021,5.063,9.583,6.729,14.635,3.667C447.875,272.792,449.51,266.229,446.479,261.188z M180.448,116.792
	            c3.917-6.333,10.698-10.125,18.146-10.125h114.812c7.448,0,14.229,3.792,18.146,10.125c3.917,6.333,4.271,14.083,0.938,20.75
	            l-21.333,42.667C307.521,187.479,300.208,192,292.073,192h-72.146c-8.135,0-15.448-4.521-19.083-11.792l-21.333-42.667
	            C176.177,130.875,176.531,123.125,180.448,116.792z M149.333,313.41V185.75l21.333,21.333v95.667L149.333,313.41z
	             M338.208,402.208c-1,1-25.115,24.458-82.208,24.458s-81.208-23.458-82.208-24.458c-3.25-3.25-4.052-8.208-2-12.313l21.333-42.667
	            c2.635-5.229,9.063-7.354,14.281-4.792C207.594,342.542,227.187,352,256,352c29.146,0,48.375-9.438,48.562-9.542
	            c2.542-1.271,5.438-1.438,8.146-0.583c2.677,0.896,4.896,2.833,6.167,5.354l21.333,42.667
	            C342.26,394,341.458,398.958,338.208,402.208z M362.667,313.41l-21.333-10.66v-95.667l21.333-21.333V313.41z"/></svg><?php echo esc_attr($terms_vehicle_doors_name); ?> <?php echo esc_html_e('Doors', 'autoroyal'); ?>
	                                    </li>
	                                <?php } ?>
	                                
	                                <?php if(!empty($terms_vehicle_transmission)) { ?>
	                                    <li class="autoroyal-vehicle-stock">
	                                        <svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"></path><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"></path><circle cx="70" cy="70" r="4"></circle></svg><?php echo esc_attr($terms_vehicle_transmission); ?>
	                                    </li>
	                                <?php } ?>

	                                <?php if(!empty($vehicle_navigation)) { ?>
	                                    <li class="autoroyal-vehicle-stock">
	                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="438.533px" height="438.533px" viewBox="0 0 438.533 438.533" style="enable-background:new 0 0 438.533 438.533;" xml:space="preserve"><path d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
	            c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
	            c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
	            s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
	            C438.533,179.485,428.732,142.795,409.133,109.203z M353.742,297.208c-13.894,23.791-32.736,42.64-56.527,56.534
	            c-23.791,13.894-49.771,20.834-77.945,20.834c-28.167,0-54.149-6.94-77.943-20.834c-23.791-13.895-42.633-32.743-56.527-56.534
	            c-13.897-23.791-20.843-49.772-20.843-77.941c0-28.171,6.949-54.152,20.843-77.943c13.891-23.791,32.738-42.637,56.527-56.53
	            c23.791-13.895,49.772-20.84,77.943-20.84c28.173,0,54.154,6.945,77.945,20.84c23.791,13.894,42.634,32.739,56.527,56.53
	            c13.895,23.791,20.838,49.772,20.838,77.943C374.58,247.436,367.637,273.417,353.742,297.208z"/><path d="M146.181,333.182l146.178-73.087V105.35l-146.178,73.089V333.182z M182.727,200.992l73.094,36.547l-73.094,36.545V200.992
	            z"/></svg><?php echo esc_html_e('Navigation', 'autoroyal'); ?>
	                                    </li>
	                                <?php } ?>

	                                <?php if(!empty($vehicle_ac)) { ?>
	                                    <li class="autoroyal-vehicle-stock">
	                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="700.236px" height="700.236px" viewBox="0 0 700.236 700.236" style="enable-background:new 0 0 700.236 700.236;" xml:space="preserve"><path d="M645.527,495.815l-75.609-43.689l63.832-38.015c10.262-4.944,13.438-18.724,7.602-28.855
	        c-5.941-10.375-18.764-12.563-28.498-6.89l-85.107,49.849L392.488,349.51l135.258-77.894l85.107,49.768
	        c2.658,1.945,6.078,3.08,9.881,3.08c7.213,0,13.674-3.404,18.617-9.889c5.699-10.294,2.66-23.911-7.602-28.855l-63.832-38.015
	        l75.609-43.688c9.855-5.674,13.244-18.4,7.602-28.856c-5.389-10.051-18.723-13.536-28.879-7.619l-75.99,44.094l-1.135-76.03
	        c-0.178-11.753-9.119-21.237-20.896-21.237c-11.775,0-20.984,10.213-20.895,21.237l0.754,100.346l-134.496,77.894V155.788
	        l84.727-48.309c9.891-5.593,14.201-18.643,8.357-28.855c-5.934-10.375-18.115-13.456-28.498-7.619l-64.586,36.475V21.236
	        c0-11.753-9.5-21.236-21.277-21.236c-11.777,0-20.896,9.483-20.896,21.236v87.053l-66.871-37.285
	        c-10.416-5.755-22.274-2.513-28.118,7.619c-5.933,10.375-2.245,23.101,7.976,28.855l87.013,49.039v156.518l-137.542-79.353
	        l0.762-98.077c1.143-11.023-8.738-21.237-20.515-21.237h-0.762c-11.016,0-20.774,9.484-20.896,21.237l-0.762,73.76l-74.084-42.554
	        c-10.343-5.998-23.109-2.432-28.499,7.538c-5.642,10.537-2.724,22.939,7.603,28.937l74.846,43.283l-65.354,39.15
	        C53.96,290.664,50.758,304.443,57,314.575c4.02,6.566,9.873,9.889,17.856,9.889c4.174,0,7.651-1.054,11.015-3.08l85.489-50.498
	        l137.162,78.624l-137.162,79.434l-85.489-50.578c-10.262-5.998-23.49-3.161-28.872,6.89c-5.642,10.456-2.578,23.02,7.214,28.855
	        l65.355,38.744l-74.847,43.689c-10.302,5.998-13.642,18.643-7.603,28.937C51.342,532.614,57,536.1,64.976,536.1
	        c1.897,0,5.698-1.135,10.643-3.08l74.084-42.554l0.762,73.76c0.122,11.753,9.88,20.831,20.896,20.831h0.762
	        c11.777,0,20.604-9.808,20.515-21.642l-0.762-97.996l137.542-78.623v155.707l-87.013,49.038
	        c-10.383,5.836-14.015,18.562-7.976,28.856c4.223,7.214,9.881,10.699,17.856,10.699c3.802,0,7.303-0.648,10.262-2.351
	        l66.871-37.935v88.513c0,11.753,9.119,20.912,20.896,20.912c11.777,0,21.277-9.159,21.277-20.912v-87.054l64.586,36.476
	        c2.957,1.702,6.459,2.351,9.881,2.351c8.355,0,14.516-3.404,18.617-10.699c5.771-10.213,2.043-23.021-8.357-28.856l-84.727-47.498
	        V385.985l134.496,77.894l-0.754,99.536c-0.098,11.834,9.119,21.642,20.896,21.642s20.717-9.078,20.895-20.831l1.135-76.435
	        l75.99,44.499c2.934,1.702,6.84,2.27,11.023,2.27c7.977,0,13.828-3.323,17.855-9.889
	        C659.363,514.539,655.382,501.489,645.527,495.815z"/></svg><?php echo esc_html_e('Air Conditioning', 'autoroyal'); ?>
	                                    </li>
	                                <?php } ?>

	                                <?php if(!empty($rent_deposit)) { ?>
	                                    <li class="autoroyal-vehicle-stock">
	                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="438.543px" height="438.543px" viewBox="0 0 438.543 438.543" style="enable-background:new 0 0 438.543 438.543;" xml:space="preserve"><path d="M396.58,5.424C392.959,1.807,388.675,0,383.727,0H54.824c-4.952,0-9.235,1.807-12.852,5.424
	        c-3.615,3.615-5.424,7.898-5.424,12.847v219.268c0,16.371,3.186,32.596,9.563,48.681c6.374,16.084,14.274,30.361,23.697,42.828
	        c9.423,12.47,20.651,24.605,33.689,36.405c13.04,11.806,25.078,21.6,36.116,29.409c11.038,7.803,22.554,15.181,34.545,22.121
	        c11.991,6.943,20.511,11.663,25.553,14.134c5.043,2.478,9.088,4.38,12.132,5.708c2.286,1.143,4.758,1.718,7.426,1.718
	        c2.671,0,5.14-0.575,7.428-1.718c3.042-1.328,7.087-3.23,12.128-5.708c5.041-2.471,13.565-7.19,25.557-14.134
	        c11.984-6.94,23.504-14.318,34.54-22.121c11.043-7.81,23.079-17.604,36.121-29.409c13.031-11.8,24.263-23.936,33.685-36.405
	        c9.421-12.467,17.319-26.744,23.705-42.828c6.379-16.085,9.562-32.31,9.562-48.681V18.271
	        C401.994,13.319,400.187,9.04,396.58,5.424z M347.178,237.539c0,33.5-22.367,67.759-67.095,102.781
	        c-17.892,14.082-38.164,27.124-60.813,39.115V54.813h127.908V237.539z"/></svg><?php $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($autoroyal_currency)) { echo esc_attr($currency_symbol); } ?><?php echo esc_attr($rent_deposit); ?>
	                                    </li>
	                                <?php } ?>

	                                <?php if(!empty($mileage_limit)) { ?>
	                                    <li class="autoroyal-vehicle-stock">
	                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M435.143,129.356c-6.796-6.795-17.463-7.797-25.407-2.384c-29.926,20.398-180.03,122.969-196.162,139.1
	                c-23.394,23.395-23.394,61.459,0,84.854c11.697,11.696,27.063,17.545,42.427,17.545c15.364,0,30.729-5.849,42.427-17.545
	                c16.131-16.132,118.701-166.236,139.1-196.162C442.939,146.821,441.938,136.153,435.143,129.356z M270.142,322.641
	                c-7.797,7.799-20.486,7.799-28.283,0c-7.798-7.797-7.799-20.482-0.004-28.28c6.268-6.194,48.885-36.588,101.319-73.035
	                C306.728,273.76,276.334,316.375,270.142,322.641z"/><path d="M92.231,401.523l-24.69,12.044C49.475,381.325,40,345.338,40,308.499c0-26.991,4.977-52.842,14.06-76.683l28.291,13.57
	                c2.79,1.338,5.735,1.972,8.636,1.972c7.453,0,14.608-4.185,18.047-11.355c4.776-9.959,0.576-21.906-9.384-26.683l-27.932-13.398
	                c34.717-56.62,94.784-96.095,164.283-102.505v30.081c0,11.046,8.954,20,20,20c11.046,0,20-8.954,20-20V93.402
	                c23.828,2.169,46.884,8.237,68.771,18.117c10.065,4.545,21.912,0.066,26.457-9.999c4.545-10.068,0.068-21.913-10-26.458
	                C328.063,60.091,292.659,52.499,256,52.499c-68.38,0-132.667,26.628-181.02,74.98C26.629,175.832,0,240.119,0,308.499
	                c0,50.53,14.998,99.674,43.373,142.115c3.822,5.715,10.141,8.886,16.639,8.886c2.954,0,5.946-0.655,8.757-2.026l41-20
	                c9.928-4.843,14.05-16.816,9.207-26.744C114.133,400.803,102.159,396.682,92.231,401.523z"/><path d="M489.436,203.271c-4.544-10.067-16.387-14.547-26.458-10c-10.067,4.545-14.544,16.39-9.999,26.457
	                C465.601,247.686,472,277.553,472,308.499c0,36.894-9.506,72.939-27.625,105.218l-25.777-12.275
	                c-9.971-4.748-21.906-0.515-26.656,9.459c-4.749,9.972-0.514,21.907,9.459,26.656l42,20c2.763,1.315,5.692,1.944,8.588,1.944
	                c6.5,0,12.82-3.175,16.637-8.886C497.002,408.173,512,359.029,512,308.499C512,271.84,504.408,236.436,489.436,203.271z"/></svg>
	<?php echo esc_attr($mileage_limit); ?><?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?>
	                                    </li>
	                                <?php } ?>

	                                <?php if(!empty($terms_vehicle_rent_age_name)) { ?>
	                                    <li class="autoroyal-vehicle-stock">
	                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 460.8 460.8" style="enable-background:new 0 0 460.8 460.8;" xml:space="preserve"><path d="M410.624,49.664H50.176C22.528,49.664,0,72.192,0,99.84v261.12c0,27.648,22.528,50.176,50.176,50.176h360.448
	            c27.648,0,50.176-22.528,50.176-50.176V99.84C460.8,72.192,438.272,49.664,410.624,49.664z M99.84,167.936
	            c4.608-22.528,26.624-37.376,49.152-32.768c22.528,4.608,37.376,26.624,32.768,49.152c-3.072,16.384-16.384,29.696-32.768,32.768
	            c-22.528,4.608-44.544-10.24-49.152-32.768C98.816,179.2,98.816,173.568,99.84,167.936z M211.968,315.392
	            c0,6.144-5.12,11.264-11.264,11.264H80.896c-6.144,0-11.264-5.12-11.264-11.264V302.08c-0.512-36.864,26.624-67.584,62.976-72.704
	            c38.912-4.608,74.752,23.552,78.848,62.464c0.512,2.56,0.512,5.632,0.512,8.192V315.392z M387.072,290.304H252.928v-33.792
	            h134.144V290.304z M387.072,204.288H252.928v-33.792h134.144V204.288z"/></svg><?php echo esc_html_e('From', 'autoroyal'); ?> <?php echo esc_attr($terms_vehicle_rent_age_name); ?> <?php echo esc_html_e('years', 'autoroyal'); ?>
	                                    </li>
	                                <?php } ?>
	                                
	                            </ul>

	                        </div>

						</div>

						<div class="align-center">

	                        <a href="#" class="autoroyal-reserve-vehicle autoroyal-button button-icon-right autoroyal-button-align-center" data-toggle="modal" data-target="#reservation-modal" data-car-id="<?php echo esc_attr($post->ID); ?>" data-car-thumb="<?php echo esc_url($foto_large); ?>"><?php esc_html_e('Reserve Now', 'autoroyal'); ?> <i class="fa fa-angle-right"></i></a>

	                    </div>

                    </div>

				    <?php } } ?>

				    <div class="widget autoroyal-car-fuel-consumption">

				    	<?php if( !empty($vehicle_consumption_urban) AND !empty($vehicle_consumption_highway) ) { ?>

					    <div class="text-left autoroyal-fuel-consumption">
							<div class="fuel-consumption-unit">
								<div class="fuel-consumption-value"><?php echo esc_attr($vehicle_consumption_urban); ?></div>
								<div class="fuel-consumption-label"><?php esc_html_e('city', 'autoroyal' ); ?> <?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('l/100km', 'autoroyal' ); } else { esc_html_e('mpg', 'autoroyal' ); } ?></div>
							</div>
							<div class="fuel-consumption-icon">
								<span>
									<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" height="200" width="200" fill="#000000" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" enable-background="new 0 0 100 100" xml:space="preserve"><g><path d="M89.417,36.305c0.18-1.034-0.144-2.146-0.953-2.877l-11.045-9.943c-1.193-1.071-3.198-1.139-4.459-0.146l-1.392,1.098   l0.55-7.6c0.116-1.6-1.102-2.907-2.705-2.907h-4.241V7.292C65.172,3.281,61.892,0,57.88,0H17.819c-4.011,0-7.292,3.281-7.292,7.292   V92.71c0,4.009,3.281,7.29,7.292,7.29H57.88c4.012,0,7.292-3.281,7.292-7.29V70.482h0.241c1.604,0,2.915-1.312,2.915-2.916v-1.449   c1.66,0.897,3.29,2.75,3.75,6.534c0.553,4.566-0.074,8.193-0.579,11.107c-0.301,1.734-0.56,3.231-0.56,4.679   c0,6.78,4.317,10.439,8.38,10.439c2.228,0,4.346-1.059,5.812-2.9c1.49-1.877,2.278-4.481,2.278-7.539   c0-5.536-0.67-10.292-1.318-14.894c-0.787-5.587-1.537-10.905-1.138-17.48c1.454-0.025,2.705-1.127,2.854-2.608l1.653-16.373   C89.488,36.812,89.464,36.554,89.417,36.305z M27.008,35.317c-1.512,0-2.738-1.227-2.738-2.737c0-1.515,1.227-2.738,2.738-2.738   c1.513,0,2.738,1.224,2.738,2.738C29.746,34.091,28.521,35.317,27.008,35.317z M37.851,35.317c-1.511,0-2.737-1.227-2.737-2.737   c0-1.515,1.227-2.738,2.737-2.738c1.514,0,2.739,1.224,2.739,2.738C40.59,34.091,39.364,35.317,37.851,35.317z M48.694,35.317   c-1.512,0-2.737-1.227-2.737-2.737c0-1.515,1.226-2.738,2.737-2.738c1.513,0,2.739,1.224,2.739,2.738   C51.434,34.091,50.207,35.317,48.694,35.317z M59.258,19.937c0,1.604-1.313,2.916-2.917,2.916H19.359   c-1.604,0-2.916-1.312-2.916-2.916v-9.825c0-1.604,1.312-2.916,2.916-2.916h36.981c1.604,0,2.917,1.312,2.917,2.916V19.937z    M81.167,92.824c-1.734,2.182-5.164,0.629-5.164-4.387c0-1.012,0.226-2.311,0.485-3.813c0.531-3.07,1.259-7.277,0.616-12.583   c-0.829-6.815-4.753-10.178-8.776-11.322v-1.161c0-1.604-1.312-2.916-2.915-2.916h-0.241v-13.07h2.096   c1.604,0,3.011-1.308,3.127-2.907l0.331-4.587l7.198,3.511l-0.065,12.875c-0.008,1.316,0.871,2.512,2.067,2.993   c-0.468,7.242,0.35,13.108,1.15,18.797c0.653,4.629,1.27,9.003,1.27,14.185C82.346,90.31,81.927,91.868,81.167,92.824z"/></g></svg>
								</span>
							</div>
							<div class="fuel-consumption-unit">
								<div class="fuel-consumption-value"><?php echo esc_attr($vehicle_consumption_highway); ?></div>
								<div class="fuel-consumption-label"><?php esc_html_e('hwy', 'autoroyal' ); ?> <?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('l/100km', 'autoroyal' ); } else { esc_html_e('mpg', 'autoroyal' ); } ?></div>
							</div>
						</div>

						<?php } ?>

					</div>

				    <div class="widget autoroyal-car-specifications">

				    	<table>
					    	<tbody> 

								<?php if(!empty($vehicle_mileage)) { ?>
								<!-- Mileage -->
								<tr>
		                			<td class="label"><?php esc_html_e('Mileage', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo autoroyal_number($vehicle_mileage); $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo " "; echo "Km"; } else { echo " "; echo "Mi"; } ?></td>
		                		</tr>
								<?php } ?>

								<?php if(!empty($vehicle_condition)) { ?>
								<!-- Condition -->
								<tr>
		                			<td class="label"><?php esc_html_e('Condition', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($vehicle_condition); ?></td>
		                		</tr>
								<?php } ?>
								
					    		<?php if(!empty($terms_vehicle_body_style)) { ?>
					    		<!-- Body Style -->
								<tr>
		                			<td class="label"><?php esc_html_e('Body Style', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($terms_vehicle_body_style_name); ?></td>
		                		</tr>
					    		<?php } ?>

					    		<?php if(!empty($vehicle_engine_type)) { ?>
					    		<!-- Engine -->
					    		<tr>
		                			<td class="label"><?php esc_html_e('Engine', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($vehicle_engine_type); ?></td>
		                		</tr>
		                		<?php } ?>
								
		                		<?php if(!empty($terms_vehicle_transmission)) { ?>
		                		<!-- Transmission -->
		                		<tr>
		                			<td class="label"><?php esc_html_e('Transmission', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($terms_vehicle_transmission); ?></td>
		                		</tr>
		                		<?php } ?>

		                		<?php if(!empty($terms_vehicle_fuel_type)) { ?>
		                		<!-- Fuel Type -->
		                		<tr>
		                			<td class="label"><?php esc_html_e('Fuel', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($terms_vehicle_fuel_type); ?></td>
		                		</tr>
		                		<?php } ?>
		                		
		                		<?php if(!empty($terms_vehicle_drive)) { ?>
		                		<!-- Drivetrain -->
		                		<tr>
		                			<td class="label"><?php esc_html_e('Drivetrain', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($terms_vehicle_drive); ?></td>
		                		</tr>
		                		<?php } ?>

		                		<?php if(!empty($color_name)) { ?>
		                		<!-- Exterior Color -->
		                		<tr>
		                			<td class="label"><?php esc_html_e('Exterior Color', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($color_name); ?></td>
		                		</tr>
		                		<?php } ?>

		                		<?php if(!empty($color_interior_name)) { ?>
		                		<!-- Interior Color -->
		                		<tr>
		                			<td class="label"><?php esc_html_e('Interior Color', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($color_interior_name); ?></td>
		                		</tr>
		                		<?php } ?>

		                		<?php if(!empty($material_interior_name)) { ?>
		                		<!-- Interior Color -->
		                		<tr>
		                			<td class="label"><?php esc_html_e('Interior Fabric', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($material_interior_name); ?></td>
		                		</tr>
		                		<?php } ?>
		                		
		                		<?php if(!empty($vehicle_stock)) { ?>
		                		<!-- Stock # -->
		                		<tr>
		                			<td class="label"><?php esc_html_e('Stock', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($vehicle_stock); ?></td>
		                		</tr>
		                		<?php } ?>
		            			
		            			<?php if(!empty($vehicle_vin)) { ?>
		            			<!--VIN NUMBER-->
		                        <tr>
		                			<td class="label"><?php esc_html_e('Vin', 'autoroyal' ); ?></td>
		                			<td class="value h6"><?php echo esc_attr($vehicle_vin); ?></td>
		                		</tr>
		                		<?php } ?>

		                    </tbody>

		                </table>

		                <?php

							if( !empty($website_type) ) {
								if( $website_type == "dealer" OR $website_type == "marketplace" OR $website_type == "rentals_dealer" ) {
										
						?>

		                <?php if(!empty($vehicle_carfax_link) OR !empty($vehicle_autocheck_link) OR !empty($vehicle_pre_owned)) { ?>
	                    <div class="autoroyal-carfax-link">
	                    	<?php if(!empty($vehicle_carfax_link)) { ?>
	                    	<a href="<?php echo esc_url($vehicle_carfax_link); ?>">
							    <img src="<?php echo autoroyal_PLUGIN_URL; ?>/assets/images/carfax-logo_03.png" alt="carfax-logo" class="img-responsive">
							</a>
							<?php } ?>
							<?php if(!empty($vehicle_autocheck_link)) { ?>
	                    	<a href="<?php echo esc_url($vehicle_autocheck_link); ?>">
							    <img src="<?php echo autoroyal_PLUGIN_URL; ?>/assets/images/autocheck.png" alt="autocheck-logo" class="img-responsive">
							</a>
							<?php } ?>
							<?php if(!empty($vehicle_pre_owned)) { ?>
	                    	<a href="<?php echo esc_url($vehicle_pre_owned); ?>">
							    <img src="<?php echo autoroyal_PLUGIN_URL; ?>/assets/images/certified-pre-owned.png" alt="certified-pre-owned-logo" class="img-responsive">
							</a>
							<?php } ?>
						</div>
						<?php } ?>

						<?php } } ?>

				    </div>

				    <?php

						if( !empty($website_type) ) {
							if( $website_type == "dealer" OR $website_type == "marketplace" OR $website_type == "rentals_dealer" ) {
									
					?>

				    <div class="widget autoroyal-car-financing-calculator">

				    	<h4><?php esc_html_e('Financing Calculator', 'autoroyal' ); ?> <i class="fa fa-calculator" aria-hidden="true"></i></h4>

				    	<div class="autoroyal-car-financing-calculator-container">

				    		<?php $currency = autoroyal_get_currency(); $currency_symbol = autoroyal_get_currency_symbol( $currency ) ?>
			                <form class="form-inline payment-calculator" method="post" id="paymentCalc">

			                	<div class="row">
									
									<div class="col-md-12">

										<input type="hidden" id="autoroyal-currency" value="<?php echo esc_attr($currency_symbol); ?>" >
					                  	<div class="form-group">
						                    <label for="vehiclePrice"><?php esc_html_e('Vehicle price', 'autoroyal' ); ?> <span>(<?php echo esc_attr($currency_symbol); ?>)</span></label>
						                    <input type="number" class="form-control" id="vehiclePrice" value="<?php echo esc_attr($price); ?>" maxlength="8">
					                  	</div>

				                  	</div>

				                  	<div class="col-md-12">

					                  	<div class="form-group">
						                    <label for="firstPayment"><?php esc_html_e('Down Payment', 'autoroyal' ); ?> <span>(<?php echo esc_attr($currency_symbol); ?>)</span></label>
						                    <input type="number" class="form-control" id="firstPayment" value="0">
					                  	</div>

				                  	</div>

				                  	<div class="col-md-6">

					                  	<div class="form-group">
						                    <label for="intRate"><?php esc_html_e('Interest rate', 'autoroyal' ); ?> <span>(%)</span></label>
						                    <input type="number" class="form-control" id="intRate" value="3">
					                  	</div>

				                  	</div>

				                  	<div class="col-md-6">

					                  	<div class="form-group">
						                    <label for="paymentPeriod"><?php esc_html_e('Period', 'autoroyal' ); ?> <span><?php esc_html_e('(months)', 'autoroyal' ); ?></span></label>
						                    <input type="number" class="form-control" id="paymentPeriod" value="24">
					                  	</div>
					                  	<div class="clearfix"></div>

				                  	</div>

				                  </div>

			                </form>

			                <!-- calculator results -->
			                <ul class="form-results pull-left list-unstyled text-uppercase">
			                  <li>
			                    <span><?php esc_html_e('total amount to pay', 'autoroyal' ); ?></span>
			                    <h4 id="totalResult">0</h4>
			                  </li>
			                  <li>
			                    <span><?php esc_html_e('Monthly payment', 'autoroyal' ); ?></span>
			                    <h4 id="monthPay">0</h4>
			                  </li>
			                  <li>
			                    <span><?php esc_html_e('total interest payment', 'autoroyal' ); ?></span>
			                    <h4 id="interesPayment">0</h4>
			                  </li>
			                </ul>
			                <div class="clearfix"></div>

			            </div>

				    </div>

					<?php } } ?>

				</div>

			</div>


		</div>
		<!-- /.row -->
	</div>
	<!-- /.container -->

	<!-- Check Availability -->
	<div class="modal fade bd-example-modal-lg" id="check-availability" tabindex="-1" role="dialog" aria-labelledby="checkavailabilityLabel">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    		<div class="modal-content">

		    	<div class="check-availability-loading">
		    		<i class="fa fa-spinner fa-spin"></i>
		    	</div>

		    	<div class="cs-modal-header">

	    			<h4><i class="fa fa-check"></i> <?php esc_html_e('Check Availability', 'autoroyal' ); ?></h4>
	    			<a href="#" class="close" data-dismiss="modal"><i class="fa fa-close"></i></a>

	    		</div>

		    	<div class="cs-modal-inner">

		    		<div id="check-availability-response">

			    		<h5 class="heading"><?php esc_html_e('Thank you for contacting us. We will get back to you shortly.', 'autoroyal' ); ?></h5>

					</div>

		    		<form id="check-availability-form" class="contact-form" action="<?php echo admin_url('admin-ajax.php'); ?>" method="post">
		      
				      	<div class="inputs-side">

				      		<div class="row">

				      			<div class="col-md-4">

						            <div class="form-group">
						              	<label for="userName"><?php esc_html_e('Your Name', 'autoroyal' ); ?> *</label>
						              	<input type="text" class="form-control userName" name="userName" placeholder="John Doe">
						              	<?php $name_error_text = get_option( 'autoroyal_contact_form_name_error' ); if(!empty($name_error_text)) { ?>
						              	<label class="error userName-error" for="userName"><?php echo esc_attr($name_error_text); ?></label>
						              	<?php } ?>
						            </div>

						        </div>

						        <div class="col-md-4">

						            <div class="form-group">
						              	<label for="userMail"><?php esc_html_e('Email address', 'autoroyal' ); ?> *</label>
						              	<input type="email" class="form-control userMail" name="userMail" placeholder="email@domain.com">
						              	<?php $email_error_text = get_option( 'autoroyal_contact_form_email_error' ); if(!empty($email_error_text)) { ?>
						              	<label class="error userMail-error" for="userMail"><?php echo esc_attr($email_error_text); ?></label>
						              	<?php } ?>
						            </div>

						        </div>

						        <div class="col-md-4">

						            <div class="form-group">
						              	<label for="userPhone"><?php esc_html_e('Phone number', 'autoroyal' ); ?> *</label>
						              	<input type="text" class="form-control userPhone" name="userPhone" placeholder="+123 456 7890">
						              	<?php $phone_error_text = get_option( 'autoroyal_contact_form_phone_error' ); if(!empty($phone_error_text)) { ?>
						              	<label class="error userPhone-error" for="userPhone"><?php echo esc_attr($phone_error_text); ?></label>
						              	<?php } ?>
						            </div>

						        </div>

						        <div class="col-md-12">

						            <div class="form-group">
						              	<label for="textMessage"><?php esc_html_e('Message', 'autoroyal' ); ?></label>
						              	<textarea class="form-control textMessage" cols="30" rows="3" name="textMessage"><?php esc_html_e('Could you provide more information about this', 'autoroyal' ); ?> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?> <?php echo esc_attr($vehicle_trim_desc_init); ?>?</textarea>
						            </div>

						            <button id="check-availability-form-submit" type="submit" class="btn btn-default">
						              	<?php esc_html_e('Send Message', 'autoroyal' ); ?>
						            </button>

						            <p class="small-text mb-0 mt-3"><?php esc_html_e('By clicking "Send Message", I consent to be contacted by the dealer selling this vehicle at any telephone number I provide, including, without limitation, communications sent via text message to my cell phone or communications sent using an autodialer or prerecorded message. This acknowledgement constitutes my written consent to receive such communications.', 'autoroyal' ); ?></p>

						        </div>

					            <input type="hidden" name="car_name" value="<?php get_the_title(); ?>" />
					            <input type="hidden" name="car_url" value="<?php echo get_permalink(); ?>" />
					            <input type="hidden" name="car_id" value="<?php echo get_the_ID(); ?>" />
					            <input type="hidden" name="dealer_email" value="<?php echo esc_attr($email_to); ?>" />
					            <input type="hidden" name="autoroyal_dealer_id" value="<?php echo esc_attr($user_id ); ?>" />
					            <input type="hidden" name="action" value="autoroyal_check_availability">

							</div>

				      	</div>
				      	<div class="clearfix"></div>

				    </form>
					
		    	</div>
		    </div>
	    </div>
	</div>

	<!-- Pre Qualify -->
	<div class="modal fade bd-example-modal-lg" id="pre-qualify" tabindex="-1" role="dialog" aria-labelledby="prequalifyLabel">

		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    
    		<div class="modal-content">

		    	<div class="pre-qualify-loading">
		    		<i class="fa fa-spinner fa-spin"></i>
		    	</div>

		    	<div class="cs-modal-header">

	    			<h4><i class="fa fa-paper-plane" aria-hidden="true"></i> <?php esc_html_e('Pre Qualify', 'autoroyal' ); ?></h4>
	    			<a href="#" class="close" data-dismiss="modal"><i class="fa fa-close"></i></a>

	    		</div>

		    	<div class="cs-modal-inner">

		    		<div id="pre-qualify-response">

			    		<h5 class="heading">
							<?php esc_html_e('Thank You.', 'autoroyal' ); ?><br>
							<?php esc_html_e('Your Pre-Qualify Request has been sent.', 'autoroyal' ); ?><br>
							<?php esc_html_e('You should receive a confirmation shortly.', 'autoroyal' ); ?><br>
							<?php esc_html_e('If you have questions or concerns please call and let us know.', 'autoroyal' ); ?>
			    		</h5>

					</div>

		    		<form id="pre-qualify-form" class="contact-form pre-qualify-form-application" action="<?php echo admin_url('admin-ajax.php'); ?>" method="post">

				    	<div class="options_group">

				    		<h2 class="options_group_heading"><?php esc_html_e('Personal Info', 'autoroyal' ); ?></h2>

				    		<fieldset>
				      
						      	<div class="row">

									<div class="col-md-4 has-error-alert">

										<label for="lead_first_name" class="control-label"><?php esc_html_e('First Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_first_name" name="lead_first_name" value=""  />
										<label id="lead_first_name-error" class="error" for="lead_first_name"><?php esc_html_e('Please add a name', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_middle_name" class="control-label"><?php esc_html_e('Middle Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_middle_name" name="lead_middle_name" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_last_name" class="control-label"><?php esc_html_e('Last Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_last_name" name="lead_last_name" value=""  />

									</div>

									<div class="col-md-6">

										<label for="lead_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_address_1" name="lead_address_1" value=""  />

									</div>

									<div class="col-md-6">

										<label for="lead_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_address_2" name="lead_address_2" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_city" name="lead_city" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_state" name="lead_state" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_zip" name="lead_zip" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_home_phone" class="control-label"><?php esc_html_e('Home Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_home_phone" name="lead_home_phone" value=""  />

									</div>

									<div class="col-md-4 has-error-alert">

										<label for="lead_mobile_phone" class="control-label"><?php esc_html_e('Mobile Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_mobile_phone" name="lead_mobile_phone" value=""  />
										<label id="lead_mobile_phone-error" class="error" for="lead_mobile_phone"><?php esc_html_e('Please add a phone', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_work_phone" class="control-label"><?php esc_html_e('Work Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_work_phone" name="lead_work_phone" value=""  />

									</div>

									<div class="col-md-4">

										<label for="time_at_address" class="control-label"><?php esc_html_e('Time At Residence:', 'autoroyal' ); ?></label>
										<select name="time_at_address" class="time_at_address form-control input-lg">
											<option value=""></option>
											<option value="0"><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
											<option value="1"><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
											<option value="2"><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
											<option value="3"><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
											<option value="4"><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
											<option value="5"><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
											<option value="6"><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
											<option value="7"><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
											<option value="8"><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
											<option value="9"><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
											<option value="10"><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
											<option value="11"><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
											<option value="12"><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>
										</select>

									</div>

									<div class="col-md-4">

										<label for="residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
										<select name="residence_type" class="residence_type form-control input-lg">
											<option value=""></option>
											<option value="Rent" ><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
											<option value="Own" ><?php esc_html_e('Own', 'autoroyal' ); ?></option>

										</select>

									</div>

									<div class="col-md-4">

										<label for="residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
										<input type="text" class="residence_price" name="residence_price" value=""  />

									</div>

									<div class="col-md-6 has-error-alert">

										<label for="lead_email" class="control-label"><?php esc_html_e('Email Address:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_email" name="lead_email" value=""  />
										<label id="lead_email-error" class="error" for="lead_email"><?php esc_html_e('Please add an email', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-6">

										<label for="lead_birth_date" class="control-label"><?php esc_html_e('Date of Birth:', 'autoroyal' ); ?></label>

										<div class="autoroyal-input-has-icon">
											<input class="date_picker_past autoroyal-input-icon-left" type="text" class="lead_birth_date" name="lead_birth_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="" />
											<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
										</div>

									</div>

								</div>

							</fieldset>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Employment Info', 'autoroyal' ); ?></h2>

							<fieldset>

								<div id="buyer_employer" class="lead_buyer_employers active">

									<div class="row">

										<div class="col-md-6">

											<label for="employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_name" name="employer[name]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
											<input type="text" class="employer_income" name="employer[income]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_occupation" class="control-label"><?php esc_html_e('Occupation:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_occupation" name="employer[occupation]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_address_1" name="employer[address_1]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_address_2" name="employer[address_2]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_city" name="employer[city]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_state" name="employer[state]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_zip" name="employer[zip]" value=""  />

										</div>

										<div class="col-md-12">

											<label for="employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_phone" name="employer[phone]" value=""  />

										</div>

										<div class="col-md-12">

											<h2 class="options_group_heading"><?php esc_html_e('Time On Job', 'autoroyal' ); ?></h2>

										</div>

										<div class="col-md-6">

											<label for="employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
											<select name="employer_years" class="employer_years form-control input-lg">
												<option value=""></option>
												<option value="0" ><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
												<option value="1" ><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
												<option value="2" ><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
												<option value="3" ><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
												<option value="4" ><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
												<option value="5" ><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
												<option value="6" ><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
												<option value="7" ><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
												<option value="8" ><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
												<option value="9" ><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
												<option value="10" ><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
												<option value="11" ><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
												<option value="12" ><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

											</select>

										</div>

										<div class="col-md-6">

											<label for="employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
											<select name="employer_months" class="employer_months form-control input-lg">
												<option value=""></option>
												<option value="0" ><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
												<option value="1" ><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
												<option value="2" ><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
												<option value="3" ><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
												<option value="4" ><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
												<option value="5" ><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
												<option value="6" ><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
												<option value="7" ><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
												<option value="8" ><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
												<option value="9" ><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
												<option value="10" ><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
												<option value="11" ><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

											</select>

										</div>

									</div>

								</div>

							</fieldset>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Trade-In', 'autoroyal' ); ?></h2>

							<fieldset class="select-car-model-table">

								<table id="select-car-model">

									<tbody>

										<tr valign="bottom">
											<th><?php esc_html_e('Make', 'autoroyal' ); ?></th>
											<th><?php esc_html_e('Model', 'autoroyal' ); ?></th>
											<th><?php esc_html_e('Year', 'autoroyal' ); ?></th>
											<th><?php esc_html_e('Trim', 'autoroyal' ); ?></th>
										</tr>

										<tr>

											<td>
												<select name="cq-make" id="cq-make" class="cq-make form-control input-lg"></select>
											</td>

											<td>
												<select name="cq-model" id="cq-model" class="cq-model form-control input-lg" disabled></select>
											</td>

											<td>
												<select name="cq-year" id="cq-year" class="cq-year form-control input-lg" disabled></select>
											</td>

											<td>
												<select name="cq-trim" id="cq-trim" class="cq-trim form-control input-lg" disabled></select>
											</td>

										</tr>

									</tbody>

								</table>

							</fieldset>

							<fieldset>
								
								<div class="row">

									<div class="col-md-4">

										<label for="lead_tradein_vehicle_vin" class="control-label"><?php esc_html_e('VIN:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_tradein_vehicle_vin" name="lead_tradein_vehicle_vin" value=""  />
										<label id="lead_tradein_vehicle_vin-error" class="error" for="lead_tradein_vehicle_vin"><?php esc_html_e('Please add a VIN code', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_tradein_vehicle_mileage" class="control-label"><?php esc_html_e('Mileage:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_tradein_vehicle_mileage" name="lead_tradein_vehicle_mileage" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_tradein_vehicle_color" class="control-label"><?php esc_html_e('Color:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_tradein_vehicle_color" name="lead_tradein_vehicle_color" value=""  />

									</div>

								</div>
								
							</fieldset>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Questions and Comments', 'autoroyal' ); ?></h2>

							<fieldset>

								<div class="row">

									<div class="col-md-12">

										<textarea  cols="20" rows="7" class="input-text" name="lead_comments" ></textarea>

									</div>

								</div>

							</fieldset>

						</div>

						<input type="hidden" name="lead_vehicle_id" value="<?php echo get_the_ID(); ?>" />
						<input type="hidden" name="autoroyal_dealer_id" value="<?php echo esc_attr($user_id); ?>" />
						<input type="hidden" name="autoroyal_dealer_email" value="<?php echo esc_attr($email_to); ?>" />
						<input type="hidden" name="action" value="autoroyal_pre_qualify" />

						<a id="autoroyal_pre_qualify_me" href="#" class="btn btn-default"><i class="fa fa-spinner fa-spin fa-3x fa-fw"></i> <?php esc_html_e( 'Qualify Me', 'autoroyal' ) ?></a>

						<p class="small-text"><?php esc_html_e('By clicking "Qualify Me", I consent to be contacted by the dealer selling this vehicle at any telephone number I provide, including, without limitation, communications sent via text message to my cell phone or communications sent using an autodialer or prerecorded message. This acknowledgement constitutes my written consent to receive such communications.', 'autoroyal' ); ?></p>

				    </form>
					
		    	</div>
		    </div>
	    </div>
	</div>

	<!-- Financial Application -->
	<div class="modal fade bd-example-modal-lg" id="financial-application" tabindex="-1" role="dialog" aria-labelledby="financialapplicationLabel">

		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    
    		<div class="modal-content">

		    	<div class="financial-application-loading">
		    		<i class="fa fa-spinner fa-spin"></i>
		    	</div>

		    	<div class="cs-modal-header">

	    			<h4><i class="fas fa-dollar-sign" aria-hidden="true"></i> <?php esc_html_e('Financial Application', 'autoroyal' ); ?></h4>
	    			<a href="#" class="close" data-dismiss="modal"><i class="fa fa-close"></i></a>

	    		</div>

		    	<div class="cs-modal-inner">

		    		<div id="financial-application-response">

			    		<h5 class="heading">
							<?php esc_html_e('Thank You.', 'autoroyal' ); ?><br>
							<?php esc_html_e('Your Finance Request has been sent.', 'autoroyal' ); ?><br>
							<?php esc_html_e('You should receive a confirmation shortly.', 'autoroyal' ); ?><br>
							<?php esc_html_e('If you have questions or concerns please call and let us know.', 'autoroyal' ); ?>
			    		</h5>

					</div>

					<form id="financial-application-form" class="contact-form contact-form-application" action="<?php echo admin_url('admin-ajax.php'); ?>" method="post">

				    	<div class="options_group">

				    		<h2 class="options_group_heading"><?php esc_html_e('Personal Info', 'autoroyal' ); ?></h2>

				    		<fieldset>
				      
						      	<div class="row">

									<div class="col-md-4 has-error-alert">

										<label for="lead_first_name" class="control-label"><?php esc_html_e('First Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_first_name" name="lead_first_name" value=""  />
										<label id="lead_first_name-error" class="error" for="lead_first_name"><?php esc_html_e('Please add a name', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_middle_name" class="control-label"><?php esc_html_e('Middle Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_middle_name" name="lead_middle_name" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_last_name" class="control-label"><?php esc_html_e('Last Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_last_name" name="lead_last_name" value=""  />

									</div>

									<div class="col-md-6">

										<label for="lead_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_address_1" name="lead_address_1" value=""  />

									</div>

									<div class="col-md-6">

										<label for="lead_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_address_2" name="lead_address_2" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_city" name="lead_city" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_state" name="lead_state" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_zip" name="lead_zip" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_home_phone" class="control-label"><?php esc_html_e('Home Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_home_phone" name="lead_home_phone" value=""  />

									</div>

									<div class="col-md-4 has-error-alert">

										<label for="lead_mobile_phone" class="control-label"><?php esc_html_e('Mobile Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_mobile_phone" name="lead_mobile_phone" value=""  />
										<label id="lead_mobile_phone-error" class="error" for="lead_mobile_phone"><?php esc_html_e('Please add a phone', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_work_phone" class="control-label"><?php esc_html_e('Work Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_work_phone" name="lead_work_phone" value=""  />

									</div>

									<div class="col-md-4">

										<label for="time_at_address" class="control-label"><?php esc_html_e('Time At Residence:', 'autoroyal' ); ?></label>
										<select name="time_at_address" class="time_at_address form-control input-lg">
											<option value=""></option>
											<option value="0"><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
											<option value="1"><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
											<option value="2"><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
											<option value="3"><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
											<option value="4"><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
											<option value="5"><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
											<option value="6"><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
											<option value="7"><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
											<option value="8"><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
											<option value="9"><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
											<option value="10"><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
											<option value="11"><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
											<option value="12"><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>
										</select>

									</div>

									<div class="col-md-4">

										<label for="residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
										<select name="residence_type" class="residence_type form-control input-lg">
											<option value=""></option>
											<option value="Rent" ><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
											<option value="Own" ><?php esc_html_e('Own', 'autoroyal' ); ?></option>

										</select>

									</div>

									<div class="col-md-4">

										<label for="residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
										<input type="text" class="residence_price" name="residence_price" value=""  />

									</div>

									<div class="col-md-4 has-error-alert">

										<label for="lead_email" class="control-label"><?php esc_html_e('Email Address:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_email" name="lead_email" value=""  />
										<label id="lead_email-error" class="error" for="lead_email"><?php esc_html_e('Please add an email', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_birth_date" class="control-label"><?php esc_html_e('Date of Birth:', 'autoroyal' ); ?></label>

										<div class="autoroyal-input-has-icon">
											<input class="date_picker_past autoroyal-input-icon-left" type="text" class="lead_birth_date" name="lead_birth_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="" />
											<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
										</div>

									</div>

									<div class="col-md-4">

										<label for="lead_social_security" class="control-label"><i class="fa fa-lock" aria-hidden="true"></i> <?php esc_html_e('Social Security Number:', 'autoroyal' ); ?></label>
										<input type="text" id="lead_social_security" name="lead_social_security" value=""  />

									</div>

								</div>

							</fieldset>

							<h5 class="autoroyal-secure-info"><?php esc_html_e('* We secure and protect your confidential information', 'autoroyal' ); ?></h5>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Employment Info', 'autoroyal' ); ?></h2>

							<fieldset>

								<div id="buyer_employer" class="lead_buyer_employers active">

									<div class="row">

										<div class="col-md-6">

											<label for="employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_name" name="employer[name]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
											<input type="text" class="employer_income" name="employer[income]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_occupation" class="control-label"><?php esc_html_e('Occupation:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_occupation" name="employer[occupation]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_address_1" name="employer[address_1]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_address_2" name="employer[address_2]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_city" name="employer[city]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_state" name="employer[state]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_zip" name="employer[zip]" value=""  />

										</div>

										<div class="col-md-12">

											<label for="employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_phone" name="employer[phone]" value=""  />

										</div>

										<div class="col-md-12">

											<h2 class="options_group_heading"><?php esc_html_e('Time On Job', 'autoroyal' ); ?></h2>

										</div>

										<div class="col-md-6">

											<label for="employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
											<select name="employer_years" class="employer_years form-control input-lg">
												<option value=""></option>
												<option value="0" ><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
												<option value="1" ><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
												<option value="2" ><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
												<option value="3" ><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
												<option value="4" ><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
												<option value="5" ><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
												<option value="6" ><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
												<option value="7" ><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
												<option value="8" ><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
												<option value="9" ><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
												<option value="10" ><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
												<option value="11" ><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
												<option value="12" ><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

											</select>

										</div>

										<div class="col-md-6">

											<label for="employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
											<select name="employer_months" class="employer_months form-control input-lg">
												<option value=""></option>
												<option value="0" ><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
												<option value="1" ><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
												<option value="2" ><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
												<option value="3" ><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
												<option value="4" ><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
												<option value="5" ><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
												<option value="6" ><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
												<option value="7" ><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
												<option value="8" ><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
												<option value="9" ><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
												<option value="10" ><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
												<option value="11" ><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

											</select>

										</div>

									</div>

								</div>

							</fieldset>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Trade-In', 'autoroyal' ); ?></h2>

							<fieldset class="select-car-model-table">

								<table id="select-car-model">

									<tbody>

										<tr valign="bottom">
											<th><?php esc_html_e('Make', 'autoroyal' ); ?></th>
											<th><?php esc_html_e('Model', 'autoroyal' ); ?></th>
											<th><?php esc_html_e('Year', 'autoroyal' ); ?></th>
											<th><?php esc_html_e('Trim', 'autoroyal' ); ?></th>
										</tr>

										<tr>

											<td>
												<select name="cq-make" id="cq-make" class="cq-make form-control input-lg"></select>
											</td>

											<td>
												<select name="cq-model" id="cq-model" class="cq-model form-control input-lg" disabled></select>
											</td>

											<td>
												<select name="cq-year" id="cq-year" class="cq-year form-control input-lg" disabled></select>
											</td>

											<td>
												<select name="cq-trim" id="cq-trim" class="cq-trim form-control input-lg" disabled></select>
											</td>

										</tr>

									</tbody>

								</table>

							</fieldset>

							<fieldset>
								
								<div class="row">

									<div class="col-md-4">

										<label for="lead_tradein_vehicle_vin" class="control-label"><?php esc_html_e('VIN:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_tradein_vehicle_vin" name="lead_tradein_vehicle_vin" value=""  />
										<label id="lead_tradein_vehicle_vin-error" class="error" for="lead_tradein_vehicle_vin"><?php esc_html_e('Please add a VIN code', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_tradein_vehicle_mileage" class="control-label"><?php esc_html_e('Mileage:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_tradein_vehicle_mileage" name="lead_tradein_vehicle_mileage" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_tradein_vehicle_color" class="control-label"><?php esc_html_e('Color:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_tradein_vehicle_color" name="lead_tradein_vehicle_color" value=""  />

									</div>

								</div>
								
							</fieldset>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Questions and Comments', 'autoroyal' ); ?></h2>

							<fieldset>

								<div class="row">

									<div class="col-md-12">

										<textarea  cols="20" rows="7" class="input-text" name="lead_comments" ></textarea>

									</div>

								</div>

							</fieldset>

						</div>
						
						<input type="hidden" name="lead_vehicle_id" value="<?php echo get_the_ID(); ?>" />
						<input type="hidden" name="autoroyal_form_name" value="financial_app" />

						<input type="hidden" name="autoroyal_dealer_id" value="<?php echo esc_attr($user_id); ?>" />
						<input type="hidden" name="autoroyal_dealer_email" value="<?php echo esc_attr($email_to); ?>" />

						<input type="hidden" name="action" value="autoroyal_ajax_financial_application" />

						<a id="autoroyal_submit_application_form" href="#" class="btn btn-default"><i class="fa fa-spinner fa-spin fa-3x fa-fw"></i> <?php esc_html_e( 'Submit Application', 'autoroyal' ) ?></a>

						<p class="small-text"><?php esc_html_e('By clicking "Submit Application", I consent to be contacted by the dealer selling this vehicle at any telephone number I provide, including, without limitation, communications sent via text message to my cell phone or communications sent using an autodialer or prerecorded message. This acknowledgement constitutes my written consent to receive such communications.', 'autoroyal' ); ?></p>

				    </form>

				</div>

			</div>

		</div>

	</div>

	<!-- test Drive -->
	<div class="modal fade bd-example-modal-lg" id="test-drive" tabindex="-1" role="dialog" aria-labelledby="testdriveLabel">

		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    
    		<div class="modal-content">

		    	<div class="test-drive-loading">
		    		<i class="fa fa-spinner fa-spin"></i>
		    	</div>

		    	<div class="cs-modal-header">

	    			<h4><i class="fas fa-tachometer-alt" aria-hidden="true"></i> <?php esc_html_e('Test Drive', 'autoroyal' ); ?></h4>
	    			<a href="#" class="close" data-dismiss="modal"><i class="fa fa-close"></i></a>

	    		</div>

		    	<div class="cs-modal-inner">

		    		<div id="test-drive-response">

			    		<h5 class="heading">
							<?php esc_html_e('Thank You.', 'autoroyal' ); ?><br>
							<?php esc_html_e('Your Test Drive Request has been sent.', 'autoroyal' ); ?><br>
							<?php esc_html_e('You should receive a confirmation shortly.', 'autoroyal' ); ?><br>
							<?php esc_html_e('If you have questions or concerns please call and let us know.', 'autoroyal' ); ?>
			    		</h5>

					</div>

					<form id="test-drive-form" class="contact-form test-drive-form-application" action="<?php echo admin_url('admin-ajax.php'); ?>" method="post">

				    	<div class="options_group">

				    		<h2 class="options_group_heading"><?php esc_html_e('Personal Info', 'autoroyal' ); ?></h2>

				    		<fieldset>
				      
						      	<div class="row">

									<div class="col-md-4 has-error-alert">

										<label for="lead_first_name" class="control-label"><?php esc_html_e('First Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_first_name" name="lead_first_name" value=""  />
										<label id="lead_first_name-error" class="error" for="lead_first_name"><?php esc_html_e('Please add a name', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_middle_name" class="control-label"><?php esc_html_e('Middle Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_middle_name" name="lead_middle_name" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_last_name" class="control-label"><?php esc_html_e('Last Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_last_name" name="lead_last_name" value=""  />

									</div>

									<div class="col-md-6">

										<label for="lead_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_address_1" name="lead_address_1" value=""  />

									</div>

									<div class="col-md-6">

										<label for="lead_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_address_2" name="lead_address_2" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_city" name="lead_city" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_state" name="lead_state" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_zip" name="lead_zip" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_home_phone" class="control-label"><?php esc_html_e('Home Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_home_phone" name="lead_home_phone" value=""  />

									</div>

									<div class="col-md-4 has-error-alert">

										<label for="lead_mobile_phone" class="control-label"><?php esc_html_e('Mobile Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_mobile_phone" name="lead_mobile_phone" value=""  />
										<label id="lead_mobile_phone-error" class="error" for="lead_mobile_phone"><?php esc_html_e('Please add a phone', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_work_phone" class="control-label"><?php esc_html_e('Work Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_work_phone" name="lead_work_phone" value=""  />

									</div>

									<div class="col-md-4">

										<label for="time_at_address" class="control-label"><?php esc_html_e('Time At Residence:', 'autoroyal' ); ?></label>
										<select name="time_at_address" class="time_at_address form-control input-lg">
											<option value=""></option>
											<option value="0"><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
											<option value="1"><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
											<option value="2"><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
											<option value="3"><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
											<option value="4"><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
											<option value="5"><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
											<option value="6"><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
											<option value="7"><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
											<option value="8"><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
											<option value="9"><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
											<option value="10"><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
											<option value="11"><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
											<option value="12"><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>
										</select>

									</div>

									<div class="col-md-4">

										<label for="residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
										<select name="residence_type" class="residence_type form-control input-lg">
											<option value=""></option>
											<option value="Rent" ><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
											<option value="Own" ><?php esc_html_e('Own', 'autoroyal' ); ?></option>

										</select>

									</div>

									<div class="col-md-4">

										<label for="residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
										<input type="text" class="residence_price" name="residence_price" value=""  />

									</div>

									<div class="col-md-6 has-error-alert">

										<label for="lead_email" class="control-label"><?php esc_html_e('Email Address:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_email" name="lead_email" value=""  />
										<label id="lead_email-error" class="error" for="lead_email"><?php esc_html_e('Please add an email', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-6">

										<label for="lead_birth_date" class="control-label"><?php esc_html_e('Date of Birth:', 'autoroyal' ); ?></label>

										<div class="autoroyal-input-has-icon">
											<input class="date_picker_past autoroyal-input-icon-left" type="text" class="lead_birth_date" name="lead_birth_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="" />
											<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
										</div>

									</div>

									<div class="col-md-4">

										<label for="lead_driver_license_state" class="control-label"><?php esc_html_e('Drivers License State:', 'autoroyal' ); ?></label>
										<input type="text" id="lead_driver_license_state" name="lead_driver_license_state" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_driver_license_number" class="control-label"><?php esc_html_e('Drivers License Number:', 'autoroyal' ); ?></label>
										<input type="text" id="lead_driver_license_number" name="lead_driver_license_number" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_driver_license_exp" class="control-label"><?php esc_html_e('Drivers License Exp:', 'autoroyal' ); ?></label>

										<div class="autoroyal-input-has-icon">
											<input class="date_picker_future autoroyal-input-icon-left" type="text" id="lead_driver_license_exp" name="lead_driver_license_exp" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="" />
											<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
										</div>

									</div>

								</div>

							</fieldset>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Employment Info', 'autoroyal' ); ?></h2>

							<fieldset>

								<div id="buyer_employer" class="lead_buyer_employers active">

									<div class="row">

										<div class="col-md-6">

											<label for="employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_name" name="employer[name]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
											<input type="text" class="employer_income" name="employer[income]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_occupation" class="control-label"><?php esc_html_e('Occupation:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_occupation" name="employer[occupation]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_address_1" name="employer[address_1]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_address_2" name="employer[address_2]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_city" name="employer[city]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_state" name="employer[state]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_zip" name="employer[zip]" value=""  />

										</div>

										<div class="col-md-12">

											<label for="employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_phone" name="employer[phone]" value=""  />

										</div>

										<div class="col-md-12">

											<h2 class="options_group_heading"><?php esc_html_e('Time On Job', 'autoroyal' ); ?></h2>

										</div>

										<div class="col-md-6">

											<label for="employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
											<select name="employer_years" class="employer_years form-control input-lg">
												<option value=""></option>
												<option value="0" ><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
												<option value="1" ><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
												<option value="2" ><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
												<option value="3" ><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
												<option value="4" ><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
												<option value="5" ><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
												<option value="6" ><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
												<option value="7" ><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
												<option value="8" ><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
												<option value="9" ><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
												<option value="10" ><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
												<option value="11" ><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
												<option value="12" ><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

											</select>

										</div>

										<div class="col-md-6">

											<label for="employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
											<select name="employer_months" class="employer_months form-control input-lg">
												<option value=""></option>
												<option value="0" ><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
												<option value="1" ><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
												<option value="2" ><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
												<option value="3" ><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
												<option value="4" ><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
												<option value="5" ><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
												<option value="6" ><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
												<option value="7" ><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
												<option value="8" ><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
												<option value="9" ><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
												<option value="10" ><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
												<option value="11" ><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

											</select>

										</div>

									</div>

								</div>

							</fieldset>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Questions and Comments', 'autoroyal' ); ?></h2>

							<fieldset>

								<div class="row">

									<div class="col-md-12">

										<textarea  cols="20" rows="7" class="input-text" name="lead_comments" ></textarea>

									</div>

								</div>

							</fieldset>

						</div>
						
						<input type="hidden" name="lead_vehicle_id" value="<?php echo get_the_ID(); ?>" />
						<input type="hidden" name="autoroyal_form_name" value="test_drive" />

						<input type="hidden" name="autoroyal_dealer_id" value="<?php echo esc_attr($user_id); ?>" />
						<input type="hidden" name="autoroyal_dealer_email" value="<?php echo esc_attr($email_to); ?>" />

						<input type="hidden" name="action" value="autoroyal_ajax_test_drive" />

						<a id="autoroyal_request_test_drive_ajax" href="#" class="btn btn-default"><i class="fa fa-spinner fa-spin fa-3x fa-fw"></i> <?php esc_html_e( 'Request Test Drive', 'autoroyal' ) ?></a>

						<p class="small-text"><?php esc_html_e('By clicking "Request Test Drive", I consent to be contacted by the dealer selling this vehicle at any telephone number I provide, including, without limitation, communications sent via text message to my cell phone or communications sent using an autodialer or prerecorded message. This acknowledgement constitutes my written consent to receive such communications.', 'autoroyal' ); ?></p>

				    </form>

				</div>

			</div>

		</div>

	</div>

	<!-- test Drive -->
	<div class="modal fade bd-example-modal-lg" id="trade-in" tabindex="-1" role="dialog" aria-labelledby="tradeinLabel">

		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
    
    		<div class="modal-content">

		    	<div class="trade-in-loading">
		    		<i class="fa fa-spinner fa-spin"></i>
		    	</div>

		    	<div class="cs-modal-header">

	    			<h4><i class="fa fa-refresh" aria-hidden="true"></i> <?php esc_html_e('Trade In', 'autoroyal' ); ?></h4>
	    			<a href="#" class="close" data-dismiss="modal"><i class="fa fa-close"></i></a>

	    		</div>

		    	<div class="cs-modal-inner">

		    		<div id="trade-in-response">

			    		<h5 class="heading">
							<?php esc_html_e('Thank You.', 'autoroyal' ); ?><br>
							<?php esc_html_e('Your Trade-In Request has been sent.', 'autoroyal' ); ?><br>
							<?php esc_html_e('You should receive a confirmation shortly.', 'autoroyal' ); ?><br>
							<?php esc_html_e('If you have questions or concerns please call and let us know.', 'autoroyal' ); ?>
			    		</h5>

					</div>

					<form id="trade-in-form" class="contact-form test-drive-form-application" action="<?php echo admin_url('admin-ajax.php'); ?>" method="post">

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Trade-In', 'autoroyal' ); ?></h2>

							<fieldset class="select-car-model-table">

								<table id="select-car-model">

									<tbody>

										<tr valign="bottom">
											<th><?php esc_html_e('Make', 'autoroyal' ); ?></th>
											<th><?php esc_html_e('Model', 'autoroyal' ); ?></th>
											<th><?php esc_html_e('Year', 'autoroyal' ); ?></th>
											<th><?php esc_html_e('Trim', 'autoroyal' ); ?></th>
										</tr>

										<tr>

											<td>
												<select name="cq-make" id="cq-make" class="cq-make form-control input-lg"></select>
											</td>

											<td>
												<select name="cq-model" id="cq-model" class="cq-model form-control input-lg" disabled></select>
											</td>

											<td>
												<select name="cq-year" id="cq-year" class="cq-year form-control input-lg" disabled></select>
											</td>

											<td>
												<select name="cq-trim" id="cq-trim" class="cq-trim form-control input-lg" disabled></select>
											</td>

										</tr>

									</tbody>

								</table>

							</fieldset>

							<fieldset>
								
								<div class="row">

									<div class="col-md-4">

										<label for="lead_tradein_vehicle_vin" class="control-label"><?php esc_html_e('VIN:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_tradein_vehicle_vin" name="lead_tradein_vehicle_vin" value=""  />
										<label id="lead_tradein_vehicle_vin-error" class="error" for="lead_tradein_vehicle_vin"><?php esc_html_e('Please add a VIN code', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_tradein_vehicle_mileage" class="control-label"><?php esc_html_e('Mileage:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_tradein_vehicle_mileage" name="lead_tradein_vehicle_mileage" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_tradein_vehicle_color" class="control-label"><?php esc_html_e('Color:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_tradein_vehicle_color" name="lead_tradein_vehicle_color" value=""  />

									</div>

								</div>
								
							</fieldset>

						</div>

				    	<div class="options_group">

				    		<h2 class="options_group_heading"><?php esc_html_e('Personal Info', 'autoroyal' ); ?></h2>

				    		<fieldset>
				      
						      	<div class="row">

									<div class="col-md-4 has-error-alert">

										<label for="lead_first_name" class="control-label"><?php esc_html_e('First Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_first_name" name="lead_first_name" value=""  />
										<label id="lead_first_name-error" class="error" for="lead_first_name"><?php esc_html_e('Please add a name', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_middle_name" class="control-label"><?php esc_html_e('Middle Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_middle_name" name="lead_middle_name" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_last_name" class="control-label"><?php esc_html_e('Last Name:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_last_name" name="lead_last_name" value=""  />

									</div>

									<div class="col-md-6">

										<label for="lead_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_address_1" name="lead_address_1" value=""  />

									</div>

									<div class="col-md-6">

										<label for="lead_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_address_2" name="lead_address_2" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_city" name="lead_city" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_state" name="lead_state" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_zip" name="lead_zip" value=""  />

									</div>

									<div class="col-md-4">

										<label for="lead_home_phone" class="control-label"><?php esc_html_e('Home Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_home_phone" name="lead_home_phone" value=""  />

									</div>

									<div class="col-md-4 has-error-alert">

										<label for="lead_mobile_phone" class="control-label"><?php esc_html_e('Mobile Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_mobile_phone" name="lead_mobile_phone" value=""  />
										<label id="lead_mobile_phone-error" class="error" for="lead_mobile_phone"><?php esc_html_e('Please add a phone', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-4">

										<label for="lead_work_phone" class="control-label"><?php esc_html_e('Work Phone:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_work_phone" name="lead_work_phone" value=""  />

									</div>

									<div class="col-md-4">

										<label for="time_at_address" class="control-label"><?php esc_html_e('Time At Residence:', 'autoroyal' ); ?></label>
										<select name="time_at_address" class="time_at_address form-control input-lg">
											<option value=""></option>
											<option value="0"><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
											<option value="1"><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
											<option value="2"><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
											<option value="3"><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
											<option value="4"><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
											<option value="5"><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
											<option value="6"><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
											<option value="7"><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
											<option value="8"><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
											<option value="9"><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
											<option value="10"><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
											<option value="11"><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
											<option value="12"><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>
										</select>

									</div>

									<div class="col-md-4">

										<label for="residence_type" class="control-label"><?php esc_html_e('Residence Type:', 'autoroyal' ); ?></label>
										<select name="residence_type" class="residence_type form-control input-lg">
											<option value=""></option>
											<option value="Rent" ><?php esc_html_e('Rent', 'autoroyal' ); ?></option>
											<option value="Own" ><?php esc_html_e('Own', 'autoroyal' ); ?></option>

										</select>

									</div>

									<div class="col-md-4">

										<label for="residence_price" class="control-label"><?php esc_html_e('Rent/Mortgage:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
										<input type="text" class="residence_price" name="residence_price" value=""  />

									</div>

									<div class="col-md-6 has-error-alert">

										<label for="lead_email" class="control-label"><?php esc_html_e('Email Address:', 'autoroyal' ); ?></label>
										<input type="text" class="lead_email" name="lead_email" value=""  />
										<label id="lead_email-error" class="error" for="lead_email"><?php esc_html_e('Please add an email', 'autoroyal' ); ?></label>

									</div>

									<div class="col-md-6">

										<label for="lead_birth_date" class="control-label"><?php esc_html_e('Date of Birth:', 'autoroyal' ); ?></label>

										<div class="autoroyal-input-has-icon">
											<input class="date_picker_past autoroyal-input-icon-left" type="text" class="lead_birth_date" name="lead_birth_date" placeholder="<?php esc_attr_e('Select Date', 'autoroyal' ); ?>" value="" />
											<span class="fa fa-calendar autoroyal-input-icon left" aria-hidden="true"></span>
										</div>

									</div>

								</div>

							</fieldset>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Employment Info', 'autoroyal' ); ?></h2>

							<fieldset>

								<div id="buyer_employer" class="lead_buyer_employers active">

									<div class="row">

										<div class="col-md-6">

											<label for="employer_name" class="control-label"><?php esc_html_e('Employer:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_name" name="employer[name]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_income" class="control-label"><?php esc_html_e('Monthly Income:', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
											<input type="text" class="employer_income" name="employer[income]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_occupation" class="control-label"><?php esc_html_e('Occupation:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_occupation" name="employer[occupation]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_address_1" class="control-label"><?php esc_html_e('Address 1:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_address_1" name="employer[address_1]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_address_2" class="control-label"><?php esc_html_e('Address 2:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_address_2" name="employer[address_2]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_city" class="control-label"><?php esc_html_e('City:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_city" name="employer[city]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_state" class="control-label"><?php esc_html_e('State:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_state" name="employer[state]" value=""  />

										</div>

										<div class="col-md-6">

											<label for="employer_zip" class="control-label"><?php esc_html_e('Zip:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_zip" name="employer[zip]" value=""  />

										</div>

										<div class="col-md-12">

											<label for="employer_phone" class="control-label"><?php esc_html_e('Phone Number:', 'autoroyal' ); ?></label>
											<input type="text" class="employer_phone" name="employer[phone]" value=""  />

										</div>

										<div class="col-md-12">

											<h2 class="options_group_heading"><?php esc_html_e('Time On Job', 'autoroyal' ); ?></h2>

										</div>

										<div class="col-md-6">

											<label for="employer_years" class="control-label"><?php esc_html_e('Years:', 'autoroyal' ); ?></label>
											<select name="employer_years" class="employer_years form-control input-lg">
												<option value=""></option>
												<option value="0" ><?php esc_html_e('0 Years', 'autoroyal' ); ?></option>
												<option value="1" ><?php esc_html_e('1 Year', 'autoroyal' ); ?></option>
												<option value="2" ><?php esc_html_e('2 Years', 'autoroyal' ); ?></option>
												<option value="3" ><?php esc_html_e('3 Years', 'autoroyal' ); ?></option>
												<option value="4" ><?php esc_html_e('4 Years', 'autoroyal' ); ?></option>
												<option value="5" ><?php esc_html_e('5 Years', 'autoroyal' ); ?></option>
												<option value="6" ><?php esc_html_e('6 Years', 'autoroyal' ); ?></option>
												<option value="7" ><?php esc_html_e('7 Years', 'autoroyal' ); ?></option>
												<option value="8" ><?php esc_html_e('8 Years', 'autoroyal' ); ?></option>
												<option value="9" ><?php esc_html_e('9 Years', 'autoroyal' ); ?></option>
												<option value="10" ><?php esc_html_e('10 Years', 'autoroyal' ); ?></option>
												<option value="11" ><?php esc_html_e('11 Years', 'autoroyal' ); ?></option>
												<option value="12" ><?php esc_html_e('12+ Years', 'autoroyal' ); ?></option>

											</select>

										</div>

										<div class="col-md-6">

											<label for="employer_months" class="control-label"><?php esc_html_e('Months:', 'autoroyal' ); ?></label>
											<select name="employer_months" class="employer_months form-control input-lg">
												<option value=""></option>
												<option value="0" ><?php esc_html_e('0 Months', 'autoroyal' ); ?></option>
												<option value="1" ><?php esc_html_e('1 Month', 'autoroyal' ); ?></option>
												<option value="2" ><?php esc_html_e('2 Months', 'autoroyal' ); ?></option>
												<option value="3" ><?php esc_html_e('3 Months', 'autoroyal' ); ?></option>
												<option value="4" ><?php esc_html_e('4 Months', 'autoroyal' ); ?></option>
												<option value="5" ><?php esc_html_e('5 Months', 'autoroyal' ); ?></option>
												<option value="6" ><?php esc_html_e('6 Months', 'autoroyal' ); ?></option>
												<option value="7" ><?php esc_html_e('7 Months', 'autoroyal' ); ?></option>
												<option value="8" ><?php esc_html_e('8 Months', 'autoroyal' ); ?></option>
												<option value="9" ><?php esc_html_e('9 Months', 'autoroyal' ); ?></option>
												<option value="10" ><?php esc_html_e('10 Months', 'autoroyal' ); ?></option>
												<option value="11" ><?php esc_html_e('11 Months', 'autoroyal' ); ?></option>

											</select>

										</div>

									</div>

								</div>

							</fieldset>

						</div>

						<div class="options_group">

							<h2 class="options_group_heading"><?php esc_html_e('Questions and Comments', 'autoroyal' ); ?></h2>

							<fieldset>

								<div class="row">

									<div class="col-md-12">

										<textarea  cols="20" rows="7" class="input-text" name="lead_comments" ></textarea>

									</div>

								</div>

							</fieldset>

						</div>
						
						<input type="hidden" name="lead_vehicle_id" value="<?php echo get_the_ID(); ?>" />
						<input type="hidden" name="autoroyal_form_name" value="trade_in" />

						<input type="hidden" name="autoroyal_dealer_id" value="<?php echo esc_attr($user_id); ?>" />
						<input type="hidden" name="autoroyal_dealer_email" value="<?php echo esc_attr($email_to); ?>" />

						<input type="hidden" name="action" value="autoroyal_ajax_trade_in" />

						<a id="autoroyal_submit_tradein_ajax" href="#" class="btn btn-default"><i class="fa fa-spinner fa-spin fa-3x fa-fw"></i> <?php esc_html_e( 'Request Trade-In', 'autoroyal' ) ?></a>

						<p class="small-text"><?php esc_html_e('By clicking "Request Trade-In", I consent to be contacted by the dealer selling this vehicle at any telephone number I provide, including, without limitation, communications sent via text message to my cell phone or communications sent using an autodialer or prerecorded message. This acknowledgement constitutes my written consent to receive such communications.', 'autoroyal' ); ?></p>

					</form>

				</div>

			</div>

		</div>

	</div>

<?php
get_footer();
