/*
 * Cars/offers localizations on map
 *
 *  INFO !!!
 *  1. just for the map we will need google maps script with API key and styles from snazzy maps
 *  2. for map with clusters and infoboxes we will need these jQuery libraries:
 *  	2.1 OverlappingMarkerSpiderfier
 *          https://github.com/jawj/OverlappingMarkerSpiderfier
 *     2.2 MarkerClusterer for Google Maps v3
 *         http://gmaps-utility-library-dev.googlecode.com/svn/tags/markerclusterer/
 *     2.3 MarkerWithLabel for V3
 *         https://github.com/printercu/google-maps-utility-library-v3-read-only/tree/master/markerwithlabel
 *     2.4 InfoBox
 *         https://developers.google.com/maps/documentation/javascript/infowindows
 *
 *  HAVE FUN :-)
 */

(function($) {

	//'use strict';

	$(document).ready( function() {

		var map;
		var marker;
		var minClusterZoom;
		var markers = [];
    	var infoboxes = [];

		function initializeMap() {

			var w = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
			var isDraggable = w > 480 ? true : false;

			var latlng = new google.maps.LatLng( 40.7127837, -74.00594130000002 );
			var mapOptions = {
				zoom: 16,
				height: 500,
				mapTypeControl: false,
				scrollwheel: false,
				needsFit: true,
				isPanned: false,
				formIndex: 0,
				center: latlng,
				draggable: isDraggable,
			}

			map = new google.maps.Map(document.getElementById('cd-locations'), mapOptions);

			/* marker loop */
			createMarkers();
		};

	    function createMarkers() {

	    	tdClearMap();

	    	var oms = new OverlappingMarkerSpiderfier(map, {
		      	markersWontMove: true,
		      	markersWontHide: true,
	          	keepSpiderfied: true
	        });
		    oms.addListener('unspiderfy', function(spidered, unspidered) {
		      	for (var i = 0; i < spidered.length; i++) {
			        spidered[i].setLabel("" + (i + 1));
			        spidered[i].setOptions({
			          	zIndex: i
			        });
		      	}
		    });

		    // Clusterer
		    var styles = [[{
			    url: autoroyalSettings.url_theme + '/assets/images/cluster-1.png',
			    width: 62, height: 62,
			    opt_anchor: [15, 15],
			    textColor: '#ffffff',
			    textSize: 12
			}, {
			    url: autoroyalSettings.url_theme + '/assets/images/cluster-2.png',
			    width: 82, height: 82,
			    opt_anchor: [20, 20],
			    textColor: '#ffffff',
			    textSize: 14
			}	, {
			    url: autoroyalSettings.url_theme + '/assets/images/cluster-3.png',
			    width: 102, height: 102,
			    opt_anchor: [25, 25],
			    textColor: '#ffffff',
			    textSize: 16
			}, {
			    url: autoroyalSettings.url_theme + '/assets/images/cluster-3.png',
			    width: 102, height: 102,
			    opt_anchor: [30, 30],
			    textColor: '#ffffff',
			    textSize: 16
			}]];

		    var markerCluster = new MarkerClusterer(map, markers, {styles: styles[0]});
	        minClusterZoom = 14;
			markerCluster.setMaxZoom(minClusterZoom);
			markerCluster.setMap(map);

			var infobox = new InfoBox({
		        disableAutoPan: false,
		        maxWidth: 202,
	        	pixelOffset: new google.maps.Size(-150, -325),
		        zIndex: null,
		        boxStyle: {
		        	background: "url('" + autoroyalSettings.url_theme + "/assets/images/infobox-bg-2.png') no-repeat",
		            opacity: 1,
		            width: "300px",
	            	height: "270px"
		        },
		        closeBoxMargin: "28px 26px 0px 0px",
		        closeBoxURL: "",
		        infoBoxClearance: new google.maps.Size(1, 1),
		        pane: "floatPane",
		        enableEventPropagation: false
		    });

	    	var self = this;
		  	var section = jQuery( '#demoCars' ).eq( map.formIndex );

			this.results = {};
			this.items = section.find( '.cd-offer-blk, .dealer-card' );

			//var marker, i;
		    var bounds = new google.maps.LatLngBounds();

		    var totalListings = 0;

			jQuery.each( this.items, function(i, el) {

				totalListings++;

				var $el = jQuery(el);

				if ( ! ( $el.data( 'lat' ) && $el.data( 'long' ) ) ) {
					return;
				}

				var data = {
					lat:      $el.data( 'lat' ),
					lng:      $el.data( 'long' ),
					thumb:    $el.data( 'thumb' ),
					pin:      $el.data( 'pin' ),
					year:     $el.data( 'year' ),
					price:    $el.data( 'price' ),
					currency: $el.data( 'currency' ),
					title:    $el.data( 'title' ),
					desc:     $el.data( 'desc' ),
					link:     $el.data( 'link' )
				}

				var siteLatLng = new google.maps.LatLng( data.lat, data.lng );
		        var marker = new MarkerWithLabel({
		            position: siteLatLng,
		            map: map,
		            draggable: false,
		            title: data.title,
		            icon: data.pin,
		            html:  '<div class="marker-holder marker-vehicle-holder"><div class="marker-content"><div class="marker-listing-image" style="background-image: url('+data.thumb+');"><a href="'+data.link+'"></a></div><span class="marker-listing-title"><a href="'+data.link+'"><span>'+data.year+'</span> '+data.title+'</a></span><span class="marker-price">'+data.currency+''+data.price+'</span></div></div>'
		        });

    		    google.maps.event.addListener(marker, "click", function () {
		        	infobox.close();
				  	infobox.setContent(this.html);
		            infobox.open(map, this);
				});		
		        google.maps.event.addListener(map, 'click', function() {
				    infobox.close();
				});

		        bounds.extend(siteLatLng);
		        markers.push(marker);
		        oms.addMarker(marker);
		        markerCluster.addMarker(marker);

			});

	        /* end marker loop */

	        map.fitBounds(bounds);

	    }

		function tdClearMap() {
	        //Loop through all the markers and remove
	        for (var i = 0; i < markers.length; i++) {
	            markers[i].setMap(null);
	        }
	        markers = [];
	    };

	    var $target = jQuery( '#cd-locations' );

		if ( $target.length > 0 ) {
			initializeMap();
		}

   	});

})(jQuery);
