<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

$moveme_post_id    = get_the_ID();
$moveme_post_date  = moveme_get_date();
$moveme_post_title = get_the_title();
$moveme_post_link  = get_permalink();
$moveme_post_author_id   = get_the_author_meta('ID');
$moveme_post_author_name = get_the_author_meta('display_name');
$moveme_post_author_url  = get_author_posts_url($moveme_post_author_id, '');

$moveme_args = get_query_var('moveme_args_widgets_posts');
$moveme_show_date = isset($moveme_args['show_date']) ? (int) $moveme_args['show_date'] : 1;
$moveme_show_image = isset($moveme_args['show_image']) ? (int) $moveme_args['show_image'] : 1;
$moveme_show_author = isset($moveme_args['show_author']) ? (int) $moveme_args['show_author'] : 1;
$moveme_show_counters = isset($moveme_args['show_counters']) ? (int) $moveme_args['show_counters'] : 1;
$moveme_show_categories = isset($moveme_args['show_categories']) ? (int) $moveme_args['show_categories'] : 1;

$moveme_output = moveme_storage_get('moveme_output_widgets_posts');

$moveme_post_counters_output = '';
if ( $moveme_show_counters ) {
	$moveme_post_counters_output = '<span class="post_info_item post_info_counters">'
								. moveme_get_post_counters('comments')
							. '</span>';
}


$moveme_output .= '<article class="post_item with_thumb">';

if ($moveme_show_image) {
	$moveme_post_thumb = get_the_post_thumbnail($moveme_post_id, moveme_get_thumb_size('tiny'), array(
		'alt' => the_title_attribute( array( 'echo' => false ) )
	));
	if ($moveme_post_thumb) $moveme_output .= '<div class="post_thumb">' . ($moveme_post_link ? '<a href="' . esc_url($moveme_post_link) . '">' : '') . ($moveme_post_thumb) . ($moveme_post_link ? '</a>' : '') . '</div>';
}

$moveme_output .= '<div class="post_content">'
			. ($moveme_show_categories 
					? '<div class="post_categories">'
						. moveme_get_post_categories()
						. $moveme_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($moveme_post_link ? '<a href="' . esc_url($moveme_post_link) . '">' : '') . ($moveme_post_title) . ($moveme_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('moveme_filter_get_post_info', 
								'<div class="post_info">'
									. ($moveme_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($moveme_post_link ? '<a href="' . esc_url($moveme_post_link) . '" class="post_info_date">' : '') 
											. esc_html($moveme_post_date) 
											. ($moveme_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($moveme_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'moveme') . ' ' 
											. ($moveme_post_link ? '<a href="' . esc_url($moveme_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($moveme_post_author_name) 
											. ($moveme_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$moveme_show_categories && $moveme_post_counters_output
										? $moveme_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
moveme_storage_set('moveme_output_widgets_posts', $moveme_output);
?>