<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

$moveme_args = get_query_var('moveme_logo_args');

// Site logo
$moveme_logo_image  = moveme_get_logo_image(isset($moveme_args['type']) ? $moveme_args['type'] : '');
$moveme_logo_text   = moveme_is_on(moveme_get_theme_option('logo_text')) ? get_bloginfo( 'name' ) : '';
$moveme_logo_slogan = get_bloginfo( 'description', 'display' );
if (!empty($moveme_logo_image) || !empty($moveme_logo_text)) {
	?><a class="sc_layouts_logo" href="<?php echo is_front_page() ? '#' : esc_url(home_url('/')); ?>"><?php
		if (!empty($moveme_logo_image)) {
			$moveme_attr = moveme_getimagesize($moveme_logo_image);
			echo '<img src="'.esc_url($moveme_logo_image).'" alt="'.esc_attr__('Image', 'moveme').'"'.(!empty($moveme_attr[3]) ? sprintf(' %s', $moveme_attr[3]) : '').'>' ;
		} else {
			moveme_show_layout(moveme_prepare_macros($moveme_logo_text), '<span class="logo_text">', '</span>');
			moveme_show_layout(moveme_prepare_macros($moveme_logo_slogan), '<span class="logo_slogan">', '</span>');
		}
	?></a><?php
}
?>