<?php
/**
 * The template to display default site header
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

$moveme_header_css = $moveme_header_image = '';
$moveme_header_video = moveme_get_header_video();
if (true || empty($moveme_header_video)) {
	$moveme_header_image = get_header_image();
	if (moveme_is_on(moveme_get_theme_option('header_image_override')) && apply_filters('moveme_filter_allow_override_header_image', true)) {
		if (is_category()) {
			if (($moveme_cat_img = moveme_get_category_image()) != '')
				$moveme_header_image = $moveme_cat_img;
		} else if (is_singular() || moveme_storage_isset('blog_archive')) {
			if (has_post_thumbnail()) {
				$moveme_header_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' );
				if (is_array($moveme_header_image)) $moveme_header_image = $moveme_header_image[0];
			} else
				$moveme_header_image = '';
		}
	}
}

?><header class="top_panel top_panel_default<?php
					echo !empty($moveme_header_image) || !empty($moveme_header_video) ? ' with_bg_image' : ' without_bg_image';
					if ($moveme_header_video!='') echo ' with_bg_video';
					if ($moveme_header_image!='') echo ' '.esc_attr(moveme_add_inline_css_class('background-image: url('.esc_url($moveme_header_image).');'));
					if (is_single() && has_post_thumbnail()) echo ' with_featured_image';
					if (moveme_is_on(moveme_get_theme_option('header_fullheight'))) echo ' header_fullheight trx-stretch-height';
					?> scheme_<?php echo esc_attr(moveme_is_inherit(moveme_get_theme_option('header_scheme')) 
													? moveme_get_theme_option('color_scheme') 
													: moveme_get_theme_option('header_scheme'));
					?>">
    <?php
    if(moveme_get_theme_option('show_top_panel') == 1 ) {
    ?>
    <div class="sc_layouts_row sc_layouts_row_type_narrow">
        <div class="sc_content color_style_default sc_content_default sc_float_center sc_content_width_1_1">
            <div class="sc_content_container">
                <div class="columns_wrap"><div class="column-1_2 sc_layouts_column sc_layouts_column_align_left sc_layouts_column_icons_position_left">
                        <?php
                        if(moveme_get_theme_option('show_text_top_panel_1') == 1 ) {
                        ?>
                        <div class="sc_layouts_item">
                            <div id="sc_layouts_iconed_text_97319300" class="sc_layouts_iconed_text">
                                <span class="sc_layouts_item_details sc_layouts_iconed_text_details">
                                    <span class="sc_layouts_item_details_line1 sc_layouts_iconed_text_line1"><?php
                                        $text1 = '';
                                        $text1 = moveme_get_theme_option('text_top_panel_1');
                                        if(!empty($text1) ) {
                                            echo wp_kses($text1, 'moveme_kses_content');
                                        }
                                        ?></span>
                                </span>
                            </div></div>
                        <?php
                        }

                        ?>
                    </div><div class="column-1_2 sc_layouts_column sc_layouts_column_align_right sc_layouts_column_icons_position_left">
                        <?php
                        if(moveme_get_theme_option('show_text_top_panel_2') == 1 ) {
                        ?>
                        <div class="sc_layouts_item">
                            <div id="sc_layouts_iconed_text_414120077" class="sc_layouts_iconed_text">
                                <span class="sc_layouts_item_icon sc_layouts_iconed_text_icon icon-phone-3"></span>
                                <span class="sc_layouts_item_details sc_layouts_iconed_text_details">
                                    <span class="sc_layouts_item_details_line1 sc_layouts_iconed_text_line1"><?php
                                        $text1 = '';
                                        $text1 = moveme_get_theme_option('text_top_panel_2');
                                        if(!empty($text1) ) {
                                            echo wp_kses($text1, 'moveme_kses_content');
                                        }
                                        ?></span>
                                    <span class="sc_layouts_item_details_line2 sc_layouts_iconed_text_line2"><?php
                                        $text1 = '';
                                        $text1 = moveme_get_theme_option('text_top_panel_3');
                                        if(!empty($text1) ) {
                                            echo wp_kses($text1, 'moveme_kses_content');
                                        }
                                        ?></span>
                                </span>
                            </div>
                        </div>
                        <?php
                        }

                        ?>
                </div></div>
            </div>
        </div>
    </div>
    <?php
    }

    ?>
    <?php

	// Background video
	if (!empty($moveme_header_video)) {
		get_template_part( 'templates/header-video' );
	}
	
	// Main menu
	if (moveme_get_theme_option("menu_style") == 'top') {
		get_template_part( 'templates/header-navi' );
	}

	// Page title and breadcrumbs area
	get_template_part( 'templates/header-title');

	// Header widgets area
	get_template_part( 'templates/header-widgets' );


?></header>