<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

$moveme_blog_style = explode('_', moveme_get_theme_option('blog_style'));
$moveme_columns = empty($moveme_blog_style[1]) ? 2 : max(2, $moveme_blog_style[1]);
$moveme_post_format = get_post_format();
$moveme_post_format = empty($moveme_post_format) ? 'standard' : str_replace('post-format-', '', $moveme_post_format);
$moveme_animation = moveme_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_'.esc_attr($moveme_columns).' post_format_'.esc_attr($moveme_post_format).(is_sticky() && !is_paged() ? ' sticky' : '') ); ?>
	<?php echo (!moveme_is_off($moveme_animation) ? ' data-animation="'.esc_attr(moveme_get_animation_classes($moveme_animation)).'"' : ''); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	$moveme_image_hover = moveme_get_theme_option('image_hover');
	// Featured image
	moveme_show_post_featured(array(
		'thumb_size' => moveme_get_thumb_size(strpos(moveme_get_theme_option('body_style'), 'full')!==false || $moveme_columns < 3 ? 'masonry-big' : 'masonry'),
		'show_no_image' => true,
		'class' => $moveme_image_hover == 'dots' ? 'hover_with_info' : '',
		'post_info' => $moveme_image_hover == 'dots' ? '<div class="post_info">'.esc_html(get_the_title()).'</div>' : ''
	));
	?>
</article>