<?php
/**
 * The Gallery template to display posts
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

$moveme_blog_style = explode('_', moveme_get_theme_option('blog_style'));
$moveme_columns = empty($moveme_blog_style[1]) ? 2 : max(2, $moveme_blog_style[1]);
$moveme_post_format = get_post_format();
$moveme_post_format = empty($moveme_post_format) ? 'standard' : str_replace('post-format-', '', $moveme_post_format);
$moveme_animation = moveme_get_theme_option('blog_animation');
$moveme_image = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'full' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_gallery post_layout_gallery_'.esc_attr($moveme_columns).' post_format_'.esc_attr($moveme_post_format) ); ?>
	<?php echo (!moveme_is_off($moveme_animation) ? ' data-animation="'.esc_attr(moveme_get_animation_classes($moveme_animation)).'"' : ''); ?>
	data-size="<?php if (!empty($moveme_image[1]) && !empty($moveme_image[2])) echo intval($moveme_image[1]) .'x' . intval($moveme_image[2]); ?>"
	data-src="<?php if (!empty($moveme_image[0])) echo esc_url($moveme_image[0]); ?>"
	>

	<?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	$moveme_image_hover = 'icon';
	if (in_array($moveme_image_hover, array('icons', 'zoom'))) $moveme_image_hover = 'dots';
	$moveme_components = moveme_is_inherit(moveme_get_theme_option_from_meta('meta_parts')) 
								? 'categories,date,counters,share'
								: moveme_array_get_keys_by_value(moveme_get_theme_option('meta_parts'));
	$moveme_counters = moveme_is_inherit(moveme_get_theme_option_from_meta('counters')) 
								? 'comments'
								: moveme_array_get_keys_by_value(moveme_get_theme_option('counters'));
	moveme_show_post_featured(array(
		'hover' => $moveme_image_hover,
		'thumb_size' => moveme_get_thumb_size( strpos(moveme_get_theme_option('body_style'), 'full')!==false || $moveme_columns < 3 ? 'masonry-big' : 'masonry' ),
		'thumb_only' => true,
		'show_no_image' => true,
		'post_info' => '<div class="post_details">'
							. '<h2 class="post_title"><a href="'.esc_url(get_permalink()).'">'. esc_html(get_the_title()) . '</a></h2>'
							. '<div class="post_description">'
								. (!empty($moveme_components)
										? moveme_show_post_meta(apply_filters('moveme_filter_post_meta_args', array(
											'components' => $moveme_components,
											'counters' => $moveme_counters,
											'seo' => false,
											'echo' => false
											), $moveme_blog_style[0], $moveme_columns))
										: '')
								. '<div class="post_description_content">'
									. apply_filters('the_excerpt', get_the_excerpt())
								. '</div>'
								. '<a href="'.esc_url(get_permalink()).'" class="theme_button post_readmore"><span class="post_readmore_label">' . esc_html__('Learn more', 'moveme') . '</span></a>'
							. '</div>'
						. '</div>'
	));
	?>
</article>