<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MOVEME
 * @since MOVEME 1.0
 */

$moveme_post_format = get_post_format();
$moveme_post_format = empty($moveme_post_format) ? 'standard' : str_replace('post-format-', '', $moveme_post_format);
$moveme_animation = moveme_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_'.esc_attr($moveme_post_format) ); ?>
	<?php echo (!moveme_is_off($moveme_animation) ? ' data-animation="'.esc_attr(moveme_get_animation_classes($moveme_animation)).'"' : ''); ?>
	><?php

	// Sticky label
	if ( is_sticky() && !is_paged() ) {
		?><span class="post_label label_sticky"></span><?php
	}

	// Featured image
	moveme_show_post_featured(array( 'thumb_size' => moveme_get_thumb_size( strpos(moveme_get_theme_option('body_style'), 'full')!==false ? 'full' : 'big' ) ));

	// Title and post meta
	if (get_the_title() != '') {
		?>
		<div class="post_header entry-header"><div class="excerpt-time"><?php

            // Post meta
                moveme_show_post_meta(apply_filters('moveme_filter_post_meta_args', array(
                        'components' => 'date',
                        'counters' => '',
                        'seo' => moveme_is_on(moveme_get_theme_option('seo_snippets'))
                    ), 'single', 1)
                );

                if(is_sticky()) {
                    echo '<div class="sticky-wrap"><span class="exc-sticky">'.esc_html__('Sticky!', 'moveme').'</span></div>';
                }
            ?></div><div class="excerpt-all"><?php


            // Post title
            the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
            // Post meta
                moveme_show_post_meta(apply_filters('moveme_filter_post_meta_args', array(
                        'components' => 'categories,author,counters',
                        'counters' => 'likes,comments',
                        'seo' => moveme_is_on(moveme_get_theme_option('seo_snippets'))
                    ), 'single', 1)
                );




			?></div></div><!-- .post_header --><?php
	}
	
	// Post content
	?><div class="post_content entry-content"><?php
		if (moveme_get_theme_option('blog_content') == 'fullpost') {
			// Post content area
			?><div class="post_content_inner"><?php
				the_content( '' );
			?></div><?php
			// Inner pages
			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'moveme' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'moveme' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

		} else {

			$moveme_show_learn_more = !in_array($moveme_post_format, array('link', 'aside', 'status', 'quote'));

			// Post content area
			?><div class="post_content_inner"><?php
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($moveme_post_format, array('link', 'aside', 'status'))) {
					the_content();
				} else if ($moveme_post_format == 'quote') {
					if (($quote = moveme_get_tag(get_the_content(), '<blockquote>', '</blockquote>'))!='')
						moveme_show_layout(wpautop($quote));
					else
						the_excerpt();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
			?></div><?php

            // Post taxonomies
            ?><div class="post-bm"><div class="blog-meta"><?php
                if( get_the_tags() ) {
                    // Post taxonomies
                    ?><span class="post_meta_item post_tags"><span
                        class="post_meta_label"><?php esc_html_e('Tags:', 'moveme'); ?></span> <?php the_tags('', ', ', ''); ?></span>
                <?php

                }
                ?> </div> <?php

            // Share
            moveme_show_share_links(array(
                'type' => 'block',
                'caption' => 'Share: ',
                'before' => '<span class="post_meta_item post_share">',
                'after' => '</span>'
            ));
            ?></div><?php
			// More button
			if ( $moveme_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'moveme'); ?></a></p><?php
			}



		}
	?></div><!-- .entry-content -->
</article>