<?php

/*
|--------------------------------------------------------------------------
| Add Colors Custom Field
|--------------------------------------------------------------------------
*/

if ( !function_exists( 'td_add_custom_nav_fields' ) ) {

    function td_add_custom_nav_fields( $menu_item ) {
        
        $menu_item->mega_menu_id = get_post_meta( $menu_item->ID, '_menu_item_mega_menu_id', true );
        $menu_item->menu_icon = get_post_meta( $menu_item->ID, '_menu_item_menu_icon', true );
        $menu_item->submenu_size = get_post_meta( $menu_item->ID, '_menu_item_submenu_size', true );
        $menu_item->submenu_position = get_post_meta( $menu_item->ID, '_menu_item_submenu_position', true );
        return $menu_item;
        
    }
    
    /* add custom menu fields to menu */
    add_filter( 'wp_setup_nav_menu_item', 'td_add_custom_nav_fields' );

}

/*
|--------------------------------------------------------------------------
| Update Iconclass Custom Field
|--------------------------------------------------------------------------
*/

if ( !function_exists( 'td_update_custom_nav_fields' ) ) {
    
    function td_update_custom_nav_fields( $menu_id, $menu_item_db_id, $args ) {

        update_post_meta( $menu_item_db_id, '_menu_item_menu_icon', "" );
        if ( isset($_REQUEST['menu-item-menu-icon'][$menu_item_db_id]) && is_array( $_REQUEST['menu-item-menu-icon']) ) {
            $mega_menu_icon_value = $_REQUEST['menu-item-menu-icon'][$menu_item_db_id];
            update_post_meta( $menu_item_db_id, '_menu_item_menu_icon', $mega_menu_icon_value );
        }

        update_post_meta( $menu_item_db_id, '_menu_item_mega_menu_id', "" );
        if ( isset($_REQUEST['menu-item-mega_menu_id'][$menu_item_db_id]) && is_array( $_REQUEST['menu-item-mega_menu_id']) ) {
            $mega_menu_id_value = $_REQUEST['menu-item-mega_menu_id'][$menu_item_db_id];
            update_post_meta( $menu_item_db_id, '_menu_item_mega_menu_id', $mega_menu_id_value );
        }

        update_post_meta( $menu_item_db_id, '_menu_item_submenu_size', "" );
        if ( isset($_REQUEST['menu-item-submenu-size'][$menu_item_db_id]) && is_array( $_REQUEST['menu-item-submenu-size']) ) {
            $submenu_size_value = $_REQUEST['menu-item-submenu-size'][$menu_item_db_id];
            update_post_meta( $menu_item_db_id, '_menu_item_submenu_size', $submenu_size_value );
        }

        update_post_meta( $menu_item_db_id, '_menu_item_submenu_position', "" );
        if ( isset($_REQUEST['menu-item-submenu-position'][$menu_item_db_id]) && is_array( $_REQUEST['menu-item-submenu-position']) ) {
            $submenu_position_value = $_REQUEST['menu-item-submenu-position'][$menu_item_db_id];
            update_post_meta( $menu_item_db_id, '_menu_item_submenu_position', $submenu_position_value );
        }
        
    }
    
    /* save menu custom fields */
    add_action( 'wp_update_nav_menu_item', 'td_update_custom_nav_fields' , 10 , 3 );

}

/*
|--------------------------------------------------------------------------
| Edit menucolor Custom Field
|--------------------------------------------------------------------------
*/

if ( !function_exists( 'td_edit_walker' ) ) {

    function td_edit_walker( $walker , $menu_id ) {
        
        return 'Walker_Nav_Menu_Edit_Custom';
        
    }
    
    /* edit menu walker */
    add_filter( 'wp_edit_nav_menu_walker', 'td_edit_walker' , 10 , 2 );

}

/*
|--------------------------------------------------------------------------
| Enhance "Appearance" => "Menus"
|--------------------------------------------------------------------------
*/

class Walker_Nav_Menu_Edit_Custom extends Walker_Nav_Menu  {
	
    /**
	 * @see Walker_Nav_Menu::start_lvl()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference.
	 */
	function start_lvl( &$output, $depth = 0, $args = array() ) {	
	}
	
	/**
	 * @see Walker_Nav_Menu::end_lvl()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference.
	 */
	function end_lvl( &$output, $depth = 0, $args = array() ) {
	}
	
	/**
	 * @see Walker::start_el()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item Menu item data object.
	 * @param int $depth Depth of menu item. Used for padding.
	 * @param object $args
	 */
	function start_el( &$output, $item, $depth = 0, $args = array() , $current_object_id = 0 ) {
	    
        global $_wp_nav_menu_max_depth;
	   
	    $_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;
	
	    $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';
	
	    ob_start();

	    $mega_menu_id = $item->mega_menu_id;
	    $submenu_size = $item->submenu_size;
	    $submenu_position = $item->submenu_position;

	    $item_id = esc_attr( $item->ID );
	    $removed_args = array(
	        'action',
	        'customlink-tab',
	        'edit-menu-item',
	        'menu-item',
	        'page-tab',
	        '_wpnonce',
	    );
	
	    $original_title = '';
	    if ( 'taxonomy' == $item->type ) {
	        $original_title = get_term_field( 'name', $item->object_id, $item->object, 'raw' );
	        if ( is_wp_error( $original_title ) )
	            $original_title = false;
	    } elseif ( 'post_type' == $item->type ) {
	        $original_object = get_post( $item->object_id );
	        $original_title = $original_object->post_title;
	    }
	
	    $classes = array(
	        'menu-item menu-item-depth-' . $depth,
	        'menu-item-' . esc_attr( $item->object ),
	        'menu-item-edit-' . ( ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? 'active' : 'inactive'),
	    );
	
	    $title = $item->title;
	
	    if ( ! empty( $item->_invalid ) ) {
	        $classes[] = 'menu-item-invalid';
	        /* translators: %s: title of menu item which is invalid */
	        $title = sprintf( esc_html__( '%s (Invalid)' , 'autoroyal' ), $item->title );
	    } elseif ( isset( $item->post_status ) && 'draft' == $item->post_status ) {
	        $classes[] = 'pending';
	        /* translators: %s: title of menu item in draft status */
	        $title = sprintf( esc_html__('%s (Pending)' , 'autoroyal' ), $item->title );
	    }
	
	    $title = empty( $item->label ) ? $title : $item->label;

	    $search_args = apply_filters( 'autoroyal_get_inventory_cars_args', array(
            'post_type'           => 'megamenu',
            'post_status'         => 'publish',
            'posts_per_page'      => -1,
        ));
        $mega_menus_query  = new WP_Query;
        $mega_menus        = $mega_menus_query->query( $search_args );
	
	    ?>
	    <li id="menu-item-<?php echo esc_attr($item_id); ?>" class="<?php echo implode(' ', $classes ); ?>">
	        <div class="menu-item-bar">
	            <div class="menu-item-handle">
	                <span class="item-title"><?php echo esc_html( $title ); ?></span>
	                <span class="item-controls">
	                    <span class="item-type"><?php echo esc_html( $item->type_label ); ?></span>
	                    <span class="item-order hide-if-js">
	                        <a href="<?php
	                            echo wp_nonce_url(
	                                add_query_arg(
	                                    array(
	                                        'action' => 'move-up-menu-item',
	                                        'menu-item' => $item_id,
	                                    ),
	                                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
	                                ),
	                                'move-menu_item'
	                            );
	                        ?>" class="item-move-up"><abbr title="<?php esc_attr_e('Move up' , 'autoroyal'); ?>">&#8593;</abbr></a>
	                        |
	                        <a href="<?php
	                            echo wp_nonce_url(
	                                add_query_arg(
	                                    array(
	                                        'action' => 'move-down-menu-item',
	                                        'menu-item' => $item_id,
	                                    ),
	                                    remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
	                                ),
	                                'move-menu_item'
	                            );
	                        ?>" class="item-move-down"><abbr title="<?php esc_attr_e('Move down' , 'autoroyal'); ?>">&#8595;</abbr></a>
	                    </span>
	                    <a class="item-edit" id="edit-<?php echo esc_attr($item_id); ?>" title="<?php esc_attr_e('Edit Menu Item' , 'autoroyal' ); ?>" href="<?php
	                        echo ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? admin_url( 'nav-menus.php' ) : add_query_arg( 'edit-menu-item', $item_id, remove_query_arg( $removed_args, admin_url( 'nav-menus.php#menu-item-settings-' . $item_id ) ) );
	                    ?>"><?php esc_html_e( 'Edit Menu Item' , 'autoroyal' ); ?></a>
	                </span>
	            </div>
	        </div>
	
	        <div class="menu-item-settings wp-clearfix" id="menu-item-settings-<?php echo esc_attr($item_id); ?>">
	            <?php if( 'custom' == $item->type ) : ?>
	                <p class="field-url description description-wide">
	                    <label for="edit-menu-item-url-<?php echo esc_attr($item_id); ?>">
	                        <?php esc_html_e( 'URL' , 'autoroyal' ); ?><br />
	                        <input type="text" id="edit-menu-item-url-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->url ); ?>" />
	                    </label>
	                </p>
	            <?php endif; ?>
	            <p class="description description-wide">
	                <label for="edit-menu-item-title-<?php echo esc_attr($item_id); ?>">
	                    <?php esc_html_e( 'Navigation Label' , 'autoroyal' ); ?><br />
	                    <input type="text" id="edit-menu-item-title-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->title ); ?>" />
	                </label>
	            </p>
	            <p class="description description-wide">
	                <label for="edit-menu-item-attr-title-<?php echo esc_attr($item_id); ?>">
	                    <?php esc_html_e( 'Title Attribute' , 'autoroyal' ); ?><br />
	                    <input type="text" id="edit-menu-item-attr-title-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-attr-title" name="menu-item-attr-title[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->post_excerpt ); ?>" />
	                </label>
	            </p>
	            <?php if ( $depth == 0 ) { ?>
	            <p class="field-custom description description-wide">
	            	<?php esc_html_e( 'Mega Menu' , 'autoroyal' ); ?><br />
	            	<?php

	            		if ( $mega_menus ) : ?>
							<select class="description-wide" name="menu-item-mega_menu_id[<?php echo esc_attr($item_id); ?>]">
								<option value="">None</option>
                			<?php foreach ( $mega_menus as $mega_menu ) :

                				$mega_menu_ID = $mega_menu->ID; 

                				?>
								<option value="<?php echo esc_attr($mega_menu_ID); ?>" <?php if($mega_menu_id == $mega_menu_ID) { ?>selected<?php } ?>><?php echo get_the_title($mega_menu_ID); ?></option>
                				<?php

                			endforeach; ?>
							</select>
                		<?php endif;

	            	?>
	            </p> 
	            <?php } ?>
	            <?php if ( $depth == 0 ) { ?>
	            <p class="field-custom description description-wide">
	            	<?php esc_html_e( 'Sub Menu Width' , 'autoroyal' ); ?><br />
	            	<select class="description-wide" name="menu-item-submenu-size[<?php echo esc_attr($item_id); ?>]">
						<option value="default" <?php if($submenu_size == 'default') { ?>selected<?php } ?>>Default (240px)</option>
						<option value="290" <?php if($submenu_size == '290') { ?>selected<?php } ?>>290px</option>
						<option value="330" <?php if($submenu_size == '330') { ?>selected<?php } ?>>330px</option>
						<option value="600" <?php if($submenu_size == '600') { ?>selected<?php } ?>>600px</option>
						<option value="900" <?php if($submenu_size == '900') { ?>selected<?php } ?>>900px</option>
					</select>
	            </p> 
	            <?php } ?>
	            <?php if ( $depth == 0 ) { ?>
	            <p class="field-custom description description-wide">
	            	<?php esc_html_e( 'Sub Menu Position' , 'autoroyal' ); ?><br />
	            	<select class="description-wide" name="menu-item-submenu-position[<?php echo esc_attr($item_id); ?>]">
						<option value="default" <?php if($submenu_position == 'default') { ?>selected<?php } ?>>Default (left)</option>
						<option value="right" <?php if($submenu_position == 'right') { ?>selected<?php } ?>>Right</option>
						<option value="middle" <?php if($submenu_position == 'middle') { ?>selected<?php } ?>>Middle</option>
					</select>
	            </p> 
	            <?php } ?>
	            <p class="description description-wide">
	                <label for="edit-menu-item-attr-title-<?php echo esc_attr($item_id); ?>">
	                    <?php esc_html_e( 'Menu Icon (font or svg)' , 'autoroyal' ); ?><br />
	                    <textarea type="text" id="edit-menu-item-menu-icon-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-menu-icon" name="menu-item-menu-icon[<?php echo esc_attr($item_id); ?>]" value="" /><?php echo esc_attr( $item->menu_icon ); ?></textarea>
	                </label>
	            </p>
	            <p class="field-link-target description">
	                <label for="edit-menu-item-target-<?php echo esc_attr($item_id); ?>">
	                    <input type="checkbox" id="edit-menu-item-target-<?php echo esc_attr($item_id); ?>" value="_blank" name="menu-item-target[<?php echo esc_attr($item_id); ?>]"<?php checked( $item->target, '_blank' ); ?> />
	                    <?php esc_html_e( 'Open link in a new window/tab' , 'autoroyal' ); ?>
	                </label>
	            </p>
	            <p class="field-css-classes description description-thin">
	                <label for="edit-menu-item-classes-<?php echo esc_attr($item_id); ?>">
	                    <?php esc_html_e( 'CSS Classes (optional)' , 'autoroyal' ); ?><br />
	                    <input type="text" id="edit-menu-item-classes-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( implode(' ', $item->classes ) ); ?>" />
	                </label>
	            </p>
	            <p class="field-xfn description description-thin">
	                <label for="edit-menu-item-xfn-<?php echo esc_attr($item_id); ?>">
	                    <?php esc_html_e( 'Link Relationship (XFN)' , 'autoroyal' ); ?><br />
	                    <input type="text" id="edit-menu-item-xfn-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->xfn ); ?>" />
	                </label>
	            </p>
	            <p class="field-description description description-wide">
	                <label for="edit-menu-item-description-<?php echo esc_attr($item_id); ?>">
	                    <?php esc_html_e( 'Description' , 'autoroyal' ); ?><br />
	                    <textarea id="edit-menu-item-description-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo esc_attr($item_id); ?>]"><?php echo esc_html( $item->description ); // textarea_escaped ?></textarea>
	                    <span class="description"><?php esc_html_e( 'The description will be displayed in the menu if the current theme supports it.' , 'autoroyal' ); ?></span>
	                </label>
	            </p>        
	            
                <?php
	            /* New fields insertion starts here */
	            ?>
	           
                
	            <?php
	            /* New fields insertion ends here */
	            ?>
                
	            <div class="menu-item-actions description-wide submitbox">
	                <?php if( 'custom' != $item->type && $original_title !== false ) : ?>
	                    <p class="link-to-original">
	                        <?php printf( esc_html__('Original: %s' , 'autoroyal' ), '<a href="' . esc_attr( $item->url ) . '">' . esc_html( $original_title ) . '</a>' ); ?>
	                    </p>
	                <?php endif; ?>
	                <a class="item-delete submitdelete deletion" id="delete-<?php echo esc_attr($item_id); ?>" href="<?php
	                echo wp_nonce_url(
	                    add_query_arg(
	                        array(
	                            'action' => 'delete-menu-item',
	                            'menu-item' => $item_id,
	                        ),
	                        remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
	                    ),
	                    'delete-menu_item_' . $item_id
	                ); ?>"><?php esc_html_e('Remove' , 'autoroyal'); ?></a> <span class="meta-sep"> | </span> <a class="item-cancel submitcancel" id="cancel-<?php echo esc_attr($item_id); ?>" href="<?php echo esc_url( add_query_arg( array('edit-menu-item' => $item_id, 'cancel' => time()), remove_query_arg( $removed_args, admin_url( 'nav-menus.php' ) ) ) );
	                    ?>#menu-item-settings-<?php echo esc_attr($item_id); ?>"><?php esc_html_e('Cancel' , 'autoroyal' ); ?></a>
	            </div>
	
	            <input class="menu-item-data-db-id" type="hidden" name="menu-item-db-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item_id); ?>" />
	            <input class="menu-item-data-object-id" type="hidden" name="menu-item-object-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->object_id ); ?>" />
	            <input class="menu-item-data-object" type="hidden" name="menu-item-object[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->object ); ?>" />
	            <input class="menu-item-data-parent-id" type="hidden" name="menu-item-parent-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->menu_item_parent ); ?>" />
	            <input class="menu-item-data-position" type="hidden" name="menu-item-position[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->menu_order ); ?>" />
	            <input class="menu-item-data-type" type="hidden" name="menu-item-type[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->type ); ?>" />
	        </div><!-- .menu-item-settings-->
	        <ul class="menu-item-transport"></ul>
	    <?php
	    
	    $output .= ob_get_clean();

	    }
}

/*
|--------------------------------------------------------------------------
| Custom Walker for wp_nav_menu args
|--------------------------------------------------------------------------
*/
 
class td_menu_walker extends Walker_Nav_Menu {

	private $curItem;

	function start_lvl( &$output, $depth = 0, $args = array() ) {

    	$itemID = $this->curItem->ID;

    	$indent = str_repeat("\t", $depth);
        $megamenu = get_post_meta( $itemID, '_menu_item_megamenu', true );

    	if(!empty($megamenu) && $depth == 0) {
			$output .= "\n$indent<ul class=\"sub-menu ft-mega-menu\">\n";
		} else {
			$output .= "\n$indent<ul class=\"sub-menu\">\n";
		}

	}
	
    function start_el( &$output, $item, $depth = 0, $args = array() , $current_object_id = 0 ) {
          
        global $wp_query, $extraClass, $itemID;

        $this->curItem = $item;

        //var_dump($item);

       	/* reset values */	
        $class_names = $value = $post_data = '';
		   
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

        $itemTitle = $item->title;
        $itemID = $item->ID;

        $mega_menu_id = get_post_meta( $itemID, '_menu_item_mega_menu_id', true );

        $menu_icon_content = "";
        $menu_has_icon = "";
        $menu_icon = get_post_meta( $itemID, '_menu_item_menu_icon', true );
        if(!empty($menu_icon)) {
        	$menu_icon_content = "<span class='ft-menu-icon'>" . $menu_icon . "</span>";
        	$menu_has_icon = "ft-menu-has-icon";
        }

        $menu_icon        = get_post_meta( $itemID, '_menu_item_menu_icon', true );
        $menu_icon        = get_post_meta( $itemID, '_menu_item_menu_icon', true );
        $submenu_size     = get_post_meta( $itemID, '_menu_item_submenu_size', true );
        $submenu_position = get_post_meta( $itemID, '_menu_item_submenu_position', true );
        
        $extraClass = "";

        if(!empty($mega_menu_id) && $depth == 0) {
        	$extraClass = "menu-item-has-children menu-has-mega-menu mega-menu-id-" . $mega_menu_id . " ";
        }

        if(!empty($megamenu)) { $mega_menu_class = "td-has-megamenu"; } else { $mega_menu_class = ""; }

        $attr_content = ! empty( $item->attr_title )   ? strip_tags($item->attr_title)  : '';

        $attr_class = "";
        $has_attr = "";
        if(!empty($attr_content)) {
        	$attr_class = "ft-menu-bold";
        	$has_attr = "ft-menu-has-attrtitle";
        	$attr_content = "<span class='ft-menu-attrtitle'>".$attr_content."</span>";
        }

        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
		$class_names = ' class="'. esc_attr( $class_names ) . ' ' . $extraClass . ' ' . $mega_menu_class . ' ft-menu-item-'.$itemID.' ' . $has_attr . ' ' . $menu_has_icon . ' ft-menu-width-'.$submenu_size.'  ft-menu-position-'.$submenu_position.' "';
		   
		$output .= $indent . '<li ' . $value . $class_names .'>';
		   
		if ( !empty( $item->object_id ) ) {
		   	$post_data = get_post($item->object_id);
		}
		  
        $prepend = '';
        $append = '';
                                    
        if($depth >= 2) {
	        $append = $prepend = "";
        }

        global $args;

        $attributes = ! empty( $item->url ) ? ' href="'   . esc_attr( $item->url ) .'"' : '';
        
        $item_output = "";
        if(isset($args)) { $item_output .= $args->before; };
        $item_output .= '<a class="nav-link menu-button-'.$itemID.'" '. $attributes .' >' . $menu_icon_content . '<span class="'.$attr_class.'">'. $itemTitle .'</span>'.$attr_content.'</a>';
        if(isset($args)) { $item_output .= $args->after; };

        if(!empty($mega_menu_id) && $depth == 0) {

        	$post = get_post($mega_menu_id); 
			$content = apply_filters('the_content', $post->post_content); 

			$shortcodes_custom_css = get_post_meta( $mega_menu_id, '_wpb_shortcodes_custom_css', true );
			if ( ! empty( $shortcodes_custom_css ) ) {

				wp_enqueue_style(
			        'autoroyal-custom-style-button',
			        get_template_directory_uri() . '/assets/css/custom-styles.css'
			    );
			    $shortcodes_custom_css = strip_tags( $shortcodes_custom_css );
			    wp_add_inline_style( 'autoroyal-custom-style-button', $shortcodes_custom_css );

			}

			$item_output .= "\n<ul class=\"sub-menu ft-mega-menu\">\n";
			$item_output .= $content;
			$item_output .= "\n</ul>\n";
		} 

        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );

    }

}

?>