<?php
/**
 * autoRoyal functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package fantasy_themes
 */

if ( ! function_exists( 'autoroyal_setup' ) ) :
	function autoroyal_setup() {

		// Make theme available for translation.
		load_theme_textdomain( 'autoroyal', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );

		// Enable support for woocommerce.
		add_theme_support( 'woocommerce' );

		// Add nav menu
		register_nav_menu( 'menu-1', esc_html__('Primary Menu','autoroyal') );
		register_nav_menu( 'menu-2', esc_html__('Footer Menu','autoroyal') );

		// Switch default core markup for search form, comment form, and comments
		add_theme_support( 'html5', array(
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'autoroyal_custom_background_args', array(
			'default-color' => 'f8f9fa',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		add_image_size( 'autoroyal-thumbnail-image', 290, 203, true );
		add_image_size( 'autoroyal-large-thumbnail-image', 442, 310, true );
		add_image_size( 'autoroyal-testimonial-image', 100, 100, true );
		add_image_size( 'autoroyal-blog-post-image', 610, 420, true );
		add_image_size( 'autoroyal-team-carousel-image', 980, 1200, true );
		add_image_size( 'autoroyal-body-type', 169, 112, true );
		add_image_size( 'autoroyal-team-avatar', 500, 420, true);

	}
endif;
add_action( 'after_setup_theme', 'autoroyal_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function autoroyal_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'autoroyal_content_width', 800 );
}
add_action( 'after_setup_theme', 'autoroyal_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function autoroyal_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Shop', 'autoroyal' ),
		'id'            => 'shop',
		'description'   => esc_html__( 'Add widgets here.', 'autoroyal' ),
		'before_widget' => '<section id="%1$s" class="widget border-bottom %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title h6">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'autoroyal' ),
		'id'            => 'sidebar-1',
		'description'   => esc_html__( 'Add widgets here.', 'autoroyal' ),
		'before_widget' => '<section id="%1$s" class="widget border-bottom %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title h6">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 1', 'autoroyal' ),
		'id'            => 'footer-1',
		'description'   => esc_html__( 'Add widgets here.', 'autoroyal' ),
		'before_widget' => '<section id="%1$s" class="widget fantasy-themes-footer-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title h6">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 2', 'autoroyal' ),
		'id'            => 'footer-2',
		'description'   => esc_html__( 'Add widgets here.', 'autoroyal' ),
		'before_widget' => '<section id="%1$s" class="widget fantasy-themes-footer-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title h6">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 3', 'autoroyal' ),
		'id'            => 'footer-3',
		'description'   => esc_html__( 'Add widgets here.', 'autoroyal' ),
		'before_widget' => '<section id="%1$s" class="widget fantasy-themes-footer-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title h6">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Column 4', 'autoroyal' ),
		'id'            => 'footer-4',
		'description'   => esc_html__( 'Add widgets here.', 'autoroyal' ),
		'before_widget' => '<section id="%1$s" class="widget fantasy-themes-footer-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title h6">',
		'after_title'   => '</h5>',
	) );
}
add_action( 'widgets_init', 'autoroyal_widgets_init' );




/**
 * Enqueue scripts and styles.
 */
add_action( 'wp_enqueue_scripts', 'autoroyal_scripts' );

function autoroyal_scripts() {

	if ( !is_admin() ) {

		// Script

		wp_enqueue_script( 'bootstrap',            get_template_directory_uri() . '/assets/js/bootstrap.js', array('jquery'), 'v4.0.0', true );
		wp_enqueue_script( 'isInView',             get_template_directory_uri() . '/assets/js/jquery.isinview.js', array('jquery'), '1.0.6', true );
		wp_enqueue_script( 'jquery-cookie',        get_template_directory_uri() . '/assets/js/jquery.cookie.js', array( 'jquery' ), '1.6.0', false );
		wp_enqueue_script( 'isotope',              get_template_directory_uri() . '/assets/js/isotope.pkgd.min.js', array( 'jquery' ), '2.1.0', false );
		wp_register_script( 'touch-punch',         get_template_directory_uri() . '/assets/js/jquery.ui.touch-punch.min.js', array( 'jquery' ), '0.2.3', false );
		wp_enqueue_script( 'fancybox',             get_template_directory_uri() . '/assets/js/jquery.fancybox.js', array( 'jquery' ), '2.1.7', false );
		wp_enqueue_script( 'autoroyal-loan',       get_template_directory_uri() . '/assets/js/loan-calculator.js', array('jquery'), '1.0.0', true );
		wp_register_script( 'populate-map',        get_template_directory_uri() . '/assets/js/populate-map.js', array('jquery'), '1.0.0', true );
		wp_register_script( 'populate-cars',       get_template_directory_uri() . '/assets/js/locations.js', array('jquery'), '1.0.0', true );
		wp_register_script( 'flipclock',           get_template_directory_uri() . '/assets/js/flipclock.js', array('jquery'), '1.0.0', true );
		wp_register_script( 'datejs',              get_template_directory_uri() . '/assets/js/datejs.js', array('jquery'), '', true );
		wp_register_script( 'autoroyal-gmap3',     get_template_directory_uri() . '/assets/js/gmap3.min.js', array('jquery'), '5.1.1' , true );
		wp_enqueue_script( 'chosen',               get_template_directory_uri() . '/assets/js/chosen.jquery.min.js', array('jquery'), '1.8.7', true );
		wp_enqueue_script( 'aos',                  get_template_directory_uri() . '/assets/js/aos.js', array('jquery'), '', true );
		wp_enqueue_script( 'autoroyal-js',         get_template_directory_uri() . '/assets/js/main.js', array('jquery'), '1.0.0', true );

		$protocol = is_ssl() ? 'https' : 'http';
		$expense_currency = "";
		$autoroyal_currency = get_option( 'autoroyal_currency' ); 
		if(!empty($autoroyal_currency)) { 
			$expense_currency = esc_html__('in', 'autoroyal' ) . " " . $autoroyal_currency; 
		}
		$currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );
		$currency_pos = get_option( 'autoroyal_currency_position' );
		
		$settings = array(
			'url_theme' => get_template_directory_uri(),
			'autoroyal_ajaxurl' => esc_url( admin_url('admin-ajax.php', 'relative') ),
			'remove_image' => esc_html__("Remove Image", "autoroyal"),
			'select_a_make' => esc_html__("Select a Make", "autoroyal"),
			'upload_image' => esc_html__("Upload Image", "autoroyal"),
			'currency_symbol' => $currency_symbol,
			'currency_pos' => $currency_pos,
			'expense_label' => esc_html__("Price", "autoroyal"),
			'expense_currency' => $expense_currency,
			'expense_desc' => esc_html__("Description", "autoroyal"),
			'expense_desc_placeholder' => esc_html__("Write down vehicle’s expense description here...", "autoroyal"),
			'expense_delete' => esc_html__("Delete", "autoroyal"),
			'measurement_type' => get_option( 'autoroyal_measurement_type' ),
			'protocol' => $protocol,
		);

		wp_localize_script( 'autoroyal-js', 'autoroyalSettings', apply_filters( 'autoroyal-js', $settings ) );

		if ( is_singular() && comments_open() ) {
			wp_enqueue_script( 'comment-reply' );
		}

		// Style

		wp_enqueue_style( 'open-iconic-bootstrap', get_template_directory_uri() . '/assets/css/open-iconic-bootstrap.css', array(), 'v4.0.0', 'all' );
		wp_enqueue_style( 'bootstrap',             get_template_directory_uri() . '/assets/css/bootstrap.css', array(), 'v4.0.0', 'all' );
		wp_enqueue_style( 'fontawesome',           get_template_directory_uri() . '/assets/css/font-awesome.min.css', array(), '4.5.0', 'all' );
		wp_enqueue_style( 'fontawesome-5',         get_template_directory_uri() . '/assets/css/fontawesome-all.min.css', array(), '4.5.0', 'all' );
		wp_enqueue_style( 'fancybox',              get_template_directory_uri() . '/assets/css/jquery.fancybox.css', array(), '2.1.7', 'all' );
		wp_enqueue_style( 'chosen',                get_template_directory_uri() . '/assets/css/chosen.min.css', array(), '1.8.7', 'all' );
		wp_enqueue_style( 'aos' ,                  get_template_directory_uri() . '/assets/css/aos.css' );
		wp_enqueue_style( 'fantasythemes-style',   get_stylesheet_uri(), array(), '1.0.0', 'all' );
		wp_enqueue_style( 'autoroyal-style',       get_template_directory_uri() . '/assets/css/theme-specific.css', array(), '1.0.0', 'all' );

	}

}


/**
 * Registers an editor stylesheet for the theme.
 */
function autoroyal_add_editor_styles() {
    add_editor_style( 'editor-style.css' );
}
add_action( 'admin_init', 'autoroyal_add_editor_styles' );


// Implement the Custom Comment feature.
require get_template_directory() . '/inc/custom-comment.php';

// Custom template tags for this theme.
require get_template_directory() . '/inc/template-tags.php';

// Functions which enhance the theme by hooking into WordPress.
require get_template_directory() . '/inc/template-functions.php';

// Custom Navbar
require get_template_directory() . '/inc/td-menu-walker.php';

// Customizer additions.
require get_template_directory() . '/inc/tgmpa/tgmpa-init.php';

// Use Kirki for customizer API
//require get_template_directory() . '/inc/theme-options/add-settings.php';

// Customizer additions.
require get_template_directory() . '/inc/customizer/td-customizer.php';

// Load Jetpack compatibility file.
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

// Load WooCommerce compatibility file.
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}

/*
|--------------------------------------------------------------------------
| Load custom colors
|--------------------------------------------------------------------------
*/
require get_template_directory() . '/inc/td-colors.php';

/*
|--------------------------------------------------------------------------
| Enqueue google fonts
|--------------------------------------------------------------------------
*/

function autoroyal_fonts_url() {

	$fonts_url = '';

	/* Translators: If there are characters in your language that are not
	* supported by Open Sans, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$OpenSans = esc_html_x( 'on', 'Open Sans font: on or off', 'autoroyal' );

	//
	 
	if ( 'off' !== $OpenSans ) {

		$font_families = array();

		if ( 'off' !== $OpenSans ) {
			$font_families[] = 'Open Sans:300,400,600,600i,700';
		}
		 
		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);
		 
		$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );

	}
	 
	return esc_url_raw( $fonts_url );
}

function autoroyal_icon_fonts_url() {

	$fonts_url = '';

	/* Translators: If there are characters in your language that are not
	* supported by Open Sans, translate this to 'off'. Do not translate
	* into your own language.
	*/
	$MaterialIcons = esc_html_x( 'on', 'Material Icons font: on or off', 'autoroyal' );

	//
	 
	if ( 'off' !== $MaterialIcons ) {

		$font_families = array();

		if ( 'off' !== $MaterialIcons ) {
			$font_families[] = 'Material Icons';
		}
		 
		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);
		 
		$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/icon' );

	}
	 
	return esc_url_raw( $fonts_url );
}


/*
Enqueue scripts and styles.
*/
function autoroyal_fonts() {
    wp_enqueue_style( 'fantasy-themes-google-fonts', autoroyal_fonts_url(), array(), '1.0.0' );
    wp_enqueue_style( 'fantasy-themes-google-icons', autoroyal_icon_fonts_url(), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'autoroyal_fonts' );

// Custom class for dashboard
function autoroyal_conditional_body_class( $classes ) {

    if( 
    	is_page_template('templates/template-dashboard.php')
    	)
        $classes[] = 'autoroyal-front-dashboard-wrapper ';

    return $classes;

}
add_filter( 'body_class', 'autoroyal_conditional_body_class' );

function autoroyal_ajax_load_rent_car_price() {

	$car_ID = sanitize_text_field( $_POST['car_ID'] );

	ob_start();

	$response['html'] = '';
	$response['car_id'] = $car_ID;

	$vehicle_rent_price_set = get_post_meta($car_ID, 'vehicle_rent_price_set',true);
		                    
    $i = 0;

    if(!empty($vehicle_rent_price_set)) {

        foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
            
            if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

                $i++;

                ?>

                <li class="clearfix">
                    <span class="pull-left"><?php if($vehicle_rent_price_set_item['period'] == 1) { echo "24"; echo " "; echo esc_html_e('hours', 'autoroyal'); } else { echo esc_attr($vehicle_rent_price_set_item['period']); echo "+ "; echo esc_html_e('days', 'autoroyal'); } ?></span>
                    <span class="pull-right">
                        <b>$<?php echo esc_attr($vehicle_rent_price_set_item['price']); ?></b>
                    </span>
                    <input type="hidden" id="price-set-period-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['period']); ?>">
                	<input type="hidden" id="price-set-price-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['price']); ?>">
                </li>

                <?php

            }

        }

        ?><input type="hidden" class="total-sets" value="<?php echo esc_attr($i); ?>"><?php

    }

	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_ajax_load_rent_car_price', 'autoroyal_ajax_load_rent_car_price' );
add_action( 'wp_ajax_nopriv_autoroyal_ajax_load_rent_car_price', 'autoroyal_ajax_load_rent_car_price' );

function autoroyal_ajax_load_rent_car_details() {

	$car_ID = sanitize_text_field( $_POST['car_ID'] );

	ob_start();

	$response['html'] = '';
	$response['car_id'] = $car_ID;

	$vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
    $vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
    $vehicle_image_url = "";

    if(!empty($vehicle_image_gallery[0]['url'])) {

        $vehicle_image_url = $vehicle_image_gallery[0]['url'];

    } elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

        $vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

    }

    $vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
    if(!empty($vehicle_cover_image)) {
        $vehicle_image_url = $vehicle_cover_image;
    }

    $vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
    $vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
    $vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));

    //
    $terms_vehicle_doors = "";
    $terms_vehicle_doors_name = "";
    $vehicle_vehicle_doors = get_the_terms($car_ID, 'vehicle_doors' );
    if ($vehicle_vehicle_doors && ! is_wp_error($vehicle_vehicle_doors)) :
        $terms_vehicle_doors = $vehicle_vehicle_doors[0]->term_id;
        $terms_vehicle_doors_name = $vehicle_vehicle_doors[0]->name;
    endif;

    //
    $terms_vehicle_seats = "";
    $terms_vehicle_seats_name = "";
    $vehicle_vehicle_seats = get_the_terms($car_ID, 'vehicle_seats' );
    if ($vehicle_vehicle_seats && ! is_wp_error($vehicle_vehicle_seats)) :
        $terms_vehicle_seats = $vehicle_vehicle_seats[0]->term_id;
        $terms_vehicle_seats_name = $vehicle_vehicle_seats[0]->name;
    endif;

    //
    $terms_vehicle_rent_age = "";
    $terms_vehicle_rent_age_name = "";
    $vehicle_vehicle_rent_age = get_the_terms($car_ID, 'vehicle_rent_age' );
    if ($vehicle_vehicle_rent_age && ! is_wp_error($vehicle_vehicle_rent_age)) :
        $terms_vehicle_rent_age = $vehicle_vehicle_rent_age[0]->term_id;
        $terms_vehicle_rent_age_name = $vehicle_vehicle_rent_age[0]->name;
    endif;

    //
    $terms_vehicle_luggages = "";
    $terms_vehicle_luggages_name = "";
    $vehicle_vehicle_luggages = get_the_terms($car_ID, 'vehicle_luggages' );
    if ($vehicle_vehicle_luggages && ! is_wp_error($vehicle_vehicle_luggages)) :
        $terms_vehicle_luggages = $vehicle_vehicle_luggages[0]->term_id;
        $terms_vehicle_luggages_name = $vehicle_vehicle_luggages[0]->name;
    endif;

    $terms_vehicle_transmission = "";
    $terms_vehicle_transmission_id = "";
    $vehicle_transmission = get_the_terms($car_ID, 'vehicle_transmission' );
    if ($vehicle_transmission && ! is_wp_error($vehicle_transmission)) :
        $terms_vehicle_transmission = $vehicle_transmission[0]->name;
        $terms_vehicle_transmission_id = $vehicle_transmission[0]->term_id;
    endif;

    $vehicle_navigation = get_post_meta($car_ID, 'vehicle_navigation',true);
    $vehicle_ac = get_post_meta($car_ID, 'vehicle_ac',true);
    $rent_deposit = get_post_meta($car_ID, 'rent_deposit',true);
    $mileage_limit = get_post_meta($car_ID, 'mileage_limit',true);

	?>

	<div class="row">

		<?php if(!empty($vehicle_image_url)) { $foto_large = autoroyal_get_resized_image( $vehicle_image_url, 'autoroyal-thumbnail-image' ); ?>
			                    
	    <div class="col-md-2">
	      	<div class="car-preview">
	            <div class="image"><img src="<?php echo esc_url($foto_large); ?>" alt="car-preview-image" class="img-responsive"></div>
	            <input type="hidden" id="reserv-car-id" name="reserv-car-id" value="">
	      	</div>
	    </div>

	    <?php } ?>

	    <div class="col-md-10">
	    	<div class="reserv-header">
				<h3 class="reserv-title"><span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?></h3>
				<ul class="reserv-subtitle">
					<?php if(!empty($terms_vehicle_seats_name)) { ?>
	                    <li class="autoroyal-vehicle-stock">
	                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 350 350" style="enable-background:new 0 0 350 350;" xml:space="preserve"><path d="M175,171.173c38.914,0,70.463-38.318,70.463-85.586C245.463,38.318,235.105,0,175,0s-70.465,38.318-70.465,85.587
	C104.535,132.855,136.084,171.173,175,171.173z"/><path d="M41.909,301.853C41.897,298.971,41.885,301.041,41.909,301.853L41.909,301.853z"/><path d="M308.085,304.104C308.123,303.315,308.098,298.63,308.085,304.104L308.085,304.104z"/><path d="M307.935,298.397c-1.305-82.342-12.059-105.805-94.352-120.657c0,0-11.584,14.761-38.584,14.761
	s-38.586-14.761-38.586-14.761c-81.395,14.69-92.803,37.805-94.303,117.982c-0.123,6.547-0.18,6.891-0.202,6.131
	c0.005,1.424,0.011,4.058,0.011,8.651c0,0,19.592,39.496,133.08,39.496c113.486,0,133.08-39.496,133.08-39.496
	c0-2.951,0.002-5.003,0.005-6.399C308.062,304.575,308.018,303.664,307.935,298.397z"/></svg><?php echo esc_attr($terms_vehicle_seats_name); ?>
	                    </li>
	                <?php } ?>

	                <?php if(!empty($terms_vehicle_luggages_name)) { ?>
	                    <li class="autoroyal-vehicle-stock">
	                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="511.626px" height="511.627px" viewBox="0 0 511.626 511.627" style="enable-background:new 0 0 511.626 511.627;" xml:space="preserve"><path d="M18.842,128.48C6.28,141.043,0,156.08,0,173.588v237.537c0,17.515,6.28,32.552,18.842,45.111
	c12.563,12.565,27.6,18.842,45.111,18.842h18.271V109.634H63.953C46.438,109.634,31.402,115.917,18.842,128.48z"/><path d="M365.446,63.955c0-7.614-2.663-14.084-7.994-19.414c-5.325-5.33-11.8-7.993-19.411-7.993H173.589
	c-7.612,0-14.083,2.663-19.414,7.993c-5.33,5.327-7.994,11.799-7.994,19.414v45.679h-36.545v365.444h292.359V109.634h-36.549
	V63.955z M328.904,109.634H182.725V73.091h146.179V109.634z"/><path d="M492.785,128.48c-12.563-12.562-27.601-18.846-45.111-18.846h-18.274v365.444h18.274c17.511,0,32.548-6.276,45.111-18.842
	c12.559-12.56,18.842-27.597,18.842-45.111V173.588C511.626,156.08,505.343,141.043,492.785,128.48z"/></svg><?php echo esc_attr($terms_vehicle_luggages_name); ?>
	                    </li>
	                <?php } ?>

	                <?php if(!empty($terms_vehicle_doors_name)) { ?>
	                    <li class="autoroyal-vehicle-stock">
	                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M446.479,261.188l-55.826-93.043c2.393-1.956,4.013-4.81,4.013-8.145V74.667C394.667,68.771,389.896,64,384,64h-1.505
	c-3.048-13.035-10.828-24.598-22.245-32.208L325.99,8.958C317.198,3.104,306.969,0,296.417,0h-80.833
	C205.031,0,194.802,3.104,186,8.958l-34.25,22.833C140.333,39.402,132.555,50.965,129.507,64H128
	c-5.896,0-10.667,4.771-10.667,10.667V160c0,3.335,1.62,6.189,4.013,8.145l-55.826,93.043c-3.031,5.042-1.396,11.604,3.656,14.625
	c5.052,3.063,11.615,1.396,14.635-3.667L128,198.5v132.167v10.667c-5.896,0-10.667,4.771-10.667,10.667v85.333
	c0,5.896,4.771,10.667,10.667,10.667h1.078c5.232,36.089,36.074,64,73.589,64h106.667c37.514,0,68.357-27.911,73.589-64H384
	c5.896,0,10.667-4.771,10.667-10.667V352c0-5.896-4.771-10.667-10.667-10.667v-10.667V198.5l44.188,73.646
	c3.021,5.063,9.583,6.729,14.635,3.667C447.875,272.792,449.51,266.229,446.479,261.188z M180.448,116.792
	c3.917-6.333,10.698-10.125,18.146-10.125h114.812c7.448,0,14.229,3.792,18.146,10.125c3.917,6.333,4.271,14.083,0.938,20.75
	l-21.333,42.667C307.521,187.479,300.208,192,292.073,192h-72.146c-8.135,0-15.448-4.521-19.083-11.792l-21.333-42.667
	C176.177,130.875,176.531,123.125,180.448,116.792z M149.333,313.41V185.75l21.333,21.333v95.667L149.333,313.41z
	M338.208,402.208c-1,1-25.115,24.458-82.208,24.458s-81.208-23.458-82.208-24.458c-3.25-3.25-4.052-8.208-2-12.313l21.333-42.667
	c2.635-5.229,9.063-7.354,14.281-4.792C207.594,342.542,227.187,352,256,352c29.146,0,48.375-9.438,48.562-9.542
	c2.542-1.271,5.438-1.438,8.146-0.583c2.677,0.896,4.896,2.833,6.167,5.354l21.333,42.667
	C342.26,394,341.458,398.958,338.208,402.208z M362.667,313.41l-21.333-10.66v-95.667l21.333-21.333V313.41z"/></svg><?php echo esc_attr($terms_vehicle_doors_name); ?> <?php echo esc_html_e('Doors', 'autoroyal'); ?>
	                    </li>
	                <?php } ?>
	                
	                <?php if(!empty($terms_vehicle_transmission)) { ?>
	                    <li class="autoroyal-vehicle-stock">
	                        <svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"></path><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"></path><circle cx="70" cy="70" r="4"></circle></svg><?php echo esc_attr($terms_vehicle_transmission); ?>
	                    </li>
	                <?php } ?>

	                <?php if(!empty($vehicle_navigation)) { ?>
	                    <li class="autoroyal-vehicle-stock">
	                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="438.533px" height="438.533px" viewBox="0 0 438.533 438.533" style="enable-background:new 0 0 438.533 438.533;" xml:space="preserve"><path d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
	c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
	c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
	s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
	C438.533,179.485,428.732,142.795,409.133,109.203z M353.742,297.208c-13.894,23.791-32.736,42.64-56.527,56.534
	c-23.791,13.894-49.771,20.834-77.945,20.834c-28.167,0-54.149-6.94-77.943-20.834c-23.791-13.895-42.633-32.743-56.527-56.534
	c-13.897-23.791-20.843-49.772-20.843-77.941c0-28.171,6.949-54.152,20.843-77.943c13.891-23.791,32.738-42.637,56.527-56.53
	c23.791-13.895,49.772-20.84,77.943-20.84c28.173,0,54.154,6.945,77.945,20.84c23.791,13.894,42.634,32.739,56.527,56.53
	c13.895,23.791,20.838,49.772,20.838,77.943C374.58,247.436,367.637,273.417,353.742,297.208z"/><path d="M146.181,333.182l146.178-73.087V105.35l-146.178,73.089V333.182z M182.727,200.992l73.094,36.547l-73.094,36.545V200.992
	z"/></svg><?php echo esc_html_e('Navigation', 'autoroyal'); ?>
	                    </li>
	                <?php } ?>

	                <?php if(!empty($vehicle_ac)) { ?>
	                    <li class="autoroyal-vehicle-stock">
	                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="700.236px" height="700.236px" viewBox="0 0 700.236 700.236" style="enable-background:new 0 0 700.236 700.236;" xml:space="preserve"><path d="M645.527,495.815l-75.609-43.689l63.832-38.015c10.262-4.944,13.438-18.724,7.602-28.855
	c-5.941-10.375-18.764-12.563-28.498-6.89l-85.107,49.849L392.488,349.51l135.258-77.894l85.107,49.768
	c2.658,1.945,6.078,3.08,9.881,3.08c7.213,0,13.674-3.404,18.617-9.889c5.699-10.294,2.66-23.911-7.602-28.855l-63.832-38.015
	l75.609-43.688c9.855-5.674,13.244-18.4,7.602-28.856c-5.389-10.051-18.723-13.536-28.879-7.619l-75.99,44.094l-1.135-76.03
	c-0.178-11.753-9.119-21.237-20.896-21.237c-11.775,0-20.984,10.213-20.895,21.237l0.754,100.346l-134.496,77.894V155.788
	l84.727-48.309c9.891-5.593,14.201-18.643,8.357-28.855c-5.934-10.375-18.115-13.456-28.498-7.619l-64.586,36.475V21.236
	c0-11.753-9.5-21.236-21.277-21.236c-11.777,0-20.896,9.483-20.896,21.236v87.053l-66.871-37.285
	c-10.416-5.755-22.274-2.513-28.118,7.619c-5.933,10.375-2.245,23.101,7.976,28.855l87.013,49.039v156.518l-137.542-79.353
	l0.762-98.077c1.143-11.023-8.738-21.237-20.515-21.237h-0.762c-11.016,0-20.774,9.484-20.896,21.237l-0.762,73.76l-74.084-42.554
	c-10.343-5.998-23.109-2.432-28.499,7.538c-5.642,10.537-2.724,22.939,7.603,28.937l74.846,43.283l-65.354,39.15
	C53.96,290.664,50.758,304.443,57,314.575c4.02,6.566,9.873,9.889,17.856,9.889c4.174,0,7.651-1.054,11.015-3.08l85.489-50.498
	l137.162,78.624l-137.162,79.434l-85.489-50.578c-10.262-5.998-23.49-3.161-28.872,6.89c-5.642,10.456-2.578,23.02,7.214,28.855
	l65.355,38.744l-74.847,43.689c-10.302,5.998-13.642,18.643-7.603,28.937C51.342,532.614,57,536.1,64.976,536.1
	c1.897,0,5.698-1.135,10.643-3.08l74.084-42.554l0.762,73.76c0.122,11.753,9.88,20.831,20.896,20.831h0.762
	c11.777,0,20.604-9.808,20.515-21.642l-0.762-97.996l137.542-78.623v155.707l-87.013,49.038
	c-10.383,5.836-14.015,18.562-7.976,28.856c4.223,7.214,9.881,10.699,17.856,10.699c3.802,0,7.303-0.648,10.262-2.351
	l66.871-37.935v88.513c0,11.753,9.119,20.912,20.896,20.912c11.777,0,21.277-9.159,21.277-20.912v-87.054l64.586,36.476
	c2.957,1.702,6.459,2.351,9.881,2.351c8.355,0,14.516-3.404,18.617-10.699c5.771-10.213,2.043-23.021-8.357-28.856l-84.727-47.498
	V385.985l134.496,77.894l-0.754,99.536c-0.098,11.834,9.119,21.642,20.896,21.642s20.717-9.078,20.895-20.831l1.135-76.435
	l75.99,44.499c2.934,1.702,6.84,2.27,11.023,2.27c7.977,0,13.828-3.323,17.855-9.889
	C659.363,514.539,655.382,501.489,645.527,495.815z"/></svg><?php echo esc_html_e('Air Conditioning', 'autoroyal'); ?>
	                    </li>
	                <?php } ?>

	                <?php if(!empty($rent_deposit)) { ?>
	                    <li class="autoroyal-vehicle-stock">
	                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="438.543px" height="438.543px" viewBox="0 0 438.543 438.543" style="enable-background:new 0 0 438.543 438.543;" xml:space="preserve"><path d="M396.58,5.424C392.959,1.807,388.675,0,383.727,0H54.824c-4.952,0-9.235,1.807-12.852,5.424
	c-3.615,3.615-5.424,7.898-5.424,12.847v219.268c0,16.371,3.186,32.596,9.563,48.681c6.374,16.084,14.274,30.361,23.697,42.828
	c9.423,12.47,20.651,24.605,33.689,36.405c13.04,11.806,25.078,21.6,36.116,29.409c11.038,7.803,22.554,15.181,34.545,22.121
	c11.991,6.943,20.511,11.663,25.553,14.134c5.043,2.478,9.088,4.38,12.132,5.708c2.286,1.143,4.758,1.718,7.426,1.718
	c2.671,0,5.14-0.575,7.428-1.718c3.042-1.328,7.087-3.23,12.128-5.708c5.041-2.471,13.565-7.19,25.557-14.134
	c11.984-6.94,23.504-14.318,34.54-22.121c11.043-7.81,23.079-17.604,36.121-29.409c13.031-11.8,24.263-23.936,33.685-36.405
	c9.421-12.467,17.319-26.744,23.705-42.828c6.379-16.085,9.562-32.31,9.562-48.681V18.271
	C401.994,13.319,400.187,9.04,396.58,5.424z M347.178,237.539c0,33.5-22.367,67.759-67.095,102.781
	c-17.892,14.082-38.164,27.124-60.813,39.115V54.813h127.908V237.539z"/></svg><?php $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($autoroyal_currency)) { echo esc_attr($currency_symbol); } ?><?php echo esc_attr($rent_deposit); ?>
	                    </li>
	                <?php } ?>

	                <?php if(!empty($mileage_limit)) { ?>
	                    <li class="autoroyal-vehicle-stock">
	                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M435.143,129.356c-6.796-6.795-17.463-7.797-25.407-2.384c-29.926,20.398-180.03,122.969-196.162,139.1
	c-23.394,23.395-23.394,61.459,0,84.854c11.697,11.696,27.063,17.545,42.427,17.545c15.364,0,30.729-5.849,42.427-17.545
	c16.131-16.132,118.701-166.236,139.1-196.162C442.939,146.821,441.938,136.153,435.143,129.356z M270.142,322.641
	c-7.797,7.799-20.486,7.799-28.283,0c-7.798-7.797-7.799-20.482-0.004-28.28c6.268-6.194,48.885-36.588,101.319-73.035
	C306.728,273.76,276.334,316.375,270.142,322.641z"/><path d="M92.231,401.523l-24.69,12.044C49.475,381.325,40,345.338,40,308.499c0-26.991,4.977-52.842,14.06-76.683l28.291,13.57
	c2.79,1.338,5.735,1.972,8.636,1.972c7.453,0,14.608-4.185,18.047-11.355c4.776-9.959,0.576-21.906-9.384-26.683l-27.932-13.398
	c34.717-56.62,94.784-96.095,164.283-102.505v30.081c0,11.046,8.954,20,20,20c11.046,0,20-8.954,20-20V93.402
	c23.828,2.169,46.884,8.237,68.771,18.117c10.065,4.545,21.912,0.066,26.457-9.999c4.545-10.068,0.068-21.913-10-26.458
	C328.063,60.091,292.659,52.499,256,52.499c-68.38,0-132.667,26.628-181.02,74.98C26.629,175.832,0,240.119,0,308.499
	c0,50.53,14.998,99.674,43.373,142.115c3.822,5.715,10.141,8.886,16.639,8.886c2.954,0,5.946-0.655,8.757-2.026l41-20
	c9.928-4.843,14.05-16.816,9.207-26.744C114.133,400.803,102.159,396.682,92.231,401.523z"/><path d="M489.436,203.271c-4.544-10.067-16.387-14.547-26.458-10c-10.067,4.545-14.544,16.39-9.999,26.457
	C465.601,247.686,472,277.553,472,308.499c0,36.894-9.506,72.939-27.625,105.218l-25.777-12.275
	c-9.971-4.748-21.906-0.515-26.656,9.459c-4.749,9.972-0.514,21.907,9.459,26.656l42,20c2.763,1.315,5.692,1.944,8.588,1.944
	c6.5,0,12.82-3.175,16.637-8.886C497.002,408.173,512,359.029,512,308.499C512,271.84,504.408,236.436,489.436,203.271z"/></svg>
	<?php echo esc_attr($mileage_limit); ?><?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?>
	                    </li>
	                <?php } ?>

	                <?php if(!empty($terms_vehicle_rent_age_name)) { ?>
	                    <li class="autoroyal-vehicle-stock">
	                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 460.8 460.8" style="enable-background:new 0 0 460.8 460.8;" xml:space="preserve"><path d="M410.624,49.664H50.176C22.528,49.664,0,72.192,0,99.84v261.12c0,27.648,22.528,50.176,50.176,50.176h360.448
	c27.648,0,50.176-22.528,50.176-50.176V99.84C460.8,72.192,438.272,49.664,410.624,49.664z M99.84,167.936
	c4.608-22.528,26.624-37.376,49.152-32.768c22.528,4.608,37.376,26.624,32.768,49.152c-3.072,16.384-16.384,29.696-32.768,32.768
	c-22.528,4.608-44.544-10.24-49.152-32.768C98.816,179.2,98.816,173.568,99.84,167.936z M211.968,315.392
	c0,6.144-5.12,11.264-11.264,11.264H80.896c-6.144,0-11.264-5.12-11.264-11.264V302.08c-0.512-36.864,26.624-67.584,62.976-72.704
	c38.912-4.608,74.752,23.552,78.848,62.464c0.512,2.56,0.512,5.632,0.512,8.192V315.392z M387.072,290.304H252.928v-33.792
	h134.144V290.304z M387.072,204.288H252.928v-33.792h134.144V204.288z"/></svg><?php echo esc_html_e('From', 'autoroyal'); ?> <?php echo esc_attr($terms_vehicle_rent_age_name); ?> <?php echo esc_html_e('years', 'autoroyal'); ?>
	                    </li>
	                <?php } ?>
				</ul>
			</div>
	    </div>
	</div>

    <?php

	$response['html'] = ob_get_clean();

	echo json_encode($response);

	exit;

}
add_action( 'wp_ajax_autoroyal_ajax_load_rent_car_details', 'autoroyal_ajax_load_rent_car_details' );
add_action( 'wp_ajax_nopriv_autoroyal_ajax_load_rent_car_details', 'autoroyal_ajax_load_rent_car_details' );


function autoroyal_count_posts_with_term($term_name, $taxonomy) {
	global $wpdb;
	
	$term = get_term_by( 'name', $term_name, $taxonomy );

	$st = $wpdb->prepare("SELECT COUNT(*) FROM $wpdb->posts p
		INNER JOIN $wpdb->term_relationships tr
		ON (p.ID = tr.object_id)
		INNER JOIN $wpdb->term_taxonomy tt
		ON (tr.term_taxonomy_id = tt.term_taxonomy_id)
		WHERE
		p.post_status = 'publish'
		AND tt.taxonomy = %s
		AND tt.term_id = %d;",
		$taxonomy,
		$term->term_id);
		
	return $wpdb->get_var($st);
}


/*
|--------------------------------------------------------------------------
| Deferring parsing of JavaScript
|--------------------------------------------------------------------------
*/
function autoroyal_defer_parsing_of_js ( $url ) {
	if ( FALSE === strpos( $url, '.js' ) ) return $url;
	if ( strpos( $url, 'jquery.js' ) ) return $url;
	return "$url'  defer='defer";
}
//add_filter( 'clean_url', 'autoroyal_defer_parsing_of_js', 11, 1 );

function autoroyal_get_term_icon_id( $term_id = null, $taxonomy = null ) {

	if ( function_exists( 'get_term_meta' ) ) {

		if ( null === $term_id ) {
			global $wp_query;
			$term    = $wp_query->queried_object;
			$term_id = $term->term_id;

		}

		return get_term_meta( $term_id, 'pix_term_icon', true );
	}

	return false;
}

function autoroyal_get_term_icon_url( $term_id = null, $size = 'full' ) {

	$attachment_id = autoroyal_get_term_icon_id( $term_id );

	if ( ! empty( $attachment_id ) ) {
		$attach_args = wp_get_attachment_image_src( $attachment_id, $size );

		// $attach_args[0] should be the url
		if ( isset( $attach_args[0] ) ) {
			return $attach_args[0];
		}
	}

	return false;
}

if ( ! function_exists( 'autoroyal_pagination' ) ) {
	/**
	 * Pagination
	 *
	 * @param string $pages
	 */
	function autoroyal_pagination( $pages = '' ) {

		global $paged;

		if ( is_page_template( 'template-home.php' ) ) {
			$paged = intval( get_query_var( 'page' ) );
		}

		if ( empty( $paged ) ) {
			$paged = 1;
		}

		$prev = $paged - 1;
		$next = $paged + 1;
		$range = 2; // only change it to show more links
		$show_items = ( $range * 2 ) + 1;

		if ( $pages == '' ) {
			global $wp_query;
			$pages = $wp_query->max_num_pages;
			if ( ! $pages ) {
				$pages = 1;
			}
		}

		if ( 1 != $pages ) {
			echo '<nav class="autoroyal-pagination"><ul class="page-numbers">';
			echo ( esc_attr($paged) > 2 && $paged > $range + 1 && $show_items < $pages ) ? "<li><a href='" . get_pagenum_link( 1 ) . "' class='page-numbers'>&laquo; " . esc_html__( 'First', 'autoroyal' ) . "</a></li> " : "";
			echo ( esc_attr($paged) > 1 && $show_items < $pages ) ? "<li><a href='" . get_pagenum_link( $prev ) . "' class='page-numbers' >&laquo; " . esc_html__( 'Previous', 'autoroyal' ) . "</a></li> " : "";

			for ( $i = 1; $i <= $pages; $i++ ) {
				if ( 1 != $pages && ( ! ( $i >= $paged + $range + 1 || $i <= $paged - $range - 1 ) || $pages <= $show_items ) ) {
					echo ( esc_attr($paged) == $i ) ? "<li><a href='" . get_pagenum_link( $i ) . "' class='page-numbers current' >" . $i . "</a></li> " : "<li><a href='" . get_pagenum_link( $i ) . "' class='page-numbers'>" . $i . "</a></li> ";
				}
			}

			echo ( esc_attr($paged) < $pages && $show_items < $pages ) ? "<li><a href='" . get_pagenum_link( $next ) . "' class='page-numbers' >" . esc_html__( 'Next', 'autoroyal' ) . " &raquo;</a></li> " : "";
			echo ( esc_attr($paged) < $pages - 1 && $paged + $range - 1 < $pages && $show_items < $pages ) ? "<li><a href='" . get_pagenum_link( $pages ) . "' class='page-numbers' >" . esc_html__( 'Last', 'autoroyal' ) . " &raquo;</a></li> " : "";
			echo "</ul></nav>";
		}
	}
}


/**
 * Change number of products that are displayed per page (shop page)
 */
add_filter( 'loop_shop_per_page', 'autoroyal_new_loop_shop_per_page', 20 );

function autoroyal_new_loop_shop_per_page( $cols ) {
  	// $cols contains the current number of products per page based on the value stored on Options -> Reading
  	// Return the number of products you wanna show per page.
  	$cols = 6;
  	return $cols;
}

// Change number of columns per row
add_filter('loop_shop_columns', 'autoroyal_change_loop_columns', 999);
add_filter('storefront_loop_columns', 'autoroyal_change_loop_columns', 999);
function autoroyal_change_loop_columns() {
    return 2;
}

// Load Ajax Quick View
require_once( get_template_directory() . '/template-parts/ajax-load-quick-view.php' );

if( !function_exists('autoroyal_get_currency_symbol') ){
	/**
	 * Get Currency symbol.
	 *
	 * @param string $currency (default: '')
	 * @return string
	 */
	function autoroyal_get_currency_symbol( $currency = '' ) {
		if ( ! $currency ) {
			$currency = autoroyal_get_currency();
		}

		$symbols = apply_filters( 'autoroyal_currency_symbols', array(
			'AED' => '&#x62f;.&#x625;',
			'AFN' => '&#x60b;',
			'ALL' => 'L',
			'AMD' => 'AMD',
			'ANG' => '&fnof;',
			'AOA' => 'Kz',
			'ARS' => '&#36;',
			'AUD' => '&#36;',
			'AWG' => '&fnof;',
			'AZN' => 'AZN',
			'BAM' => 'KM',
			'BBD' => '&#36;',
			'BDT' => '&#2547;&nbsp;',
			'BGN' => '&#1083;&#1074;.',
			'BHD' => '.&#x62f;.&#x628;',
			'BIF' => 'Fr',
			'BMD' => '&#36;',
			'BND' => '&#36;',
			'BOB' => 'Bs.',
			'BRL' => '&#82;&#36;',
			'BSD' => '&#36;',
			'BTC' => '&#3647;',
			'BTN' => 'Nu.',
			'BWP' => 'P',
			'BYR' => 'Br',
			'BZD' => '&#36;',
			'CAD' => '&#36;',
			'CDF' => 'Fr',
			'CHF' => '&#67;&#72;&#70;',
			'CLP' => '&#36;',
			'CNY' => '&yen;',
			'COP' => '&#36;',
			'CRC' => '&#x20a1;',
			'CUC' => '&#36;',
			'CUP' => '&#36;',
			'CVE' => '&#36;',
			'CZK' => '&#75;&#269;',
			'DJF' => 'Fr',
			'DKK' => 'DKK',
			'DOP' => 'RD&#36;',
			'DZD' => '&#x62f;.&#x62c;',
			'EGP' => 'EGP',
			'ERN' => 'Nfk',
			'ETB' => 'Br',
			'EUR' => '&euro;',
			'FJD' => '&#36;',
			'FKP' => '&pound;',
			'GBP' => '&pound;',
			'GEL' => '&#x10da;',
			'GGP' => '&pound;',
			'GHS' => '&#x20b5;',
			'GIP' => '&pound;',
			'GMD' => 'D',
			'GNF' => 'Fr',
			'GTQ' => 'Q',
			'GYD' => '&#36;',
			'HKD' => '&#36;',
			'HNL' => 'L',
			'HRK' => 'Kn',
			'HTG' => 'G',
			'HUF' => '&#70;&#116;',
			'IDR' => 'Rp',
			'ILS' => '&#8362;',
			'IMP' => '&pound;',
			'INR' => '&#8377;',
			'IQD' => '&#x639;.&#x62f;',
			'IRR' => '&#xfdfc;',
			'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;',
			'ISK' => 'kr.',
			'JEP' => '&pound;',
			'JMD' => '&#36;',
			'JOD' => '&#x62f;.&#x627;',
			'JPY' => '&yen;',
			'KES' => 'KSh',
			'KGS' => '&#x441;&#x43e;&#x43c;',
			'KHR' => '&#x17db;',
			'KMF' => 'Fr',
			'KPW' => '&#x20a9;',
			'KRW' => '&#8361;',
			'KWD' => '&#x62f;.&#x643;',
			'KYD' => '&#36;',
			'KZT' => 'KZT',
			'LAK' => '&#8365;',
			'LBP' => '&#x644;.&#x644;',
			'LKR' => 'Rs',
			'LRD' => '&#36;',
			'LSL' => 'L',
			'LYD' => '&#x644;.&#x62f;',
			'MAD' => '&#x62f;.&#x645;.',
			'MDL' => 'MDL',
			'MGA' => 'Ar',
			'MKD' => '&#x434;&#x435;&#x43d;',
			'MMK' => 'Ks',
			'MNT' => '&#x20ae;',
			'MOP' => 'P',
			'MRO' => 'UM',
			'MUR' => '&#x20a8;',
			'MVR' => '.&#x783;',
			'MWK' => 'MK',
			'MXN' => '&#36;',
			'MYR' => '&#82;&#77;',
			'MZN' => 'MT',
			'NAD' => '&#36;',
			'NGN' => '&#8358;',
			'NIO' => 'C&#36;',
			'NOK' => '&#107;&#114;',
			'NPR' => '&#8360;',
			'NZD' => '&#36;',
			'OMR' => '&#x631;.&#x639;.',
			'PAB' => 'B/.',
			'PEN' => 'S/.',
			'PGK' => 'K',
			'PHP' => '&#8369;',
			'PKR' => '&#8360;',
			'PLN' => '&#122;&#322;',
			'PRB' => '&#x440;.',
			'PYG' => '&#8370;',
			'QAR' => '&#x631;.&#x642;',
			'RMB' => '&yen;',
			'RON' => 'lei',
			'RSD' => '&#x434;&#x438;&#x43d;.',
			'RUB' => '&#8381;',
			'RWF' => 'Fr',
			'SAR' => '&#x631;.&#x633;',
			'SBD' => '&#36;',
			'SCR' => '&#x20a8;',
			'SDG' => '&#x62c;.&#x633;.',
			'SEK' => '&#107;&#114;',
			'SGD' => '&#36;',
			'SHP' => '&pound;',
			'SLL' => 'Le',
			'SOS' => 'Sh',
			'SRD' => '&#36;',
			'SSP' => '&pound;',
			'STD' => 'Db',
			'SYP' => '&#x644;.&#x633;',
			'SZL' => 'L',
			'THB' => '&#3647;',
			'TJS' => '&#x405;&#x41c;',
			'TMT' => 'm',
			'TND' => '&#x62f;.&#x62a;',
			'TOP' => 'T&#36;',
			'TRY' => '&#8378;',
			'TTD' => '&#36;',
			'TWD' => '&#78;&#84;&#36;',
			'TZS' => 'Sh',
			'UAH' => '&#8372;',
			'UGX' => 'UGX',
			'USD' => '&#36;',
			'UYU' => '&#36;',
			'UZS' => 'UZS',
			'VEF' => 'Bs F',
			'VND' => '&#8363;',
			'VUV' => 'Vt',
			'WST' => 'T',
			'XAF' => 'CFA',
			'XCD' => '&#36;',
			'XOF' => 'Fr',
			'XPF' => 'Fr',
			'YER' => '&#xfdfc;',
			'ZAR' => '&#82;',
			'ZMW' => 'ZK',
		) );

		$currency_symbol = isset( $symbols[ $currency ] ) ? $symbols[ $currency ] : '';

		return apply_filters( 'autoroyal_currency_symbol', $currency_symbol, $currency );
	}

}

/**
 * Get Base Currency Code.
 *
 * @return string
 */
function autoroyal_get_currency() {
	return apply_filters( 'autoroyal_currency', get_option( 'autoroyal_currency' ) );
}


/**
 * Register Backend and Frontend CSS Styles
 */
add_action( 'vc_base_register_front_css', 'autoroyal_vc_iconpicker_base_register_css' );
add_action( 'vc_base_register_admin_css', 'autoroyal_vc_iconpicker_base_register_css' );
function autoroyal_vc_iconpicker_base_register_css(){
    wp_register_style('material', get_stylesheet_directory_uri() . '/assets/css/material-icons.css');
}
/**
 * Enqueue Backend and Frontend CSS Styles
 */
add_action( 'vc_backend_editor_enqueue_js_css', 'autoroyal_vc_iconpicker_editor_jscss' );
add_action( 'vc_frontend_editor_enqueue_js_css', 'autoroyal_vc_iconpicker_editor_jscss' );
function autoroyal_vc_iconpicker_editor_jscss(){
    wp_enqueue_style( 'material' );
}
/**
 * Enqueue CSS in Frontend when it's used
 */
add_action('vc_enqueue_font_icon_element', 'autoroyal_enqueue_font_material');
function autoroyal_enqueue_font_material($font){
    switch ( $font ) {
        case 'material': wp_enqueue_style( 'material' );
    }
}

function autoroyal_mime_types($mimes) {
  	$mimes['svg'] = 'image/svg+xml';
  	return $mimes;
}
add_filter('upload_mimes', 'autoroyal_mime_types');


//
function autoroyal_redirect_cpt_archive() {

    if( is_tax( 'vehicle_body_style' ) ) {
    	$vehicles_search_url = "";
    	$vehicles_search_url = get_option("autoroyal_search_vehicles_page_id");
    	$term_id = get_queried_object()->term_id;
    	if(!empty($vehicles_search_url)) {
    		wp_redirect( get_permalink( $vehicles_search_url ).'?body_style='.$term_id );
    	}
        exit();
    }
}
add_action( 'template_redirect', 'autoroyal_redirect_cpt_archive' );

function autoroyal_author_pre_get( $query ) {
    if ( $query->is_author() && $query->is_main_query() ) :
    	$query->set( 'posts_per_page', 12 );
        $query->set( 'post_type', array('vehicle') );
    endif;
}
add_action( 'pre_get_posts', 'autoroyal_author_pre_get' );

function autoroyal_hex2rgba($color, $opacity = false) {
 
	$default = 'rgb(0,0,0)';
 
	//Return default if no color provided
	if(empty($color))
          return $default; 
 
	//Sanitize $color if "#" is provided 
        if ($color[0] == '#' ) {
        	$color = substr( $color, 1 );
        }
 
        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
                $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
        } elseif ( strlen( $color ) == 3 ) {
                $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
        } else {
                return $default;
        }
 
        //Convert hexadec to rgb
        $rgb =  array_map('hexdec', $hex);
 
        //Check if opacity is set(rgba or rgb)
        if($opacity){
        	if(abs($opacity) > 1)
        		$opacity = 1.0;
        	$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
        } else {
        	$output = 'rgb('.implode(",",$rgb).')';
        }
 
        //Return rgb(a) color string
        return $output;
}

// make sure that we have a valid color hex code.
function autoroyal_sanitize_hex( $color ) {

    $color = ltrim( $color, '#' );

    return preg_match( '/([A-Fa-f0-9]{3}){1,2}$/', $color ) ? $color : '';
}

function autoroyal_get_term_color( $term_id, $hash = false ) {

    $color = get_term_meta( $term_id, 'color', true );
    $color = autoroyal_sanitize_hex( $color );

    return $hash && $color ? "#{$color}" : $color;

}

add_filter( 'save_post', 'update_vehicle_rent_status', 10, 2 );

function update_vehicle_rent_status( $post_id, $post ) {

	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
	    return;
  	}

    // If this is just a revision, don't send the email.
    if ( wp_is_post_revision( $post_id ) )
    return;

    if (!is_object($post) || !isset($post->post_type)) {
        return;
    }

    if( 'vehicle' == $post->post_type ) {

        $vehicle_id = $post_id;

        if($vehicle_id) {

        	$i = 0;

            $price_set = get_post_meta( $vehicle_id, 'vehicle_rent_price_set', true );
            if( isset($price_set) AND !empty($price_set) ) {

            	foreach ($price_set as $vehicle_rent_price_set_item) {
					
					if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

						$i++;

						if( $i == 1 ) {
							update_post_meta($vehicle_id, 'vehicle_rent_price_max', $vehicle_rent_price_set_item['price']);
							update_post_meta($vehicle_id, 'vehicle_rent_period_min', $vehicle_rent_price_set_item['period']);
						}

						update_post_meta($vehicle_id, 'vehicle_rent_price_min', $vehicle_rent_price_set_item['price']);
						update_post_meta($vehicle_id, 'vehicle_rent_period_max', $vehicle_rent_price_set_item['period']);

					}

				}

				update_post_meta($vehicle_id, 'vehicle_for_rent', 1);
			} else {
				$price_set = "";
				delete_post_meta($vehicle_id, 'vehicle_for_rent', 1);
			}

        }

    }

}
