<?php

$postID = get_the_ID();
$page_title_block = get_post_meta( $postID , 'page_title' , true );

get_header(); ?>

    <?php if ( have_posts() ) : ?>

    <div class="autoroyal-front-dashboard">

        <div id="primary" class="content-area">

            <main id="main" class="site-main">

                <?php 

                    if($page_title_block != 2) { 

                ?>

                <div class="autoroyal-page-title">

                    <div class="container">

                        <h2><?php the_archive_title(); ?></h2>

                        <div class="breadcrumbs">
    
                            <?php the_archive_description(); ?>

                        </div>
                        
                    </div>

                </div>

                <?php } ?>

                <div class="container">

                    <div class="row">

                        <div class="autoroyal-full-width-page col-md-12">

                            <div class="row justify-content-center">
                                
                                <?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
                                <div class="col-md-4 fantasy-themes-sidebar-width">
                                    <?php get_sidebar(); ?>
                                </div>
                                <?php endif; ?>

                                <div class="col-md-8 fantasy-themes-content-width">

                                    <?php

                                        /* Start the Loop */
                                        while ( have_posts() ) : the_post();

                                            // Include the Post-Format-specific template for the content.
                                            ?>

                                            <article id="post-<?php the_ID(); ?>" <?php post_class( 'card mt-3r' ); ?>>

                                                <div class="card-body">

                                                    <?php if ( is_sticky() ) : ?>
                                                        <span class="fa fa-bookmark fantasy-themes-sticky" title="<?php echo esc_attr__( 'Sticky Post', 'autoroyal' ); ?>"></span>
                                                    <?php endif; ?>

                                                    <header class="entry-header">

                                                        <span class="cat-links">
                                                            <span class="ar-badge"><?php the_category( '</span> <span class="ar-badge">' ); ?></span>
                                                        </span>
                                                        <?php the_title( '<h2 class="entry-title card-title h3"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>

                                                    </header><!-- .entry-header -->

                                                    <?php autoroyal_post_thumbnail(); ?>
                                                    <div class="entry-summary">
                                                        <?php the_excerpt(); ?>
                                                    </div><!-- .entry-summary -->

                                                    <div class="entry-meta text-muted">

                                                        <?php autoroyal_posted_on(); ?>

                                                        <span class="post-meta-comm float-right">
                                                            <a href="<?php comments_link(); ?>"><i class="fas fa-comment"></i> <?php $my_comments = get_comments_number( $post->ID ); echo esc_attr( $my_comments ); ?></a>
                                                        </span>

                                                    </div><!-- .entry-meta -->

                                                </div>
                                                <!-- /.card-body -->

                                            </article><!-- #post-<?php the_ID(); ?> -->

                                            <?php

                                        endwhile;

                                        the_posts_navigation( array(
                                            'next_text' => esc_html__( 'Newer Posts', 'autoroyal' ),
                                            'prev_text' => esc_html__( 'Older Posts', 'autoroyal' ),
                                        ) );

                                        if (  !have_posts() ) {
                                            get_template_part( 'template-parts/content', 'none' );
                                        }

                                    ?>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </main><!-- #main -->

        </div><!-- #primary -->

    </div>

    <?php endif; ?>

<?php
get_footer();
