<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;

get_header( 'shop' );

?>

    <div class="autoroyal-front-dashboard">

        <div id="primary" class="content-area">

            <main id="main" class="site-main">

                <div class="autoroyal-page-title">

                    <div class="container">

                        <h2><?php woocommerce_page_title(); ?></h2>
                        
                    </div>

                </div>

                <div class="container">

                    <div class="row">

                        <div class="autoroyal-full-width-page col-md-12 autoroyal-woocommerce-page">

                            <div class="row justify-content-center">
                                
                                
                                <?php if ( is_active_sidebar( 'shop' ) ) : ?>
                                    <div class="col-md-4 fantasy-themes-sidebar-width">
                                        <aside class="widget-area sidebar-1-area shop-area mb-2 card">
                                            <?php dynamic_sidebar( 'shop' ); ?>
                                        </aside>
                                    </div>
                                <?php endif; ?>

                                <div class="col-md-8 fantasy-themes-content-width">

                                    <?php
                                        if ( woocommerce_product_loop() ) {

                                            /**
                                             * Hook: woocommerce_before_shop_loop.
                                             *
                                             * @hooked wc_print_notices - 10
                                             * @hooked woocommerce_result_count - 20
                                             * @hooked woocommerce_catalog_ordering - 30
                                             */
                                            do_action( 'woocommerce_before_shop_loop' );

                                            woocommerce_product_loop_start();

                                            if ( wc_get_loop_prop( 'total' ) ) {
                                                while ( have_posts() ) {
                                                    the_post();

                                                    /**
                                                     * Hook: woocommerce_shop_loop.
                                                     *
                                                     * @hooked WC_Structured_Data::generate_product_data() - 10
                                                     */
                                                    do_action( 'woocommerce_shop_loop' );

                                                    wc_get_template_part( 'content', 'product' );
                                                }
                                            }

                                            woocommerce_product_loop_end();

                                            /**
                                             * Hook: woocommerce_after_shop_loop.
                                             *
                                             * @hooked woocommerce_pagination - 10
                                             */
                                            do_action( 'woocommerce_after_shop_loop' );
                                        } else {
                                            /**
                                             * Hook: woocommerce_no_products_found.
                                             *
                                             * @hooked wc_no_products_found - 10
                                             */
                                            do_action( 'woocommerce_no_products_found' );
                                        } 

                                        ?>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </main><!-- #main -->

        </div><!-- #primary -->

    </div>

<?php
get_footer();
