<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package fantasy_themes
 */

get_header(); ?>

	<div class="container">
		
		<div class="row justify-content-center">

			<div class="col-md-8 fantasy-themes-content-width">

				<div id="primary" class="content-area">

					<main id="main" class="site-main">

					<?php
					if ( have_posts() ) :

						if ( is_home() && ! is_front_page() ) : ?>
							<header>
								<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
							</header>

						<?php
						endif;

						/* Start the Loop */
						while ( have_posts() ) : the_post();

							?>

							<article id="post-<?php the_ID(); ?>" <?php post_class( 'card mt-3r' ); ?>>

								<div class="card-body">

									<?php if ( is_sticky() ) : ?>
										<span class="fa fa-bookmark fantasy-themes-sticky" title="<?php echo esc_attr__( 'Sticky Post', 'autoroyal' ); ?>"></span>
									<?php endif; ?>

									<header class="entry-header">

										<span class="cat-links">
											<span class="ar-badge"><?php the_category( '</span> <span class="ar-badge">' ); ?></span>
										</span>
										<?php the_title( '<h2 class="entry-title card-title h3"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>

									</header><!-- .entry-header -->

									<?php autoroyal_post_thumbnail(); ?>
									<div class="entry-summary">
										<?php the_excerpt(); ?>
									</div><!-- .entry-summary -->

									<div class="entry-meta text-muted">

										<?php autoroyal_posted_on(); ?>

										<span class="post-meta-comm float-right">
											<a href="<?php comments_link(); ?>"><i class="fas fa-comment"></i> <?php $my_comments = get_comments_number( $post->ID ); echo esc_attr( $my_comments ); ?></a>
										</span>

									</div><!-- .entry-meta -->

								</div>
								<!-- /.card-body -->

							</article><!-- #post-<?php the_ID(); ?> -->

							<?php

						endwhile;

						the_posts_navigation( array(
							'next_text' => esc_html__( 'Newer Posts', 'autoroyal' ),
							'prev_text' => esc_html__( 'Older Posts', 'autoroyal' ),
						) );

					else :

						get_template_part( 'template-parts/content', 'none' );

					endif; ?>

					</main><!-- #main -->

				</div><!-- #primary -->

			</div>
			<!-- /.col-md-8 -->
			<?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
			<div class="col-md-4 fantasy-themes-sidebar-width">
				<?php get_sidebar(); ?>
			</div>
			<?php endif; ?>

		</div>
		<!-- /.row -->
	</div>
	<!-- /.container -->

<?php
get_footer();
