<?php
/**
* Contains methods for customizing the theme customization screen.
* @since autoroyal v.1.0
*/
function autoroyal_defaults()
{
    return array(
        "logo" => get_template_directory_uri() . '/assets/images/logo.svg',
        "logo_white" => '',
        "vehicles_search_url" => '',
        "footer_layout" => "version_1",
        "estate_page_title_bg" => get_template_directory_uri() . '/images/estate.jpg',
        "estate_decimals" => 2,
        "estate_dec_point" => ".",
        "estate_thousands_sep" => ",",
        "estate_currency_position" => "before",
        "estate_submit_listing" => "anyone",
        "number_of_properties" => 6,
        "search_page_title_bg" => get_template_directory_uri() . '/images/search.jpg',
        "blog_page_title_bg" => get_template_directory_uri() . '/images/blog.jpg',
        "shop_page_title_bg" => get_template_directory_uri() . '/images/shop.jpg',

        "footer_copyright_text" => "Proudly powered by <a href='https://wordpress.org/'>WordPress</a> and <a href='http://themeforest.net/user/fantasythemes/portfolio?ref=fantasythemes'>autoRoyal</a> by <a href='http://themeforest.net/user/fantasythemes/portfolio?ref=fantasythemes'>FantasyThemes</a>",

        "show_hide_top_bar" => false,
        "show_fav_in_top_bar" => "no",
        "header_address" => "1771 Market St, San Francisco, CA 94103",
        "header_working_hours" => "Mon - Sat: 8:00am - 6:00pm",
        "header_phone_number" => "888-777-1234",

        "footer_stats_1_value" => "",
        "footer_stats_1_label" => "",
        "footer_stats_1_icon" => "",

        "footer_stats_2_value" => "",
        "footer_stats_2_label" => "",
        "footer_stats_2_icon" => "",

        "footer_stats_3_value" => "",
        "footer_stats_3_label" => "",
        "footer_stats_3_icon" => "",

        "color_version" => "default",
        "main_color" => "#0C3EB8",
        "main_hover_color" => "#0C3A96",

        "button_bg_color" => "#2c425d",
        "button_text_color" => "#f0f7ff",
        "button_hover_bg_color" => "#f0f7ff",
        "button_hover_text_color" => "#2c425d",

        "second_color" => "#dc3545",
        "second_hover_color" => "#aa0020",

        "select_text" => "#0C3EB8",
        "select_bg" => "#e6ecf7",
        
        "autoroyal_account_funds_min_topup" => "",
        "autoroyal_account_funds_max_topup" => "",
        "autoroyal_submit_listing_price" => "",
        "autoroyal_promoted_listing_price" => "",
        "autoroyal_featured_listing_price" => "",
        "contact_email" => "",
        "contact_thankyou_message" => "Thank you! We will get back to you as soon as possible.",
        "contact_latitude" => "47.02552795015715",
        "contact_longitude" => "28.830285722137432",
        "contact_zoom" => "16",
        "map_pin" => get_template_directory_uri() . '/images/map-pin.png',
        "buy_button_link" => "",
        "envato_label" => get_template_directory_uri() . '/images/envato-label.png',
        "buy_button_icon" => get_template_directory_uri() . '/images/buy-now-logo.png',

        "pending_review_page" => "",
        "submit_listing_page" => "",
        "submit_listing_unreg_users_page" => "",
        "my_listings_page" => "",
        "my_favorites_page" => "",
        "account_funds_page" => "",
        "account_settings" => "",
        "notifications_page" => "",
        "notifications_subscribers" => "",
        "my_advertised_listings_page" => "",
        "autoroyal_monetization_status" => "",
        "autoroyal_monetization_pending" => "",
        "reports_page" => "",
        "leads_page" => '',
        "deals_page" => '',
        "upcoming_payments_page" => '',

        ""=>"",
    );
    // $autoroyal_defaults['blog_page_header_lines']
}
class autoroyal_Customize {

    public static function register ( $wp_customize ) {

    	$autoroyal_defaults = autoroyal_defaults();

        $wp_customize->remove_section("colors");
        $wp_customize->remove_section("background_image");

        // autoRoyal: Styling Settings
        require_once( get_template_directory() . '/inc/customizer/td-customizer-styling.php' );
        //

        // autoRoyal: Site Settings
        //require_once( get_template_directory() . '/inc/customizer/td-customizer-settings.php' );
        //

        // autoRoyal: Logo
        require_once( get_template_directory() . '/inc/customizer/td-customizer-header.php' );
        //

        // autoRoyal: Footer
        require_once( get_template_directory() . '/inc/customizer/td-customizer-footer.php' );
        //

    }

    public static function live_preview() {
        wp_enqueue_script('autoroyal-customizer',    get_template_directory_uri().'/assets/js/customizer.js',array( 'jquery','customize-preview' ),false,true);
    }

}

add_action( 'customize_register', array( 'autoroyal_customize' , 'register' ));
add_action( 'customize_preview_init', array( 'autoroyal_customize' , 'live_preview' ));
add_action( 'customize_controls_enqueue_scripts', array( 'autoroyal_customize' , 'live_preview' ) );

?>