<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$currency_pos = get_option( 'autoroyal_currency_position' );

	$show_filter = 1;

	$posts_per_page = -1;

	// Rent
	$rent_pickup_place = "";
	if ( isset( $_GET['rezerve-pickup-place-filter'] ) AND !empty($_GET['rezerve-pickup-place-filter']) ) {
        $rent_pickup_place = $_GET['rezerve-pickup-place-filter'];
    }

    $rent_drop_place = "";
	if ( isset( $_GET['rezerve-drop-place-filter'] ) AND !empty($_GET['rezerve-drop-place-filter']) ) {
        $rent_drop_place = $_GET['rezerve-drop-place-filter'];
    }

    $rent_pickup_date = "";
	if ( isset( $_GET['rezerve-pickup-date'] ) AND !empty($_GET['rezerve-pickup-date']) ) {
        $rent_pickup_date = $_GET['rezerve-pickup-date'];
    }

    $rent_pickup_time = "";
	if ( isset( $_GET['rezerve-pickup-time'] ) AND !empty($_GET['rezerve-pickup-time']) ) {
        $rent_pickup_time = $_GET['rezerve-pickup-time'];
    }

    $rent_drop_date = "";
	if ( isset( $_GET['rezerve-drop-date'] ) AND !empty($_GET['rezerve-drop-date']) ) {
        $rent_drop_date = $_GET['rezerve-drop-date'];
    }

    $rent_drop_time = "";
	if ( isset( $_GET['rezerve-drop-time'] ) AND !empty($_GET['rezerve-drop-time']) ) {
        $rent_drop_time = $_GET['rezerve-drop-time'];
    }
	//

	$orderby = "default";
	if ( isset( $_GET['orderby'] ) AND !empty($_GET['orderby']) ) {
        $orderby = $_GET['orderby'];
    }

	if( !empty($show) ) {
		$posts_per_page = $show;
	}

	$view_type = "list";
	if ( isset( $_GET['view_type'] ) AND !empty($_GET['view_type']) ) {
        $view_type = $_GET['view_type'];
    } else if ( ! empty( $_COOKIE['autoroyal_view_type'] ) ) {
		$view_type = $_COOKIE['autoroyal_view_type'];
    }

    $post_status = array( 'publish' );

    if ( is_home() || is_front_page() ) {
   		$paged = get_query_var( 'page' ) ? get_query_var( 'page' ) : 1;
   	} else {
   		$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
   	}
    
    $search_args = apply_filters( 'autoroyal_get_inventory_rent_cars_args', array(
        'post_type'           => 'vehicle',
        'post_status'         => 'publish',
        'posts_per_page'      => -1,
        'offset'              => ( max( 1, $paged ) - 1 ) * $posts_per_page,
        'orderby'             => 'date', 
        'order'               => 'DESC',
        'ignore_sticky_posts' => 1,
        'meta_key'            => 'vehicle_for_rent',
        'meta_query' => array(
            'relation' => 'AND',
            array(
                'key'     => '_sold',
                'value'   => 0
            )
        )
    ));

	$search_args = apply_filters( 'autoroyal_search_filter_parameters', $search_args );
	$cars_query  = new WP_Query;
	$cars        = $cars_query->query( $search_args );
	$total       = $cars_query->found_posts;

	$max_num_pages = $cars_query->max_num_pages;

	wp_enqueue_script( 'bootstrap-select' );

	// Extract shortcode atts
	//print_r($args['filter']);

	$uniqid = uniqid();

?>

<div class="autoroyal-horizontal-filter-wrapper autoroyal-inventory-flash-filter"><?php if( $show_filter == 1 AND $args['filter'] == 'horizontal' ) { $shortcode_filter = 0; autoroyal_horizontal_search_filter( $shortcode_filter ); } ?></div>

<div id="autoroyal-inventory" class="animated-car-blocks <?php if( $args['filter'] == 'horizontal' ) { ?>autoroyal-inventory-horizontal<?php } ?> autoroyal-inventory-flash">

	<div class="row">

		<?php if( $show_filter == 1 ) { if ( $args['filter'] == 'vertical_left' OR $args['filter'] == 'vertical_right' ) { ?>

		<div class="col-lg-3 col-md-4 col-sm-6 <?php if( $args['filter'] == 'vertical_right' ) { echo "order-2"; } ?>">

			<?php $shortcode_filter = 0; autoroyal_vertical_search_filter_rent( $shortcode_filter ); ?>

		</div>

		<div class="col-lg-9 col-md-8 col-sm-6"> 

			<div class="row">

		<?php } } ?>

		<div class="col-md-12">

			<div id="autoroyal-listing-sort" class="autoroyal-listing-sort">

				<div class="autoroyal-rent-booking-dates">

					<?php if( !empty($rent_pickup_date) ) { ?>
					<input type="hidden" id="rent_pickup_date" value="<?php echo esc_attr($rent_pickup_date); ?>">
					<?php } ?>
					<?php if( !empty($rent_pickup_time) ) { ?>
					<input type="hidden" id="rent_pickup_time" value="<?php echo esc_attr($rent_pickup_time); ?>">
					<?php } ?>
					<?php if( !empty($rent_drop_date) ) { ?>
					<input type="hidden" id="rent_drop_date" value="<?php echo esc_attr($rent_drop_date); ?>">
					<?php } ?>
					<?php if( !empty($rent_drop_time) ) { ?>
					<input type="hidden" id="rent_drop_time" value="<?php echo esc_attr($rent_drop_time); ?>">
					<?php } ?>

					<div class="row">

						<div class="col-md-3">
							
							<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 408 408" style="enable-background:new 0 0 408 408;" xml:space="preserve"><polygon points="204,0 168.3,35.7 311.1,178.5 0,178.5 0,229.5 311.1,229.5 168.3,372.3 204,408 408,204"/></svg>
							<div class="autoroyal-rent-booking-dates-pickup-location"><?php if( !empty($rent_pickup_place) ) { echo esc_attr($rent_pickup_place); } else { esc_html_e( 'Pickup location', 'autoroyal' ); } ?></div>
							<div class="autoroyal-rent-booking-dates-pickup-date">
								<span class="date"></span>
								<span class="time"></span>
							</div>

						</div>

						<div class="col-md-3">

							<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 408 408" style="enable-background:new 0 0 408 408;" xml:space="preserve"><polygon points="204,0 168.3,35.7 311.1,178.5 0,178.5 0,229.5 311.1,229.5 168.3,372.3 204,408 408,204"/></svg>
							<div class="autoroyal-rent-booking-dates-return-location"><?php if(!empty($rent_drop_place)) { echo esc_attr($rent_drop_place); } else { esc_html_e( 'Return location', 'autoroyal' ); } ?></div>
							<div class="autoroyal-rent-booking-dates-return-date">
								<span class="date"></span>
								<span class="time"></span>
							</div>

						</div>

						<div class="col-md-3">

							<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="485.213px" height="485.212px" viewBox="0 0 485.213 485.212" style="enable-background:new 0 0 485.213 485.212;" xml:space="preserve"><path d="M60.652,75.816V15.163C60.652,6.781,67.433,0,75.817,0c8.38,0,15.161,6.781,15.161,15.163v60.653
		c0,8.38-6.781,15.161-15.161,15.161C67.433,90.978,60.652,84.196,60.652,75.816z M318.424,90.978
		c8.378,0,15.163-6.781,15.163-15.161V15.163C333.587,6.781,326.802,0,318.424,0c-8.382,0-15.168,6.781-15.168,15.163v60.653
		C303.256,84.196,310.042,90.978,318.424,90.978z M485.212,363.906c0,66.996-54.312,121.307-121.303,121.307
		c-66.986,0-121.302-54.311-121.302-121.307c0-66.986,54.315-121.3,121.302-121.3C430.9,242.606,485.212,296.919,485.212,363.906z
		 M454.89,363.906c0-50.161-40.81-90.976-90.98-90.976c-50.166,0-90.976,40.814-90.976,90.976c0,50.171,40.81,90.98,90.976,90.98
		C414.08,454.886,454.89,414.077,454.89,363.906z M121.305,181.955H60.652v60.651h60.653V181.955z M60.652,333.584h60.653V272.93
		H60.652V333.584z M151.629,242.606h60.654v-60.651h-60.654V242.606z M151.629,333.584h60.654V272.93h-60.654V333.584z
		 M30.328,360.891V151.628h333.582v60.653h30.327V94c0-18.421-14.692-33.349-32.843-33.349h-12.647v15.166
		c0,16.701-13.596,30.325-30.322,30.325c-16.731,0-30.326-13.624-30.326-30.325V60.651H106.14v15.166
		c0,16.701-13.593,30.325-30.322,30.325c-16.733,0-30.327-13.624-30.327-30.325V60.651H32.859C14.707,60.651,0.001,75.579,0.001,94
		v266.892c0,18.36,14.706,33.346,32.858,33.346h179.424v-30.331H32.859C31.485,363.906,30.328,362.487,30.328,360.891z
		 M303.256,242.606v-60.651h-60.648v60.651H303.256z M409.399,363.906h-45.49v-45.49c0-8.377-6.781-15.158-15.163-15.158
		s-15.159,6.781-15.159,15.158v60.658c0,8.378,6.777,15.163,15.159,15.163h60.653c8.382,0,15.163-6.785,15.163-15.163
		C424.562,370.692,417.781,363.906,409.399,363.906z"/></svg>
							<div class="autoroyal-rent-booking-dates-rental-period-label"><?php esc_html_e( 'Rental period', 'autoroyal' ); ?></div>
							<div class="autoroyal-rent-booking-dates-rental-period">
								<span class="date"></span>
								<span class="time"><?php esc_html_e( 'Days', 'autoroyal' ); ?></span>
							</div>

						</div>

						<div class="col-md-3">
							<a href="#" class="autoroyal-change-rent-booking-dates"><?php esc_html_e( 'Change Booking Dates', 'autoroyal' ); ?><i class="fa fa-angle-down" aria-hidden="true"></i></a>
						</div>

					</div>

					<div class="autoroyal-rent-booking-dates-update">

                        <div class="row">

                            <div class="col-md-4">

                            	<div class="form-group"> 

									<label><?php esc_html_e('Pick-up location', 'autoroyal'); ?> </label>
			                    	<select id="rezerve-pickup-place-filter" name="rezerve-pickup-place-filter" class="chosen-select" title="<?php esc_attr_e('Select location', 'autoroyal' ); ?>" autocomplete="off">
				                      	<option value="0"><?php esc_html_e('Select location', 'autoroyal'); ?></option>
				                      	<?php

				                      		$categories = get_categories( array('taxonomy' => 'vehicle_rent_pickup', 'hide_empty' => false,  'parent' => 0) );
											foreach ($categories as $category) {

										?>
										<option value="<?php echo esc_attr($category->cat_name); ?>" <?php if( $rent_pickup_place == $category->cat_name ) { echo "selected"; } ?>><?php echo esc_attr($category->cat_name); ?></option>
										<?php } ?>
			                    	</select>

								</div>

                            </div>

                            <div class="col-md-4">

                            	<div class="form-group"> 
						
									<label><?php esc_html_e('Pick-up date', 'autoroyal'); ?> </label>
									<div class="form-group input-append">
				                      	<input type="text" name="rezerve-pickup-date" placeholder="<?php esc_attr_e('Choose a date', 'autoroyal'); ?>" class="daySelect" id="curentDay-filter" autocomplete="off">
				                    </div>

								</div> 

                            </div>

                            <div class="col-md-4">

                            	<div class="form-group"> 

									<label><?php esc_html_e('Pick-up time', 'autoroyal'); ?> </label>
									<div class="form-group input-append timepick">
				                      	<input type="text" name="rezerve-pickup-time" placeholder="12:00 AM" id="curentHour-filter" autocomplete="off">
				                    </div>

								</div>

                            </div>

                        </div>

                        <div class="row">

                            <div class="col-md-4">

                            	<div class="form-group"> 

									<label><?php esc_html_e('Return location', 'autoroyal'); ?> </label>
			                    	<select id="rezerve-drop-place-filter" name="rezerve-drop-place-filter" class="chosen-select" title="<?php esc_attr_e('Select location', 'autoroyal' ); ?>" autocomplete="off">
				                      	<option value="0"><?php esc_html_e('Select location', 'autoroyal'); ?></option>
				                      	<?php

				                      		$categories = get_categories( array('taxonomy' => 'vehicle_rent_pickup', 'hide_empty' => false,  'parent' => 0) );
											foreach ($categories as $category) {

										?>
										<option value="<?php echo esc_attr($category->cat_name); ?>" <?php if( $rent_drop_place == $category->cat_name ) { echo "selected"; } ?>><?php echo esc_attr($category->cat_name); ?></option>
										<?php } ?>
			                    	</select>

								</div>

                            </div>

                            <div class="col-md-4">

                            	<div class="form-group"> 
						
									<label><?php esc_html_e('Return date', 'autoroyal'); ?> </label>
									<div class="form-group input-append">
				                      	<input type="text" name="rezerve-drop-date" placeholder="<?php esc_attr_e('Choose a date', 'autoroyal'); ?>" class="daySelect" id="dropDay-filter" autocomplete="off">
				                    </div>

								</div>

                            </div>

                            <div class="col-md-4">

                            	<div class="form-group"> 

									<label><?php esc_html_e('Return time', 'autoroyal'); ?> </label>
									<div class="form-group input-append timepick">
				                      	<input type="text" name="rezerve-drop-time" placeholder="12:00 AM" id="dropHour-filter" autocomplete="off">
				                    </div>

								</div>

                            </div>

                        </div>

                    </div>

				</div>

				<div class="autoroyal-listing-sort-item-result">

					<strong><?php echo autoroyal_search_filter_total_rent(); ?></strong> <?php esc_html_e( 'Offers found', 'autoroyal' ); ?>

				</div>

				<div class="autoroyal-listing-sort-item">

					<span>

						<div class="title"><?php esc_html_e('Sort', 'autoroyal' ); ?></div>

						<select id="orderby" name="orderby" class="input-sm input-xsmall input-inline autoroyal-inventory-select-order chosen-select">
							<option value="default" <?php if( $orderby == 'default' ) { echo "selected"; } ?>><?php esc_html_e('Default Sorting', 'autoroyal' ); ?></option>
							<option value="price_asc" <?php if( $orderby == 'price_asc' ) { echo "selected"; } ?>><?php esc_html_e('Price &uarr;', 'autoroyal' ); ?></option>
							<option value="price_desc" <?php if( $orderby == 'price_desc' ) { echo "selected"; } ?>><?php esc_html_e('Price &darr;', 'autoroyal' ); ?></option>
							<option value="mileage_asc" <?php if( $orderby == 'mileage_asc' ) { echo "selected"; } ?>><?php esc_html_e('Mileage &uarr;', 'autoroyal' ); ?></option>
							<option value="mileage_desc" <?php if( $orderby == 'mileage_desc' ) { echo "selected"; } ?>><?php esc_html_e('Mileage &darr;', 'autoroyal' ); ?></option>
							<option value="year_asc" <?php if( $orderby == 'year_asc' ) { echo "selected"; } ?>><?php esc_html_e('Year &uarr;', 'autoroyal' ); ?></option>
							<option value="year_desc" <?php if( $orderby == 'year_desc' ) { echo "selected"; } ?>><?php esc_html_e('Year &darr;', 'autoroyal' ); ?></option>
							<option value="make_asc" <?php if( $orderby == 'make_asc' ) { echo "selected"; } ?>><?php esc_html_e('Make &uarr;', 'autoroyal' ); ?></option>
							<option value="make_desc" <?php if( $orderby == 'make_desc' ) { echo "selected"; } ?>><?php esc_html_e('Make &darr;', 'autoroyal' ); ?></option>
							<option value="model_asc" <?php if( $orderby == 'model_asc' ) { echo "selected"; } ?>><?php esc_html_e('Model &uarr;', 'autoroyal' ); ?></option>
							<option value="model_desc" <?php if( $orderby == 'model_desc' ) { echo "selected"; } ?>><?php esc_html_e('Model &darr;', 'autoroyal' ); ?></option>
						</select>

					</span>

				</div>

				<div class="autoroyal-listing-sort-item autoroyal-listing-view-type">

			        <a class="grid <?php if($view_type == "grid") { ?>active<?php } ?>" href="#">
				        <i class="fa fa-th" aria-hidden="true"></i>
				    </a>

				    <a class="list <?php if($view_type == "list") { ?>active<?php } ?>" href="#">
				        <i class="fa fa-th-list" aria-hidden="true"></i>
				    </a>

				</div>

			</div>
			
		</div>

		<div id="inventory-vehicles-holder" class="col-md-12 autoroyal-vehicles-for-rent inventory-vehicles-holder autoroyal-invetory-<?php if($view_type == "grid") { ?>grid<?php } else { ?>list<?php } ?>-view">

			<div id="isotope-container" class="row">

				<?php 

					if ( ! $cars ) : 

				?>
					<div class="col-md-12">
						<h4><?php esc_html_e( 'No listings were found matching your search criteria.', 'autoroyal' ); ?></h4>
					</div>
				<?php else : ?>
					<?php foreach ( $cars as $car ) : ?>

						<?php 

							$car_ID = $car->ID; 

		                    $vehicle_year = esc_attr(get_post_meta($car_ID, 'vehicle_year',true));
		                    $vehicle_make = esc_attr(get_post_meta($car_ID, 'vehicle_make',true));
		                    $vehicle_model = esc_attr(get_post_meta($car_ID, 'vehicle_model',true));
		                    $vehicle_trim_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_trim_desc_init',true));
		                    $vehicle_make_desc_init = esc_attr(get_post_meta($car_ID, 'vehicle_make_desc_init',true));
		                    $vehicle_stock = esc_attr(get_post_meta($car_ID, 'vehicle_stock',true));
		                    $vehicle_vin = esc_attr(get_post_meta($car_ID, 'vehicle_vin',true));

		                    $vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
		                    if(!empty($vehicle_exterior_color)) {
		                        $color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
		                        $color_id   = $vehicle_exterior_color[0]->term_id;
		                        $color_name = $vehicle_exterior_color[0]->name;
		                    } else {
		                        $color_name = "";
		                        $color_id   = "";
		                    }

		                    $vehicle_mileage = esc_attr(get_post_meta($car_ID, 'vehicle_mileage',true));

		                    $vehicle_cost = esc_attr(get_post_meta($car_ID, 'vehicle_cost',true));
		                    $vehicle_retail_price = esc_attr(get_post_meta($car_ID, 'vehicle_retail_price',true));
		                    $vehicle_discounted_price = esc_attr(get_post_meta($car_ID, 'vehicle_discounted_price',true));
		                    $price = esc_attr(get_post_meta($car_ID, 'vehicle_price',true));

		                    $vehicle_image_gallery = get_post_meta($car_ID, 'vehicle_image_gallery',true);
		                    $vehicle_image_extended_gallery = get_post_meta($car_ID, 'vehicle_image_extended_gallery',true);
		                    $vehicle_image_url = "";

		                    if(!empty($vehicle_image_gallery[0]['url'])) {

		                        $vehicle_image_url = $vehicle_image_gallery[0]['url'];

		                    } elseif(!empty($vehicle_image_extended_gallery[0]['url'])) {

		                        $vehicle_image_url = $vehicle_image_extended_gallery[0]['url'];

		                    }

		                    $vehicle_cover_image = get_post_meta($car_ID, 'vehicle_cover_image',true);
		                    if(!empty($vehicle_cover_image)) {
		                        $vehicle_image_url = $vehicle_cover_image;
		                    }

		                    $vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));
		                    $vehicle_power_hp = esc_attr(get_post_meta($car_ID, 'vehicle_power_hp',true));

		                    $vehicle_drive = get_the_terms($car_ID, 'vehicle_drive' );
		                    $terms_vehicle_drive = $vehicle_drive[0]->name;

		                    // Cars meta
		                    $vehicle_consumption_urban = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_urban',true));
		                    $vehicle_consumption_highway = esc_attr(get_post_meta($car_ID, 'vehicle_consumption_highway',true));

		                    $terms_vehicle_fuel_type = "";
		                    $terms_vehicle_fuel_type_id = "";
		                    $vehicle_fuel_type = get_the_terms($car_ID, 'vehicle_fuel_type' );
		                    if ($vehicle_fuel_type && ! is_wp_error($vehicle_fuel_type)) :
		                        $terms_vehicle_fuel_type = $vehicle_fuel_type[0]->name;
		                        $terms_vehicle_fuel_type_id = $vehicle_fuel_type[0]->term_id;
		                    endif;

		                    $terms_vehicle_transmission = "";
		                    $terms_vehicle_transmission_id = "";
		                    $vehicle_transmission = get_the_terms($car_ID, 'vehicle_transmission' );
		                    if ($vehicle_transmission && ! is_wp_error($vehicle_transmission)) :
		                        $terms_vehicle_transmission = $vehicle_transmission[0]->name;
		                        $terms_vehicle_transmission_id = $vehicle_transmission[0]->term_id;
		                    endif;

		                    $vehicle_name = $vehicle_year . " " . $vehicle_make . " " . $vehicle_model;

		                    $vehicle_condition = esc_attr(get_post_meta($car_ID, 'vehicle_condition',true));

		                    //
		                    $terms_vehicle_body_style = "";
		                    $terms_vehicle_body_style_name = "";
		                    $vehicle_body_style = get_the_terms($car_ID, 'vehicle_body_style' );
		                    if ($vehicle_body_style && ! is_wp_error($vehicle_body_style)) :
		                        $terms_vehicle_body_style = $vehicle_body_style[0]->term_id;
		                        $terms_vehicle_body_style_name = $vehicle_body_style[0]->name;
		                    endif;

                            //
                            $terms_vehicle_doors = "";
                            $terms_vehicle_doors_name = "";
                            $vehicle_vehicle_doors = get_the_terms($car_ID, 'vehicle_doors' );
                            if ($vehicle_vehicle_doors && ! is_wp_error($vehicle_vehicle_doors)) :
                                $terms_vehicle_doors = $vehicle_vehicle_doors[0]->term_id;
                                $terms_vehicle_doors_name = $vehicle_vehicle_doors[0]->name;
                            endif;

                            //
                            $terms_vehicle_seats = "";
                            $terms_vehicle_seats_name = "";
                            $vehicle_vehicle_seats = get_the_terms($car_ID, 'vehicle_seats' );
                            if ($vehicle_vehicle_seats && ! is_wp_error($vehicle_vehicle_seats)) :
                                $terms_vehicle_seats = $vehicle_vehicle_seats[0]->term_id;
                                $terms_vehicle_seats_name = $vehicle_vehicle_seats[0]->name;
                            endif;

                            //
                            $terms_vehicle_rent_age = "";
                            $terms_vehicle_rent_age_name = "";
                            $vehicle_vehicle_rent_age = get_the_terms($car_ID, 'vehicle_rent_age' );
                            if ($vehicle_vehicle_rent_age && ! is_wp_error($vehicle_vehicle_rent_age)) :
                                $terms_vehicle_rent_age = $vehicle_vehicle_rent_age[0]->term_id;
                                $terms_vehicle_rent_age_name = $vehicle_vehicle_rent_age[0]->name;
                            endif;

                            //
                            $terms_vehicle_luggages = "";
                            $terms_vehicle_luggages_name = "";
                            $vehicle_vehicle_luggages = get_the_terms($car_ID, 'vehicle_luggages' );
                            if ($vehicle_vehicle_luggages && ! is_wp_error($vehicle_vehicle_luggages)) :
                                $terms_vehicle_luggages = $vehicle_vehicle_luggages[0]->term_id;
                                $terms_vehicle_luggages_name = $vehicle_vehicle_luggages[0]->name;
                            endif;

		                    $total_photos = autoroyal_count_photos( $car_ID );

		                    //
		                    $vehicle_exterior_color = get_the_terms($car_ID, 'vehicle_exterior_color' );
		                    if(!empty($vehicle_exterior_color)) {
		                        $color      = autoroyal_get_term_color( $vehicle_exterior_color[0]->term_id, true );
		                        $color_id   = $vehicle_exterior_color[0]->term_id;
		                        $color_name = $vehicle_exterior_color[0]->name;
		                        $color_type = get_term_meta( $vehicle_exterior_color[0]->term_id, 'color_type', true );
		                    } else {
		                        $color_type = "";
		                    }

		                    $vehicle_engine_volume_l = esc_attr(get_post_meta($car_ID, 'vehicle_engine_volume_l',true));

		                    $vehicle_carfax_link = esc_attr(get_post_meta($car_ID, 'vehicle_carfax_link',true));
		                    $vehicle_autocheck_link = esc_attr(get_post_meta($car_ID, 'vehicle_autocheck_link',true));
		                    $vehicle_pre_owned = esc_attr(get_post_meta($car_ID, 'vehicle_pre_owned',true));

		                    // Rent
		                    $vehicle_rent_price_min = get_post_meta($car_ID, 'vehicle_rent_price_min',true);
		                    $vehicle_rent_price_max = get_post_meta($car_ID, 'vehicle_rent_price_max',true);

		                    $vehicle_navigation = get_post_meta($car_ID, 'vehicle_navigation',true);
		                    $vehicle_ac = get_post_meta($car_ID, 'vehicle_ac',true);
		                    $rent_deposit = get_post_meta($car_ID, 'rent_deposit',true);
		                    $mileage_limit = get_post_meta($car_ID, 'mileage_limit',true);

		                    $autoroyal_currency = get_option( 'autoroyal_currency' );

		                    $vehicle_rent_pickup = wp_get_post_terms( $car_ID, 'vehicle_rent_pickup', array( 'orderby' => 'name', 'order' => 'ASC') ); 
		                    $vehicle_rent_pickup_array = "";
                            if( $vehicle_rent_pickup && ! is_wp_error($vehicle_rent_pickup) ) { 
                                foreach ($vehicle_rent_pickup as $vehicle_rent_pickup_item) {
                                    $cat_id = $vehicle_rent_pickup_item->term_id;
                                    $vehicle_rent_pickup_array .= $cat_id . ",";
                              	} 
                          	}

						?>

						<!-- Grid View -->
						<div id="car-rent-grid-id-<?php echo esc_attr($car_ID); ?>" class="<?php if( $args['filter'] == 'vertical_left' OR $args['filter'] == 'vertical_right' ) { ?>col-lg-6<?php } else { ?>col-lg-4<?php } ?> col-md-6 col-sm-12 autoroyal-animated-blk autoroyal-vehicle-grid-block autoroyal-vehicle-rent autoroyal-vehicle-item" data-make="<?php echo esc_attr($vehicle_make); ?>" data-model="<?php echo esc_attr($vehicle_model); ?>" data-price="<?php if(!empty($price)) { echo esc_attr($price); } else { echo "0"; } ?>" data-year="<?php echo esc_attr($vehicle_year); ?>" data-mileage="<?php echo esc_attr($vehicle_mileage); ?>" data-condition="<?php echo esc_attr($vehicle_condition); ?>" data-fuel="<?php echo esc_attr($terms_vehicle_fuel_type_id); ?>" data-transmission="<?php echo esc_attr($terms_vehicle_transmission_id); ?>" data-bodystyle="<?php echo esc_attr($terms_vehicle_body_style); ?>" data-doors="<?php echo esc_attr($terms_vehicle_doors_name); ?>" data-seats="<?php echo esc_attr($terms_vehicle_seats_name); ?>" data-luggages="<?php echo esc_attr($terms_vehicle_luggages_name); ?>" data-age="<?php echo esc_attr($terms_vehicle_rent_age_name); ?>" data-color="<?php if(!empty($color_id)) { echo esc_attr($color_id); } else { echo "0"; } ?>" data-favorite-grid="<?php echo esc_attr($car_ID); ?>"> 

							<div class="autoroyal-vehicle-block autoroyal-block-style-1">
								
								<div class="autoroyal-vehicle-block-image-wrapper">
									
									<?php if(!empty($vehicle_image_url)) { ?>
									<a data-open-id="car-gallery-grid-<?php echo esc_attr($uniqid); ?>-<?php echo esc_attr($car_ID); ?>" class="autoroyal-vehicle-block-image-gallery open-album" href="#"><i class="fa fa-file-image-o" aria-hidden="true"></i><?php if($total_photos['total'] > "0") {?><span><?php echo esc_attr($total_photos['total']); ?></span><?php } ?></a>
									
									<?php foreach ( $total_photos['image'] as $image ) { ?>
									<a rel="car-gallery-grid-<?php echo esc_attr($uniqid); ?>-<?php echo esc_attr($car_ID); ?>"  class="fancybox" href="<?php echo esc_url($image); ?>"></a>
									<?php } ?>

									<?php } ?>

									<?php if(!empty($vehicle_image_url)) { $foto_large = autoroyal_get_resized_image( $vehicle_image_url, 'autoroyal-thumbnail-image' ); ?>
									<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-thumbnail" style="background-image: url(<?php echo esc_url($foto_large); ?>);"></a>
									<?php } else { ?>
									<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-no-thumbnail">
										<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 538.043 538.043" style="enable-background:new 0 0 538.043 538.043;" xml:space="preserve"><path d="M526.745,312.866h-15.005c-3.706-18.736-10.307-44.359-20.792-57.941c-49.022-63.573-110.574-97.697-187.945-97.697
			c-50.134,0-82.787,4.902-99.789,14.981c-2.295,1.363-9.063,5.369-27.344,42.135c-26.687,0.419-97.278,5.261-131.127,43.414
			c-16.99,19.143-23.746,39.719-26.352,55.096h-7.078C5.058,312.854,0,317.924,0,324.177c0,6.241,5.058,11.323,11.311,11.323h5.655
			c0.048,0.61,0.096,1.076,0.108,1.219c0.598,5.739,5.464,10.115,11.239,10.115h14.252c8.752,19.968,28.66,33.981,51.831,33.981
			s43.079-14.013,51.855-33.981h215.982c8.74,19.968,28.66,33.981,51.832,33.981c23.172,0,43.091-14.013,51.832-33.981h38.165
			c0.084,0,0.155,0,0.215,0c6.253,0,11.335-5.07,11.335-11.323h11.131c6.241,0,11.299-5.081,11.299-11.323
			C538.044,317.924,532.986,312.866,526.745,312.866z M94.397,358.169c-18.724,0-33.968-15.232-33.968-33.981
			c0-18.748,15.232-33.992,33.968-33.992c18.748,0,34.004,15.245,34.004,33.992C128.402,342.937,113.145,358.169,94.397,358.169z
			 M295.183,226.433c0,3.133-2.523,5.667-5.667,5.667h-87.964c-1.937,0-3.742-1.016-4.783-2.666
			c-1.052-1.662-1.148-3.731-0.287-5.476c4.149-8.537,11.67-23.327,15.269-26.4c11.981-7.616,36.001-11.227,72.002-11.227
			c1.961,0,3.922,0.024,5.906,0.06c3.061,0.072,5.512,2.595,5.512,5.667L295.183,226.433L295.183,226.433z M306.53,226.433V193.66
			c0-1.614,0.705-3.157,1.901-4.233c1.208-1.076,2.81-1.614,4.424-1.399c39.863,4.687,70.519,17.875,82.058,35.272
			c1.16,1.746,1.244,3.97,0.263,5.811c-0.968,1.841-2.905,2.989-4.998,2.989h-78.004C309.077,232.1,306.53,229.565,306.53,226.433z
			 M414.067,358.169c-18.724,0-33.98-15.232-33.98-33.981c0-18.748,15.244-33.992,33.98-33.992c18.736,0,33.98,15.245,33.98,33.992
			C448.047,342.937,432.791,358.169,414.067,358.169z"/></svg>

									</a>
									<?php } ?>
								</div>

								<div class="autoroyal-vehicle-block-meta">

		                            <a class="heading" href="<?php echo get_permalink( $car_ID ); ?>"><span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?></a>

		                            <div class="autoroyal-rent-subtitle">

		                                <?php if(!empty($terms_vehicle_seats_name)) { ?>
		                                    <span>
		                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 350 350" style="enable-background:new 0 0 350 350;" xml:space="preserve"><path d="M175,171.173c38.914,0,70.463-38.318,70.463-85.586C245.463,38.318,235.105,0,175,0s-70.465,38.318-70.465,85.587
		        C104.535,132.855,136.084,171.173,175,171.173z"/><path d="M41.909,301.853C41.897,298.971,41.885,301.041,41.909,301.853L41.909,301.853z"/><path d="M308.085,304.104C308.123,303.315,308.098,298.63,308.085,304.104L308.085,304.104z"/><path d="M307.935,298.397c-1.305-82.342-12.059-105.805-94.352-120.657c0,0-11.584,14.761-38.584,14.761
		        s-38.586-14.761-38.586-14.761c-81.395,14.69-92.803,37.805-94.303,117.982c-0.123,6.547-0.18,6.891-0.202,6.131
		        c0.005,1.424,0.011,4.058,0.011,8.651c0,0,19.592,39.496,133.08,39.496c113.486,0,133.08-39.496,133.08-39.496
		        c0-2.951,0.002-5.003,0.005-6.399C308.062,304.575,308.018,303.664,307.935,298.397z"/></svg><?php echo esc_attr($terms_vehicle_seats_name); ?>
		                                    </span>
		                                <?php } ?>

		                                <?php if(!empty($terms_vehicle_luggages_name)) { ?>
		                                    <span>
		                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="511.626px" height="511.627px" viewBox="0 0 511.626 511.627" style="enable-background:new 0 0 511.626 511.627;" xml:space="preserve"><path d="M18.842,128.48C6.28,141.043,0,156.08,0,173.588v237.537c0,17.515,6.28,32.552,18.842,45.111
		            c12.563,12.565,27.6,18.842,45.111,18.842h18.271V109.634H63.953C46.438,109.634,31.402,115.917,18.842,128.48z"/><path d="M365.446,63.955c0-7.614-2.663-14.084-7.994-19.414c-5.325-5.33-11.8-7.993-19.411-7.993H173.589
		            c-7.612,0-14.083,2.663-19.414,7.993c-5.33,5.327-7.994,11.799-7.994,19.414v45.679h-36.545v365.444h292.359V109.634h-36.549
		            V63.955z M328.904,109.634H182.725V73.091h146.179V109.634z"/><path d="M492.785,128.48c-12.563-12.562-27.601-18.846-45.111-18.846h-18.274v365.444h18.274c17.511,0,32.548-6.276,45.111-18.842
		            c12.559-12.56,18.842-27.597,18.842-45.111V173.588C511.626,156.08,505.343,141.043,492.785,128.48z"/></svg><?php echo esc_attr($terms_vehicle_luggages_name); ?>
		                                    </span>
		                                <?php } ?>

		                                <?php if(!empty($terms_vehicle_doors_name)) { ?>
		                                    <span>
		                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M446.479,261.188l-55.826-93.043c2.393-1.956,4.013-4.81,4.013-8.145V74.667C394.667,68.771,389.896,64,384,64h-1.505
		            c-3.048-13.035-10.828-24.598-22.245-32.208L325.99,8.958C317.198,3.104,306.969,0,296.417,0h-80.833
		            C205.031,0,194.802,3.104,186,8.958l-34.25,22.833C140.333,39.402,132.555,50.965,129.507,64H128
		            c-5.896,0-10.667,4.771-10.667,10.667V160c0,3.335,1.62,6.189,4.013,8.145l-55.826,93.043c-3.031,5.042-1.396,11.604,3.656,14.625
		            c5.052,3.063,11.615,1.396,14.635-3.667L128,198.5v132.167v10.667c-5.896,0-10.667,4.771-10.667,10.667v85.333
		            c0,5.896,4.771,10.667,10.667,10.667h1.078c5.232,36.089,36.074,64,73.589,64h106.667c37.514,0,68.357-27.911,73.589-64H384
		            c5.896,0,10.667-4.771,10.667-10.667V352c0-5.896-4.771-10.667-10.667-10.667v-10.667V198.5l44.188,73.646
		            c3.021,5.063,9.583,6.729,14.635,3.667C447.875,272.792,449.51,266.229,446.479,261.188z M180.448,116.792
		            c3.917-6.333,10.698-10.125,18.146-10.125h114.812c7.448,0,14.229,3.792,18.146,10.125c3.917,6.333,4.271,14.083,0.938,20.75
		            l-21.333,42.667C307.521,187.479,300.208,192,292.073,192h-72.146c-8.135,0-15.448-4.521-19.083-11.792l-21.333-42.667
		            C176.177,130.875,176.531,123.125,180.448,116.792z M149.333,313.41V185.75l21.333,21.333v95.667L149.333,313.41z
		             M338.208,402.208c-1,1-25.115,24.458-82.208,24.458s-81.208-23.458-82.208-24.458c-3.25-3.25-4.052-8.208-2-12.313l21.333-42.667
		            c2.635-5.229,9.063-7.354,14.281-4.792C207.594,342.542,227.187,352,256,352c29.146,0,48.375-9.438,48.562-9.542
		            c2.542-1.271,5.438-1.438,8.146-0.583c2.677,0.896,4.896,2.833,6.167,5.354l21.333,42.667
		            C342.26,394,341.458,398.958,338.208,402.208z M362.667,313.41l-21.333-10.66v-95.667l21.333-21.333V313.41z"/></svg><?php echo esc_attr($terms_vehicle_doors_name); ?> <?php echo esc_html_e('Doors', 'autoroyal'); ?>
		                                    </span>
		                                <?php } ?>
		                                
		                                <?php if(!empty($terms_vehicle_transmission)) { ?>
		                                    <span>
		                                        <svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"></path><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"></path><circle cx="70" cy="70" r="4"></circle></svg><?php echo esc_attr($terms_vehicle_transmission); ?>
		                                    </span>
		                                <?php } ?>

		                                <?php if(!empty($vehicle_navigation)) { ?>
		                                    <span>
		                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="438.533px" height="438.533px" viewBox="0 0 438.533 438.533" style="enable-background:new 0 0 438.533 438.533;" xml:space="preserve"><path d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
		            c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
		            c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
		            s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
		            C438.533,179.485,428.732,142.795,409.133,109.203z M353.742,297.208c-13.894,23.791-32.736,42.64-56.527,56.534
		            c-23.791,13.894-49.771,20.834-77.945,20.834c-28.167,0-54.149-6.94-77.943-20.834c-23.791-13.895-42.633-32.743-56.527-56.534
		            c-13.897-23.791-20.843-49.772-20.843-77.941c0-28.171,6.949-54.152,20.843-77.943c13.891-23.791,32.738-42.637,56.527-56.53
		            c23.791-13.895,49.772-20.84,77.943-20.84c28.173,0,54.154,6.945,77.945,20.84c23.791,13.894,42.634,32.739,56.527,56.53
		            c13.895,23.791,20.838,49.772,20.838,77.943C374.58,247.436,367.637,273.417,353.742,297.208z"/><path d="M146.181,333.182l146.178-73.087V105.35l-146.178,73.089V333.182z M182.727,200.992l73.094,36.547l-73.094,36.545V200.992
		            z"/></svg><?php echo esc_html_e('Navigation', 'autoroyal'); ?>
		                                    </span>
		                                <?php } ?>

		                                <?php if(!empty($vehicle_ac)) { ?>
		                                    <span>
		                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="700.236px" height="700.236px" viewBox="0 0 700.236 700.236" style="enable-background:new 0 0 700.236 700.236;" xml:space="preserve"><path d="M645.527,495.815l-75.609-43.689l63.832-38.015c10.262-4.944,13.438-18.724,7.602-28.855
		        c-5.941-10.375-18.764-12.563-28.498-6.89l-85.107,49.849L392.488,349.51l135.258-77.894l85.107,49.768
		        c2.658,1.945,6.078,3.08,9.881,3.08c7.213,0,13.674-3.404,18.617-9.889c5.699-10.294,2.66-23.911-7.602-28.855l-63.832-38.015
		        l75.609-43.688c9.855-5.674,13.244-18.4,7.602-28.856c-5.389-10.051-18.723-13.536-28.879-7.619l-75.99,44.094l-1.135-76.03
		        c-0.178-11.753-9.119-21.237-20.896-21.237c-11.775,0-20.984,10.213-20.895,21.237l0.754,100.346l-134.496,77.894V155.788
		        l84.727-48.309c9.891-5.593,14.201-18.643,8.357-28.855c-5.934-10.375-18.115-13.456-28.498-7.619l-64.586,36.475V21.236
		        c0-11.753-9.5-21.236-21.277-21.236c-11.777,0-20.896,9.483-20.896,21.236v87.053l-66.871-37.285
		        c-10.416-5.755-22.274-2.513-28.118,7.619c-5.933,10.375-2.245,23.101,7.976,28.855l87.013,49.039v156.518l-137.542-79.353
		        l0.762-98.077c1.143-11.023-8.738-21.237-20.515-21.237h-0.762c-11.016,0-20.774,9.484-20.896,21.237l-0.762,73.76l-74.084-42.554
		        c-10.343-5.998-23.109-2.432-28.499,7.538c-5.642,10.537-2.724,22.939,7.603,28.937l74.846,43.283l-65.354,39.15
		        C53.96,290.664,50.758,304.443,57,314.575c4.02,6.566,9.873,9.889,17.856,9.889c4.174,0,7.651-1.054,11.015-3.08l85.489-50.498
		        l137.162,78.624l-137.162,79.434l-85.489-50.578c-10.262-5.998-23.49-3.161-28.872,6.89c-5.642,10.456-2.578,23.02,7.214,28.855
		        l65.355,38.744l-74.847,43.689c-10.302,5.998-13.642,18.643-7.603,28.937C51.342,532.614,57,536.1,64.976,536.1
		        c1.897,0,5.698-1.135,10.643-3.08l74.084-42.554l0.762,73.76c0.122,11.753,9.88,20.831,20.896,20.831h0.762
		        c11.777,0,20.604-9.808,20.515-21.642l-0.762-97.996l137.542-78.623v155.707l-87.013,49.038
		        c-10.383,5.836-14.015,18.562-7.976,28.856c4.223,7.214,9.881,10.699,17.856,10.699c3.802,0,7.303-0.648,10.262-2.351
		        l66.871-37.935v88.513c0,11.753,9.119,20.912,20.896,20.912c11.777,0,21.277-9.159,21.277-20.912v-87.054l64.586,36.476
		        c2.957,1.702,6.459,2.351,9.881,2.351c8.355,0,14.516-3.404,18.617-10.699c5.771-10.213,2.043-23.021-8.357-28.856l-84.727-47.498
		        V385.985l134.496,77.894l-0.754,99.536c-0.098,11.834,9.119,21.642,20.896,21.642s20.717-9.078,20.895-20.831l1.135-76.435
		        l75.99,44.499c2.934,1.702,6.84,2.27,11.023,2.27c7.977,0,13.828-3.323,17.855-9.889
		        C659.363,514.539,655.382,501.489,645.527,495.815z"/></svg><?php echo esc_html_e('Air Conditioning', 'autoroyal'); ?>
		                                    </span>
		                                <?php } ?>

		                            </div>

		                            <div class="autoroyal-rent-subtitle autoroyal-rent-subtitle-meta">

		                                <?php if(!empty($rent_deposit)) { ?>
		                                    <span>
		                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="438.543px" height="438.543px" viewBox="0 0 438.543 438.543" style="enable-background:new 0 0 438.543 438.543;" xml:space="preserve"><path d="M396.58,5.424C392.959,1.807,388.675,0,383.727,0H54.824c-4.952,0-9.235,1.807-12.852,5.424
		        c-3.615,3.615-5.424,7.898-5.424,12.847v219.268c0,16.371,3.186,32.596,9.563,48.681c6.374,16.084,14.274,30.361,23.697,42.828
		        c9.423,12.47,20.651,24.605,33.689,36.405c13.04,11.806,25.078,21.6,36.116,29.409c11.038,7.803,22.554,15.181,34.545,22.121
		        c11.991,6.943,20.511,11.663,25.553,14.134c5.043,2.478,9.088,4.38,12.132,5.708c2.286,1.143,4.758,1.718,7.426,1.718
		        c2.671,0,5.14-0.575,7.428-1.718c3.042-1.328,7.087-3.23,12.128-5.708c5.041-2.471,13.565-7.19,25.557-14.134
		        c11.984-6.94,23.504-14.318,34.54-22.121c11.043-7.81,23.079-17.604,36.121-29.409c13.031-11.8,24.263-23.936,33.685-36.405
		        c9.421-12.467,17.319-26.744,23.705-42.828c6.379-16.085,9.562-32.31,9.562-48.681V18.271
		        C401.994,13.319,400.187,9.04,396.58,5.424z M347.178,237.539c0,33.5-22.367,67.759-67.095,102.781
		        c-17.892,14.082-38.164,27.124-60.813,39.115V54.813h127.908V237.539z"/></svg><?php $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($autoroyal_currency)) { echo esc_attr($currency_symbol); } ?><?php echo esc_attr($rent_deposit); ?>
		                                    </span>
		                                <?php } ?>

		                                <?php if(!empty($mileage_limit)) { ?>
		                                    <span>
		                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M435.143,129.356c-6.796-6.795-17.463-7.797-25.407-2.384c-29.926,20.398-180.03,122.969-196.162,139.1
		                c-23.394,23.395-23.394,61.459,0,84.854c11.697,11.696,27.063,17.545,42.427,17.545c15.364,0,30.729-5.849,42.427-17.545
		                c16.131-16.132,118.701-166.236,139.1-196.162C442.939,146.821,441.938,136.153,435.143,129.356z M270.142,322.641
		                c-7.797,7.799-20.486,7.799-28.283,0c-7.798-7.797-7.799-20.482-0.004-28.28c6.268-6.194,48.885-36.588,101.319-73.035
		                C306.728,273.76,276.334,316.375,270.142,322.641z"/><path d="M92.231,401.523l-24.69,12.044C49.475,381.325,40,345.338,40,308.499c0-26.991,4.977-52.842,14.06-76.683l28.291,13.57
		                c2.79,1.338,5.735,1.972,8.636,1.972c7.453,0,14.608-4.185,18.047-11.355c4.776-9.959,0.576-21.906-9.384-26.683l-27.932-13.398
		                c34.717-56.62,94.784-96.095,164.283-102.505v30.081c0,11.046,8.954,20,20,20c11.046,0,20-8.954,20-20V93.402
		                c23.828,2.169,46.884,8.237,68.771,18.117c10.065,4.545,21.912,0.066,26.457-9.999c4.545-10.068,0.068-21.913-10-26.458
		                C328.063,60.091,292.659,52.499,256,52.499c-68.38,0-132.667,26.628-181.02,74.98C26.629,175.832,0,240.119,0,308.499
		                c0,50.53,14.998,99.674,43.373,142.115c3.822,5.715,10.141,8.886,16.639,8.886c2.954,0,5.946-0.655,8.757-2.026l41-20
		                c9.928-4.843,14.05-16.816,9.207-26.744C114.133,400.803,102.159,396.682,92.231,401.523z"/><path d="M489.436,203.271c-4.544-10.067-16.387-14.547-26.458-10c-10.067,4.545-14.544,16.39-9.999,26.457
		                C465.601,247.686,472,277.553,472,308.499c0,36.894-9.506,72.939-27.625,105.218l-25.777-12.275
		                c-9.971-4.748-21.906-0.515-26.656,9.459c-4.749,9.972-0.514,21.907,9.459,26.656l42,20c2.763,1.315,5.692,1.944,8.588,1.944
		                c6.5,0,12.82-3.175,16.637-8.886C497.002,408.173,512,359.029,512,308.499C512,271.84,504.408,236.436,489.436,203.271z"/></svg>
		<?php echo esc_attr($mileage_limit); ?><?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?>
		                                    </span>
		                                <?php } ?>

		                                <?php if(!empty($terms_vehicle_rent_age_name)) { ?>
		                                    <span>
		                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 460.8 460.8" style="enable-background:new 0 0 460.8 460.8;" xml:space="preserve"><path d="M410.624,49.664H50.176C22.528,49.664,0,72.192,0,99.84v261.12c0,27.648,22.528,50.176,50.176,50.176h360.448
		            c27.648,0,50.176-22.528,50.176-50.176V99.84C460.8,72.192,438.272,49.664,410.624,49.664z M99.84,167.936
		            c4.608-22.528,26.624-37.376,49.152-32.768c22.528,4.608,37.376,26.624,32.768,49.152c-3.072,16.384-16.384,29.696-32.768,32.768
		            c-22.528,4.608-44.544-10.24-49.152-32.768C98.816,179.2,98.816,173.568,99.84,167.936z M211.968,315.392
		            c0,6.144-5.12,11.264-11.264,11.264H80.896c-6.144,0-11.264-5.12-11.264-11.264V302.08c-0.512-36.864,26.624-67.584,62.976-72.704
		            c38.912-4.608,74.752,23.552,78.848,62.464c0.512,2.56,0.512,5.632,0.512,8.192V315.392z M387.072,290.304H252.928v-33.792
		            h134.144V290.304z M387.072,204.288H252.928v-33.792h134.144V204.288z"/></svg><?php echo esc_html_e('From', 'autoroyal'); ?> <?php echo esc_attr($terms_vehicle_rent_age_name); ?> <?php echo esc_html_e('years', 'autoroyal'); ?>
		                                    </span>
		                                <?php } ?>

		                            </div>

		                            <hr class="separator">

		                            <h4 class="autoroyal-vehicle-block-meta-price">
                                        <span class="rent-price"><?php esc_html_e('From', 'autoroyal'); ?> <b><span><?php echo autoroyal_clean_price($vehicle_rent_price_min); ?></span></b> <?php esc_html_e('per day', 'autoroyal'); ?></span>
                                        <span class="rent-price-period"><b><?php if( $currency_pos == "left" OR $currency_pos == "left_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?><?php if( $currency_pos == "left_space" ) { ?> <?php } ?><span class="price"></span><?php if( $currency_pos == "right_space" ) { ?> <?php } ?><?php if( $currency_pos == "right" OR $currency_pos == "right_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?></b> <?php esc_html_e('for', 'autoroyal'); ?> <span class="period"></span> <?php esc_html_e('days', 'autoroyal'); ?></span>
                                    </h4>

		                            <a href="#" class="autoroyal-reserve-vehicle autoroyal-button button-icon-right autoroyal-button-align-center" data-car-id="<?php echo esc_attr($car_ID); ?>" data-car-thumb="<?php echo esc_url($foto_large); ?>" data-toggle="modal" data-target="#reservation-modal"><?php esc_html_e('Reserve Now', 'autoroyal'); ?> <i class="fa fa-angle-right"></i></a>

		                            <div id="car-price-sets-<?php echo esc_attr($car_ID); ?>">

		                                <?php

		                                    $vehicle_rent_price_set = get_post_meta($car_ID, 'vehicle_rent_price_set',true);
		                    
		                                    $i = 0;

		                                    if(!empty($vehicle_rent_price_set)) {

		                                        foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
		                                            
		                                            if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

		                                                $i++;

		                                                ?>

		                                                <input type="hidden" id="price-set-period-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['period']); ?>">
		                                                <input type="hidden" id="price-set-price-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['price']); ?>">

		                                                <?php

		                                            }

		                                        }

		                                    }

		                                ?>

		                                <input type="hidden" class="total-sets" value="<?php echo esc_attr($i); ?>">

		                            </div>

		                            <ul id="rent-price-table-<?php echo esc_attr($car_ID); ?>" class="hidden">

		                                <?php
		                    
		                                    $i = 0;

		                                    if(!empty($vehicle_rent_price_set)) {

		                                        foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
		                                            
		                                            if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

		                                                $i++;

		                                                ?>

		                                                <li class="clearfix">
		                                                    <span class="pull-left"><?php if($vehicle_rent_price_set_item['period'] == 1) { echo "24"; echo " "; echo esc_html_e('hours', 'autoroyal'); } else { echo esc_attr($vehicle_rent_price_set_item['period']); echo "+ "; echo esc_html_e('days', 'autoroyal'); } ?></span>
		                                                    <span class="pull-right">
		                                                        <b><?php echo autoroyal_clean_price($vehicle_rent_price_set_item['price']); ?></b>
		                                                    </span>
		                                                </li>

		                                                <?php

		                                            }

		                                        }

		                                    }

		                                ?>

		                            </ul>

		                        </div>

							</div>

						</div>
						<!-- End Grid View -->

						<!-- List View -->
						<div id="car-rent-id-<?php echo esc_attr($car_ID); ?>" class="col-md-12 autoroyal-animated-blk autoroyal-vehicle-list-block autoroyal-vehicle-item" data-car-id="<?php echo esc_attr($car_ID); ?>" data-make="<?php echo esc_attr($vehicle_make); ?>" data-model="<?php echo esc_attr($vehicle_model); ?>" data-price="<?php if(!empty($price)) { echo esc_attr($price); } else { echo "0"; } ?>" data-year="<?php echo esc_attr($vehicle_year); ?>" data-mileage="<?php echo esc_attr($vehicle_mileage); ?>" data-condition="<?php echo esc_attr($vehicle_condition); ?>" data-fuel="<?php echo esc_attr($terms_vehicle_fuel_type_id); ?>" data-transmission="<?php echo esc_attr($terms_vehicle_transmission_id); ?>" data-bodystyle="<?php echo esc_attr($terms_vehicle_body_style); ?>" data-doors="<?php echo esc_attr($terms_vehicle_doors_name); ?>" data-seats="<?php echo esc_attr($terms_vehicle_seats_name); ?>" data-luggages="<?php echo esc_attr($terms_vehicle_luggages_name); ?>" data-age="<?php echo esc_attr($terms_vehicle_rent_age_name); ?>" data-color="<?php if(!empty($color_id)) { echo esc_attr($color_id); } else { echo "0"; } ?>"> 

							<div class="autoroyal-vehicle-block autoroyal-block-style-2">

								<div class="row">
							
									<div class="col-md-4">
								
										<div class="autoroyal-vehicle-block-image-wrapper">
											
											<?php if(!empty($vehicle_image_url)) { ?>
											<a data-open-id="car-gallery-<?php echo esc_attr($uniqid); ?>-<?php echo esc_attr($car_ID); ?>" class="autoroyal-vehicle-block-image-gallery open-album" href="#"><i class="fa fa-file-image-o" aria-hidden="true"></i><?php if($total_photos['total'] > "0") {?><span><?php echo esc_attr($total_photos['total']); ?></span><?php } ?></a>
											
											<?php foreach ( $total_photos['image'] as $image ) { ?>
											<a rel="car-gallery-<?php echo esc_attr($uniqid); ?>-<?php echo esc_attr($car_ID); ?>"  class="fancybox" href="<?php echo esc_url($image); ?>"></a>
											<?php } ?>

											<?php } ?>

											<?php if(!empty($vehicle_image_url)) { $foto_large = autoroyal_get_resized_image( $vehicle_image_url, 'autoroyal-thumbnail-image' ); ?>
											<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-thumbnail" style="background-image: url(<?php echo esc_url($foto_large); ?>);"></a>
											<?php } else { ?>
											<a href="<?php echo get_permalink( $car_ID ); ?>" class="autoroyal-vehicle-block-no-thumbnail">
												<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 538.043 538.043" style="enable-background:new 0 0 538.043 538.043;" xml:space="preserve"><path d="M526.745,312.866h-15.005c-3.706-18.736-10.307-44.359-20.792-57.941c-49.022-63.573-110.574-97.697-187.945-97.697
								c-50.134,0-82.787,4.902-99.789,14.981c-2.295,1.363-9.063,5.369-27.344,42.135c-26.687,0.419-97.278,5.261-131.127,43.414
								c-16.99,19.143-23.746,39.719-26.352,55.096h-7.078C5.058,312.854,0,317.924,0,324.177c0,6.241,5.058,11.323,11.311,11.323h5.655
								c0.048,0.61,0.096,1.076,0.108,1.219c0.598,5.739,5.464,10.115,11.239,10.115h14.252c8.752,19.968,28.66,33.981,51.831,33.981
								s43.079-14.013,51.855-33.981h215.982c8.74,19.968,28.66,33.981,51.832,33.981c23.172,0,43.091-14.013,51.832-33.981h38.165
								c0.084,0,0.155,0,0.215,0c6.253,0,11.335-5.07,11.335-11.323h11.131c6.241,0,11.299-5.081,11.299-11.323
								C538.044,317.924,532.986,312.866,526.745,312.866z M94.397,358.169c-18.724,0-33.968-15.232-33.968-33.981
								c0-18.748,15.232-33.992,33.968-33.992c18.748,0,34.004,15.245,34.004,33.992C128.402,342.937,113.145,358.169,94.397,358.169z
								M295.183,226.433c0,3.133-2.523,5.667-5.667,5.667h-87.964c-1.937,0-3.742-1.016-4.783-2.666
								c-1.052-1.662-1.148-3.731-0.287-5.476c4.149-8.537,11.67-23.327,15.269-26.4c11.981-7.616,36.001-11.227,72.002-11.227
								c1.961,0,3.922,0.024,5.906,0.06c3.061,0.072,5.512,2.595,5.512,5.667L295.183,226.433L295.183,226.433z M306.53,226.433V193.66
								c0-1.614,0.705-3.157,1.901-4.233c1.208-1.076,2.81-1.614,4.424-1.399c39.863,4.687,70.519,17.875,82.058,35.272
								c1.16,1.746,1.244,3.97,0.263,5.811c-0.968,1.841-2.905,2.989-4.998,2.989h-78.004C309.077,232.1,306.53,229.565,306.53,226.433z
								M414.067,358.169c-18.724,0-33.98-15.232-33.98-33.981c0-18.748,15.244-33.992,33.98-33.992c18.736,0,33.98,15.245,33.98,33.992
								C448.047,342.937,432.791,358.169,414.067,358.169z"/></svg>

											</a>
											<?php } ?>
										</div>

									</div>

									<div class="col-md-8">

										<div class="autoroyal-vehicle-block-meta">

				                            <a class="heading" href="<?php echo get_permalink( $car_ID ); ?>"><span class="productYear"><?php echo esc_attr($vehicle_year); ?></span> <?php echo esc_attr($vehicle_make_desc_init); ?> <?php echo esc_attr($vehicle_model); ?></a>

                                            <ul class="autoroyal-vehicle-block-specs list-view-car-specs autoroyal-rent-subtitle">

                                                <?php if(!empty($terms_vehicle_seats_name)) { ?>
                                                    <li class="autoroyal-vehicle-stock">
                                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 350 350" style="enable-background:new 0 0 350 350;" xml:space="preserve"><path d="M175,171.173c38.914,0,70.463-38.318,70.463-85.586C245.463,38.318,235.105,0,175,0s-70.465,38.318-70.465,85.587
                        C104.535,132.855,136.084,171.173,175,171.173z"/><path d="M41.909,301.853C41.897,298.971,41.885,301.041,41.909,301.853L41.909,301.853z"/><path d="M308.085,304.104C308.123,303.315,308.098,298.63,308.085,304.104L308.085,304.104z"/><path d="M307.935,298.397c-1.305-82.342-12.059-105.805-94.352-120.657c0,0-11.584,14.761-38.584,14.761
                        s-38.586-14.761-38.586-14.761c-81.395,14.69-92.803,37.805-94.303,117.982c-0.123,6.547-0.18,6.891-0.202,6.131
                        c0.005,1.424,0.011,4.058,0.011,8.651c0,0,19.592,39.496,133.08,39.496c113.486,0,133.08-39.496,133.08-39.496
                        c0-2.951,0.002-5.003,0.005-6.399C308.062,304.575,308.018,303.664,307.935,298.397z"/></svg><?php echo esc_attr($terms_vehicle_seats_name); ?>
                                                    </li>
                                                <?php } ?>

                                                <?php if(!empty($terms_vehicle_luggages_name)) { ?>
                                                    <li class="autoroyal-vehicle-stock">
                                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="511.626px" height="511.627px" viewBox="0 0 511.626 511.627" style="enable-background:new 0 0 511.626 511.627;" xml:space="preserve"><path d="M18.842,128.48C6.28,141.043,0,156.08,0,173.588v237.537c0,17.515,6.28,32.552,18.842,45.111
                            c12.563,12.565,27.6,18.842,45.111,18.842h18.271V109.634H63.953C46.438,109.634,31.402,115.917,18.842,128.48z"/><path d="M365.446,63.955c0-7.614-2.663-14.084-7.994-19.414c-5.325-5.33-11.8-7.993-19.411-7.993H173.589
                            c-7.612,0-14.083,2.663-19.414,7.993c-5.33,5.327-7.994,11.799-7.994,19.414v45.679h-36.545v365.444h292.359V109.634h-36.549
                            V63.955z M328.904,109.634H182.725V73.091h146.179V109.634z"/><path d="M492.785,128.48c-12.563-12.562-27.601-18.846-45.111-18.846h-18.274v365.444h18.274c17.511,0,32.548-6.276,45.111-18.842
                            c12.559-12.56,18.842-27.597,18.842-45.111V173.588C511.626,156.08,505.343,141.043,492.785,128.48z"/></svg><?php echo esc_attr($terms_vehicle_luggages_name); ?>
                                                    </li>
                                                <?php } ?>

                                                <?php if(!empty($terms_vehicle_doors_name)) { ?>
                                                    <li class="autoroyal-vehicle-stock">
                                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M446.479,261.188l-55.826-93.043c2.393-1.956,4.013-4.81,4.013-8.145V74.667C394.667,68.771,389.896,64,384,64h-1.505
                            c-3.048-13.035-10.828-24.598-22.245-32.208L325.99,8.958C317.198,3.104,306.969,0,296.417,0h-80.833
                            C205.031,0,194.802,3.104,186,8.958l-34.25,22.833C140.333,39.402,132.555,50.965,129.507,64H128
                            c-5.896,0-10.667,4.771-10.667,10.667V160c0,3.335,1.62,6.189,4.013,8.145l-55.826,93.043c-3.031,5.042-1.396,11.604,3.656,14.625
                            c5.052,3.063,11.615,1.396,14.635-3.667L128,198.5v132.167v10.667c-5.896,0-10.667,4.771-10.667,10.667v85.333
                            c0,5.896,4.771,10.667,10.667,10.667h1.078c5.232,36.089,36.074,64,73.589,64h106.667c37.514,0,68.357-27.911,73.589-64H384
                            c5.896,0,10.667-4.771,10.667-10.667V352c0-5.896-4.771-10.667-10.667-10.667v-10.667V198.5l44.188,73.646
                            c3.021,5.063,9.583,6.729,14.635,3.667C447.875,272.792,449.51,266.229,446.479,261.188z M180.448,116.792
                            c3.917-6.333,10.698-10.125,18.146-10.125h114.812c7.448,0,14.229,3.792,18.146,10.125c3.917,6.333,4.271,14.083,0.938,20.75
                            l-21.333,42.667C307.521,187.479,300.208,192,292.073,192h-72.146c-8.135,0-15.448-4.521-19.083-11.792l-21.333-42.667
                            C176.177,130.875,176.531,123.125,180.448,116.792z M149.333,313.41V185.75l21.333,21.333v95.667L149.333,313.41z
                             M338.208,402.208c-1,1-25.115,24.458-82.208,24.458s-81.208-23.458-82.208-24.458c-3.25-3.25-4.052-8.208-2-12.313l21.333-42.667
                            c2.635-5.229,9.063-7.354,14.281-4.792C207.594,342.542,227.187,352,256,352c29.146,0,48.375-9.438,48.562-9.542
                            c2.542-1.271,5.438-1.438,8.146-0.583c2.677,0.896,4.896,2.833,6.167,5.354l21.333,42.667
                            C342.26,394,341.458,398.958,338.208,402.208z M362.667,313.41l-21.333-10.66v-95.667l21.333-21.333V313.41z"/></svg><?php echo esc_attr($terms_vehicle_doors_name); ?> <?php echo esc_html_e('Doors', 'autoroyal'); ?>
                                                    </li>
                                                <?php } ?>
                                                
                                                <?php if(!empty($terms_vehicle_transmission)) { ?>
                                                    <li class="autoroyal-vehicle-stock">
                                                        <svg xmlns="http://www.w3.org/2000/svg" height="200" width="200" fill="#000000" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><path d="M30,94H70A24,24,0,0,0,94,70V30A24,24,0,0,0,70,6H30A24,24,0,0,0,6,30V70A24,24,0,0,0,30,94ZM14,30A16,16,0,0,1,30,14H70A16,16,0,0,1,86,30V70A16,16,0,0,1,70,86H30A16,16,0,0,1,14,70Z"></path><path d="M30,74a4,4,0,0,0,4-4V54H46V70a4,4,0,0,0,8,0V54h8A12,12,0,0,0,74,42V30a4,4,0,0,0-8,0V42a4,4,0,0,1-4,4H54V30a4,4,0,0,0-8,0V46H34V30a4,4,0,0,0-8,0V70A4,4,0,0,0,30,74Z"></path><circle cx="70" cy="70" r="4"></circle></svg><?php echo esc_attr($terms_vehicle_transmission); ?>
                                                    </li>
                                                <?php } ?>

                                                <?php if(!empty($vehicle_navigation)) { ?>
                                                    <li class="autoroyal-vehicle-stock">
                                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="438.533px" height="438.533px" viewBox="0 0 438.533 438.533" style="enable-background:new 0 0 438.533 438.533;" xml:space="preserve"><path d="M409.133,109.203c-19.608-33.592-46.205-60.189-79.798-79.796C295.736,9.801,259.058,0,219.273,0
                            c-39.781,0-76.47,9.801-110.063,29.407c-33.595,19.604-60.192,46.201-79.8,79.796C9.801,142.8,0,179.489,0,219.267
                            c0,39.78,9.804,76.463,29.407,110.062c19.607,33.592,46.204,60.189,79.799,79.798c33.597,19.605,70.283,29.407,110.063,29.407
                            s76.47-9.802,110.065-29.407c33.593-19.602,60.189-46.206,79.795-79.798c19.603-33.596,29.403-70.284,29.403-110.062
                            C438.533,179.485,428.732,142.795,409.133,109.203z M353.742,297.208c-13.894,23.791-32.736,42.64-56.527,56.534
                            c-23.791,13.894-49.771,20.834-77.945,20.834c-28.167,0-54.149-6.94-77.943-20.834c-23.791-13.895-42.633-32.743-56.527-56.534
                            c-13.897-23.791-20.843-49.772-20.843-77.941c0-28.171,6.949-54.152,20.843-77.943c13.891-23.791,32.738-42.637,56.527-56.53
                            c23.791-13.895,49.772-20.84,77.943-20.84c28.173,0,54.154,6.945,77.945,20.84c23.791,13.894,42.634,32.739,56.527,56.53
                            c13.895,23.791,20.838,49.772,20.838,77.943C374.58,247.436,367.637,273.417,353.742,297.208z"/><path d="M146.181,333.182l146.178-73.087V105.35l-146.178,73.089V333.182z M182.727,200.992l73.094,36.547l-73.094,36.545V200.992
                            z"/></svg><?php echo esc_html_e('Navigation', 'autoroyal'); ?>
                                                    </li>
                                                <?php } ?>

                                                <?php if(!empty($vehicle_ac)) { ?>
                                                    <li class="autoroyal-vehicle-stock">
                                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="700.236px" height="700.236px" viewBox="0 0 700.236 700.236" style="enable-background:new 0 0 700.236 700.236;" xml:space="preserve"><path d="M645.527,495.815l-75.609-43.689l63.832-38.015c10.262-4.944,13.438-18.724,7.602-28.855
                        c-5.941-10.375-18.764-12.563-28.498-6.89l-85.107,49.849L392.488,349.51l135.258-77.894l85.107,49.768
                        c2.658,1.945,6.078,3.08,9.881,3.08c7.213,0,13.674-3.404,18.617-9.889c5.699-10.294,2.66-23.911-7.602-28.855l-63.832-38.015
                        l75.609-43.688c9.855-5.674,13.244-18.4,7.602-28.856c-5.389-10.051-18.723-13.536-28.879-7.619l-75.99,44.094l-1.135-76.03
                        c-0.178-11.753-9.119-21.237-20.896-21.237c-11.775,0-20.984,10.213-20.895,21.237l0.754,100.346l-134.496,77.894V155.788
                        l84.727-48.309c9.891-5.593,14.201-18.643,8.357-28.855c-5.934-10.375-18.115-13.456-28.498-7.619l-64.586,36.475V21.236
                        c0-11.753-9.5-21.236-21.277-21.236c-11.777,0-20.896,9.483-20.896,21.236v87.053l-66.871-37.285
                        c-10.416-5.755-22.274-2.513-28.118,7.619c-5.933,10.375-2.245,23.101,7.976,28.855l87.013,49.039v156.518l-137.542-79.353
                        l0.762-98.077c1.143-11.023-8.738-21.237-20.515-21.237h-0.762c-11.016,0-20.774,9.484-20.896,21.237l-0.762,73.76l-74.084-42.554
                        c-10.343-5.998-23.109-2.432-28.499,7.538c-5.642,10.537-2.724,22.939,7.603,28.937l74.846,43.283l-65.354,39.15
                        C53.96,290.664,50.758,304.443,57,314.575c4.02,6.566,9.873,9.889,17.856,9.889c4.174,0,7.651-1.054,11.015-3.08l85.489-50.498
                        l137.162,78.624l-137.162,79.434l-85.489-50.578c-10.262-5.998-23.49-3.161-28.872,6.89c-5.642,10.456-2.578,23.02,7.214,28.855
                        l65.355,38.744l-74.847,43.689c-10.302,5.998-13.642,18.643-7.603,28.937C51.342,532.614,57,536.1,64.976,536.1
                        c1.897,0,5.698-1.135,10.643-3.08l74.084-42.554l0.762,73.76c0.122,11.753,9.88,20.831,20.896,20.831h0.762
                        c11.777,0,20.604-9.808,20.515-21.642l-0.762-97.996l137.542-78.623v155.707l-87.013,49.038
                        c-10.383,5.836-14.015,18.562-7.976,28.856c4.223,7.214,9.881,10.699,17.856,10.699c3.802,0,7.303-0.648,10.262-2.351
                        l66.871-37.935v88.513c0,11.753,9.119,20.912,20.896,20.912c11.777,0,21.277-9.159,21.277-20.912v-87.054l64.586,36.476
                        c2.957,1.702,6.459,2.351,9.881,2.351c8.355,0,14.516-3.404,18.617-10.699c5.771-10.213,2.043-23.021-8.357-28.856l-84.727-47.498
                        V385.985l134.496,77.894l-0.754,99.536c-0.098,11.834,9.119,21.642,20.896,21.642s20.717-9.078,20.895-20.831l1.135-76.435
                        l75.99,44.499c2.934,1.702,6.84,2.27,11.023,2.27c7.977,0,13.828-3.323,17.855-9.889
                        C659.363,514.539,655.382,501.489,645.527,495.815z"/></svg><?php echo esc_html_e('Air Conditioning', 'autoroyal'); ?>
                                                    </li>
                                                <?php } ?>

                                                <?php if(!empty($rent_deposit)) { ?>
                                                    <li class="autoroyal-vehicle-stock">
                                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="438.543px" height="438.543px" viewBox="0 0 438.543 438.543" style="enable-background:new 0 0 438.543 438.543;" xml:space="preserve"><path d="M396.58,5.424C392.959,1.807,388.675,0,383.727,0H54.824c-4.952,0-9.235,1.807-12.852,5.424
                        c-3.615,3.615-5.424,7.898-5.424,12.847v219.268c0,16.371,3.186,32.596,9.563,48.681c6.374,16.084,14.274,30.361,23.697,42.828
                        c9.423,12.47,20.651,24.605,33.689,36.405c13.04,11.806,25.078,21.6,36.116,29.409c11.038,7.803,22.554,15.181,34.545,22.121
                        c11.991,6.943,20.511,11.663,25.553,14.134c5.043,2.478,9.088,4.38,12.132,5.708c2.286,1.143,4.758,1.718,7.426,1.718
                        c2.671,0,5.14-0.575,7.428-1.718c3.042-1.328,7.087-3.23,12.128-5.708c5.041-2.471,13.565-7.19,25.557-14.134
                        c11.984-6.94,23.504-14.318,34.54-22.121c11.043-7.81,23.079-17.604,36.121-29.409c13.031-11.8,24.263-23.936,33.685-36.405
                        c9.421-12.467,17.319-26.744,23.705-42.828c6.379-16.085,9.562-32.31,9.562-48.681V18.271
                        C401.994,13.319,400.187,9.04,396.58,5.424z M347.178,237.539c0,33.5-22.367,67.759-67.095,102.781
                        c-17.892,14.082-38.164,27.124-60.813,39.115V54.813h127.908V237.539z"/></svg><?php $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($autoroyal_currency)) { echo esc_attr($currency_symbol); } ?><?php echo esc_attr($rent_deposit); ?>
                                                    </li>
                                                <?php } ?>

                                                <?php if(!empty($mileage_limit)) { ?>
                                                    <li class="autoroyal-vehicle-stock">
                                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M435.143,129.356c-6.796-6.795-17.463-7.797-25.407-2.384c-29.926,20.398-180.03,122.969-196.162,139.1
                                c-23.394,23.395-23.394,61.459,0,84.854c11.697,11.696,27.063,17.545,42.427,17.545c15.364,0,30.729-5.849,42.427-17.545
                                c16.131-16.132,118.701-166.236,139.1-196.162C442.939,146.821,441.938,136.153,435.143,129.356z M270.142,322.641
                                c-7.797,7.799-20.486,7.799-28.283,0c-7.798-7.797-7.799-20.482-0.004-28.28c6.268-6.194,48.885-36.588,101.319-73.035
                                C306.728,273.76,276.334,316.375,270.142,322.641z"/><path d="M92.231,401.523l-24.69,12.044C49.475,381.325,40,345.338,40,308.499c0-26.991,4.977-52.842,14.06-76.683l28.291,13.57
                                c2.79,1.338,5.735,1.972,8.636,1.972c7.453,0,14.608-4.185,18.047-11.355c4.776-9.959,0.576-21.906-9.384-26.683l-27.932-13.398
                                c34.717-56.62,94.784-96.095,164.283-102.505v30.081c0,11.046,8.954,20,20,20c11.046,0,20-8.954,20-20V93.402
                                c23.828,2.169,46.884,8.237,68.771,18.117c10.065,4.545,21.912,0.066,26.457-9.999c4.545-10.068,0.068-21.913-10-26.458
                                C328.063,60.091,292.659,52.499,256,52.499c-68.38,0-132.667,26.628-181.02,74.98C26.629,175.832,0,240.119,0,308.499
                                c0,50.53,14.998,99.674,43.373,142.115c3.822,5.715,10.141,8.886,16.639,8.886c2.954,0,5.946-0.655,8.757-2.026l41-20
                                c9.928-4.843,14.05-16.816,9.207-26.744C114.133,400.803,102.159,396.682,92.231,401.523z"/><path d="M489.436,203.271c-4.544-10.067-16.387-14.547-26.458-10c-10.067,4.545-14.544,16.39-9.999,26.457
                                C465.601,247.686,472,277.553,472,308.499c0,36.894-9.506,72.939-27.625,105.218l-25.777-12.275
                                c-9.971-4.748-21.906-0.515-26.656,9.459c-4.749,9.972-0.514,21.907,9.459,26.656l42,20c2.763,1.315,5.692,1.944,8.588,1.944
                                c6.5,0,12.82-3.175,16.637-8.886C497.002,408.173,512,359.029,512,308.499C512,271.84,504.408,236.436,489.436,203.271z"/></svg>
                <?php echo esc_attr($mileage_limit); ?><?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?>
                                                    </li>
                                                <?php } ?>

                                                <?php if(!empty($terms_vehicle_rent_age_name)) { ?>
                                                    <li class="autoroyal-vehicle-stock">
                                                       <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 460.8 460.8" style="enable-background:new 0 0 460.8 460.8;" xml:space="preserve"><path d="M410.624,49.664H50.176C22.528,49.664,0,72.192,0,99.84v261.12c0,27.648,22.528,50.176,50.176,50.176h360.448
                            c27.648,0,50.176-22.528,50.176-50.176V99.84C460.8,72.192,438.272,49.664,410.624,49.664z M99.84,167.936
                            c4.608-22.528,26.624-37.376,49.152-32.768c22.528,4.608,37.376,26.624,32.768,49.152c-3.072,16.384-16.384,29.696-32.768,32.768
                            c-22.528,4.608-44.544-10.24-49.152-32.768C98.816,179.2,98.816,173.568,99.84,167.936z M211.968,315.392
                            c0,6.144-5.12,11.264-11.264,11.264H80.896c-6.144,0-11.264-5.12-11.264-11.264V302.08c-0.512-36.864,26.624-67.584,62.976-72.704
                            c38.912-4.608,74.752,23.552,78.848,62.464c0.512,2.56,0.512,5.632,0.512,8.192V315.392z M387.072,290.304H252.928v-33.792
                            h134.144V290.304z M387.072,204.288H252.928v-33.792h134.144V204.288z"/></svg><?php echo esc_html_e('From', 'autoroyal'); ?> <?php echo esc_attr($terms_vehicle_rent_age_name); ?> <?php echo esc_html_e('years', 'autoroyal'); ?>
                                                    </li>
                                                <?php } ?>
                                                
                                            </ul>

				                            <h4 class="autoroyal-vehicle-block-meta-price">
				                                <span class="rent-price"><?php esc_html_e('From', 'autoroyal'); ?> <b><span><?php echo autoroyal_clean_price($vehicle_rent_price_min); ?></span></b> <?php esc_html_e('per day', 'autoroyal'); ?></span>
				                                <span class="rent-price-period"><b><?php if( $currency_pos == "left" OR $currency_pos == "left_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?><?php if( $currency_pos == "left_space" ) { ?> <?php } ?><span class="price"></span><?php if( $currency_pos == "right_space" ) { ?> <?php } ?><?php if( $currency_pos == "right" OR $currency_pos == "right_space" ) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); if(!empty($currency_symbol)) { echo esc_attr($currency_symbol); } } ?></b> <?php esc_html_e('for', 'autoroyal'); ?> <span class="period"></span> <?php esc_html_e('days', 'autoroyal'); ?></span>
				                            </h4>

				                            <a href="#" class="autoroyal-reserve-vehicle autoroyal-button button-icon-right autoroyal-button-align-right" data-car-id="<?php echo esc_attr($car_ID); ?>" data-car-thumb="<?php echo esc_url($foto_large); ?>" data-toggle="modal" data-target="#reservation-modal"><?php esc_html_e('Reserve Now', 'autoroyal'); ?> <i class="fa fa-angle-right"></i></a>

				                            <div id="car-price-sets-<?php echo esc_attr($car_ID); ?>">

				                                <?php

				                                    $vehicle_rent_price_set = get_post_meta($car_ID, 'vehicle_rent_price_set',true);
				                    
				                                    $i = 0;

				                                    if(!empty($vehicle_rent_price_set)) {

				                                        foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
				                                            
				                                            if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

				                                                $i++;

				                                                ?>

				                                                <input type="hidden" id="price-set-period-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['period']); ?>">
				                                                <input type="hidden" id="price-set-price-<?php echo esc_attr($i); ?>" value="<?php echo esc_attr($vehicle_rent_price_set_item['price']); ?>">

				                                                <?php

				                                            }

				                                        }

				                                    }

				                                ?>

				                                <input type="hidden" class="total-sets" value="<?php echo esc_attr($i); ?>">

				                            </div>

				                            <ul id="rent-price-table-<?php echo esc_attr($car_ID); ?>" class="hidden">

				                                <?php
				                    
				                                    $i = 0;

				                                    if(!empty($vehicle_rent_price_set)) {

				                                        foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
				                                            
				                                            if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

				                                                $i++;

				                                                ?>

				                                                <li class="clearfix">
				                                                    <span class="pull-left"><?php if($vehicle_rent_price_set_item['period'] == 1) { echo "24"; echo " "; echo esc_html_e('hours', 'autoroyal'); } else { echo esc_attr($vehicle_rent_price_set_item['period']); echo "+ "; echo esc_html_e('days', 'autoroyal'); } ?></span>
				                                                    <span class="pull-right">
				                                                        <b><?php echo autoroyal_clean_price($vehicle_rent_price_set_item['price']); ?></b>
				                                                    </span>
				                                                </li>

				                                                <?php

				                                            }

				                                        }

				                                    }

				                                ?>

				                            </ul>

				                        </div>

									</div>

								</div>

							</div>

						</div>
						<!-- End List View -->

					<?php endforeach; ?>
				<?php endif; ?>

			</div>

		</div>

		<?php if( $show_filter == 1 AND $args['filter'] == 'vertical_left' ) { ?>

			</div>

		</div> 

		<?php } ?>

	</div>

</div>
