<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
	
	$action = "";
	if ( isset( $_GET['action'] ) ) {
        $action = $_GET['action'];
    }

    if( empty($car_id) AND isset( $_GET['car_id']) ) {
    	$car_id = $_GET['car_id'];
    }

    if( $action == "duplicate" OR $action == "edit" ) {

	    if ( ! autoroyal_user_can_edit_car( $car_id ) ) {

	    	echo "<div class='car-manager-error'>" . __( 'Invalid ID', 'autoroyal' ) . "</div>";

	    } else {

	    	autoroyal_load_submit_form( $car_id );

	    }

	} else {

		autoroyal_load_submit_form( $car_id );

	}

	wp_enqueue_script( 'jquery-ui-sortable' );

?>

<?php function autoroyal_load_submit_form( $car_id ) { ?>

<div id="autoroyal-submit">
	
	<?php

        if(!empty($car_id)) {

        	$vehicle_manually = esc_attr(get_post_meta($car_id, 'vehicle_manually',true));

        	$vehicle_year = esc_attr(get_post_meta($car_id, 'vehicle_year',true));
			$vehicle_make = esc_attr(get_post_meta($car_id, 'vehicle_make',true));
			$vehicle_model = esc_attr(get_post_meta($car_id, 'vehicle_model',true));
			$vehicle_trim_id = esc_attr(get_post_meta($car_id, 'vehicle_trim_id',true));
			$vehicle_trim_desc_init = esc_attr(get_post_meta($car_id, 'vehicle_trim_desc_init',true));
			$vehicle_make_desc_init = esc_attr(get_post_meta($car_id, 'vehicle_make_desc_init',true));

			$vehicle_condition = esc_attr(get_post_meta($car_id, 'vehicle_condition',true));
			$vehicle_mileage = esc_attr(get_post_meta($car_id, 'vehicle_mileage',true));
			$vehicle_condition_num = esc_attr(get_post_meta($car_id, 'vehicle_condition_num',true));
			$vehicle_owners = esc_attr(get_post_meta($car_id, 'vehicle_owners',true));
			$vehicle_accident_free = esc_attr(get_post_meta($car_id, 'vehicle_accident_free',true));
			$vehicle_service_history = esc_attr(get_post_meta($car_id, 'vehicle_service_history',true));
			$vehicle_vin = esc_attr(get_post_meta($car_id, 'vehicle_vin',true));
			$vehicle_stock = esc_attr(get_post_meta($car_id, 'vehicle_stock',true));
			$vehicle_carfax_link = esc_attr(get_post_meta($car_id, 'vehicle_carfax_link',true));
			$vehicle_autocheck_link = esc_attr(get_post_meta($car_id, 'vehicle_autocheck_link',true));
			$vehicle_pre_owned = esc_attr(get_post_meta($car_id, 'vehicle_pre_owned',true));

			$vehicle_metalic_paint = esc_attr(get_post_meta($car_id, 'vehicle_metalic_paint',true));
			$vehicle_body_style = esc_attr(get_post_meta($car_id, 'vehicle_body_style',true));
			$vehicle_navigation = esc_attr(get_post_meta($car_id, 'vehicle_navigation',true));
			$vehicle_ac = esc_attr(get_post_meta($car_id, 'vehicle_ac',true));

			$vehicle_description = get_post_field('post_content', $car_id);

			$vehicle_engine_volume_l = esc_attr(get_post_meta($car_id, 'vehicle_engine_volume_l',true));
			$vehicle_engine_volume_ccm = esc_attr(get_post_meta($car_id, 'vehicle_engine_volume_ccm',true));
			$vehicle_engine_position = esc_attr(get_post_meta($car_id, 'vehicle_engine_position',true));
			$vehicle_cilinders = esc_attr(get_post_meta($car_id, 'vehicle_cilinders',true));
			$vehicle_engine_type = esc_attr(get_post_meta($car_id, 'vehicle_engine_type',true));
			$vehicle_power_hp = esc_attr(get_post_meta($car_id, 'vehicle_power_hp',true));
			$vehicle_power_kw = esc_attr(get_post_meta($car_id, 'vehicle_power_kw',true));
			$vehicle_max_power_rpm = esc_attr(get_post_meta($car_id, 'vehicle_max_power_rpm',true));
			$vehicle_torque_nm = esc_attr(get_post_meta($car_id, 'vehicle_torque_nm',true));
			$vehicle_max_torque_rpm = esc_attr(get_post_meta($car_id, 'vehicle_max_torque_rpm',true));
			$vehicle_gears_num = esc_attr(get_post_meta($car_id, 'vehicle_gears_num',true));
			$vehicle_accel_0_100 = esc_attr(get_post_meta($car_id, 'vehicle_accel_0_100',true));

			$vehicle_consumption_combined = esc_attr(get_post_meta($car_id, 'vehicle_consumption_combined',true));
			$vehicle_consumption_urban = esc_attr(get_post_meta($car_id, 'vehicle_consumption_urban',true));
			$vehicle_consumption_highway = esc_attr(get_post_meta($car_id, 'vehicle_consumption_highway',true));
			$vehicle_emissions = esc_attr(get_post_meta($car_id, 'vehicle_emissions',true));
			$vehicle_emission_class = esc_attr(get_post_meta($car_id, 'vehicle_emission_class',true));
			$vehicle_fuel_tank = esc_attr(get_post_meta($car_id, 'vehicle_fuel_tank',true));

			$vehicle_length = esc_attr(get_post_meta($car_id, 'vehicle_length',true));
			$vehicle_width = esc_attr(get_post_meta($car_id, 'vehicle_width',true));
			$vehicle_height = esc_attr(get_post_meta($car_id, 'vehicle_height',true));
			$vehicle_wheelbase = esc_attr(get_post_meta($car_id, 'vehicle_wheelbase',true));
			$vehicle_weight = esc_attr(get_post_meta($car_id, 'vehicle_weight',true));

			$vehicle_wheel_size = wp_kses(get_post_meta($car_id, 'vehicle_wheel_size', true), true);

			$vehicle_location = get_categories( array('taxonomy' => 'vehicle_location', 'hide_empty' => false,  'parent' => 0) );

			$vehicle_acquisition_price = esc_attr(get_post_meta($car_id, 'vehicle_acquisition_price',true));
			$vehicle_retail_price = esc_attr(get_post_meta($car_id, 'vehicle_retail_price',true));
			$vehicle_discounted_price = esc_attr(get_post_meta($car_id, 'vehicle_discounted_price',true));
			$vehicle_discount = esc_attr(get_post_meta($car_id, 'vehicle_discount',true));

			$vehicle_image_gallery = get_post_meta($car_id, 'vehicle_image_gallery',true);

			$vehicle_expenses = get_post_meta($car_id, 'vehicle_expenses',true);

			// Rent Options
			$vehicle_rent_price_set = get_post_meta($car_id, 'vehicle_rent_price_set',true);
			$rent_deposit = get_post_meta($car_id, 'rent_deposit',true);
			$mileage_limit = get_post_meta($car_id, 'mileage_limit',true);

        } else {

        	$vehicle_manually = "";

        	$vehicle_year = "";
			$vehicle_make = "";
			$vehicle_model = "";
			$vehicle_trim_id = "";
			$vehicle_trim_desc_init = "";
			$vehicle_make_desc_init = "";

			$vehicle_condition = "";
			$vehicle_mileage = "";
			$vehicle_condition_num = "";
			$vehicle_owners = "";
			$vehicle_accident_free = "";
			$vehicle_service_history = "";
			$vehicle_vin = "";
			$vehicle_stock = "";
			$vehicle_carfax_link = "";
			$vehicle_autocheck_link = "";
			$vehicle_pre_owned = "";

			$vehicle_metalic_paint = "";
			$vehicle_body_style = "";
			$vehicle_navigation = "";
			$vehicle_ac = "";

			$vehicle_description = "";

			$vehicle_engine_volume_l = "";
			$vehicle_engine_volume_ccm = "";
			$vehicle_engine_position = "";
			$vehicle_cilinders = "";
			$vehicle_engine_type = "";
			$vehicle_power_hp = "";
			$vehicle_power_kw = "";
			$vehicle_max_power_rpm = "";
			$vehicle_torque_nm = "";
			$vehicle_max_torque_rpm = "";
			$vehicle_gears_num = "";
			$vehicle_accel_0_100 = "";

			$vehicle_consumption_combined = "";
			$vehicle_consumption_urban = "";
			$vehicle_consumption_highway = "";
			$vehicle_emissions = "";
			$vehicle_emission_class = "";
			$vehicle_fuel_tank = "";

			$vehicle_length = "";
			$vehicle_width = "";
			$vehicle_height = "";
			$vehicle_wheelbase = "";
			$vehicle_weight = "";

			$vehicle_wheel_size = "";

			$vehicle_location = get_categories( array('taxonomy' => 'vehicle_location', 'hide_empty' => false,  'parent' => 0) );

			$vehicle_acquisition_price = "";
			$vehicle_retail_price = "";
			$vehicle_discounted_price = "";
			$vehicle_discount = "";

			$vehicle_image_gallery = "";

			$vehicle_expenses = "";

			$vehicle_rent_price_set = "";
			$rent_deposit = "";
			$mileage_limit = "";

        }

	?>

	<form action="<?php echo get_permalink(); ?>?action=edit&car_id=<?php echo esc_attr($car_id); ?>" method="post" id="submit-autoroyal-form" class="autoroyal-form" enctype="multipart/form-data">

		<input id="vehicle_year_init" type="hidden" name="vehicle_year_init" value="<?php echo esc_attr($vehicle_year); ?>" />
		<input id="vehicle_make_init" type="hidden" name="vehicle_make_init" value="<?php echo esc_attr($vehicle_make); ?>" />
		<input id="vehicle_model_init" type="hidden" name="vehicle_model_init" value="<?php echo esc_attr($vehicle_model); ?>" />
		<input id="vehicle_trim_id_init" type="hidden" name="vehicle_trim_id_init" value="<?php echo esc_attr($vehicle_trim_id); ?>" />
		<input id="vehicle_trim_desc_init" type="hidden" name="vehicle_trim_desc_init" value="<?php echo esc_attr($vehicle_trim_desc_init); ?>" />
		<input id="vehicle_make_desc_init" type="hidden" name="vehicle_make_desc_init" value="<?php echo esc_attr($vehicle_make_desc_init); ?>" />

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Car Info', 'autoroyal' ); ?></h2>

			<fieldset class="select-add-car-type">

				<div class="show-hide-drop-wrapper">

                    <div class="custom-control custom-switch mb-4 float-right">
                        <input type="checkbox" class="custom-control-input" id="showDropOffLocation" name="add-car-manually" value="selectManually" <?php if( $vehicle_manually == "selectManually" ) { echo "checked"; } ?>>
                        <label class="custom-control-label text-muted" for="showDropOffLocation"><?php esc_html_e('Add car details manually', 'autoroyal' ); ?></label>
                    </div>

                </div>

            </fieldset>

            <fieldset class="add-car-manually" <?php if( $vehicle_manually == "selectManually" ) { echo "style='display: block;'"; } ?>>

            	<div class="row">

            		<div class="col-12 col-md-6 col-lg-3">

            			<label for="cq-make-manually" class="control-label"><?php esc_html_e('Make', 'autoroyal' ); ?></label>
						<input type="text" id="cq-make-manually" name="cq-make-manually" value="<?php echo esc_attr($vehicle_make_desc_init); ?>" placeholder="">

            		</div>

            		<div class="col-12 col-md-6 col-lg-3">

            			<label for="cq-model-manually" class="control-label"><?php esc_html_e('Model', 'autoroyal' ); ?></label>
						<input type="text" id="cq-model-manually" name="cq-model-manually" value="<?php echo esc_attr($vehicle_model); ?>" placeholder="">

            		</div>

            		<div class="col-12 col-md-6 col-lg-3">

            			<label for="cq-year-manually" class="control-label"><?php esc_html_e('Year', 'autoroyal' ); ?></label>
						<input type="text" id="cq-year-manually" name="cq-year-manually" value="<?php echo esc_attr($vehicle_year); ?>" placeholder="">

            		</div>

            		<div class="col-12 col-md-6 col-lg-3">

            			<label for="cq-trim-manually" class="control-label"><?php esc_html_e('Trim', 'autoroyal' ); ?></label>
						<input type="text" id="cq-trim-manually" name="cq-trim-manually" value="<?php echo esc_attr($vehicle_trim_desc_init); ?>" placeholder="">

            		</div>

            	</div>

            </fieldset>

			<fieldset class="select-car-model-table" <?php if( $vehicle_manually == "selectManually" ) { echo "style='display: none;'"; } ?>>
				
				<table id="select-car-model">

					<tbody>

						<tr valign="bottom">
							<th><?php esc_html_e('Make', 'autoroyal' ); ?></th>
							<th><?php esc_html_e('Model', 'autoroyal' ); ?></th>
							<th><?php esc_html_e('Year', 'autoroyal' ); ?></th>
							<th><?php esc_html_e('Trim', 'autoroyal' ); ?></th>
						</tr>

						<tr>

							<td>
								<select name="cq-make" id="cq-make" class="cq-make"></select>
							</td>

							<td>
								<select name="cq-model" id="cq-model" class="cq-model" <?php if(empty($vehicle_model)) { ?>disabled<?php } ?>></select>
							</td>

							<td>
								<select name="cq-year" id="cq-year" class="cq-year" <?php if(empty($vehicle_year)) { ?>disabled<?php } ?>></select>
							</td>

							<td>
								<select name="cq-trim" id="cq-trim" class="cq-trim" <?php if(empty($vehicle_trim_id)) { ?>disabled<?php } ?>></select>
							</td>

						</tr>

					</tbody>

				</table>

				<div class="row">

					<div class="col-md-12">

						<a href="#" id="cq-show-data"><?php esc_html_e('Populate car details', 'autoroyal' ); ?></a>

					</div>

				</div>
				
			</fieldset>

		</div>	<!-- end review_options_pop -->

		<?php

			$website_type = get_option("autoroyal_webiste_type");
  			if( !empty($website_type) ) {
  				if( $website_type == "rentals" OR $website_type == "rentals_dealer" ) {

		?>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Rent Options', 'autoroyal' ); ?></h2>

			<fieldset>

				<h2 class="autoroyal-subtitle"><span><?php esc_html_e('Rent Price Sets', 'autoroyal' ); ?></span></h2>

				<div class="autoroyal-price-set-wrapper">

					<?php 

						$i = 0;

						if(!empty($vehicle_rent_price_set)) {

							foreach ($vehicle_rent_price_set as $vehicle_rent_price_set_item) {
								
								if( !empty($vehicle_rent_price_set_item['period']) AND !empty($vehicle_rent_price_set_item['price']) ) {

									$i++;

					?>

					<div class="row price-set" set-id="<?php echo esc_attr($i); ?>">

						<div class="col-lg-4 col-md-6">

							<label for="price_set_period" class="control-label"><?php esc_html_e('Period in days', 'autoroyal' ); ?> (<?php esc_html_e('only digits', 'autoroyal' ); ?>)</label>
							<input type="text" id="price_set_period" name="price_set[<?php echo esc_attr($i); ?>][period]" value="<?php echo esc_attr($vehicle_rent_price_set_item['period']); ?>" placeholder="1">

						</div>

						<div class="col-lg-4 col-md-6">

							<label for="price_set_price" class="control-label"><?php esc_html_e('Price', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
							<input type="text" id="price_set_price" name="price_set[<?php echo esc_attr($i); ?>][price]" value="<?php echo esc_attr($vehicle_rent_price_set_item['price']); ?>" placeholder="150">

						</div>

						<div class="col-lg-3 col-md-6">
						
							<a class="delete-price-period" href="#"><?php esc_html_e('Delete', 'autoroyal' ); ?></a>

						</div>

					</div>

					<?php } } } else { ?>

					<div class="row price-set" set-id="0">

						<div class="col-lg-4 col-md-6">

							<label for="price_set_period" class="control-label"><?php esc_html_e('Period in days', 'autoroyal' ); ?> (<?php esc_html_e('only digits', 'autoroyal' ); ?>)</label>
							<input type="text" id="price_set_period" name="price_set[0][period]" value="" placeholder="1">

						</div>

						<div class="col-lg-4 col-md-6">

							<label for="price_set_price" class="control-label"><?php esc_html_e('Price', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
							<input type="text" id="price_set_price" name="price_set[0][price]" value="" placeholder="150">

						</div>

						<div class="col-lg-3 col-md-6">
						
							<a class="delete-price-period" href="#"><?php esc_html_e('Delete', 'autoroyal' ); ?></a>

						</div>

					</div>

					<?php } ?>

				</div>

				<div class="row full-width">

					<div class="col-lg-3 col-md-6">

						<a class="add-new-price-period" href="#"><?php esc_html_e('Add new price set', 'autoroyal' ); ?></a>

					</div>

				</div>

				<div class="row price-set clean-price-set hidden" set-id="">

					<div class="col-lg-4 col-md-6">

						<label for="price_set_period" class="control-label"><?php esc_html_e('Period in days', 'autoroyal' ); ?> (<?php esc_html_e('only digits', 'autoroyal' ); ?>)</label>
						<input type="text" id="price_set_period" name="" value="" placeholder="1">

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="price_set_price" class="control-label"><?php esc_html_e('Price', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
						<input type="text" id="price_set_price" name="" value="" placeholder="150">

					</div>

					<div class="col-lg-3 col-md-6">
					
						<a class="delete-price-period" href="#"><?php esc_html_e('Delete', 'autoroyal' ); ?></a>

					</div>

				</div>

			</fieldset>

			<fieldset>

				<div class="row">

					<div class="col-md-12">
			
						<h2 class="autoroyal-subtitle"><span><?php esc_html_e('Requirements', 'autoroyal' ); ?></span></h2>

					</div>

					<div class="col-md-12 autoroyal-style-margin-bottom-30">

						<div class="row">

							<div class="col-lg-4 col-md-6">

								<label for="rent_deposit" class="control-label"><?php esc_html_e('Deposit', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
								<input type="text" id="rent_deposit" name="rent_deposit" value="<?php echo esc_attr($rent_deposit); ?>" placeholder="300">

							</div>

							<div class="col-lg-4 col-md-6">

								<label for="minimum_age" class="control-label"><?php esc_html_e('Minimum age', 'autoroyal' ); ?></label>
								<select name="vehicle_rent_age" id="vehicle_rent_age">

									<?php

										$terms_cat = get_the_terms($car_id, 'vehicle_rent_age' );
										$terms_slug_str_cat = "";
										if ($terms_cat && ! is_wp_error($terms_cat)) :
											$term_slugs_arr_cat = array();
												foreach ($terms_cat as $term_cat) {
													$term_slugs_arr_cat[] = $term_cat->slug;
												}
											$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
										endif;

										$categories = get_categories( array('taxonomy' => 'vehicle_rent_age', 'hide_empty' => false,  'parent' => 0) );

										foreach ($categories as $category) {
											$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
											$option .= $category->cat_name;
											$option .= '</option>';

											$catID = $category->term_id;

											$categories_child = get_categories( array('taxonomy' => 'vehicle_rent_age', 'hide_empty' => false,  'parent' => $catID) );

											foreach ($categories_child as $category_child) {
												$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
												$option .= $category_child->cat_name;
												$option .= '</option>';

											}

											echo $option;
										}

									?>
									
								</select>

							</div>

							<div class="col-lg-4 col-md-6">

								<label for="mileage_limit" class="control-label"><?php esc_html_e('Mileage limit', 'autoroyal' ); ?> (<?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?>)</label>
								<input type="text" id="mileage_limit" name="mileage_limit" value="<?php echo esc_attr($mileage_limit); ?>" placeholder="600">

							</div>
						
						</div>

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<?php } } ?>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Price', 'autoroyal' ); ?></h2>

			<fieldset>

				<div class="row">

					<div class="col-lg-4 col-md-6">

						<label for="vehicle_acquisition_price" class="control-label"><?php esc_html_e('Acquisition Price', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); }  echo " - "; ?><?php esc_html_e('not public', 'autoroyal' ); ?>)</label>
						<input type="text" id="vehicle_acquisition_price" name="vehicle_acquisition_price" value="<?php echo esc_attr($vehicle_acquisition_price); ?>" placeholder="15000" />

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="vehicle_retail_price" class="control-label"><?php esc_html_e('Retail Price', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
						<input type="text" id="vehicle_retail_price" name="vehicle_retail_price" value="<?php echo esc_attr($vehicle_retail_price); ?>" placeholder="20000" />

					</div>

					<div class="col-lg-4 col-md-6 autoroyal-checkbox-field">

						<input type="checkbox" id="vehicle_discount" name="vehicle_discount" <?php if($vehicle_discount == "on") { echo "checked"; } ?>>
						<label for="vehicle_discount"><?php esc_html_e('Make a discount?', 'autoroyal' ); ?></label>

					</div>

					<div class="ol-lg-4 col-md-6 new-discounted-price">

						<label for="vehicle_discounted_price" class="control-label"><?php esc_html_e('New Retail Price', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
						<input type="text" id="vehicle_discounted_price" name="vehicle_discounted_price" value="<?php echo esc_attr($vehicle_discounted_price); ?>" placeholder="19000" />

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Condition', 'autoroyal' ); ?></h2>

			<fieldset>

				<div class="row">

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_condition" class="control-label"><?php esc_html_e('Condition', 'autoroyal' ); ?></label>
						<select name="vehicle_condition" id="vehicle_condition">

							<option value="New" <?php selected( $vehicle_condition, 'New' ); ?>><?php esc_html_e('New', 'autoroyal' ); ?></option>
							<option value="Used" <?php selected( $vehicle_condition, 'Used' ); ?>><?php esc_html_e('Used', 'autoroyal' ); ?></option>

						</select>

					</div>

				</div>

			</fieldset>

			<fieldset>

				<div class="show-hide-condition">

					<div class="row pt30">

						<div class="col-lg-3 col-md-6">

							<label for="vehicle_mileage" class="control-label"><?php esc_html_e('Mileage', 'autoroyal' ); ?> (<?php $unit_system = get_option( 'autoroyal_measurement_type' ); if( empty($unit_system) OR $unit_system == "metric") { echo "Km"; } else { echo "Mi"; } ?>)</label>
							<input type="text" id="vehicle_mileage" class="" name="vehicle_mileage" value="<?php echo esc_attr($vehicle_mileage); ?>" placeholder="2000" />

						</div>

						<div class="col-lg-3 col-md-6">

							<label for="vehicle_condition_num" class="control-label"><?php esc_html_e('Condition (0 - 100)', 'autoroyal' ); ?></label>
							<select name="vehicle_condition_num" id="vehicle_condition_num">

								<?php for($i = 100; $i >= 0; --$i) { ?>
									<option value="<?php echo esc_attr($i); ?>" <?php selected( $i, $vehicle_condition_num ); ?>><?php echo esc_attr($i); ?></option>
								<?php } ?>
								
							</select>

						</div>

						<div class="col-lg-3 col-md-6">

							<label for="vehicle_owners" class="control-label"><?php esc_html_e('Owners (number)', 'autoroyal' ); ?></label>
							<select name="vehicle_owners" id="vehicle_owners">

								<?php for($i = 0; $i <= 20; ++$i) { ?>
									<option value="<?php echo esc_attr($i); ?>" <?php selected( $i, $vehicle_owners ); ?>><?php echo esc_attr($i); ?></option>
								<?php } ?>
								
							</select>

						</div>

						<div class="col-md-3 autoroyal-checkbox-field">

							<input type="checkbox" name="vehicle_accident_free" <?php if($vehicle_accident_free == "on") { echo "checked"; } ?>>
							<label for="vehicle_accident_free"><?php esc_html_e('Accident Free', 'autoroyal' ); ?></label>

						</div>

						<div class="col-md-3 autoroyal-checkbox-field">

							<input type="checkbox" name="vehicle_service_history" <?php if($vehicle_service_history == "on") { echo "checked"; } ?>>
							<label for="vehicle_service_history"><?php esc_html_e('Service History', 'autoroyal' ); ?></label>

						</div>

					</div>

				</div>

				<div class="row pt30">

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_stock" class="control-label"><?php esc_html_e('Stock #', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_stock" name="vehicle_stock" value="<?php echo esc_attr($vehicle_stock); ?>" placeholder="" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_vin" class="control-label"><?php esc_html_e('VIN Number', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_vin" name="vehicle_vin" value="<?php echo esc_attr($vehicle_vin); ?>" placeholder="" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_carfax_link" class="control-label"><?php esc_html_e('Carfax Link', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_carfax_link" name="vehicle_carfax_link" value="<?php echo esc_attr($vehicle_carfax_link); ?>" placeholder="http://www.carfax.com/" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_autocheck_link" class="control-label"><?php esc_html_e('AutoCheck Link', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_autocheck_link" name="vehicle_autocheck_link" value="<?php echo esc_attr($vehicle_autocheck_link); ?>" placeholder="http://www.autocheck.com/" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_pre_owned" class="control-label"><?php esc_html_e('Certified Pre Owned Label', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_pre_owned" name="vehicle_pre_owned" value="<?php echo esc_attr($vehicle_pre_owned); ?>" placeholder="#" />

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Characteristics', 'autoroyal' ); ?></h2>

			<fieldset>

				<div class="row">

					<div class="col-md-12">

						<label for="vehicle_exterior_color" class="control-label"><?php esc_html_e('Exterior color', 'autoroyal' ); ?></label>

						<?php

							$terms_slug_str_cat = "";

							$terms_cat = get_the_terms($car_id, 'vehicle_exterior_color' );
							if ($terms_cat && ! is_wp_error($terms_cat)) :
								$term_slugs_arr_cat = array();
									foreach ($terms_cat as $term_cat) {
										$term_slugs_arr_cat[] = $term_cat->term_id;
									}
								$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
							endif;

							$categories = get_categories( array('taxonomy' => 'vehicle_exterior_color', 'hide_empty' => false,  'parent' => 0, 'orderby' => 'id', 'order' => 'ASC') );

							foreach ($categories as $category) {

								$color      = autoroyal_get_term_color( $category->term_id, true );
								$color_id   = $category->term_id;
								$color_name = $category->cat_name;
								$color_type = get_term_meta( $category->term_id, 'color_type', true );

								?>

									<label class="control control--checkbox">
								      	<input type="radio" class="autoroyal-select-color" name="radio" value="<?php echo esc_attr($category->term_id); ?>" <?php if($color_id == $terms_slug_str_cat) { ?>checked="checked"<?php } ?>/>
								      	<?php if($color_type == "combined") { ?>
											<div class="control__indicator car_combined_color"></div>
								      	<?php } elseif($color_type == "na") { ?>
											<div class="control__indicator car_na_color"><?php echo esc_attr($color_name); ?></div>
								      	<?php } else { ?>
								      		<div class="control__indicator" style="background-color: <?php echo esc_attr($color); ?>"></div>
								      	<?php } ?>
								      	<span class="tooltiptext"><?php echo esc_attr($color_name); ?></span>
								    </label>

								<?php
							}

						?>

						<input type="hidden" id="vehicle_exterior_color" name="vehicle_exterior_color" value="<?php echo esc_attr($terms_slug_str_cat); ?>"/>

					</div>

					<div class="col-lg-4 col-md-6 autoroyal-checkbox-field">

						<input type="checkbox" name="vehicle_metalic_paint" <?php if($vehicle_metalic_paint == "on") { echo "checked"; } ?>>
						<label for="vehicle_metalic_paint"><?php esc_html_e('Metalic Paint', 'autoroyal' ); ?></label>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="vehicle_body_style" class="control-label"><?php esc_html_e('Body Style', 'autoroyal' ); ?></label>
						<select name="vehicle_body_style" id="vehicle_body_style">

							<?php

								$terms_cat = get_the_terms($car_id, 'vehicle_body_style' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'vehicle_body_style', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'vehicle_body_style', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>
							
						</select>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="vehicle_doors" class="control-label"><?php esc_html_e('Doors', 'autoroyal' ); ?></label>
						<select name="vehicle_doors" id="vehicle_doors">

							<?php

								$terms_cat = get_the_terms($car_id, 'vehicle_doors' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'vehicle_doors', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'vehicle_doors', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>
							
						</select>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="vehicle_seats" class="control-label"><?php esc_html_e('Seats', 'autoroyal' ); ?></label>
						<select name="vehicle_seats" id="vehicle_seats">

							<?php

								$terms_cat = get_the_terms($car_id, 'vehicle_seats' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'vehicle_seats', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'vehicle_seats', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>
							
						</select>

					</div>

					<div class="col-lg-4 col-md-6">

							<label for="vehicle_luggage" class="control-label"><?php esc_html_e('Suitcases', 'autoroyal' ); ?></label>
							<select name="vehicle_luggages" id="vehicle_luggages">

								<?php

									$terms_cat = get_the_terms($car_id, 'vehicle_luggages' );
									if ($terms_cat && ! is_wp_error($terms_cat)) :
										$term_slugs_arr_cat = array();
											foreach ($terms_cat as $term_cat) {
												$term_slugs_arr_cat[] = $term_cat->slug;
											}
										$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
									endif;

									$categories = get_categories( array('taxonomy' => 'vehicle_luggages', 'hide_empty' => false,  'parent' => 0) );

									foreach ($categories as $category) {
										$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
										$option .= $category->cat_name;
										$option .= '</option>';

										$catID = $category->term_id;

										$categories_child = get_categories( array('taxonomy' => 'vehicle_luggages', 'hide_empty' => false,  'parent' => $catID) );

										foreach ($categories_child as $category_child) {
											$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
											$option .= $category_child->cat_name;
											$option .= '</option>';

										}

										echo $option;
									}

								?>
								
							</select>

						</div>

					<div class="col-lg-4 col-md-6 autoroyal-checkbox-field">

						<input type="checkbox" name="vehicle_navigation" <?php if($vehicle_navigation == "on") { echo "checked"; } ?>>
						<label for="vehicle_navigation"><?php esc_html_e('Navigation Included', 'autoroyal' ); ?></label>

					</div>

					<div class="col-lg-4 col-md-6 autoroyal-checkbox-field">

						<input type="checkbox" name="vehicle_ac" <?php if($vehicle_ac == "on") { echo "checked"; } ?>>
						<label for="vehicle_ac"><?php esc_html_e('Air Conditioning Included', 'autoroyal' ); ?></label>

					</div>

				</div>

			</fieldset>

			<fieldset>

				<div class="row">

					<div class="col-md-12">

						<label for="vehicle_interior_color" class="control-label"><?php esc_html_e('Interior color', 'autoroyal' ); ?></label>

						<?php

							$terms_slug_str_cat = "";

							$terms_cat = get_the_terms($car_id, 'vehicle_interior_color' );
							if ($terms_cat && ! is_wp_error($terms_cat)) :
								$term_slugs_arr_cat = array();
									foreach ($terms_cat as $term_cat) {
										$term_slugs_arr_cat[] = $term_cat->term_id;
									}
								$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
							endif;

							$categories = get_categories( array('taxonomy' => 'vehicle_interior_color', 'hide_empty' => false,  'parent' => 0, 'orderby' => 'id', 'order' => 'ASC') );

							foreach ($categories as $category) {

								$color      = autoroyal_get_term_color( $category->term_id, true );
								$color_id   = $category->term_id;
								$color_name = $category->cat_name;
								$color_type = get_term_meta( $category->term_id, 'color_type', true );

								?>

									<label class="control control--checkbox">
								      	<input type="radio" class="autoroyal-select-interior-color" name="radio-int" value="<?php echo esc_attr($category->term_id); ?>" <?php if($color_id == $terms_slug_str_cat) { ?>checked="checked"<?php } ?>/>
								      	<?php if($color_type == "combined") { ?>
											<div class="control__indicator car_combined_color"></div>
								      	<?php } elseif($color_type == "na") { ?>
											<div class="control__indicator car_na_color"><?php echo esc_attr($color_name); ?></div>
								      	<?php } else { ?>
								      		<div class="control__indicator" style="background-color: <?php echo esc_attr($color); ?>"></div>
								      	<?php } ?>
								      	<span class="tooltiptext"><?php echo esc_attr($color_name); ?></span>
								    </label>

								<?php
							}

						?>

						<input type="hidden" id="vehicle_interior_color" name="vehicle_interior_color" value="<?php echo esc_attr($terms_slug_str_cat); ?>"/>

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="Interior materials" class="control-label"><?php esc_html_e('Interior materials', 'autoroyal' ); ?></label>
						<select name="vehicle_interior_material" id="vehicle_interior_material">

							<?php

								$terms_cat = get_the_terms($car_id, 'vehicle_interior_material' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'vehicle_interior_material', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'vehicle_interior_material', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>

						</select>

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Description', 'autoroyal' ); ?></h2>

			<fieldset>

				<div class="row">

					<div class="col-md-12">

						<?php 

                        	$content = $vehicle_description;
							$editor_id = 'vehicle_description';
							$settings =   array(
							    'wpautop' => true, // use wpautop?
							    'media_buttons' => false, // show insert/upload button(s)
							    'textarea_name' => $editor_id, // set the textarea name to something different, square brackets [] can be used here
							    'textarea_rows' => get_option('default_post_edit_rows', 10), // rows="..."
							    'tabindex' => '',
							    'editor_css' => '', //  extra styles for both visual and HTML editors buttons, 
							    'editor_class' => '', // add extra class(es) to the editor textarea
							    'teeny' => false, // output the minimal editor config used in Press This
							    'dfw' => false, // replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4)
							    'tinymce' => true, // load TinyMCE, can be used to pass settings directly to TinyMCE using an array()
							    'quicktags' => true, // load Quicktags, can be used to pass settings directly to Quicktags using an array()
							    'editor_height' => 320,
							);

                        	wp_editor( $content, $editor_id, $settings = array() ); 

                        ?>

					</div>

					<div class="col-md-12 autoroyal-style-margin-bottom-30">
							
						<h2 class="autoroyal-subtitle"><span><?php esc_html_e('Add vehicle to collections', 'autoroyal' ); ?></span></h2>

						<?php

							$categories = get_categories( array('taxonomy' => 'vehicle_collection', 'hide_empty' => false,  'parent' => 0) );

							foreach ($categories as $category) {

							?>

							<div class="autoroyal-checkbox-field-small">

								<input type="checkbox" name="vehicle_collection[]" value="<?php echo esc_attr($category->term_id); ?>" <?php if( has_term( $category->cat_name, 'vehicle_collection', $car_id ) ) { echo "checked"; } ?>>
								<label for="vehicle_collection"><?php echo esc_attr($category->cat_name); ?></label>

							</div>

							<?php

						}

						?>

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Engine and Transmission', 'autoroyal' ); ?></h2>

			<fieldset>

				<div class="row">

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_fuel_type" class="control-label"><?php esc_html_e('Fuel Type', 'autoroyal' ); ?></label>
						<select name="vehicle_fuel_type" id="vehicle_fuel_type">

							<?php

								$terms_cat = get_the_terms($car_id, 'vehicle_fuel_type' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'vehicle_fuel_type', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'vehicle_fuel_type', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>
							
						</select>

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_engine_volume_l" class="control-label"><?php esc_html_e('Engine volume (L)', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_engine_volume_l" name="vehicle_engine_volume_l" value="<?php echo esc_attr($vehicle_engine_volume_l); ?>" placeholder="3.0" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_engine_volume_ccm" class="control-label"><?php esc_html_e('Engine volume (ccm)', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_engine_volume_ccm" name="vehicle_engine_volume_ccm" value="<?php echo esc_attr($vehicle_engine_volume_ccm); ?>" placeholder="2987" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_engine_position" class="control-label"><?php esc_html_e('Engine position', 'autoroyal' ); ?></label>
						<select name="vehicle_engine_position" id="vehicle_engine_position">

							<option value="<?php esc_html_e('Front', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_position, esc_html__('Front', 'autoroyal' ) ); ?>><?php esc_html_e('Front', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Rear', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_position, esc_html__('Rear', 'autoroyal' ) ); ?>><?php esc_html_e('Rear', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Middle', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_position, esc_html__('Middle', 'autoroyal' ) ); ?>><?php esc_html_e('Middle', 'autoroyal' ); ?></option>
							
						</select>

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_cilinders" class="control-label"><?php esc_html_e('Number of cilinders', 'autoroyal' ); ?></label>
						<select name="vehicle_cilinders" id="vehicle_cilinders">
							<option value="<?php esc_html_e('2', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('2', 'autoroyal' ) ); ?>><?php esc_html_e('2', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('3', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('3', 'autoroyal' ) ); ?>><?php esc_html_e('3', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('4', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('4', 'autoroyal' ) ); ?>><?php esc_html_e('4', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('5', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('5', 'autoroyal' ) ); ?>><?php esc_html_e('5', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('6', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('6', 'autoroyal' ) ); ?>><?php esc_html_e('6', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('7', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('7', 'autoroyal' ) ); ?>><?php esc_html_e('7', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('8', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('8', 'autoroyal' ) ); ?>><?php esc_html_e('8', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('9', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('9', 'autoroyal' ) ); ?>><?php esc_html_e('9', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('10', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('10', 'autoroyal' ) ); ?>><?php esc_html_e('10', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('12', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('12', 'autoroyal' ) ); ?>><?php esc_html_e('12', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('14', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('14', 'autoroyal' ) ); ?>><?php esc_html_e('14', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('16', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('16', 'autoroyal' ) ); ?>><?php esc_html_e('16', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('18', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('18', 'autoroyal' ) ); ?>><?php esc_html_e('18', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('20', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('20', 'autoroyal' ) ); ?>><?php esc_html_e('20', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('24', 'autoroyal' ); ?>" <?php selected( $vehicle_cilinders, esc_html__('24', 'autoroyal' ) ); ?>><?php esc_html_e('24', 'autoroyal' ); ?></option>
						</select>

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_power_hp" class="control-label"><?php esc_html_e('Power (hp)', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_power_hp" name="vehicle_power_hp" value="<?php echo esc_attr($vehicle_power_hp); ?>" placeholder="265" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_power_kw" class="control-label"><?php esc_html_e('Power (kw)', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_power_kw" name="vehicle_power_kw" value="<?php echo esc_attr($vehicle_power_kw); ?>" placeholder="265" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_max_power_rpm" class="control-label"><?php esc_html_e('Max Power (RPM)', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_max_power_rpm" name="vehicle_max_power_rpm" value="<?php echo esc_attr($vehicle_max_power_rpm); ?>" placeholder="4500" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_torque_nm" class="control-label"><?php esc_html_e('Torque (Nm)', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_torque_nm" name="vehicle_torque_nm" value="<?php echo esc_attr($vehicle_torque_nm); ?>" placeholder="265" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_max_torque_rpm" class="control-label"><?php esc_html_e('Max Torque (RPM)', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_max_torque_rpm" name="vehicle_max_torque_rpm" value="<?php echo esc_attr($vehicle_max_torque_rpm); ?>" placeholder="4500" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_engine_type" class="control-label"><?php esc_html_e('Engine type', 'autoroyal' ); ?></label>
						<select name="vehicle_engine_type" id="vehicle_engine_type">
							<option value="<?php esc_html_e('V', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_type, esc_html__('V', 'autoroyal' ) ); ?>><?php esc_html_e('V', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Inline', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_type, esc_html__('Inline', 'autoroyal' ) ); ?>><?php esc_html_e('Inline', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Flat', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_type, esc_html__('Flat', 'autoroyal' ) ); ?>><?php esc_html_e('Flat', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('W', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_type, esc_html__('W', 'autoroyal' ) ); ?>><?php esc_html_e('W', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('H', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_type, esc_html__('H', 'autoroyal' ) ); ?>><?php esc_html_e('H', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('U', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_type, esc_html__('U', 'autoroyal' ) ); ?>><?php esc_html_e('U', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Square four', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_type, esc_html__('Square four', 'autoroyal' ) ); ?>><?php esc_html_e('Square four', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('VR', 'autoroyal' ); ?>" <?php selected( $vehicle_engine_type, esc_html__('VR', 'autoroyal' ) ); ?>><?php esc_html_e('VR', 'autoroyal' ); ?></option>
						</select>

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_transmission" class="control-label"><?php esc_html_e('Transmission', 'autoroyal' ); ?></label>
						<select name="vehicle_transmission" id="vehicle_transmission">

							<?php

								$terms_cat = get_the_terms($car_id, 'vehicle_transmission' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'vehicle_transmission', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'vehicle_transmission', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>
							
						</select>

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_gears_num" class="control-label"><?php esc_html_e('Number of gears', 'autoroyal' ); ?></label>
						<select name="vehicle_gears_num" id="vehicle_gears_num">

							<?php for($i = 0; $i <= 24; ++$i) { ?>
								<option value="<?php echo esc_attr($i); ?>" <?php selected( $i, $vehicle_gears_num ); ?>><?php echo esc_attr($i); ?></option>
							<?php } ?>
							
						</select>

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_drive" class="control-label"><?php esc_html_e('Drive', 'autoroyal' ); ?></label>
						<select name="vehicle_drive" id="vehicle_drive">

							<?php

								$terms_cat = get_the_terms($car_id, 'vehicle_drive' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								$categories = get_categories( array('taxonomy' => 'vehicle_drive', 'hide_empty' => false,  'parent' => 0) );

								foreach ($categories as $category) {
									$option = '<option value="'.$category->term_id.'" '. selected( $terms_slug_str_cat, $category->slug ) .' >';
									$option .= $category->cat_name;
									$option .= '</option>';

									$catID = $category->term_id;

									$categories_child = get_categories( array('taxonomy' => 'vehicle_drive', 'hide_empty' => false,  'parent' => $catID) );

									foreach ($categories_child as $category_child) {
										$option .= '<option value="'.$category_child->term_id.'" '. selected( $terms_slug_str_cat, $category_child->slug ) .' > - ';
										$option .= $category_child->cat_name;
										$option .= '</option>';

									}

									echo $option;
								}

							?>
							
						</select>

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_accel_0_100" class="control-label"><?php esc_html_e('0-100km/h accel', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_accel_0_100" name="vehicle_accel_0_100" value="<?php echo esc_attr($vehicle_accel_0_100); ?>" placeholder="6.2" />

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Fuel consumption and emissions', 'autoroyal' ); ?></h2>

			<fieldset>

				<div class="row">

					<div class="col-md-6">

						<label for="vehicle_consumption_combined" class="control-label"><?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('Combined l/100km', 'autoroyal' ); } else { esc_html_e('Combined mpg', 'autoroyal' ); } ?></label>
						<input type="text" id="vehicle_consumption_combined" name="vehicle_consumption_combined" value="<?php echo esc_attr($vehicle_consumption_combined); ?>" placeholder="10.4" />

					</div>

					<div class="col-md-6">

						<label for="vehicle_consumption_urban" class="control-label"><?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('Urban l/100km', 'autoroyal' ); } else { esc_html_e('Urban mpg', 'autoroyal' ); } ?></label>
						<input type="text" id="vehicle_consumption_urban" name="vehicle_consumption_urban" value="<?php echo esc_attr($vehicle_consumption_urban); ?>" placeholder="11" />

					</div>

					<div class="col-md-6">

						<label for="vehicle_consumption_highway" class="control-label"><?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('Highway l/100km', 'autoroyal' ); } else { esc_html_e('Highway mpg', 'autoroyal' ); } ?></label>
						<input type="text" id="vehicle_consumption_highway" name="vehicle_consumption_highway" value="<?php echo esc_attr($vehicle_consumption_highway); ?>" placeholder="8" />

					</div>

					<div class="col-md-6">

						<label for="vehicle_emissions" class="control-label"><?php esc_html_e('Emissions g CO2/km', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_emissions" name="vehicle_emissions" value="<?php echo esc_attr($vehicle_emissions); ?>" placeholder="235" />

					</div>

					<div class="col-md-6">

						<label for="vehicle_emission_class" class="control-label"><?php esc_html_e('Class', 'autoroyal' ); ?></label>
						<select name="vehicle_emission_class" id="vehicle_emission_class">
							<option value="<?php esc_html_e('Euro 6', 'autoroyal' ); ?>" <?php selected( $vehicle_emission_class, esc_html__('Euro 6', 'autoroyal' ) ); ?>><?php esc_html_e('Euro 6', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Euro 5', 'autoroyal' ); ?>" <?php selected( $vehicle_emission_class, esc_html__('Euro 5', 'autoroyal' ) ); ?>><?php esc_html_e('Euro 5', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Euro 4', 'autoroyal' ); ?>" <?php selected( $vehicle_emission_class, esc_html__('Euro 4', 'autoroyal' ) ); ?>><?php esc_html_e('Euro 4', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Euro 3', 'autoroyal' ); ?>" <?php selected( $vehicle_emission_class, esc_html__('Euro 3', 'autoroyal' ) ); ?>><?php esc_html_e('Euro 3', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Euro 2', 'autoroyal' ); ?>" <?php selected( $vehicle_emission_class, esc_html__('Euro 2', 'autoroyal' ) ); ?>><?php esc_html_e('Euro 2', 'autoroyal' ); ?></option>
							<option value="<?php esc_html_e('Euro 1', 'autoroyal' ); ?>" <?php selected( $vehicle_emission_class, esc_html__('Euro 1', 'autoroyal' ) ); ?>><?php esc_html_e('Euro 1', 'autoroyal' ); ?></option>
						</select>

					</div>

					<div class="col-md-6">

						<label for="vehicle_fuel_tank" class="control-label"><?php esc_html_e('Fuel tank', 'autoroyal' ); ?> (<?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('liters', 'autoroyal' ); } else { esc_html_e('gallons', 'autoroyal' ); } ?>)</label>
						<input type="text" id="vehicle_fuel_tank" name="vehicle_fuel_tank" value="<?php echo esc_attr($vehicle_fuel_tank); ?>" placeholder="80" />

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Dimenions and weight', 'autoroyal' ); ?></h2>

			<fieldset>

				<div class="row">

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_length" class="control-label"><?php esc_html_e('Length', 'autoroyal' ); ?> (<?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('mm', 'autoroyal' ); } else { esc_html_e('in', 'autoroyal' ); } ?>)</label>
						<input type="text" id="vehicle_length" name="vehicle_length" value="<?php echo esc_attr($vehicle_length); ?>" placeholder="4636" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_width" class="control-label"><?php esc_html_e('Width', 'autoroyal' ); ?> (<?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('mm', 'autoroyal' ); } else { esc_html_e('in', 'autoroyal' ); } ?>)</label>
						<input type="text" id="vehicle_width" name="vehicle_width" value="<?php echo esc_attr($vehicle_width); ?>" placeholder="2060" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_height" class="control-label"><?php esc_html_e('Height', 'autoroyal' ); ?> (<?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('mm', 'autoroyal' ); } else { esc_html_e('in', 'autoroyal' ); } ?>)</label>
						<input type="text" id="vehicle_height" name="vehicle_height" value="<?php echo esc_attr($vehicle_height); ?>" placeholder="1783" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_wheelbase" class="control-label"><?php esc_html_e('Wheelbase', 'autoroyal' ); ?> (<?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('mm', 'autoroyal' ); } else { esc_html_e('in', 'autoroyal' ); } ?>)</label>
						<input type="text" id="vehicle_wheelbase" name="vehicle_wheelbase" value="<?php echo esc_attr($vehicle_wheelbase); ?>" placeholder="2694" />

					</div>

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_weight" class="control-label"><?php esc_html_e('Weight', 'autoroyal' ); ?> (<?php $measurement_type = get_option( 'autoroyal_measurement_type' ); if($measurement_type == "metric") { esc_html_e('kg', 'autoroyal' ); } else { esc_html_e('lbs', 'autoroyal' ); } ?>)</label>
						<input type="text" id="vehicle_weight" name="vehicle_weight" value="<?php echo esc_attr($vehicle_weight); ?>" placeholder="2987" />

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Vehicle features and specifications', 'autoroyal' ); ?></h2>

			<fieldset>

				<div class="row">

					<div class="col-md-12">

						<div class="row">

							<div class="col-lg-4 col-md-6 autoroyal-style-margin-bottom-30">

								<h2 class="autoroyal-subtitle"><span><?php esc_html_e('Safety', 'autoroyal' ); ?></span></h2>

								<?php

									$categories = get_categories( array('taxonomy' => 'vehicle_safety', 'hide_empty' => false,  'parent' => 0) );

									foreach ($categories as $category) {

									?>

									<div class="autoroyal-checkbox-field-small">

										<input type="checkbox" name="vehicle_safety[]" value="<?php echo esc_attr($category->cat_name); ?>" <?php if( has_term( $category->cat_name, 'vehicle_safety', $car_id ) ) { echo "checked"; } ?>>
										<label for="vehicle_safety"><?php echo esc_attr($category->cat_name); ?></label>

									</div>

									<?php

								}

								?>

							</div>

							<div class="col-lg-4 col-md-6 autoroyal-style-margin-bottom-30">

								<h2 class="autoroyal-subtitle"><span><?php esc_html_e('Comfort', 'autoroyal' ); ?></span></h2>

								<?php

									$categories = get_categories( array('taxonomy' => 'vehicle_comfort', 'hide_empty' => false,  'parent' => 0) );

									foreach ($categories as $category) {

										$catID = $category->term_id;

										$categories_child = get_categories( array('taxonomy' => 'vehicle_comfort', 'hide_empty' => false, 'parent' => $catID, 'orderby' => 'id', 'order' => 'ASC' ) );

									?>

									<div class="autoroyal-checkbox-field-small <?php if(!empty($categories_child)) { ?>autoroyal-checkbox-sub-category<?php } ?>">

										<input type="checkbox" <?php if(!empty($categories_child)) { ?>class="vehicle_comfort_sub_main"<?php } ?> name="vehicle_comfort[]" value="<?php echo esc_attr($category->term_id); ?>" <?php if( has_term( $category->cat_name, 'vehicle_comfort', $car_id ) ) { echo "checked"; } ?>>

										<?php if(empty($categories_child)) { ?>
										<label for="vehicle_safety"><?php echo esc_attr($category->cat_name); ?></label>
										<?php } ?>

										<?php

											if(!empty($categories_child)) {

												?>

												<select class="taxonomy-subcategory-select" name="vehicle_comfort[]">

													<option value="na" <?php if( !has_term( $category->term_id, 'vehicle_comfort', $car_id ) ) { echo "selected"; } ?>><?php esc_html_e('Select', 'autoroyal' ); ?> - <?php echo $category->cat_name; ?></option>

												<?php

												foreach ($categories_child as $category_child) {

													?>
													
														<option value="<?php echo $category_child->term_id; ?>" <?php if( has_term( $category_child->term_id, 'vehicle_comfort', $car_id ) ) { echo "selected"; } ?>><?php echo $category_child->cat_name; ?></option>

													<?php

												}

												?></select><?php

											}

										?>

									</div>

									<?php

								}

								?>

							</div>

							<div class="col-lg-4 col-md-6 autoroyal-style-margin-bottom-30">

								<h2 class="autoroyal-subtitle"><span><?php esc_html_e('Visibility', 'autoroyal' ); ?></span></h2>

								<?php

									$categories = get_categories( array('taxonomy' => 'vehicle_visibility', 'hide_empty' => false,  'parent' => 0) );

									foreach ($categories as $category) {

										$catID = $category->term_id;

										$categories_child = get_categories( array('taxonomy' => 'vehicle_visibility', 'hide_empty' => false, 'parent' => $catID, 'orderby' => 'id', 'order' => 'ASC' ) );

									?>

									<div class="autoroyal-checkbox-field-small <?php if(!empty($categories_child)) { ?>autoroyal-checkbox-sub-category<?php } ?>">

										<input type="checkbox" <?php if(!empty($categories_child)) { ?>class="vehicle_comfort_sub_main"<?php } ?> name="vehicle_visibility[]" value="<?php echo esc_attr($category->term_id); ?>" <?php if( has_term( $category->cat_name, 'vehicle_visibility', $car_id ) ) { echo "checked"; } ?>>

										<?php if(empty($categories_child)) { ?>
										<label for="vehicle_safety"><?php echo esc_attr($category->cat_name); ?></label>
										<?php } ?>

										<?php

											if(!empty($categories_child)) {

												?>

												<select class="taxonomy-subcategory-select" name="vehicle_visibility[]">

													<option value="na" <?php if( !has_term( $category->term_id, 'vehicle_visibility', $car_id ) ) { echo "selected"; } ?>><?php esc_html_e('Select', 'autoroyal' ); ?> - <?php echo $category->cat_name; ?></option>

												<?php

												foreach ($categories_child as $category_child) {

													?>
													
														<option value="<?php echo $category_child->term_id; ?>" <?php if( has_term( $category_child->term_id, 'vehicle_visibility', $car_id ) ) { echo "selected"; } ?>><?php echo $category_child->cat_name; ?></option>

													<?php

												}

												?></select><?php

											}

										?>

									</div>

									<?php

								}

								?>

							</div>

						</div>

					</div>

					<div class="col-md-12">

						<div class="row">

							<div class="col-lg-4 col-md-6 autoroyal-style-margin-bottom-30">

								<h2 class="autoroyal-subtitle"><span><?php esc_html_e('Multimedia', 'autoroyal' ); ?></span></h2>

								<?php

									$terms_cat = get_the_terms($car_id, 'vehicle_multimedia' );
									if ($terms_cat && ! is_wp_error($terms_cat)) :
										$term_slugs_arr_cat = array();
											foreach ($terms_cat as $term_cat) {
												$term_slugs_arr_cat[] = $term_cat->slug;
											}
										$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
									endif;

									$categories = get_categories( array('taxonomy' => 'vehicle_multimedia', 'hide_empty' => false,  'parent' => 0) );

									foreach ($categories as $category) {

									?>

									<div class="autoroyal-checkbox-field-small">

										<input type="checkbox" name="vehicle_multimedia[]" value="<?php echo esc_attr($category->cat_name); ?>" <?php if( has_term( $category->cat_name, 'vehicle_multimedia', $car_id ) ) { echo "checked"; } ?>>
										<label for="vehicle_multimedia"><?php echo esc_attr($category->cat_name); ?></label>

									</div>

									<?php

								}

								?>

							</div>

							<div class="col-lg-4 col-md-6 autoroyal-style-margin-bottom-30">

								<h2 class="autoroyal-subtitle"><span><?php esc_html_e('Exterior', 'autoroyal' ); ?></span></h2>

								<?php

									$categories = get_categories( array('taxonomy' => 'vehicle_exterior', 'hide_empty' => false,  'parent' => 0) );

									foreach ($categories as $category) {

										$catID = $category->term_id;

										$categories_child = get_categories( array('taxonomy' => 'vehicle_exterior', 'hide_empty' => false, 'parent' => $catID, 'orderby' => 'id', 'order' => 'ASC' ) );

									?>

									<div class="autoroyal-checkbox-field-small <?php if(!empty($categories_child)) { ?>autoroyal-checkbox-sub-category<?php } ?>">

										<input type="checkbox" <?php if(!empty($categories_child)) { ?>class="vehicle_comfort_sub_main"<?php } ?> name="vehicle_exterior[]" value="<?php echo esc_attr($category->term_id); ?>" <?php if( has_term( $category->cat_name, 'vehicle_exterior', $car_id ) ) { echo "checked"; } ?>>

										<?php if(empty($categories_child)) { ?>
										<label for="vehicle_safety"><?php echo esc_attr($category->cat_name); ?></label>
										<?php } ?>

										<?php

											if(!empty($categories_child)) {

												?>

												<select class="taxonomy-subcategory-select" name="vehicle_exterior[]">

													<option value="na" <?php if( !has_term( $category->term_id, 'vehicle_exterior', $car_id ) ) { echo "selected"; } ?>><?php esc_html_e('Select', 'autoroyal' ); ?> - <?php echo $category->cat_name; ?></option>

												<?php

												foreach ($categories_child as $category_child) {

													?>
													
														<option value="<?php echo $category_child->term_id; ?>" <?php if( has_term( $category_child->term_id, 'vehicle_exterior', $car_id ) ) { echo "selected"; } ?>><?php echo $category_child->cat_name; ?></option>

													<?php

												}

												?></select><?php

											}

										?>

									</div>

									<?php

								}

								?>

							</div>

							<div class="col-lg-4 col-md-6 autoroyal-style-margin-bottom-30">

								<h2 class="autoroyal-subtitle"><span><?php esc_html_e('Interior', 'autoroyal' ); ?></span></h2>

								<?php

									$categories = get_categories( array('taxonomy' => 'vehicle_interior', 'hide_empty' => false,  'parent' => 0) );

									foreach ($categories as $category) {

										$catID = $category->term_id;

										$categories_child = get_categories( array('taxonomy' => 'vehicle_interior', 'hide_empty' => false, 'parent' => $catID, 'orderby' => 'id', 'order' => 'ASC' ) );

									?>

									<div class="autoroyal-checkbox-field-small <?php if(!empty($categories_child)) { ?>autoroyal-checkbox-sub-category<?php } ?>">

										<input type="checkbox" <?php if(!empty($categories_child)) { ?>class="vehicle_comfort_sub_main"<?php } ?> name="vehicle_interior[]" value="<?php echo esc_attr($category->term_id); ?>" <?php if( has_term( $category->cat_name, 'vehicle_interior', $car_id ) ) { echo "checked"; } ?>>

										<?php if(empty($categories_child)) { ?>
										<label for="vehicle_safety"><?php echo esc_attr($category->cat_name); ?></label>
										<?php } ?>

										<?php

											if(!empty($categories_child)) {

												?>

												<select class="taxonomy-subcategory-select" name="vehicle_interior[]">

													<option value="na" <?php if( !has_term( $category->term_id, 'vehicle_interior', $car_id ) ) { echo "selected"; } ?>><?php esc_html_e('Select', 'autoroyal' ); ?> - <?php echo $category->cat_name; ?></option>

												<?php

												foreach ($categories_child as $category_child) {

													?>
													
														<option value="<?php echo $category_child->term_id; ?>" <?php if( has_term( $category_child->term_id, 'vehicle_interior', $car_id ) ) { echo "selected"; } ?>><?php echo $category_child->cat_name; ?></option>

													<?php

												}

												?></select><?php

											}

										?>

									</div>

									<?php

								}

								?>

							</div>

						</div>

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<?php

	  		$website_type = get_option("autoroyal_webiste_type");
	  		if( !empty($website_type) AND $website_type == "marketplace" ) {

	  	?>

	  	<?php } else { ?>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Location & contact info', 'autoroyal' ); ?></h2>

			<?php if(isset($vehicle_location) AND !empty($vehicle_location)) { ?>

			<fieldset>

				<div class="row">

					<div class="col-lg-3 col-md-6">

						<label for="vehicle_location" class="control-label"><?php esc_html_e('Existent locations', 'autoroyal' ); ?></label>
						<select name="vehicle_location" id="vehicle_location">

							<option value="new" data-name="" data-phone="" data-email="" data-address="" data-latitude="" data-longitude="" ><?php esc_html_e('New location', 'autoroyal' ); ?></option>

							<?php

								$terms_cat = get_the_terms($car_id, 'vehicle_location' );
								if ($terms_cat && ! is_wp_error($terms_cat)) :
									$term_slugs_arr_cat = array();
										foreach ($terms_cat as $term_cat) {
											$term_slugs_arr_cat[] = $term_cat->slug;
										}
									$terms_slug_str_cat = join( " ", $term_slugs_arr_cat);
								endif;

								foreach ($vehicle_location as $category) {

									$term_id = $category->term_id;
									$vehicle_location_name = get_term_meta( $term_id, 'vehicle_location_name', true );
									$vehicle_location_phone = get_term_meta( $term_id, 'vehicle_location_phone', true );
									$vehicle_location_email = get_term_meta( $term_id, 'vehicle_location_email', true );
									$vehicle_location_address = get_term_meta( $term_id, 'vehicle_location_address', true );
									$vehicle_location_latitude = get_term_meta( $term_id, 'vehicle_location_latitude', true );
									$vehicle_location_longitude = get_term_meta( $term_id, 'vehicle_location_longitude', true );

								?>

									<option value="<?php echo $category->term_id; ?>" <?php selected( $terms_slug_str_cat, $category->slug ); ?> data-name="<?php echo esc_attr($vehicle_location_name); ?>" data-phone="<?php echo esc_attr($vehicle_location_phone); ?>" data-email="<?php echo esc_attr($vehicle_location_email); ?>" data-address="<?php echo esc_attr($vehicle_location_address); ?>" data-latitude="<?php echo esc_attr($vehicle_location_latitude); ?>" data-longitude="<?php echo esc_attr($vehicle_location_longitude); ?>" ><?php echo $category->cat_name; ?></option>

								<?php

								}

							?>
							
						</select>

					</div>

				</div>

			</fieldset>

			<?php } else { ?>

			<input type="hidden" class="vehicle_location" name="vehicle_location" value="new" />

			<?php } ?>

			<fieldset>

				<?php

					$vehicle_location_name = "";
					$vehicle_location_phone = "";
					$vehicle_location_email = "";
					$vehicle_location_address = "";
					$vehicle_location_latitude = "0";
					$vehicle_location_longitude = "0";

					$terms_cat = get_the_terms($car_id, 'vehicle_location' );
					if(isset($terms_cat) AND !empty($terms_cat)) {

						$term_id = $terms_cat[0]->term_id;
						$vehicle_location_name = get_term_meta( $term_id, 'vehicle_location_name', true );
						$vehicle_location_phone = get_term_meta( $term_id, 'vehicle_location_phone', true );
						$vehicle_location_email = get_term_meta( $term_id, 'vehicle_location_email', true );
						$vehicle_location_address = get_term_meta( $term_id, 'vehicle_location_address', true );
						$vehicle_location_latitude = get_term_meta( $term_id, 'vehicle_location_latitude', true );
						$vehicle_location_longitude = get_term_meta( $term_id, 'vehicle_location_longitude', true );

					}

				?>

				<div class="row">

					<div class="col-lg-4 col-md-6">

						<label for="vehicle_location_name" class="control-label"><?php esc_html_e('Location Name / Company Name', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_location_name" name="vehicle_location_name" value="<?php echo esc_attr($vehicle_location_name); ?>" placeholder="">

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="vehicle_location_phone" class="control-label"><?php esc_html_e('Phone number', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_location_phone" name="vehicle_location_phone" value="<?php echo esc_attr($vehicle_location_phone); ?>" placeholder="">

					</div>

					<div class="col-lg-4 col-md-6">

						<label for="vehicle_location_email" class="control-label"><?php esc_html_e('Email', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_location_email" name="vehicle_location_email" value="<?php echo esc_attr($vehicle_location_email); ?>" placeholder="">

					</div>

					<div class="col-md-12">

						<label for="vehicle_location_address" class="control-label"><?php esc_html_e('Location (Full Address)', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_location_address" name="vehicle_location_address" value="<?php echo esc_attr($vehicle_location_address); ?>" placeholder="">

						<input type="hidden" id="vehicle_location_latitude" name="vehicle_location_latitude" value="<?php echo esc_attr($vehicle_location_latitude); ?>" />
						<input type="hidden" id="vehicle_location_longitude" name="vehicle_location_longitude" value="<?php echo esc_attr($vehicle_location_longitude); ?>" />

					</div>

					<div class="col-md-12">

						<div id="map-canvas"></div>

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->

		<?php } ?>

		<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Photo Gallery', 'autoroyal' ); ?></h2>

			<fieldset>

				<div id="vehicle_gallery_more_images">

					<div class="row autoroyal-uploaded-files">

						<?php 

							$i = 0;

							if(!empty($vehicle_image_gallery)) {

								foreach ($vehicle_image_gallery as $vehicle_image_gallery_item) {
									
									if( !empty($vehicle_image_gallery_item['url']) ) {

										$i++;

						?>

						<div class="col-md-3 col-sm-6 autoroyal-image-gallery" data-id="<?php echo esc_attr($i); ?>">

							<div class="vehicle_gallery_image_holder_has_image vehicle_gallery_image_loaded add_more_button" style="background-image: url(<?php if(!empty($vehicle_image_gallery_item['url'])) { echo esc_attr($vehicle_image_gallery_item['url']); } ?>);">

								<img class="image-holder" src="<?php if(!empty($vehicle_image_gallery_item['url'])) { echo esc_attr($vehicle_image_gallery_item['url']); } ?>" alt=""/>

								<div class="vehicle_gallery_image_holder_no_image_inner">

									<div class="your_image_url_button">
										<i class="fas fa-cloud-upload-alt" aria-hidden="true"></i>
										<?php esc_html_e('Upload Image', 'autoroyal' ); ?>
									</div>

								</div>

								<div class="vehicle_gallery_image_holder_with_image_inner">

									<div class="your_image_url_button_remove">
										<i class="fa fa-trash" aria-hidden="true"></i>
										<?php esc_html_e('Remove Image', 'autoroyal' ); ?>
									</div>
									
								</div>

								<input type="hidden" class="vehicle_gallery_image_url" name="vehicle_image_gallery[<?php echo esc_attr($i); ?>][url]" value="<?php if(!empty($vehicle_image_gallery_item['url'])) { echo esc_attr($vehicle_image_gallery_item['url']); } ?>" />
								<input type="hidden" class="vehicle_gallery_image_id" name="vehicle_image_gallery[<?php echo esc_attr($i); ?>][id]" value="<?php if(!empty($vehicle_image_gallery_item['id'])) { echo esc_attr($vehicle_image_gallery_item['id']); } ?>" />

							</div>

						</div>

						<?php } } } ?>

						<div class="col-lg-3 col-md-6 col-sm-12 autoroyal-add-gallery-button" data-id="<?php if(!empty($vehicle_image_gallery)) { $totalImg = count($vehicle_image_gallery); } else { $totalImg = 0; } $totalImg++; echo esc_attr($totalImg); ?>">

							<div class="vehicle_gallery_image_holder_no_image add_more_button">

								<img class="image-holder" src="" alt=""/>

								<div class="vehicle_gallery_image_holder_no_image_inner">

									<div class="your_image_url_button">
										<i class="fas fa-cloud-upload-alt" aria-hidden="true"></i>
										<?php esc_html_e('Upload Image', 'autoroyal' ); ?>
										<input type="file" class="input-text autoroyal-file-upload" data-file_types="jpg|jpeg|gif|png" multiple="" name="post_gallery" id="post_gallery" placeholder="">
									</div>

								</div>

								<div class="vehicle_gallery_image_holder_with_image_inner">

									<div class="your_image_url_button_remove">
										<i class="fa fa-trash" aria-hidden="true"></i>
										<?php esc_html_e('Remove Image', 'autoroyal' ); ?>
									</div>
									
								</div>

							</div>

						</div>

					</div>

				</div>

			</fieldset>

		</div>	<!-- end review_options_pop -->
			
		<div id="car_expenses">

			<div class="options_group">

				<h2 class="options_group_heading"><?php esc_html_e('Expenses', 'autoroyal' ); ?></h2>

				<fieldset>

					<div id="vehicle_expenses_container">

						<?php 

							$i = 0;

							if(!empty($vehicle_expenses)) {

								foreach ($vehicle_expenses as $vehicle_expenses_item) {
									
									if( !empty($vehicle_expenses_item['price']) ) {

										$i++;

						?>

						<div class="vehicle_expenses_item" data-id="<?php echo esc_attr($i); ?>">

							<div class="row">

								<div class="col-lg-4 col-md-6">

									<label for="vehicle_expenses" class="control-label"><?php esc_html_e('Price', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="vehicle_expenses" name="vehicle_expenses[<?php echo esc_attr($i); ?>][price]" value="<?php if(!empty($vehicle_expenses_item['price'])) { echo esc_attr($vehicle_expenses_item['price']); } ?>" placeholder="200" />

								</div>

								<div class="col-lg-4 col-md-6">

									<label for="vehicle_expenses" class="control-label"><?php esc_html_e('Description', 'autoroyal' ); ?></label>
									<textarea cols="20" rows="4" class="input-text" name="vehicle_expenses[<?php echo esc_attr($i); ?>][desc]" placeholder="<?php esc_attr_e('Write down vehicle’s expense description here...', 'autoroyal' ); ?>"><?php if(!empty($vehicle_expenses_item['desc'])) { echo wp_kses($vehicle_expenses_item['desc'], true); } ?></textarea>

								</div>

								<div class="col-lg-4 col-md-6">

									<div class="delete_expense"><i class="fa fa-times" aria-hidden="true"></i> <?php esc_html_e('Delete', 'autoroyal' ); ?></div>

								</div>

							</div>

						</div>

						<?php } } } ?>
						<?php if( $i == 0 ) { ?>

						<div class="vehicle_expenses_item" data-id="<?php echo esc_attr($i); ?>">

							<div class="row">

								<div class="col-lg-4 col-md-6">

									<label for="vehicle_expenses" class="control-label"><?php esc_html_e('Price', 'autoroyal' ); ?> (<?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { echo esc_html_e('in', 'autoroyal' ); echo " "; echo esc_attr($autoroyal_currency); } ?>)</label>
									<input type="text" id="vehicle_expenses" name="vehicle_expenses[<?php echo esc_attr($i); ?>][price]" value="" placeholder="200" />

								</div>

								<div class="col-lg-4 col-md-6">

									<label for="vehicle_expenses" class="control-label"><?php esc_html_e('Description', 'autoroyal' ); ?></label>
									<textarea cols="20" rows="4" class="input-text" name="vehicle_expenses[<?php echo esc_attr($i); ?>][desc]" placeholder="<?php esc_attr_e('Write down vehicle’s expense description here...', 'autoroyal' ); ?>"></textarea>

								</div>

								<div class="col-lg-4 col-md-6">

									<div class="delete_expense"><i class="fa fa-times" aria-hidden="true"></i> <?php esc_html_e('Delete', 'autoroyal' ); ?></div>

								</div>

							</div>

						</div>

						<?php } ?>

					</div>

					<div class="col-md-12">
						
						<div class="add_new_expense"><i class="fa fa-plus-circle" aria-hidden="true"></i> <?php esc_html_e('Add New Expense', 'autoroyal' ); ?></div>

					</div>

				</fieldset>

				<fieldset class="autoroyal-last-fieldset">

					<div class="row">

						<div class="col-md-12">

							<input type="hidden" name="listing_id" value="<?php echo esc_attr($car_id); ?>" />
							<input type="hidden" name="action_name" value="<?php if(!empty($_GET['action'])) { echo $_GET['action']; } ?>" />
												
							<input type="hidden" name="action" value="submitVehicleFunction" />
							<?php wp_nonce_field( 'submitVehicleFunction_html', 'submitVehicleFunction_nonce' ); ?>

							<a id="autoroyal_submit_vehicle" href="#" class="btn btn-default"><?php esc_html_e( 'Save vehicle', 'autoroyal' ) ?></a>

							<a id="autoroyal_discard_vehicle" href="<?php echo esc_url(autoroyal_get_permalink( 'inventory' )); ?>" class="btn btn-default"><?php esc_html_e( 'Cancel', 'autoroyal' ) ?></a>

						</div>

					</div>

				</fieldset>

			</div>

		</div>

	</form>
	
</div>

<?php } ?>
