<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function testimonials_item_func( $atts, $content ) {

    extract( shortcode_atts( array(
        'image' => '',
        'name' => 'John Doe',
        'position' => 'User Interface & Interaction',
    ), $atts ) );

    ob_start();

    $img_id = preg_replace( '/[^\d]/', '', $image );
    $link_image = wp_get_attachment_image_src( $img_id, 'full' );
    $img_src = $link_image[0];

    $random_num = rand(1,4);
    $unique_id = uniqid();
    $testimonial_class = "testimonial_class_" . $unique_id;

    //
    // Get all the Customized Theme Mods
    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    $select_bg_color = "";
    if(strlen($MODS['select_bg'])>0) {
        $select_bg_color = $MODS['select_bg'];
    }

    if(!empty($select_bg_color)) {

        $bg_shape_1 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
         viewBox="0 0 500 481" style="enable-background:new 0 0 500 481;" xml:space="preserve">
            <path fill="'.$select_bg_color.'" d="M495,242.7c0,128.1-103.9,232-232,232s-330.3-149.8-232-232C130,160,183.1,32.9,263,10.7
                C386.5-23.5,495,114.6,495,242.7z"/>
            </svg>';
        $bg_shape_encoded_1 = base64_encode($bg_shape_1); 

        $bg_shape_2 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
         viewBox="0 0 500 426.8" style="enable-background:new 0 0 500 426.8;" xml:space="preserve">
            <path fill="'.$select_bg_color.'" d="M182.7,419.3c46.5-4.5,183.3-15.5,233.8-9.8c128.5,14.5,81.1-236-13.5-329S161-16.1,73.9,72.6
                s-101,263.1,13.5,329C113.4,416.7,145.9,420.3,182.7,419.3"/>
            </svg>';
        $bg_shape_encoded_2 = base64_encode($bg_shape_2); 

        $bg_shape_3 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
         viewBox="0 0 500 436.6" style="enable-background:new 0 0 500 436.6;" xml:space="preserve">
            <path fill="'.$select_bg_color.'" d="M430.6,217.6c-192,148.8-95.3,212.8-212.8,212.8S5,335.1,5,217.6S100.3,4.8,217.8,4.8S622.6,68.8,430.6,217.6z"
                />
            </svg>';
        $bg_shape_encoded_3 = base64_encode($bg_shape_3); 

        $bg_shape_4 = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
         viewBox="0 0 500 397" style="enable-background:new 0 0 500 397;" xml:space="preserve">
            <path fill="'.$select_bg_color.'" d="M493.6,270.5c-3.1,26.3-9.5,47.4-18.2,64.3c-11.7,22.4-31.6,31.5-49.4,40.9c-5.1,2.7-10.5,5.1-16,7
                c-32.4,11.2-68.7,8.3-97.1,2.3c-20-4.2-40.3-6.7-60.6-7.7c-5.8-0.3-11.6-0.4-17.5-0.4c-9,0-170.7,3.1-210.1-76.7
                c-9.7-19.7-16.4-43.7-18.8-73C-1,144.5,36.3,90.1,84.3,54.6c90.9-67.2,215.4-64.4,305,4.6C448.9,105.1,504.7,174.7,493.6,270.5z"/>
            </svg>';
        $bg_shape_encoded_4 = base64_encode($bg_shape_4);

        if( $random_num == 1 ) {
            $bg_image = $bg_shape_encoded_1;
        } elseif( $random_num == 2 ) {
            $bg_image = $bg_shape_encoded_2;
        } elseif( $random_num == 3 ) {
            $bg_image = $bg_shape_encoded_3;
        } else {
            $bg_image = $bg_shape_encoded_4;
        }

    } else {

        $bg_image = get_template_directory_uri() . '/assets/images/icon-bg-shape-' . $random_num . '.svg';

    }

    ?>

        <div class="item autoroyal-testimonials-holder <?php echo esc_attr($testimonial_class); ?>">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="autoroyal-testimonials text-center">

                        <div class="text-center"><i class="material-icons">format_quote</i></div>

                        <div class="autoroyal-post-testimonials-content">
                            <?php echo wp_kses($content, true); ?>
                        </div>

                        <div class="user">
                            <?php if(!empty($img_src)) { ?><img src="<?php $foto_large = autoroyal_get_resized_image( $img_src, 'autoroyal-testimonial-image' ); echo esc_url($foto_large); ?>" alt="user-interface" class="img-responsive img-circle"><?php } ?>
                            <div class="user-info">
                                <h3 class="text-capitalize"><?php if(!empty($name)) { echo esc_attr($name); } ?></h3>
                                <span class="text-muted"><?php echo esc_attr($position); ?></span>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    <?php

    wp_enqueue_style(
        'autoroyal-custom-style-testimonial',
        get_template_directory_uri() . '/assets/css/custom-styles.css'
    );

    $custom_bg_image = "

            .autoroyal-testimonials-holder.{$testimonial_class} { 
                background-image: url('data:image/svg+xml;base64,{$bg_image}');
            }

            ";
    wp_add_inline_style( 'autoroyal-custom-style-testimonial', $custom_bg_image );

    return ob_get_clean();

}
add_shortcode( 'testimonials_item', 'testimonials_item_func' );

vc_map( array(
    'name' => esc_html__( 'Testimonials item', 'autoroyal' ),
    'base' => 'testimonials_item',
    'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
    'description' => esc_html__( 'Custom autoroyal testimonials item', 'autoroyal' ),
    'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
    "content_element" => true,
    "as_child" => array('only' => 'autoroyal_slider'), 
    'params' => array(
        array(
            'type' => 'attach_image',
            'heading' => esc_html__( 'Image', 'autoroyal' ),
            'param_name' => 'image',
            'value' => '',
            'description' => esc_html__( 'Select image from media library.', 'autoroyal' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Name', 'autoroyal' ),
            'param_name' => 'name',
            'admin_label' => true,
            'value' => 'John Doe',
        ),
        array(
            'type' => 'textarea_html',
            'heading' => esc_html__( 'Content', 'autoroyal' ),
            'param_name' => 'content',
            'value' => "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don't look even slightly believable.",
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Location', 'autoroyal' ),
            'param_name' => 'position',
            'admin_label' => true,
            'value' => 'New York',
        ),
    ),
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_testimonials_item extends WPBakeryShortCode {
    }
}

