<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function tabs_style_2_func( $atts, $content = null ) {

    extract( shortcode_atts( array(
        "tabs_style_2_nav_style" => "show",
        "css" => "",
    ), $atts ) );

    global $single_tab_style_2_array;
    $single_tab_style_2_array = array(); // clear the array
   
    $tabs_style_2_nav = '';
    $tabs_style_2_content = '';
    $tabs_style_2_output = '';

    $class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;
 
    $tabs_style_2_nav .= '<div class="nav nav-classic nav-justified mx-lg-auto">';
   
    // execute the '[tab]' shortcode first to get the title and content - acts on global $single_tab_array
    do_shortcode($content);

    $random_id = '';
   
    //declare our vars to be super clean here
    foreach ($single_tab_style_2_array as $tab => $tab_attr_array) {

        $random_id = rand(1000,2000); // potential duplicate issue.. need to fix
     
        $default_nav = ( $tab == 0 ) ? 'active' : '';
        $default_tab = ( $tab == 0 ) ? 'show active' : '';

        $title = $tab_attr_array['title'];
        $add_icon = $tab_attr_array['add_icon'];
        $icon_type = $tab_attr_array['icon_type'];
        $icon_material = $tab_attr_array['icon_material'];
        $icon_fontawesome = $tab_attr_array['icon_fontawesome'];
        $icon_openiconic = $tab_attr_array['icon_openiconic'];
        $icon_typicons = $tab_attr_array['icon_typicons'];
        $icon_entypo = $tab_attr_array['icon_entypo'];
        $icon_linecons = $tab_attr_array['icon_linecons'];
        $icon_monosocial = $tab_attr_array['icon_monosocial'];
        $icon_bg_type = $tab_attr_array['icon_bg_type'];
        $tab_id = $tab_attr_array['tab_style_2_id'];

        if ( 'true' === $add_icon ) {
            vc_icon_element_fonts_enqueue( $icon_type );

            if ( isset( ${'icon_' . $icon_type} ) ) {
                $icon_class = ${'icon_' . $icon_type};
            } else {
                $icon_class = 'fa fa-adjust';
            }
            if( $icon_type == "material" ) {
                $icon_class = 'material-icons';
            }
        }

        $icon_wrapper = "";
        $unique_id = uniqid();
        $icon_bg_class = "autoroyal_icon_bg_class_" . $unique_id;

        if ( 'true' === $add_icon ) { 
            if( $icon_type == "material" ) { 
                $icon_wrapper = "<i class='" . wp_kses($icon_material, true) . "'></i>"; 
            } else { 
                $icon_wrapper = "<i class='" . wp_kses($icon_class, true) . "'></i>"; 
            } 
        }
      
        $tabs_style_2_nav .= '<a class="nav-item nav-link icon-bg-' . $icon_bg_type . ' ' . $default_nav . '" id="' . ( empty( $tab_id ) ? sanitize_title( $title ) : esc_attr( $tab_id ) ) . '-tab" data-toggle="tab" href="#pricing-' . ( empty( $tab_id ) ? sanitize_title( $title ) : esc_attr( $tab_id ) ) . '">' . $icon_wrapper . ' ' . esc_attr($title) . '</a>';
        $tabs_style_2_content .= '<div class="tab-pane ' . $default_tab . '" id="pricing-' . esc_attr( $tab_id ) . '" role="tabpanel" aria-labelledby="' . esc_attr( $tab_id ) . '">'.$tab_attr_array['content'].'</div>';

      
    }

    $tabs_style_2_nav .= '</div><!-- .tab-me-tabs -->';
    
    if ($tabs_style_2_nav_style == "hide") {
        $tabs_style_2_output = '<div class="tab-content" id="myTabContent-' . $random_id . '">' . $tabs_style_2_content . '</div>';
    } else {
        $tabs_style_2_output = '<div class="tab-wrapper nav-shadow nav-rounded nav-bordered">' . $tabs_style_2_nav . '<div class="tab-content" id="myTabContent-' . $random_id . '">' . $tabs_style_2_content . '</div></div>';
    }

    return $tabs_style_2_output;
}
add_shortcode('tabs_style_2', 'tabs_style_2_func');

vc_map( array(
    'name' => esc_html__( 'Tabs Style 2', 'autoroyal' ),
    'base' => 'tabs_style_2',
    'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
    'description' => esc_html__( 'Custom autoRoyal tab', 'autoroyal' ),
    'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
    "as_parent" => array('only' => 'tab_style_2'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
    "content_element" => true,
    //"show_settings_on_create" => false,
    "is_container" => true,
    'params' => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Show/Hide default tabs navigation', 'autoroyal' ),
            'value' => array(
                esc_html__( 'Show', 'autoroyal' ) => 'show',
                esc_html__( 'Hide', 'autoroyal' ) => 'hide',
            ),
            'param_name' => 'tabs_style_2_nav_style',
            'description' => esc_html__( 'Add navigation in a new place with custom tab navigation shortcode.', 'autoroyal' ),
            'std' => 'show',
        ),
        array(
            'type' => 'css_editor',
            'heading' => esc_html__( 'CSS box', 'autoroyal' ),
            'param_name' => 'css',
            'group' => esc_html__( 'Design Options', 'autoroyal' ),
        ),
    ),
    "js_view" => 'VcColumnView'
));

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    class WPBakeryShortCode_tabs_style_2 extends WPBakeryShortCodesContainer {
    }
}

