<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_locations_carousel_func( $atts, $content ) {

	extract( shortcode_atts( array(
		'add_map' => 'true',
    	'css' => '',
   	), $atts ) );

	ob_start();

	wp_enqueue_script( 'autoroyal-gmap3' );

	$class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;

	?>

	<div class="owl-carousel owl-theme locations-carousel <?php echo esc_attr($css_class); ?>">

		<?php

			$vehicle_location = get_categories( array('taxonomy' => 'vehicle_location', 'hide_empty' => false,  'parent' => 0) );

			foreach ($vehicle_location as $category) {

				$term_id = $category->term_id;
				$vehicle_location_name = get_term_meta( $term_id, 'vehicle_location_name', true );
				$vehicle_location_phone = get_term_meta( $term_id, 'vehicle_location_phone', true );
				$vehicle_location_email = get_term_meta( $term_id, 'vehicle_location_email', true );
				$vehicle_location_address = get_term_meta( $term_id, 'vehicle_location_address', true );
				$vehicle_location_latitude = get_term_meta( $term_id, 'vehicle_location_latitude', true );
				$vehicle_location_longitude = get_term_meta( $term_id, 'vehicle_location_longitude', true );

				$map_pin = get_template_directory_uri().'/assets/images/map-pin.png';

				$unique_map_id = uniqid();

				$get_directions_link = '//maps.google.com/maps?daddr=' . $vehicle_location_latitude . ',' . $vehicle_location_longitude;

				?>

				<div class="item autoroyal-location-holder">

					<?php if( $add_map == "true" ) { ?>

					<div id="main-map-<?php echo esc_attr($unique_map_id); ?>" class="locations-map"></div>

					<script type="text/javascript">
						var mapDiv,
							map,
							infobox;
						jQuery(document).ready(function($) {

							mapDiv = $("#main-map-<?php echo esc_attr($unique_map_id); ?>");
							mapDiv.height(400).gmap3({
								map: {
									options: {
										"center": [<?php echo esc_attr($vehicle_location_latitude); ?>, <?php echo esc_attr($vehicle_location_longitude); ?>]
										,"zoom": 13							
										,"mapTypeControl": true
										,"mapTypeId": google.maps.MapTypeId.ROADMAP
										,"scrollwheel": false
										,"panControl": true
										,"rotateControl": false
										,"scaleControl": true
										,"streetViewControl": true
										,"zoomControl": true
										,"draggable": false						
									}
								}
								,marker: {
									values: [

									{

										latLng: [<?php echo esc_attr($vehicle_location_latitude); ?>, <?php echo esc_attr($vehicle_location_longitude); ?>],
										options: {
											icon: "<?php echo esc_attr($map_pin); ?>",
											shadow: "",
										}
									}	
											
									],
									options:{
										draggable: false
									}
								}
							});

							map = mapDiv.gmap3("get");
						    infobox = new InfoBox({
						    	pixelOffset: new google.maps.Size(-50, -65),
						    	closeBoxURL: '',
						    	enableEventPropagation: true
						    });
						    mapDiv.delegate('.infoBox .close','click',function () {
						    	infobox.close();
						    });

						});
					</script>

					<?php } ?>

					<div class="location-card-style-2 location-card">

						<h4><?php echo esc_attr($vehicle_location_name); ?></h4>
						
						<div class="autoroyal-location-block">
							<div class="address">
								<span class="heading-font first-line"><?php esc_html_e('Visit Us', 'autoroyal' ); ?>:</span>
								<span class="heading-font"><a href="<?php echo esc_url($get_directions_link); ?>" target="_blank"><?php echo esc_attr($vehicle_location_address); ?></a></span>
							</div>
						</div>

						<div class="autoroyal-location-block">
							<div class="address">
								<span class="heading-font first-line"><?php esc_html_e('Call Us', 'autoroyal' ); ?>:</span>
								<span class="heading-font"><a href="tel:<?php echo esc_attr($vehicle_location_phone); ?>"><?php echo esc_attr($vehicle_location_phone); ?></a></span>
							</div>
						</div>

						<div class="autoroyal-location-block">
							<div class="address">
								<span class="heading-font first-line"><?php esc_html_e('Mail Us', 'autoroyal' ); ?>:</span>
								<span class="heading-font"><a href="mailto:<?php echo esc_attr($vehicle_location_email); ?>"><?php echo esc_attr($vehicle_location_email); ?></a></span>
							</div>
						</div>

						<a href="<?php echo esc_url($get_directions_link); ?>" class="autoroyal-button button-icon-right autoroyal-button-align-left" target="_blank"><?php esc_html_e('Get Directions', 'autoroyal' ); ?> <i class="fa fa-map-signs"></i></a>

					</div>

				</div>

				<?php

			}

		?>

    </div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_locations_carousel', 'autoroyal_locations_carousel_func' );

vc_map( array(
  	'name' => esc_html__( 'Locations Carousel', 'autoroyal' ),
	'base' => 'autoroyal_locations_carousel',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal location carousel', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'checkbox',
			'heading' => esc_html__( 'Show maps?', 'autoroyal' ),
			'param_name' => 'add_map',
			'std' => 'true',
			'admin_label' => true,
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),

));

