<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_homepage_search_block_func( $atts ) {

	extract( shortcode_atts( array(
        "add_custom_colors" => "",
        "bg_color" => "#0c3eb8",
        "label_color" => "#96abdf",
        "title_color" => "#ffffff",
        "btn_bg_color" => "#FF3366",
        "btn_bg_hover_color" => "#de2c59",
    	"css" => "",
   	), $atts ) );

	ob_start();

    // Enqueue styles
    wp_enqueue_style( 'jquery-ui' );
    wp_enqueue_style( 'bootstrap-select' );

    // Enqueue scripts
    wp_enqueue_script( 'jquery-ui-slider' );
    wp_enqueue_script( 'jquery-ui-autocomplete' );
    wp_enqueue_script( 'touch-punch' );
    wp_enqueue_script( 'time-picker' );
    wp_enqueue_script( 'bootstrap-select' );

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

    //
    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    $vehicles_search_url = "";
    $vehicles_search_url = get_option("autoroyal_search_vehicles_page_id");

    $unique_id = uniqid();
    $form_class = "autoroyal_search_" . $unique_id;

	?>

    <div class="<?php echo esc_attr($css_class); ?>">

        <div class="autoroyal-homepage-search-box <?php echo esc_attr($form_class); ?>">

            <?php if(!empty($vehicles_search_url)) { ?>
                <form id="autoroyal-advance-search-form" action="<?php echo get_permalink( $vehicles_search_url ); ?>" method="GET">

                    <div class="search-form-wrapper">

                        <div class="row">

                            <div class="col-md-12 col-lg-5 md-mb-30 sm-mb-30 xs-mb-30">

                                <div class="row">

                                    <div class="col-sm-12 col-md-6 xs-mb-30 sm-mb-30">

                                        <div class="title"><?php esc_html_e('Make', 'autoroyal' ); ?></div>

                                        <select id="cd-carmake" name="make" class="chosen-select">
                                            <option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
                                            <?php 

                                                $autoroyal_vehicles_query = autoroyal_vehicle_query();
                                                $total_cars_by_make = $autoroyal_vehicles_query["total_cars"];
                                                $make = "0";
                                                $model = "0";

                                                if( !empty($total_cars_by_make) ) {

                                                    $total = count($total_cars_by_make);

                                                    for( $i = 1; $i <= $total; ++$i ){

                                            ?>
                                            <option value="<?php echo esc_attr($total_cars_by_make[$i]['make_clean']); ?>" <?php selected( $total_cars_by_make[$i]['make_clean'], $make ); ?>><?php echo esc_attr($total_cars_by_make[$i]['make']); ?></option>
                                            <?php

                                                    }

                                                }

                                            ?>
                                        </select>

                                        <script>

                                            jQuery("document").ready(function(){

                                                // object literal holding data for option elements
                                                var Select_List_Data = {
                                                    
                                                    'model': { // name of associated select box
                                                        
                                                        // names match option values in controlling select box
                                                        <?php 

                                                            $total_cars_by_make = $autoroyal_vehicles_query["total_cars"];

                                                            if( !empty($total_cars_by_make) ) {

                                                                $total = count($total_cars_by_make);

                                                                for( $i = 1; $i <= $total; ++$i ){

                                                        ?>'<?php echo esc_attr($total_cars_by_make[$i]['make_clean']); ?>': {
                                                            text: [<?php 

                                                                        if( !empty($total_cars_by_make[$i]['model']) ) {

                                                                            $total_models = count($total_cars_by_make[$i]['model']);

                                                                            for( $j = 0; $j <= $total_models; ++$j ){

                                                                                if(!empty($total_cars_by_make[$i]['model'][$j])) {

                                                                    ?>'<?php echo esc_attr($total_cars_by_make[$i]['model'][$j]); ?>',<?php
                                                                                }

                                                                            }

                                                                        }

                                                                    ?>]
                                                        },
                                                       <?php

                                                                }

                                                            }

                                                        ?>
                                                    
                                                    }    
                                                };

                                                // removes all option elements in select box 
                                                // removeGrp (optional) boolean to remove optgroups
                                                function removeAllOptions(sel, removeGrp) {
                                                    var len, groups, par;
                                                    if (removeGrp) {
                                                        groups = sel.getElementsByTagName('optgroup');
                                                        len = groups.length;
                                                        for (var i=len; i; i--) {
                                                            sel.removeChild( groups[i-1] );
                                                        }
                                                    }
                                                    
                                                    len = sel.options.length;
                                                    for (var i=len; i; i--) {
                                                        par = sel.options[i-1].parentNode;
                                                        par.removeChild( sel.options[i-1] );
                                                    }
                                                }

                                                function appendDataToSelect(sel, obj) {

                                                    var f = document.createDocumentFragment();
                                                    var labels = [], group, opts;

                                                    if(obj != '0') {
                                                    
                                                        function addOptions(obj) {
                                                            var f = document.createDocumentFragment();
                                                            var o;

                                                            o = document.createElement('option');
                                                            o.appendChild( document.createTextNode( '<?php esc_html_e('Any', 'autoroyal' ); ?>' ) );
                                                            o.value = '0';
                                                            $("#model_all").val( obj.text );
                                                            f.appendChild(o);
                                                            
                                                            for (var i=0, len=obj.text.length; i<len; i++) {
                                                                o = document.createElement('option');
                                                                o.appendChild( document.createTextNode( obj.text[i] ) );
                                                                
                                                                o.value = obj.text[i];

                                                                if( o.value == '<?php echo esc_attr($model); ?>' ) {
                                                                    o.setAttribute('selected', 'selected');
                                                                }
                                                                
                                                                f.appendChild(o);
                                                            }
                                                            
                                                            return f;
                                                        }
                                                        
                                                        if ( obj.text ) {
                                                            opts = addOptions(obj);
                                                            f.appendChild(opts);
                                                        } else {
                                                            for ( var prop in obj ) {
                                                                if ( obj.hasOwnProperty(prop) ) {
                                                                    labels.push(prop);
                                                                }
                                                            }
                                                            
                                                            for (var i=0, len=labels.length; i<len; i++) {
                                                                group = document.createElement('optgroup');
                                                                group.label = labels[i];
                                                                f.appendChild(group);
                                                                opts = addOptions(obj[ labels[i] ] );
                                                                group.appendChild(opts);
                                                            }
                                                        }

                                                    } else {

                                                        var f = document.createDocumentFragment();
                                                        var o;

                                                        o = document.createElement('option');
                                                        o.appendChild( document.createTextNode( '<?php esc_html_e('Select a Make', 'autoroyal' ); ?>' ) );
                                                        o.value = '0';
                                                        $("#model_all").val( "" );
                                                        f.appendChild(o);

                                                    }
                                                    sel.appendChild(f);

                                                    $('.chosen-select').trigger("chosen:updated");

                                                }

                                                $('select#cd-carmake').on('change', function(){

                                                    var selected = $('select#cd-carmake option:selected').val();

                                                    // name of associated select box
                                                    var relName = 'model';
                                                    
                                                    // reference to associated select box 
                                                    var relList = this.form.elements[ relName ];
                                                    
                                                    // get data from object literal based on selection in controlling select box (this.value)
                                                    var obj = Select_List_Data[ relName ][ selected ];

                                                    if(selected != '0') {
                                                        
                                                        // remove current option elements
                                                        removeAllOptions(relList, true);
                                                        
                                                        // call function to add optgroup/option elements
                                                        // pass reference to associated select box and data for new options
                                                        appendDataToSelect(relList, obj);

                                                    } else {

                                                        // remove current option elements
                                                        removeAllOptions(relList, true);
                                                        
                                                        // call function to add optgroup/option elements
                                                        // pass reference to associated select box and data for new options
                                                        appendDataToSelect(relList, '0');

                                                    }

                                                });

                                            })

                                        </script>

                                    </div>

                                    <div class="col-sm-12 col-md-6">

                                        <div class="title"><?php esc_html_e('Model', 'autoroyal' ); ?></div>

                                        <select id="model" name="model" class="chosen-select"> 
                                            <option value="0"><?php esc_html_e('Select a Make', 'autoroyal' ); ?></option>
                                        </select>

                                    </div>

                                </div>

                            </div>

                            <div class="col-md-12 col-lg-7">

                                <div class="row">

                                    <div class="col-sm-12 col-md-6 col-lg-5 xs-mb-30 sm-mb-30">

                                        <div class="title">
                                            <?php esc_html_e('Price', 'autoroyal' ); ?>
                                        </div>

                                        <div class="range-wrapper">
                                            <a class="open_range">
                                                <span id="price_up" class="filter-dynamic-data">
                                                    <span class="filter-dynamic-data-min"></span> - <span class="filter-dynamic-data-max"></span>
                                                </span>
                                                <i class="material-icons">expand_more</i>
                                            </a>
                                            <div class="range-container">
                                                <span class="filter-surrency-symbol"><?php $autoroyal_currency = get_option( 'autoroyal_currency' ); if(!empty($autoroyal_currency)) { $currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency ); echo esc_attr($currency_symbol); } ?></span> 
                                                <div class="range-holder">
                                                    <div id="priceUpRange2" class="pull-right"></div>
                                                </div>
                                            </div>
                                            <input type="hidden" id="priceUp2" name="price" readonly class="filter-meta">
                                            <input type="hidden" id="priceUp1" name="price_min" readonly class="filter-meta">
                                        </div>

                                        <div class="clearfix"></div>

                                        <script>
                                            jQuery("document").ready(function(){

                                                var carPriceMin = parseFloat(<?php echo autoroyal_get_min_price(); ?>);
                                                var carPriceMax = parseFloat(<?php echo autoroyal_get_max_price(); ?>);

                                                var currency_symbol = jQuery(".filter-surrency-symbol").text();
                                                var currency_pos = autoroyalSettings.currency_pos;
                                                console.log(currency_pos);

                                                $( "#priceUpRange2" ).slider({
                                                    range: true,
                                                    min: carPriceMin,
                                                    max: carPriceMax,
                                                    values: [ carPriceMin, carPriceMax ],
                                                    slide: function( event, ui ) {
                                                        $( "#priceUp1" ).val( ui.values[ 0 ] );
                                                        $( "#priceUp2" ).val( ui.values[ 1 ] );

                                                        if( currency_pos == 'right' || currency_pos == 'right_space' ) {
                                                            $( "#price_up .filter-dynamic-data-min" ).text( addCommas( ui.values[ 0 ] ) + currency_symbol );
                                                            $( "#price_up .filter-dynamic-data-max" ).text( addCommas( ui.values[ 1 ] ) + currency_symbol );
                                                        } else {
                                                            $( "#price_up .filter-dynamic-data-min" ).text( currency_symbol + addCommas( ui.values[ 0 ] ) );
                                                            $( "#price_up .filter-dynamic-data-max" ).text( currency_symbol + addCommas( ui.values[ 1 ] ) );
                                                        }
                                                    }
                                                });
                                                $( "#priceUp1" ).val( $( "#priceUpRange2" ).slider( "values", 0 ) );
                                                $( "#priceUp2" ).val( $( "#priceUpRange2" ).slider( "values", 1 ) );

                                                if( currency_pos == 'right' || currency_pos == 'right_space' ) {
                                                    $( "#price_up span.filter-dynamic-data-min" ).text( addCommas( $( "#priceUpRange2" ).slider( "values", 0 ) ) + currency_symbol );
                                                    $( "#price_up span.filter-dynamic-data-max" ).text( addCommas( $( "#priceUpRange2" ).slider( "values", 1 ) ) + currency_symbol );
                                                } else {
                                                    $( "#price_up span.filter-dynamic-data-min" ).text( currency_symbol + addCommas( $( "#priceUpRange2" ).slider( "values", 0 ) ) );
                                                    $( "#price_up span.filter-dynamic-data-max" ).text( currency_symbol + addCommas( $( "#priceUpRange2" ).slider( "values", 1 ) ) );
                                                }

                                                $('#priceUpRange2').draggable();

                                                function addCommas(nStr) {
                                                    nStr += '';
                                                    var x = nStr.split('.');
                                                    var x1 = x[0];
                                                    var x2 = x.length > 1 ? '.' + x[1] : '';
                                                    var rgx = /(\d+)(\d{3})/;
                                                    while (rgx.test(x1)) {
                                                        x1 = x1.replace(rgx, '$1' + ' ' + '$2');
                                                    }
                                                    return x1 + x2;
                                                }

                                            })
                                        </script>

                                    </div>

                                    <div class="d-none d-lg-block col-lg-3">

                                        <a id="autoroyal-advanced-options" href="#"><i class="material-icons">more_horiz</i></a>

                                    </div>

                                    <div class="col-sm-12 col-md-6 col-lg-4">

                                        <button type="submit" class="btn btn-default autoroyal-homepage-filter-button mt-1"><?php esc_html_e('Search', 'autoroyal' ); ?></button>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="autoroyal-filter-advanced-fields">

                        <div class="row mb-4">

                            <div class="col-md-3">

                                <div class="form-group"> 
                                    
                                    <div class="title"><?php esc_html_e('Condition', 'autoroyal' ); ?></div>

                                    <select id="vehicle_condition" name="vehicle_condition" class="chosen-select">
                                        <option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
                                        <option value="Used"><?php esc_html_e('Used', 'autoroyal' ); ?></option>
                                        <option value="New"><?php esc_html_e('New', 'autoroyal' ); ?></option>
                                    </select>

                                </div>

                            </div>

                            <div class="col-md-3">

                                <div class="form-group"> 

                                    <div class="title"><?php esc_html_e('Fuel type', 'autoroyal' ); ?></div>

                                    <select id="fuel_type" name="fuel_type" class="chosen-select">
                                        
                                        <option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
                                        <?php

                                            $categories = get_categories( array('taxonomy' => 'vehicle_fuel_type', 'hide_empty' => true,  'parent' => 0) );

                                            foreach ($categories as $category) {

                                                $option = '<option value="'.$category->term_id.'">';
                                                $option .= $category->cat_name;
                                                $option .= '</option>';

                                                echo $option;

                                            }

                                        ?>

                                    </select>

                                </div>

                            </div>

                            <div class="col-md-3">

                                <div class="form-group"> 

                                    <div class="title"><?php esc_html_e('Transmission', 'autoroyal' ); ?></div>

                                    <select id="transmission" name="transmission" class="chosen-select">
                                        
                                        <option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
                                        <?php

                                            $categories_transmission = get_categories( array('taxonomy' => 'vehicle_transmission', 'hide_empty' => true,  'parent' => 0) );

                                            foreach ($categories_transmission as $category_transmission) {

                                                $option_cat = '<option value="'.$category_transmission->term_id.'">';
                                                $option_cat .= $category_transmission->cat_name;
                                                $option_cat .= '</option>';

                                                echo $option_cat;

                                            }

                                        ?>

                                    </select>

                                </div>

                            </div>

                            <div class="col-md-3">

                                <div class="form-group"> 

                                    <div class="title"><?php esc_html_e('Body Style', 'autoroyal' ); ?></div>

                                    <select id="body_style" name="body_style" class="chosen-select">
                                        
                                        <option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
                                        <?php

                                            $categories_body_style = get_categories( array('taxonomy' => 'vehicle_body_style', 'hide_empty' => true,  'parent' => 0) );

                                            foreach ($categories_body_style as $category_body_style) {

                                                $option = '<option value="'.$category_body_style->term_id.'">';
                                                $option .= $category_body_style->cat_name;
                                                $option .= '</option>';

                                                echo $option;

                                            }

                                        ?>

                                    </select>

                                </div>

                            </div>

                        </div>

                        <div class="row">

                            <div class="col-md-3">

                                <div class="form-group custom-range"> 

                                    <div class="title">
                                        <?php esc_html_e('Year', 'autoroyal' ); ?>
                                    </div>

                                    <div class="range-wrapper">
                                        <a class="open_range">
                                            <span id="year_up" class="filter-dynamic-data">
                                                <span class="filter-dynamic-data-min"></span> - <span class="filter-dynamic-data-max"></span>
                                            </span>
                                            <i class="material-icons">expand_more</i>
                                        </a>
                                        <div class="range-container">
                                            <div class="range-holder">
                                                <div id="registrationRange2" class="pull-right"></div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="vehicle_year_max" id="cd-registration2" readonly class="filter-meta">
                                        <input type="hidden" name="vehicle_year_min" id="cd-registration1" readonly class="filter-meta">
                                    </div>

                                    <script>
                                        jQuery("document").ready(function(){

                                            var regYearMin = parseFloat(<?php echo autoroyal_get_min_year(); ?>);
                                            var regYearMax = parseFloat(<?php echo autoroyal_get_max_year(); ?>);

                                            $( "#registrationRange2" ).slider({
                                                range: true,
                                                min: regYearMin,
                                                max: regYearMax,
                                                values: [ regYearMin, regYearMax ],
                                                slide: function( event, ui ) {
                                                    $( "#cd-registration1" ).val( ui.values[ 0 ] );
                                                    $( "#cd-registration2" ).val( ui.values[ 1 ] );

                                                    $( "#year_up span.filter-dynamic-data-min" ).text( ui.values[ 0 ] );
                                                    $( "#year_up span.filter-dynamic-data-max" ).text( ui.values[ 1 ] );
                                                }
                                            });
                                            $( "#cd-registration1" ).val( $( "#registrationRange2" ).slider( "values", 0 ) );
                                            $( "#cd-registration2" ).val( $( "#registrationRange2" ).slider( "values", 1 ) );

                                            $( "#year_up span.filter-dynamic-data-min" ).text( $( "#registrationRange2" ).slider( "values", 0 ) );
                                            $( "#year_up span.filter-dynamic-data-max" ).text( $( "#registrationRange2" ).slider( "values", 1 ) );

                                            $('#registrationRange2').draggable();

                                        })
                                    </script>
                                
                                </div>

                            </div>

                            <div class="col-md-3">

                                <div class="form-group custom-range">

                                    <div class="title">
                                        <?php esc_html_e('Mileage', 'autoroyal' ); ?>
                                    </div>

                                    <div class="range-wrapper">
                                        <a class="open_range">
                                            <span id="mileage_up" class="filter-dynamic-data">
                                                <span class="filter-dynamic-data-min"></span> - <span class="filter-dynamic-data-max"></span>
                                            </span>
                                            <i class="material-icons">expand_more</i>
                                        </a>
                                        <div class="range-container">
                                            <div class="range-holder">
                                                <div id="mileageRange2" class="pull-right"></div>
                                            </div>
                                        </div>
                                        <input type="hidden" name="mileage_min" id="cd-mileage1" readonly class="filter-meta">
                                        <input type="hidden" name="mileage" id="cd-mileage2" readonly class="filter-meta">
                                    </div>

                                    <?php $mileage_min = autoroyal_get_min_mileage(); $mileage = autoroyal_get_max_mileage(); ?>

                                    <script>

                                        jQuery("document").ready(function(){

                                            var mileageMin = parseFloat(<?php echo esc_attr($mileage_min / 1000); ?>);
                                            var mileageMax = parseFloat(<?php echo esc_attr($mileage / 1000); ?>);

                                            $( "#mileageRange2" ).slider({
                                                range: true,
                                                min: Math.floor(mileageMin),
                                                max: Math.ceil(mileageMax),
                                                values: [ Math.floor(mileageMin), Math.ceil(mileageMax) ],
                                                slide: function( event, ui ) {
                                                    $( "#cd-mileage1" ).val( ui.values[ 0 ] );
                                                    $( "#cd-mileage2" ).val( ui.values[ 1 ] );

                                                    $( "#mileage_up span.filter-dynamic-data-min" ).text( ui.values[ 0 ] + "K" );
                                                    $( "#mileage_up span.filter-dynamic-data-max" ).text( ui.values[ 1 ] + "K" );
                                                }
                                            });
                                            $( "#cd-mileage1" ).val( $( "#mileageRange2" ).slider( "values", 0 ) );
                                            $( "#cd-mileage2" ).val( $( "#mileageRange2" ).slider( "values", 1 ) );

                                            $( "#mileage_up span.filter-dynamic-data-min" ).text( $( "#mileageRange2" ).slider( "values", 0 ) + "K" );
                                            $( "#mileage_up span.filter-dynamic-data-max" ).text( $( "#mileageRange2" ).slider( "values", 1 ) + "K" );

                                            $('#mileageRange2').draggable();

                                        })
                                    </script>

                                </div> 

                            </div>

                            <div class="col-md-6">

                                <div class="aside-blk colors">

                                    <div class="title">
                                        <?php esc_html_e('Exterior color', 'autoroyal' ); ?>
                                    </div>

                                    <ul class="list-inline color-list multiple">

                                        <?php

                                            $vehicle_colors = $autoroyal_vehicles_query["vehicle_color"];
                                            foreach ( $vehicle_colors as $vehicle_colors_item ) {

                                                $vehicle_color_obj = get_term_by( 'id', $vehicle_colors_item, 'vehicle_exterior_color' );
                                                if(!empty($vehicle_color_obj)) {
                                                    $vehicle_color_name = $vehicle_color_obj->name;
                                                } else {
                                                    $vehicle_color_name = "";
                                                }

                                                $color      = autoroyal_get_term_color( $vehicle_colors_item, true );
                                                $color_id   = $vehicle_colors_item;
                                                $color_name = $vehicle_color_name;
                                                $color_type = get_term_meta( $vehicle_colors_item, 'color_type', true );

                                                ?>

                                                    <?php if($color_type == "combined") { ?>

                                                        <li id="autoroyal-filter-vehicle-color-<?php echo esc_attr($vehicle_colors_item); ?>">
                                                            <button type="button" class="btn btn-default" data-toggle="tooltip" data-value="<?php echo esc_attr($vehicle_colors_item); ?>" data-placement="top" title="<?php esc_html_e('Combined', 'autoroyal' ); ?>"
                                                                  style="background: #ebdec9;
                                                                         background: -moz-linear-gradient(left,  #ebdec9 0%, #ebdec9 50%, #000333 50%, #000333 100%);
                                                                         background: -webkit-linear-gradient(left,  #ebdec9 0%,#ebdec9 50%,#000333 50%,#000333 100%);
                                                                         background: linear-gradient(to right,  #ebdec9 0%,#ebdec9 50%,#000333 50%,#000333 100%);
                                                                         filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#ebdec9', endColorstr='#000333',GradientType=1 );">
                                                            </button>
                                                        </li>

                                                    <?php } elseif($color_type == "na") { ?>

                                                        <li id="autoroyal-filter-vehicle-color-<?php echo esc_attr($vehicle_colors_item); ?>">
                                                            <button type="button" class="btn btn-default" style="background-color: #cccccc" data-toggle="tooltip" data-value="<?php echo esc_attr($vehicle_colors_item); ?>" data-placement="top" title="<?php esc_html_e('N/A', 'autoroyal' ); ?>" ><?php esc_html_e('N/A', 'autoroyal' ); ?></button>
                                                        </li>

                                                    <?php } else { ?>

                                                        <li id="autoroyal-filter-vehicle-color-<?php echo esc_attr($vehicle_colors_item); ?>">
                                                            <button type="button" class="btn btn-default" data-toggle="tooltip" data-value="<?php echo esc_attr($vehicle_colors_item); ?>" data-placement="top" title="<?php echo esc_attr($color_name); ?>" style="background-color: <?php echo esc_attr($color); ?>"></button>
                                                        </li>

                                                    <?php } ?>

                                                <?php
                                            }

                                        ?>

                                        <div class="clearfix"></div>

                                    </ul>

                                    <div id="autoroyal-filter-color-wrapper"></div>

                                </div>

                            </div>

                        </div>

                    </div>

                </form>
            <?php } ?>

        </div>

    </div>

	<?php

    wp_enqueue_style(
        'autoroyal-custom-style-search',
        get_template_directory_uri() . '/assets/css/custom-styles.css'
    );

    if( $add_custom_colors === "true" ) {

        if(!empty($bg_color)) {

            $custom_bg_color = "

                    .{$form_class} .search-form-wrapper { 
                        background-color: {$bg_color} !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-search', $custom_bg_color );

        }

        if(!empty($label_color)) {

            $custom_label_color = "

                    .{$form_class}.autoroyal-homepage-search-box .search-form-wrapper .title, 
                    .{$form_class}.autoroyal-homepage-search-box .search-form-wrapper .title #price_up, .control-label,
                    .{$form_class} .search-form-wrapper .chosen-container-single .chosen-single div i.material-icons,
                    .{$form_class} .search-form-wrapper .open_range .material-icons { 
                        color: {$label_color} !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-search', $custom_label_color );

        }

        if(!empty($title_color)) {

            $custom_title_color = "

                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container-single .chosen-single, 
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container-active.chosen-with-drop .chosen-single,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper a#autoroyal-advanced-options,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container.chosen-container-single.chosen-with-drop.chosen-container-active .chosen-single
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container-single .chosen-single:hover, 
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container-active.chosen-with-drop .chosen-single:hover,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper a#autoroyal-advanced-options:hover,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .open_range,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .open_range:hover { 
                        color: {$title_color} !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-search', $custom_title_color );

        }

        if(!empty($btn_bg_color)) {

            $custom_btn_bg_color = "

                    .autoroyal-homepage-search-box.{$form_class} .search-form-wrapper .autoroyal-homepage-filter-button { 
                        background-color: {$btn_bg_color} !important;
                        color: #fff !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-search', $custom_btn_bg_color );

        }

        if(!empty($btn_bg_hover_color)) {

            $custom_btn_bg_hover_color = "

                    .autoroyal-homepage-search-box.{$form_class} .search-form-wrapper .autoroyal-homepage-filter-button:hover { 
                        background-color: {$btn_bg_hover_color} !important;
                        color: #fff !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-search', $custom_btn_bg_hover_color );

        }

    }

	return ob_get_clean();

}
add_shortcode( 'autoroyal_homepage_search_block', 'autoroyal_homepage_search_block_func' );

vc_map( array(
  	'name' => esc_html__( 'Search Block', 'autoroyal' ),
	'base' => 'autoroyal_homepage_search_block',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Search block', 'autoroyal' ),
	'params' => array(
        array(
            'type' => 'checkbox',
            'heading' => esc_html__( 'Add custom colors?', 'autoroyal' ),
            'param_name' => 'add_custom_colors',
            'std' => 'false',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Background Color', 'autoroyal' ),
            'param_name' => 'bg_color',
            'description' => esc_html__( 'Select background color.', 'autoroyal' ),
            'std' => '#0c3eb8',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Pre labels color', 'autoroyal' ),
            'param_name' => 'label_color',
            'description' => esc_html__( 'Select pre labels color.', 'autoroyal' ),
            'std' => '#96abdf',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Labels Color', 'autoroyal' ),
            'param_name' => 'title_color',
            'description' => esc_html__( 'Select labels color.', 'autoroyal' ),
            'std' => '#ffffff',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Button Background Color', 'autoroyal' ),
            'param_name' => 'btn_bg_color',
            'description' => esc_html__( 'Select button background color.', 'autoroyal' ),
            'std' => '#FF3366',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Button Hover Background Color', 'autoroyal' ),
            'param_name' => 'btn_bg_hover_color',
            'description' => esc_html__( 'Select button hover background color.', 'autoroyal' ),
            'std' => '#de2c59',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

