<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_homepage_search_rent_block_func( $atts ) {

	extract( shortcode_atts( array(
        "add_custom_colors" => "",
        "bg_color" => "#0c3eb8",
        "label_color" => "#96abdf",
        "title_color" => "#ffffff",
        "btn_bg_color" => "#FF3366",
        "btn_bg_hover_color" => "#de2c59",
    	"css" => "",
   	), $atts ) );

	ob_start();

    // Enqueue styles
    wp_enqueue_style( 'jquery-ui' );
    wp_enqueue_style( 'bootstrap-select' );

    // Enqueue scripts
    wp_enqueue_script( 'jquery-ui-slider' );
    wp_enqueue_script( 'jquery-ui-autocomplete' );
    wp_enqueue_script( 'touch-punch' );
    wp_enqueue_script( 'time-picker' );
    wp_enqueue_script( 'bootstrap-select' );

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

    //
    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    $vehicles_search_url = "";
    $vehicles_search_url = get_option("autoroyal_search_rent_vehicles_page_id");

    $unique_id = uniqid();
    $form_class = "autoroyal_search_" . $unique_id;

	?>

    <div class="<?php echo esc_attr($css_class); ?>">

        <div class="autoroyal-homepage-search-box autoroyal-homepage-search-box-rent <?php echo esc_attr($form_class); ?>">

            <?php if(!empty($vehicles_search_url)) { ?>
                <form id="autoroyal-advance-search-form" action="<?php echo get_permalink( $vehicles_search_url ); ?>" method="GET">

                    <div class="search-form-wrapper">

                        <div class="row">

                            <div class="col-md-4 ">

                                <div class="row">

                                    <div class="col-lg-6 col-md-12 right-separator sm-mb-30 md-mb-30">

                                        <div class="title"><?php esc_html_e('Pick-up location', 'autoroyal' ); ?></div>
                                        <select id="rezerve-pickup-place-filter" name="rezerve-pickup-place-filter" class="chosen-select" autocomplete="off">
                                            <option value="0"><?php esc_html_e('Select location', 'autoroyal'); ?></option>
                                            <?php

                                                $categories = get_categories( array('taxonomy' => 'vehicle_rent_pickup', 'hide_empty' => false,  'parent' => 0) );
                                                foreach ($categories as $category) {

                                            ?>
                                            <option value="<?php echo esc_attr($category->cat_name); ?>"><?php echo esc_attr($category->cat_name); ?></option>
                                            <?php } ?>
                                        </select>

                                    </div>

                                    <div class="col-lg-6 col-md-12 right-separator">

                                        <div class="title"><?php esc_html_e('Return location', 'autoroyal' ); ?></div>
                                        <select id="rezerve-drop-place-filter" name="rezerve-drop-place-filter" class="chosen-select" autocomplete="off">
                                            <option value="0"><?php esc_html_e('Select location', 'autoroyal'); ?></option>
                                            <?php

                                                $categories = get_categories( array('taxonomy' => 'vehicle_rent_pickup', 'hide_empty' => false,  'parent' => 0) );
                                                foreach ($categories as $category) {

                                            ?>
                                            <option value="<?php echo esc_attr($category->cat_name); ?>"><?php echo esc_attr($category->cat_name); ?></option>
                                            <?php } ?>
                                        </select>

                                    </div>

                                </div>

                            </div>

                            <div class="col-md-8 ">

                                <div class="row">

                                    <div class="col-lg-9 col-md-8">

                                        <div class="row">

                                            <div class="col-lg-6 col-md-12 right-separator sm-mb-30 md-mb-30">

                                                <div class="autoroyal-rent-filter-date">

                                                    <div class="title"><?php esc_html_e('Pick-up date', 'autoroyal' ); ?></div>
                                                    <div class="form-group input-append mt-2">
                                                        <input type="text" name="rezerve-pickup-date" placeholder="<?php esc_attr_e('Choose a date', 'autoroyal'); ?>" class="daySelect" id="curentDay-filter" autocomplete="off">
                                                    </div>

                                                </div>

                                                <div class="autoroyal-rent-filter-time">

                                                    <div class="title"><?php esc_html_e('Pick-up time', 'autoroyal' ); ?></div>
                                                    <div class="form-group input-append timepick mt-2">
                                                        <input type="text" name="rezerve-pickup-time" placeholder="12:00 AM" id="curentHour-filter" autocomplete="off">
                                                    </div>

                                                </div>

                                            </div>

                                            <div class="col-lg-6 col-md-12 right-separator">

                                                <div class="autoroyal-rent-filter-date">

                                                    <div class="title"><?php esc_html_e('Return date', 'autoroyal' ); ?></div>
                                                    <div class="form-group input-append mt-2">
                                                        <input type="text" name="rezerve-drop-date" placeholder="<?php esc_attr_e('Choose a date', 'autoroyal'); ?>" class="daySelect" id="dropDay-filter" autocomplete="off">
                                                    </div>

                                                </div>

                                                <div class="autoroyal-rent-filter-time">

                                                    <div class="title"><?php esc_html_e('Return time', 'autoroyal' ); ?></div>
                                                    <div class="form-group input-append timepick mt-2">
                                                        <input type="text" name="rezerve-drop-time" placeholder="12:00 AM" id="dropHour-filter" autocomplete="off">
                                                    </div>

                                                </div>

                                            </div>

                                        </div>

                                    </div>

                                    <div class="col-lg-3 col-md-4">

                                        <button type="submit" class="btn btn-default autoroyal-homepage-filter-button mt-2"><?php esc_html_e('Search', 'autoroyal' ); ?></button>

                                    </div>

                                </div>

                            </div>

                        </div>

                    </div>

                </form>
            <?php } ?>

        </div>

    </div>

	<?php

    wp_enqueue_style(
        'autoroyal-custom-style-rent',
        get_template_directory_uri() . '/assets/css/custom-styles.css'
    );

    if( $add_custom_colors === "true" ) {

        if(!empty($bg_color)) {

            $custom_bg_color = "

                    .{$form_class} .search-form-wrapper { 
                        background-color: {$bg_color} !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-rent', $custom_bg_color );

        }

        if(!empty($label_color)) {

            $custom_label_color = "

                    .{$form_class}.autoroyal-homepage-search-box .search-form-wrapper .title, 
                    .{$form_class}.autoroyal-homepage-search-box .search-form-wrapper .title #price_up, .control-label,
                    .{$form_class} .search-form-wrapper .chosen-container-single .chosen-single div i.material-icons,
                    .{$form_class} .search-form-wrapper .open_range .material-icons { 
                        color: {$label_color} !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-rent', $custom_label_color );

        }

        if(!empty($title_color)) {

            $custom_title_color = "

                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container-single .chosen-single, 
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container-active.chosen-with-drop .chosen-single,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper a#autoroyal-advanced-options,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container.chosen-container-single.chosen-with-drop.chosen-container-active .chosen-single
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container-single .chosen-single:hover, 
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .chosen-container-active.chosen-with-drop .chosen-single:hover,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper a#autoroyal-advanced-options:hover,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .open_range,
                    .{$form_class} #autoroyal-advance-search-form .search-form-wrapper .open_range:hover { 
                        color: {$title_color} !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-rent', $custom_title_color );

        }

        if(!empty($btn_bg_color)) {

            $custom_btn_bg_color = "

                    .autoroyal-homepage-search-box.{$form_class} .search-form-wrapper .autoroyal-homepage-filter-button { 
                        background-color: {$btn_bg_color} !important;
                        color: #fff !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-rent', $custom_btn_bg_color );

        }

        if(!empty($btn_bg_hover_color)) {

            $custom_btn_bg_hover_color = "

                    .autoroyal-homepage-search-box.{$form_class} .search-form-wrapper .autoroyal-homepage-filter-button:hover { 
                        background-color: {$btn_bg_hover_color} !important;
                        color: #fff !important;
                    }

                    ";
            wp_add_inline_style( 'autoroyal-custom-style-rent', $custom_btn_bg_hover_color );

        }

    }

	return ob_get_clean();

}
add_shortcode( 'autoroyal_homepage_search_rent_block', 'autoroyal_homepage_search_rent_block_func' );

vc_map( array(
  	'name' => esc_html__( 'Search For Rent Block', 'autoroyal' ),
	'base' => 'autoroyal_homepage_search_rent_block',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Search vehicles for rent block', 'autoroyal' ),
	'params' => array(
        array(
            'type' => 'checkbox',
            'heading' => esc_html__( 'Add custom colors?', 'autoroyal' ),
            'param_name' => 'add_custom_colors',
            'std' => 'false',
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Background Color', 'autoroyal' ),
            'param_name' => 'bg_color',
            'description' => esc_html__( 'Select background color.', 'autoroyal' ),
            'std' => '#0c3eb8',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Pre labels color', 'autoroyal' ),
            'param_name' => 'label_color',
            'description' => esc_html__( 'Select pre labels color.', 'autoroyal' ),
            'std' => '#96abdf',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Labels Color', 'autoroyal' ),
            'param_name' => 'title_color',
            'description' => esc_html__( 'Select labels color.', 'autoroyal' ),
            'std' => '#ffffff',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Button Background Color', 'autoroyal' ),
            'param_name' => 'btn_bg_color',
            'description' => esc_html__( 'Select button background color.', 'autoroyal' ),
            'std' => '#FF3366',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Button Hover Background Color', 'autoroyal' ),
            'param_name' => 'btn_bg_hover_color',
            'description' => esc_html__( 'Select button hover background color.', 'autoroyal' ),
            'std' => '#de2c59',
            'dependency' => array(
                'element' => 'add_custom_colors',
                'value' => 'true',
            ),
        ),
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

