<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_entry_title_func( $atts, $content ) {

	extract( shortcode_atts( array(
		'title' => 'Title',
		'badge' => '',
		'title_color' => '#2c425d',
		'pretitle' => '',
		'pre_title_color' => '#696969',
		'align' => 'left',
    	'css' => '',
   	), $atts ) );

	ob_start();

	$class_to_filter = '';
    $class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
    $css_class = $class_to_filter;

	?>

	<div class="autoroyal-entry-title-wrapper <?php echo esc_attr($css_class); ?>">
		<div class="autoroyal-entry-title autoroyal-entry-title-align-<?php echo esc_attr($align); ?>">
			<?php if(!empty($badge)) { ?><p class="ar-badge"><?php echo esc_attr($badge); ?></p><?php } ?>
			<?php if(!empty($title)) { ?><h3 style="color: <?php echo esc_attr($title_color); ?>"><?php echo esc_attr($title); ?></h3><?php } ?>
			<?php if(!empty($pretitle)) { ?><h5 style="color: <?php echo esc_attr($pre_title_color); ?>"><?php echo esc_attr($pretitle); ?></h5><?php } ?>
		</div>
    </div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_entry_title', 'autoroyal_entry_title_func' );

vc_map( array(
  	'name' => esc_html__( 'Entry Title', 'autoroyal' ),
	'base' => 'autoroyal_entry_title',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoroyal icon box', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Title', 'autoroyal' ),
			'param_name' => 'title',
			'admin_label' => true,
			'value' => esc_html__( 'Title', 'autoroyal' ),
		),
		array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Title Color', 'autoroyal' ),
            'param_name' => 'title_color',
            'description' => esc_html__( 'Select color for title.', 'autoroyal' ),
            'std' => '#2c425d',
        ),
        array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Badge', 'autoroyal' ),
			'param_name' => 'badge',
			'admin_label' => true,
		),
        array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Sub Title', 'autoroyal' ),
			'param_name' => 'pretitle',
			'admin_label' => true,
			'value' => esc_html__( 'Sub Title', 'autoroyal' ),
		),
		array(
            'type' => 'colorpicker',
            'heading' => esc_html__( 'Sub Title Color', 'autoroyal' ),
            'param_name' => 'pre_title_color',
            'description' => esc_html__( 'Select color for pre title.', 'autoroyal' ),
            'std' => '#696969',
        ),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Align', 'autoroyal' ),
			'value' => array(
				__( 'Left', 'autoroyal' ) => 'left',
				__( 'Center', 'autoroyal' ) => 'center',
				__( 'Right', 'autoroyal' ) => 'right',
			),
			'param_name' => 'align',
			'description' => esc_html__( 'Select align.', 'autoroyal' ),
			'std' => 'left',
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),

));

