<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_cta_text_block_func( $atts, $content ) {

	extract( shortcode_atts( array(
		'image' => '',
		'title' => '',
		'custom_cta_bg_color' => '#0C3EB8',
		'custom_title_color' => '#ffffff',
		'content_text' => '',
		'custom_subtitle_color' => '#96ABDF',
		'button_text' => '',
		'button_url' => '',
		'custom_background_color' => '#4829B2',
		'custom_text_color' => '#ffffff',
		'custom_background_color_hover' => '#3b2293',
		'custom_text_color_hover' => '#ffffff',
    	'css' => '',
   	), $atts ) );

	ob_start();

	$img_id = preg_replace( '/[^\d]/', '', $image );
	$link_image = wp_get_attachment_image_src( $img_id, 'full' );
	$img_src = $link_image[0];

	$class_to_filter = vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

	$unique_id = uniqid();
	$button_class = "autoroyal_button_class_" . $unique_id;
	$cta_class = "autoroyal_cta_" . $unique_id;

	?>

	<div class="<?php echo esc_attr($css_class); ?> <?php echo esc_attr($cta_class); ?> p-5 aos-init aos-animate autoroyal-cta" data-aos="fade-up">
      	<div class="row justify-content-between align-items-center text-center text-md-left">
	        <div class="col-md-8 sm-mb-30">
	          	<?php if(!empty($title)) { ?><h3><?php echo esc_attr($title); ?></h3><?php } ?>
	          	<?php if(!empty($content_text)) { ?><h5 class="mb-0"><?php echo esc_attr($content_text); ?></h5><?php } ?>
	        </div>
	        <div class="col-md-4 text-lg-right">
	          	<?php if(!empty($button_url) AND !empty($button_text)) { ?>
	          		<a class="btn btn-icon-right <?php echo esc_attr($button_class); ?>" href="<?php echo esc_url($button_url); ?>"><?php echo esc_attr($button_text); ?> <i class="material-icons">trending_flat</i></a>
	          	<?php } ?>
	        </div>
      	</div>
    </div>

	<?php

	wp_enqueue_style(
		'autoroyal-custom-style-cta',
		get_template_directory_uri() . '/assets/css/custom-styles.css'
	);

    // Main Hover Color
	if(!empty($custom_cta_bg_color)) {

        $custom_custom_cta_bg_color = "

                .{$cta_class} { 
                    background-color: {$custom_cta_bg_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-cta', $custom_custom_cta_bg_color );

    }

    // Main Hover Color
	if(!empty($custom_background_color)) {

        $custom_css_custom_background_color = "

                .{$button_class} { 
                    background-color: {$custom_background_color};
                    border-color: {$custom_background_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-cta', $custom_css_custom_background_color );

    }

    // Main Hover Color
	if(!empty($custom_title_color)) {

        $custom_custom_title_color = "

                .{$cta_class} h3 { 
                    color: {$custom_title_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-cta', $custom_custom_title_color );

    }

    // Main Hover Color
	if(!empty($custom_subtitle_color)) {

        $custom_custom_subtitle_color = "

                .{$cta_class} h5 { 
                    color: {$custom_subtitle_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-cta', $custom_custom_subtitle_color );

    }

    if(!empty($custom_text_color)) {

        $custom_css_custom_text_color = "

                .{$button_class} { 
                    color: {$custom_text_color};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-cta', $custom_css_custom_text_color );

    }

    if(!empty($custom_background_color_hover)) {

        $custom_css_custom_background_color_hover = "

                .{$button_class}:hover { 
                    background-color: {$custom_background_color_hover};
                    border-color: {$custom_background_color_hover};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-cta', $custom_css_custom_background_color_hover );

    }

    if(!empty($custom_text_color_hover)) {

        $custom_css_custom_text_color_hover = "

                .{$button_class}:hover { 
                    color: {$custom_text_color_hover};
                }

                ";
        wp_add_inline_style( 'autoroyal-custom-style-cta', $custom_css_custom_text_color_hover );

    }

	return ob_get_clean();

}
add_shortcode( 'autoroyal_cta_text_block', 'autoroyal_cta_text_block_func' );

vc_map( array(
  	'name' => esc_html__( 'Call to Action', 'autoroyal' ),
	'base' => 'autoroyal_cta_text_block',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Custom autoRoyal call to action block', 'autoroyal' ),
	'params' => array(
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'CTA Background Color', 'autoroyal' ),
			'param_name' => 'custom_cta_bg_color',
			'description' => esc_html__( 'Select cta background color.', 'autoroyal' ),
			'std' => '#0C3EB8',
		),
		array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Title', 'autoroyal' ),
            'param_name' => 'title',
            'value' => '',
            'description' => esc_html__( 'Enter title here.', 'autoroyal' ),
            'admin_label' => true,
        ),
        array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Title Color', 'autoroyal' ),
			'param_name' => 'custom_title_color',
			'description' => esc_html__( 'Select custom title color for your element.', 'autoroyal' ),
			'std' => '#ffffff',
		),
		array(
			'type' => 'textarea',
			'heading' => esc_html__( 'Sub Title', 'autoroyal' ),
			'param_name' => 'content_text',
			'value' => '',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Sub Title Color', 'autoroyal' ),
			'param_name' => 'custom_subtitle_color',
			'description' => esc_html__( 'Select custom sub title color for your element.', 'autoroyal' ),
			'std' => '#96ABDF',
		),
		array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Button URL', 'autoroyal' ),
            'param_name' => 'button_url',
            'value' => '',
            'description' => esc_html__( 'Enter button url here.', 'autoroyal' ),
        ),
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Button Label', 'autoroyal' ),
            'param_name' => 'button_text',
            'value' => '',
            'description' => esc_html__( 'Enter button label here.', 'autoroyal' ),
            'admin_label' => true,
        ),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Button Background', 'autoroyal' ),
			'param_name' => 'custom_background_color',
			'description' => esc_html__( 'Select custom background color for your element.', 'autoroyal' ),
			'edit_field_class' => 'vc_col-sm-6',
			'std' => '#4829B2',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Button Text Color', 'autoroyal' ),
			'param_name' => 'custom_text_color',
			'description' => esc_html__( 'Select custom text color for your element.', 'autoroyal' ),
			'edit_field_class' => 'vc_col-sm-6',
			'std' => '#ffffff',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Button Hover Background Color', 'autoroyal' ),
			'param_name' => 'custom_background_color_hover',
			'description' => esc_html__( 'Select custom background color for your element.', 'autoroyal' ),
			'edit_field_class' => 'vc_col-sm-6',
			'std' => '#3b2293',
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Button Hover Text', 'autoroyal' ),
			'param_name' => 'custom_text_color_hover',
			'description' => esc_html__( 'Select custom text color for your element.', 'autoroyal' ),
			'edit_field_class' => 'vc_col-sm-6',
			'std' => '#ffffff',
		),
		array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Style', 'autoroyal' ),
		),
	),

));

