<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Content class.
 */
class autoroyal_Rent_Post_Type {

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'register_rent_post_type' ), 0 );

		add_filter( 'the_rent_description', 'wptexturize'        );
		add_filter( 'the_rent_description', 'convert_smilies'    );
		add_filter( 'the_rent_description', 'convert_chars'      );
		add_filter( 'the_rent_description', 'wpautop'            );
		add_filter( 'the_rent_description', 'shortcode_unautop'  );
		add_filter( 'the_rent_description', 'prepend_attachment' );
		if ( ! empty( $GLOBALS['wp_embed'] ) ) {
			add_filter( 'the_rent_description', array( $GLOBALS['wp_embed'], 'run_shortcode' ), 8 );
			add_filter( 'the_rent_description', array( $GLOBALS['wp_embed'], 'autoembed' ), 8 );
		}

		add_filter( 'wp_insert_post_data', array( $this, 'fix_rent_post_name' ), '99', 2 );

	}

	/**
	 * register_rent_post_type function.
	 *
	 * @access public
	 * @return void
	 */
	public function register_rent_post_type() {
		
		if ( post_type_exists( "rent" ) )
			return;

		// Deal Method of Payment
	    $singular  = __( 'Extra Option', 'autoroyal' );
		$plural    = __( 'Extra Options', 'autoroyal' );

		if ( current_theme_supports( 'rent-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'rent-method-of-payment', 'rent status slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "rent_extra_options",
			apply_filters( 'register_taxonomy_deal_payment_meyhod_object_type', array( 'rent' ) ),
	   	 	apply_filters( 'register_taxonomy_deal_payment_meyhod_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Extra Option', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Extra Option', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Extra Option', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Extra Option:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Extra Option', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Extra Option', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Extra Option', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Extra Option', 'autoroyal' ),  $singular )
	        	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

		// Taxonomies
	    $taxonomies = array(
			"rent_extra_options" => array(
				"Insurance",
				"Child seat",
				"Additional driver"
			)
		);

		$autoroyal_rents_installed_terms = get_option( 'autoroyal_rents_installed_terms' );

		if( !isset($autoroyal_rents_installed_terms) OR empty($autoroyal_rents_installed_terms) ) {

			foreach ( $taxonomies as $taxonomy => $terms ) {

				foreach ( $terms as $term ) {

					if( is_array( $term ) ) {

						if ( ! get_term_by( 'slug', sanitize_title( $term[0] ), $taxonomy ) ) {
							
							$submit_term = wp_insert_term( $term[0], $taxonomy );

							if ( is_wp_error( $submit_term ) ) {
							   	$error_string = $submit_term->get_error_message();
							   	echo '<div id="message" class="error"><p>' . $error_string . ' - ' . $taxonomy . ' - ' . $s . '</p></div>';
							}

							if ( ! is_wp_error( $submit_term ) ) {
							    // Get term_id, set default as 0 if not set
							    $term_id = isset( $submit_term['term_id'] ) ? $submit_term['term_id'] : 0;

							    foreach ( $term as $sub_term ) {

									if ( ! get_term_by( 'slug', sanitize_title( $sub_term ), $taxonomy ) ) {

										if( $term[0] != $sub_term ) {

											$submit_term = wp_insert_term( $sub_term, $taxonomy, array( 'parent' => $term_id) );

										}

									}

								}
							}

						};

					} else {
						
						if ( ! get_term_by( 'slug', sanitize_title( $term ), $taxonomy ) ) {
							
							$submit_term = wp_insert_term( $term, $taxonomy );

							if ( ! is_wp_error( $submit_term ) ) {
							    // Get term_id, set default as 0 if not set
							    $term_id = isset( $submit_term['term_id'] ) ? $submit_term['term_id'] : 0;
							}

							if ( is_wp_error( $submit_term ) ) {
							   	$error_string = $submit_term->get_error_message();
							   	echo '<div id="message" class="error"><p>' . $error_string . ' - ' . $taxonomy . ' - ' . $s . '</p></div>';
							}

						}

					}

				}

			}

			if( isset($submit_term['term_id']) && !is_wp_error($submit_term) ) {
	            update_option( 'autoroyal_rents_installed_terms', 1 );
	        }

		}

		function autoroyal_get_term_extra_options( $term_id, $hash = false ) {

		    $extra_options = get_term_meta( $term_id, 'extra_options', true );
		    $extra_options = autoroyal_sanitize_hex( $extra_options );

		    return $hash && $extra_options ? "#{$extra_options}" : $extra_options;

		}

		add_action( 'rent_extra_options_add_form_fields', 'ccp_new_term_extra_options_field' );

		function ccp_new_term_extra_options_field() {

		    wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_extra_options_nonce' ); ?>

			<div class="form-field autoroyal-term-extra_options-wrap">
				
				<label for="autoroyal-term-extra_options"><?php esc_html_e( 'Fee Type', 'autoroyal' ); ?></label>
		    	<input type="radio" name="extra_options_type" value="one_time" checked> <?php esc_html_e('One time fee', 'autoroyal' ); ?><br>
	  			<input type="radio" name="extra_options_type" value="per_day" > <?php esc_html_e('Per day', 'autoroyal' ); ?><br>

		  	</div>

		  	<div class="form-field autoroyal-term-coextra_optionslor-wrap">
		        <label for="autoroyal-term-color"><?php esc_html_e( 'Price', 'autoroyal' ); ?></label>
		        <input type="text" name="extra_options_price" id="extra_options_price" value="" class="autoroyal-color-field" />
		    </div>

		    <div class="form-field autoroyal-term-extra_options-wrap">
				
				<label for="autoroyal-term-extra_options"><?php esc_html_e( 'Units', 'autoroyal' ); ?></label>
		    	<input type="radio" name="extra_options_selection_type" value="multiple" checked> <?php esc_html_e('Multiple units selection', 'autoroyal' ); ?><br>
	  			<input type="radio" name="extra_options_selection_type" value="single" > <?php esc_html_e('One unit only', 'autoroyal' ); ?><br>

		  	</div>

		<?php }

		add_action( 'rent_extra_options_edit_form_fields', 'ccp_edit_term_extra_options_field' );

		function ccp_edit_term_extra_options_field( $term ) {

		    $extra_options_type   = get_term_meta( $term->term_id, 'extra_options_type', true );
		    $extra_options_price   = get_term_meta( $term->term_id, 'extra_options_price', true );
		    $extra_options_selection_type   = get_term_meta( $term->term_id, 'extra_options_selection_type', true );

		    if(empty($extra_options_type)) {
		    	$extra_options_type = "one_time";
		    }

		    if(empty($extra_options_price)) {
		    	$extra_options_price = "0";
		    }

		    if(empty($extra_options_selection_type)) {
		    	$extra_options_selection_type = "multiple";
		    }

		    ?>

		    <tr class="form-field autoroyal-term-extra_options-wrap">
		        <th scope="row"><label for="autoroyal-term-extra_options"><?php esc_html_e( 'Fee Type', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_extra_options_nonce' ); ?>
		            <input type="radio" name="extra_options_type" value="one_time" <?php if($extra_options_type == "one_time") { echo "checked"; } ?>> <?php esc_html_e('One time fee', 'autoroyal' ); ?><br>
	  				<input type="radio" name="extra_options_type" value="per_day" <?php if($extra_options_type == "per_day") { echo "checked"; } ?>> <?php esc_html_e('Per day', 'autoroyal' ); ?><br>
		        </td>
		    </tr>

		    <tr class="form-field autoroyal-term-color-wrap">
		        <th scope="row"><label for="autoroyal-term-color"><?php esc_html_e( 'Price', 'autoroyal' ); ?> <?php $currency = autoroyal_get_currency(); if(!empty($currency)) { echo "("; esc_html_e( 'in', 'autoroyal' ); echo " "; echo $currency; echo ")"; } ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_color_nonce' ); ?>
		            <input type="text" name="extra_options_price" id="extra_options_price" value="<?php echo esc_attr( $extra_options_price ); ?>" class=" autoroyal-color-field" />
		            <p class="description"><?php esc_html_e( 'Only digits', 'autoroyal' ); ?></p>
		        </td>
		    </tr>

		    <tr class="form-field autoroyal-term-extra_options-wrap">
		        <th scope="row"><label for="autoroyal-term-extra_options"><?php esc_html_e( 'Units', 'autoroyal' ); ?></label></th>
		        <td>
		            <?php wp_nonce_field( basename( __FILE__ ), 'autoroyal_term_extra_options_nonce' ); ?>
		            <input type="radio" name="extra_options_selection_type" value="multiple" <?php if($extra_options_selection_type == "multiple") { echo "checked"; } ?>> <?php esc_html_e('Multiple units selection', 'autoroyal' ); ?><br>
	  				<input type="radio" name="extra_options_selection_type" value="single" <?php if($extra_options_selection_type == "single") { echo "checked"; } ?>> <?php esc_html_e('One unit only', 'autoroyal' ); ?><br>
		        </td>
		    </tr>

		<?php }

		add_action( 'edited_rent_extra_options', 'autoroyal_save_term_extra_options' );
		add_action( 'create_rent_extra_options', 'autoroyal_save_term_extra_options' );

		function autoroyal_save_term_extra_options( $term_id ) {

		    if ( ! isset( $_POST['autoroyal_term_extra_options_nonce'] ) || ! wp_verify_nonce( $_POST['autoroyal_term_extra_options_nonce'], basename( __FILE__ ) ) )
		        return;

		    $extra_options_type = isset( $_POST['extra_options_type'] ) ? esc_attr( $_POST['extra_options_type'] ) : '';
		    update_term_meta( $term_id, 'extra_options_type', $extra_options_type );

		    $extra_options_price = isset( $_POST['extra_options_price'] ) ? esc_attr( $_POST['extra_options_price'] ) : '';
		    update_term_meta( $term_id, 'extra_options_price', $extra_options_price );

		    $extra_options_selection_type = isset( $_POST['extra_options_selection_type'] ) ? esc_attr( $_POST['extra_options_selection_type'] ) : '';
		    update_term_meta( $term_id, 'extra_options_selection_type', $extra_options_selection_type );
		}

	    /**
		 * Post types
		 */
		$singular  = __( 'Rent Reservation', 'autoroyal' );
		$plural    = __( 'Rent Reservations', 'autoroyal' );

		if ( current_theme_supports( 'rent-manager-templates' ) ) {
			$has_archive = _x( 'rents', 'Post type archive slug - resave permalinks after changing this', 'autoroyal' );
		} else {
			$has_archive = false;
		}

		$rewrite     = array(
			'slug'       => _x( 'rent', 'rent permalink - resave permalinks after changing this', 'autoroyal' ),
			'with_front' => false,
			'feeds'      => true,
			'pages'      => false
		);

		register_post_type( "rent",
			apply_filters( "register_post_type_rent", array(
				'labels' => array(
					'name'			=> $plural,
					'singular_name' 	=> $singular,
					'menu_name'             => __( 'Rent Reservations', 'autoroyal' ),
					'all_items'             => sprintf( __( 'All rents', 'autoroyal' ), $plural ),
					'add_new' 		=> __( 'Add New rent', 'autoroyal' ),
					'add_new_item' 		=> sprintf( __( 'Add %s', 'autoroyal' ), $singular ),
					'edit' 			=> __( 'Edit', 'autoroyal' ),
					'edit_item' 		=> sprintf( __( 'Edit %s', 'autoroyal' ), $singular ),
					'new_item' 		=> sprintf( __( 'New %s', 'autoroyal' ), $singular ),
					'view' 			=> sprintf( __( 'View %s', 'autoroyal' ), $singular ),
					'view_item' 		=> sprintf( __( 'View %s', 'autoroyal' ), $singular ),
					'search_items' 		=> sprintf( __( 'Search %s', 'autoroyal' ), $plural ),
					'not_found' 		=> sprintf( __( 'No %s found', 'autoroyal' ), $plural ),
					'not_found_in_trash' 	=> sprintf( __( 'No %s found in trash', 'autoroyal' ), $plural ),
					'parent' 		=> sprintf( __( 'Parent %s', 'autoroyal' ), $singular ),
				),
				'description' => sprintf( __( 'This is where you can create and manage %s.', 'autoroyal' ), $plural ),
				'public' 				=> true,
				'show_ui' 				=> true,
				'capability_type' 		=> 'vehicle',
				'map_meta_cap'          => true,
				'publicly_queryable' 	=> true,
				'exclude_from_search' 	=> false,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> array( 'title', 'editor', 'custom-fields', 'publicize', 'thumbnail', 'author' ),
				'has_archive' 			=> $has_archive,
				'show_in_nav_menus' 	=> false
			) )
		);

		// Hide text editor in rent back end
		add_action('init', 'init_remove_editor_rent',100);
		function init_remove_editor_rent(){
			$post_type = 'rent';
			remove_post_type_support( $post_type, 'editor');
		}
	}

	/**
	 * Fix post name when wp_update_post changes it
	 * @param  array $data
	 * @return array
	 */
	public function fix_rent_post_name( $data, $postarr ) {

		global $post, $id;

	  	if( 'rent' == $data['post_type'] && isset($data['post_type']) ) {

	  		$id = $postarr['ID'];

			if($id) {

				//$postID = $_POST['reservation_id'];
				$postID = $id;

				if( !isset($_POST['rent_status']) OR empty($_POST['rent_status']) ) {
					$rent_status = "New";
				} else {
					$rent_status = $_POST['rent_status'];
				}

				$pickup_location = esc_attr( $_POST['pickup_location'] );
				$pickup_date = esc_attr( $_POST['pickup_date'] );
				$pickup_time = esc_attr( $_POST['pickup_time'] );

				$reserv_car_days = esc_attr( $_POST['reserv_car_days'] );

				$total_price = esc_attr( $_POST['reserv-car-price-total'] );

				$rent_first_name = esc_attr( $_POST['rent_first_name'] );
				$rent_middle_name = esc_attr( $_POST['rent_middle_name'] );
				$rent_last_name = esc_attr( $_POST['rent_last_name'] );

				$rent_vehicle_id = esc_attr( $_POST['reserv-car-id-2'] );

				$autoroyal_currency = get_option( 'autoroyal_currency' ); 
		    	$currency_symbol = autoroyal_get_currency_symbol( $autoroyal_currency );

				$rent_vehicle_year = esc_attr(get_post_meta($rent_vehicle_id, 'vehicle_year',true));
				$rent_vehicle_make = esc_attr(get_post_meta($rent_vehicle_id, 'vehicle_make_desc_init',true));
				$rent_vehicle_model = esc_attr(get_post_meta($rent_vehicle_id, 'vehicle_model',true));
				$rent_vehicle_trim = esc_attr(get_post_meta($rent_vehicle_id, 'vehicle_trim_desc_init',true));

				$postNewTitle = $rent_status . " - ";

				if(!empty($pickup_location)) {
					$postNewTitle .= $pickup_location . " ";
				}

				if(!empty($pickup_date)) {
					$postNewTitle .= $pickup_date . " ";
				}

				if(!empty($pickup_time)) {
					$postNewTitle .= $pickup_time . " - ";
				}

				if(!empty($reserv_car_days)) {
					$postNewTitle .= $reserv_car_days . " Days ";
				}

				if(!empty($total_price)) {
					$postNewTitle .= $currency_symbol . "" . $total_price . " ";
				}

				if(!empty($rent_first_name)) {
					$postNewTitle .= $rent_first_name . " - ";
				}

				$rentVehicleName = $rent_vehicle_make . " " . $rent_vehicle_model . " " . $rent_vehicle_trim . " " . $rent_vehicle_year;

				if(!empty($rentVehicleName)) {
					$postNewTitle .= $rentVehicleName;
				}

				update_post_meta($postID, 'rent_vehicle_name', $rentVehicleName);

				$data['post_name'] = sanitize_title( $postNewTitle );
				$data['post_title'] = $postNewTitle;

			}

		}

	  	return $data; // Returns the modified data.

	}

}
