<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Content class.
 */
class autoroyal_Lead_Post_Type {

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'register_lead_post_type' ), 0 );

		add_filter( 'the_lead_description', 'wptexturize'        );
		add_filter( 'the_lead_description', 'convert_smilies'    );
		add_filter( 'the_lead_description', 'convert_chars'      );
		add_filter( 'the_lead_description', 'wpautop'            );
		add_filter( 'the_lead_description', 'shortcode_unautop'  );
		add_filter( 'the_lead_description', 'prepend_attachment' );
		if ( ! empty( $GLOBALS['wp_embed'] ) ) {
			add_filter( 'the_lead_description', array( $GLOBALS['wp_embed'], 'run_shortcode' ), 8 );
			add_filter( 'the_lead_description', array( $GLOBALS['wp_embed'], 'autoembed' ), 8 );
		}

		add_filter( 'wp_insert_post_data', array( $this, 'fix_lead_post_name' ), '99', 2 );

	}

	/**
	 * register_lead_post_type function.
	 *
	 * @access public
	 * @return void
	 */
	public function register_lead_post_type() {
		
		if ( post_type_exists( "lead" ) )
			return;

		$admin_capability = 'manage_leads';

	    // Lead Status
	    $singular  = __( 'Lead Status', 'autoroyal' );
		$plural    = __( 'Lead Statuses', 'autoroyal' );

		if ( current_theme_supports( 'car-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'lead-status', 'lead status slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "lead_status",
			apply_filters( 'register_taxonomy_lead_status_object_type', array( 'lead' ) ),
       	 	apply_filters( 'register_taxonomy_lead_status_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Lead Status', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Lead Status', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Lead Status', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Lead Status:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Lead Status', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Lead Status', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Lead Status', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Lead Status', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

		// Up Type
	    $singular  = __( 'Up Type', 'autoroyal' );
		$plural    = __( 'Up Types', 'autoroyal' );

		if ( current_theme_supports( 'car-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'lead-up-type', 'lead up type slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "lead_up_type",
			apply_filters( 'register_taxonomy_lead_up_type_object_type', array( 'lead' ) ),
       	 	apply_filters( 'register_taxonomy_lead_up_type_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Lead Up Type', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Lead Up Type', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Lead Up Type', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Lead Up Type:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Lead Up Type', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Lead Up Type', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Lead Up Type', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Lead Up Type', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

	    // Advertising Source
	    $singular  = __( 'Advertising Source', 'autoroyal' );
		$plural    = __( 'Advertising Sources', 'autoroyal' );

		if ( current_theme_supports( 'car-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'lead-ad-source', 'lead advertising source slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "lead_ad_source",
			apply_filters( 'register_taxonomy_lead_ad_source_object_type', array( 'lead' ) ),
       	 	apply_filters( 'register_taxonomy_lead_ad_source_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Lead Advertising Source', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Lead Advertising Source', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Lead Advertising Source', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Lead Advertising Source:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Lead Advertising Source', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Lead Advertising Source', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Lead Advertising Source', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Lead Advertising Source', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

		// Taxonomies
	    $taxonomies = array(
			'lead_status' => array(
				'New',
				'Left a Voicemail',
				'Email Sent',
				'Video Sent',
				'Assigned',
				'Appointment Set',
				'Viewed',
				'On Test Drive',
				'Test Driven',
				'Working',
				'In Business Office',
				'Awaiting Credit Approval',
				'Could Not Get Financing',
				'Purchased (Elsewhere)',
				'Sold',
				'Deleted',
				'Be Back'
			),
			'lead_up_type' => array(
				'Floor Up',
				'Phone Up',
				'Internet Up',
				'Rent',
			),
			'lead_ad_source' => array(
				'Mail Campaign',
				'Floor Up',
				'Facebook.com',
				'Google.com',
				'Referral',
				'Dealer Website',
				'Repeat Customer',
				'Newspaper',
				'Radio',
				'TV',
				'Sold at Auction',
				'Sold to Dealer',
			)
		);

		$autoroyal_leads_installed_terms = get_option( 'autoroyal_leads_installed_terms' );

		if( !isset($autoroyal_leads_installed_terms) OR empty($autoroyal_leads_installed_terms) ) {

			foreach ( $taxonomies as $taxonomy => $terms ) {

				foreach ( $terms as $term ) {

					if( is_array( $term ) ) {

						if ( ! get_term_by( 'slug', sanitize_title( $term[0] ), $taxonomy ) ) {
							
							$submit_term = wp_insert_term( $term[0], $taxonomy );

							if ( is_wp_error( $submit_term ) ) {
							   	$error_string = $submit_term->get_error_message();
							   	echo '<div id="message" class="error"><p>' . $error_string . ' - ' . $taxonomy . ' - ' . $s . '</p></div>';
							}

							if ( ! is_wp_error( $submit_term ) ) {
							    // Get term_id, set default as 0 if not set
							    $term_id = isset( $submit_term['term_id'] ) ? $submit_term['term_id'] : 0;

							    foreach ( $term as $sub_term ) {

									if ( ! get_term_by( 'slug', sanitize_title( $sub_term ), $taxonomy ) ) {

										if( $term[0] != $sub_term ) {

											$submit_term = wp_insert_term( $sub_term, $taxonomy, array( 'parent' => $term_id) );

										}

									}

								}
							}

						};

					} else {
						
						if ( ! get_term_by( 'slug', sanitize_title( $term ), $taxonomy ) ) {
							
							$submit_term = wp_insert_term( $term, $taxonomy );

							if ( ! is_wp_error( $submit_term ) ) {
							    // Get term_id, set default as 0 if not set
							    $term_id = isset( $submit_term['term_id'] ) ? $submit_term['term_id'] : 0;
							}

							if ( is_wp_error( $submit_term ) ) {
							   	$error_string = $submit_term->get_error_message();
							   	echo '<div id="message" class="error"><p>' . $error_string . ' - ' . $taxonomy . ' - ' . $s . '</p></div>';
							}

						}

					}

				}

			}

			if(  isset($submit_term['term_id']) && !is_wp_error($submit_term) ) {
	            update_option( 'autoroyal_leads_installed_terms', 1 );
	        }

		} 

	    /**
		 * Post types
		 */
		$singular  = __( 'Lead', 'autoroyal' );
		$plural    = __( 'Leads', 'autoroyal' );

		if ( current_theme_supports( 'lead-manager-templates' ) ) {
			$has_archive = _x( 'Leads', 'Post type archive slug - resave permalinks after changing this', 'autoroyal' );
		} else {
			$has_archive = false;
		}

		$rewrite     = array(
			'slug'       => _x( 'lead', 'Lead permalink - resave permalinks after changing this', 'autoroyal' ),
			'with_front' => false,
			'feeds'      => true,
			'pages'      => false
		);

		register_post_type( "lead",
			apply_filters( "register_post_type_lead", array(
				'labels' => array(
					'name'			=> $plural,
					'singular_name' 	=> $singular,
					'menu_name'             => __( 'Leads', 'autoroyal' ),
					'all_items'             => sprintf( __( 'All Leads', 'autoroyal' ), $plural ),
					'add_new' 		=> __( 'Add New Lead', 'autoroyal' ),
					'add_new_item' 		=> sprintf( __( 'Add %s', 'autoroyal' ), $singular ),
					'edit' 			=> __( 'Edit', 'autoroyal' ),
					'edit_item' 		=> sprintf( __( 'Edit %s', 'autoroyal' ), $singular ),
					'new_item' 		=> sprintf( __( 'New %s', 'autoroyal' ), $singular ),
					'view' 			=> sprintf( __( 'View %s', 'autoroyal' ), $singular ),
					'view_item' 		=> sprintf( __( 'View %s', 'autoroyal' ), $singular ),
					'search_items' 		=> sprintf( __( 'Search %s', 'autoroyal' ), $plural ),
					'not_found' 		=> sprintf( __( 'No %s found', 'autoroyal' ), $plural ),
					'not_found_in_trash' 	=> sprintf( __( 'No %s found in trash', 'autoroyal' ), $plural ),
					'parent' 		=> sprintf( __( 'Parent %s', 'autoroyal' ), $singular ),
				),
				'description' => sprintf( __( 'This is where you can create and manage %s.', 'autoroyal' ), $plural ),
				'public' 				=> true,
				'show_ui' 				=> true,
				'capability_type' 		=> 'car',
				'map_meta_cap'          => true,
				'publicly_queryable' 	=> true,
				'exclude_from_search' 	=> false,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> array( 'title', 'editor', 'custom-fields', 'publicize', 'thumbnail', 'author' ),
				'has_archive' 			=> $has_archive,
				'show_in_nav_menus' 	=> false
			) )
		);

		// Hide text editor in lead back end
		add_action('init', 'init_remove_editor_lead',100);
		function init_remove_editor_lead(){
			$post_type = 'lead';
			remove_post_type_support( $post_type, 'editor');
		}
	}

	/**
	 * Fix post name when wp_update_post changes it
	 * @param  array $data
	 * @return array
	 */
	public function fix_lead_post_name( $data, $postarr ) {

		global $post, $id;

	  	if( 'lead' == $data['post_type'] && isset($data['post_type']) ) {

	  		$id = $postarr['ID'];

			if($id) {

				$postID = $_POST['lead_id'];

				$lead_first_name = esc_attr( $_POST['lead_first_name'] );
				$lead_middle_name = esc_attr( $_POST['lead_middle_name'] );
				$lead_last_name = esc_attr( $_POST['lead_last_name'] );

				$postNewTitle = $lead_first_name . " " . $lead_middle_name . " " . $lead_last_name;

				$data['post_name'] = sanitize_title( $postNewTitle );
				$data['post_title'] = $postNewTitle;

			}

		}

	  	return $data; // Returns the modified data.

	}

}
