<?php
// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Define component's subfolder
if ( !defined('fnt_ADDONS_PLUGIN_IMPORTER') ) define('fnt_ADDONS_PLUGIN_IMPORTER', '/importer/');

// Add component to the global list
if (!function_exists('fnt_addons_importer_add_to_components')) {
	add_filter( 'fnt_addons_components_list', 'fnt_addons_importer_add_to_components' );
	function fnt_addons_importer_add_to_components($list=array()) {
		$list['importer'] = array(
					'title' => __('Import/Export demo data', 'autoroyal'),
					'std' => 1,
					'hidden' => true
					);
		return $list;
	}
}

// Theme init
if (!function_exists('fnt_addons_importer_theme_setup')) {
	add_action( 'after_setup_theme', 'fnt_addons_importer_theme_setup' );
	function fnt_addons_importer_theme_setup() {
		if (is_admin() && current_user_can('import')) {
			if (($fdir = fnt_addons_get_file_dir(fnt_ADDONS_PLUGIN_IMPORTER . 'importer-class.php')) != '') { include_once $fdir; }
			//include_once( dirname( __FILE__ ) . '/importer-class.php' );
			new fnt_addons_demo_data_importer();
		}
	}
}

if (!function_exists('fnt_addons_importer_localize_script_admin')) {
	add_filter( 'fnt_addons_filter_localize_script_admin', 'fnt_addons_importer_localize_script_admin' );
	function fnt_addons_importer_localize_script_admin($vars) {
		$vars['msg_importer_error'] = esc_html__('Errors that occurred during the import process:', 'autoroyal');
		return $vars;
	}
}
?>