<?php
// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }

$creds = '';
require_once(ABSPATH . 'wp-admin/includes/file.php');
if ( ! WP_Filesystem($creds) ) {
	request_filesystem_credentials($url, '', true, false, null);
	return;
}

// Return .min version (if exists and filetime .min > filetime original) instead original
if (!function_exists('fnt_addons_check_min_file')) {	
	function fnt_addons_check_min_file($file, $dir) {
		if (substr($file, -3)=='.js') {
			if (substr($file, -7)!='.min.js' && fnt_addons_is_off(fnt_addons_get_option('debug_mode', false, false))) {
				$dir = trailingslashit($dir);
				$file_min = substr($file, 0, strlen($file)-3).'.min.js';
				if (file_exists($dir . $file_min) && filemtime($dir . $file) <= filemtime($dir . $file_min)) $file = $file_min;
			}
		} else if (substr($file, -4)=='.css') {
			if (substr($file, -8)!='.min.css'  && fnt_addons_is_off(fnt_addons_get_option('debug_mode', false, false))) {
				$dir = trailingslashit($dir);
				$file_min = substr($file, 0, strlen($file)-4).'.min.css';
				if (file_exists($dir . $file_min) && filemtime($dir . $file) <= filemtime($dir . $file_min)) $file = $file_min;
			}
		}
		return $file;
	}
}

// Check value for "on" | "off" | "inherit" values
if (!function_exists('fnt_addons_is_on')) {
	function fnt_addons_is_on($prm) {
		return $prm>0 || in_array(strtolower($prm), array('true', 'on', 'yes', 'show'));
	}
}
if (!function_exists('fnt_addons_is_off')) {
	function fnt_addons_is_off($prm) {
		return empty($prm) || $prm===0 || in_array(strtolower($prm), array('false', 'off', 'no', 'none', 'hide'));
	}
}
if (!function_exists('fnt_addons_is_inherit')) {
	function fnt_addons_is_inherit($prm) {
		return in_array(strtolower($prm), array('inherit'));
	}
}

/* Check if file/folder present in the child theme and return path (url) to it. 
   Else - path (url) to file in the main theme dir
------------------------------------------------------------------------------------- */
if (!function_exists('fnt_addons_get_file_dir')) {	
	function fnt_addons_get_file_dir($file, $return_url=false) {
		if ($file[0]=='/') $file = substr($file, 1);
		$theme_dir = get_template_directory() . '/' . 'autoroyal_PLUGIN_BASE' . '/';
		$theme_url = get_template_directory_uri().'/'.'autoroyal_PLUGIN_BASE'.'/';
		$child_dir = get_stylesheet_directory().'/'.'autoroyal_PLUGIN_BASE'.'/';
		$child_url = get_stylesheet_directory_uri().'/'.'autoroyal_PLUGIN_BASE'.'/';
		$dir = '';
		if (file_exists(($child_dir).($file))) {
			$dir = ($return_url ? $child_url : $child_dir) . fnt_addons_check_min_file($file, $child_dir);
		} else if (file_exists(($theme_dir).($file))){
			$dir = ($return_url ? $theme_url : $theme_dir) . fnt_addons_check_min_file($file, $theme_dir);
		} else if (file_exists(autoroyal_IMPORT_PLUGIN_DIR . ($file))) {
			$dir = ($return_url ? autoroyal_PLUGIN_URL : autoroyal_IMPORT_PLUGIN_DIR) . fnt_addons_check_min_file($file, autoroyal_IMPORT_PLUGIN_DIR);
		}
		return apply_filters( $return_url ? 'fnt_addons_get_file_url' : 'fnt_addons_get_file_dir', $dir, $file );
	}
}

if (!function_exists('fnt_addons_get_file_url')) {	
	function fnt_addons_get_file_url($file) {
		return fnt_addons_get_file_dir($file, true);
	}
}

// Return customizable option value
if (!function_exists('fnt_addons_get_option')) {
	function fnt_addons_get_option($name, $defa='', $strict_mode=true) {
		global $FNT_ADDONS_STORAGE;
		$rez = $defa;
		$part = '';
		if (strpos($name, '[')!==false) {
			$tmp = explode('[', $name);
			$name = $tmp[0];
			$part = substr($tmp[1], 0, -1);
		}

		// If options are loaded and specified name is not exists and 'strict_mode' is on - display warning message
		// and dump call's stack
		if ( isset($FNT_ADDONS_STORAGE['options']) && !isset($FNT_ADDONS_STORAGE['options'][$name]) && $strict_mode ) {
			$s = debug_backtrace();
			// This way display all stack
			//array_shift($s);
			// This way display only last call
			$s = array_shift($s);
			echo '<pre>';
			echo esc_html(sprintf(__('Undefined option "%s" called from:', 'autoroyal'), $name));
			if (function_exists('fnt_addons_debug_dump_screen'))
				fnt_addons_debug_dump_screen($s);
			else
				print_r($s);
			echo '</pre>';
			die();
		}
		// Override option from GET
		if (isset($_GET[$name])) {
			if (empty($part))
				$rez = $_GET[$name];
			else if (isset($_GET[$name][$part]))
				$rez = $_GET[$name][$part];
		// Get saved option value
		} else if (isset($FNT_ADDONS_STORAGE['options'][$name]['val'])) {
			if (empty($part))
				$rez = $FNT_ADDONS_STORAGE['options'][$name]['val'];
			else if (isset($FNT_ADDONS_STORAGE['options'][$name]['val'][$part]))
				$rez = $FNT_ADDONS_STORAGE['options'][$name]['val'][$part];
		}
		return $rez;
	}
}

// Output string with the html layout (if not empty)
// (put it between 'before' and 'after' tags)
// Attention! This string may contain layout formed in any plugin (widgets or shortcodes output) and not require escaping to prevent damage!
if ( !function_exists('fnt_addons_show_layout') ) {
	function fnt_addons_show_layout($str, $before='', $after='') {
		if (trim($str) != '') {
			printf("%s%s%s", $before, $str, $after);
		}
	}
}

// Get text from specified file
if (!function_exists('fnt_addons_fgc')) {	
	function fnt_addons_fgc($file, $unpack=false) {
		static $allow_url_fopen = -1;
		if ($allow_url_fopen==-1) $allow_url_fopen = (int) ini_get('allow_url_fopen');
		global $wp_filesystem;
		if (!empty($file)) {
			if (isset($wp_filesystem) && is_object($wp_filesystem)) {
				$file = str_replace(ABSPATH, $wp_filesystem->abspath(), $file);
				$tmp_cont = strpos($file, '//')!==false && !$allow_url_fopen 
								? fnt_addons_remote_get($file) 
								: $wp_filesystem->get_contents($file);
				if ($unpack && fnt_addons_get_file_ext($file) == 'zip') {
					$tmp_name = 'tmp-'.rand().'.zip';
					$tmp = wp_upload_bits($tmp_name, null, $tmp_cont);
					if ($tmp['error'])
						$tmp_cont = '';
					else {
						unzip_file($tmp['file'], dirname($tmp['file']));
						$file_name = dirname($tmp['file']) . '/' . basename($file, '.zip') . '.txt';
						$tmp_cont = fnt_addons_fgc($file_name);
						unlink($tmp['file']);
						unlink($file_name);
					}
				}
				return $tmp_cont;
			} else {
				if (fnt_addons_is_on(fnt_addons_get_option('debug_mode', false, false)))
					throw new Exception(sprintf(esc_html__('WP Filesystem is not initialized! Get contents from the file "%s" failed', 'autoroyal'), $file));
			}
		}
		return '';
	}
}

// Get text from specified file via HTTP (cURL)
if (!function_exists('fnt_addons_remote_get')) {	
	function fnt_addons_remote_get($file, $timeout=-1) {
		// Set timeout as half of the PHP execution time
		if ($timeout < 1) $timeout = round( 0.5 * max(30, ini_get('max_execution_time')));
		$response = wp_remote_get($file, array(
									'timeout'     => $timeout
									)
								);
		//return wp_remote_retrieve_response_code( $response ) == 200 ? wp_remote_retrieve_body( $response ) : '';
		return !is_wp_error($response) && isset($response['response']['code']) && $response['response']['code']==200 ? $response['body'] : '';
	}
}

// Strip slashes if Magic Quotes is on
if (!function_exists('fnt_addons_stripslashes')) {
	function fnt_addons_stripslashes($val) {
		static $magic = 0;
		if ($magic === 0) {
			$magic = version_compare(phpversion(), '5.4', '>=')
					|| (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()==1) 
					|| (function_exists('get_magic_quotes_runtime') && get_magic_quotes_runtime()==1) 
					|| strtolower(ini_get('magic_quotes_sybase'))=='on';
		}
		if (is_array($val)) {
			foreach($val as $k=>$v)
				$val[$k] = fnt_addons_stripslashes($v);
		} else
			$val = $magic ? stripslashes(trim($val)) : trim($val);
		return $val;
	}
}

// Put data into specified file
if (!function_exists('fnt_addons_fpc')) {	
	function fnt_addons_fpc($file, $data, $flag=0) {
		global $wp_filesystem;
		if (!empty($file)) {
			if (isset($wp_filesystem) && is_object($wp_filesystem)) {
				$file = str_replace(ABSPATH, $wp_filesystem->abspath(), $file);
				// Attention! WP_Filesystem can't append the content to the file!
				if ($flag==FILE_APPEND && $wp_filesystem->exists($file) && strpos($file, '//')===false) {
					// If it is a existing local file (not contain '//' in the path) and we need to append data -
					// use native PHP function to prevent large consumption of memory
					return file_put_contents($file, $data, $flag);
				} else {
					// In other case (not a local file or not need to append data or file not exists)
					// That's why we have to read the contents of the file into a string,
					// add new content to this string and re-write it to the file if parameter $flag == FILE_APPEND!
					return $wp_filesystem->put_contents($file, ($flag==FILE_APPEND && $wp_filesystem->exists($file) ? $wp_filesystem->get_contents($file) : '') . $data, false);
				}
			} else {
				if (fnt_addons_is_on(fnt_addons_get_option('debug_mode', false, false)))
					throw new Exception(sprintf(esc_html__('WP Filesystem is not initialized! Put contents to the file "%s" failed', 'autoroyal'), $file));
			}
		}
		return false;
	}
}

// Return GET or POST value
if (!function_exists('fnt_addons_get_value_gp')) {
	function fnt_addons_get_value_gp($name, $defa='') {
		if (isset($_GET[$name]))		$rez = $_GET[$name];
		else if (isset($_POST[$name]))	$rez = $_POST[$name];
		else							$rez = $defa;
		return fnt_addons_stripslashes($rez);
	}
}

// Unserialize string (try replace \n with \r\n)
if (!function_exists('fnt_addons_unserialize')) {
	function fnt_addons_unserialize($str) {
		if ( !empty($str) && is_serialized($str) ) {
			try {
				$data = unserialize($str);
			} catch (Exception $e) {
				dcl($e->getMessage());
				$data = false;
			}
			if ($data===false) {
				try {
					$data = @unserialize(str_replace("\n", "\r\n", $str));
				} catch (Exception $e) {
					dcl($e->getMessage());
					$data = false;
				}
			}
			//if ($data===false) $data = @unserialize(str_replace(array("\n", "\r"), array('\\n','\\r'), $str));
			return $data;
		} else
			return $str;
	}
}

// Return file extension from full name/path
if (!function_exists('fnt_addons_get_file_ext')) {	
	function fnt_addons_get_file_ext($file) {
		$ext = pathinfo($file, PATHINFO_EXTENSION);
		return empty($ext) ? '' : $ext;
	}
}

// Return first key (by default) or value from associative array
if (!function_exists('fnt_addons_array_get_first')) {
	function fnt_addons_array_get_first(&$arr, $key=true) {
		$rez = false;
		foreach ($arr as $k=>$v) {
			$rez = $key ? $k : $v;
			break;
		}
		return $rez;
	}
}

// Get domain part from URL
if (!function_exists('fnt_addons_get_domain_from_url')) {
	function fnt_addons_get_domain_from_url($url) {
		if (($pos=strpos($url, '://'))!==false) $url = substr($url, $pos+3);
		if (($pos=strpos($url, '/'))!==false) $url = substr($url, 0, $pos);
		return $url;
	}
}

// Return 'no-image'
if (!function_exists('fnt_addons_get_no_image')) {
	function fnt_addons_get_no_image($img='css/images/no-image.jpg') {
		return apply_filters('fnt_addons_filter_no_image', fnt_addons_get_file_url($img));
	}
}

?>