<?php

	if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

	$user_id = get_current_user_id();

	$dealer_name = get_user_meta( $user_id, 'dealer_name', true );
	$mobile_phone = get_user_meta( $user_id, 'mobile_phone', true );
	$office_phone = get_user_meta( $user_id, 'office_phone', true );
	$dealer_website = get_user_meta( $user_id, 'dealer_website', true );

	$dealer_address = get_user_meta( $user_id, 'dealer_address', true );
	$dealer_address_latitude = get_user_meta( $user_id, 'dealer_address_latitude', true );
	$dealer_address_longitude = get_user_meta( $user_id, 'dealer_address_longitude', true );


	$dealer_cover_image = get_user_meta( $user_id, 'dealer_cover_image', true );

?>

<form action="<?php echo get_permalink(); ?>" method="post" id="autoroyal-update-user-form" class="autoroyal-form" enctype="multipart/form-data">

	<div class="options_group">

			<h2 class="options_group_heading"><?php esc_html_e('Account Info', 'autoroyal' ); ?></h2>

			<fieldset>

				<div class="row">

					<div class="col-md-4">

						<label for="dealer_name" class="control-label"><?php esc_html_e('Name / Company Name', 'autoroyal' ); ?></label>
						<input type="text" id="dealer_name" name="dealer_name" value="<?php echo esc_attr($dealer_name); ?>" placeholder="" />

					</div>

					<div class="col-md-4">

						<label for="office_phone" class="control-label"><?php esc_html_e('Phone', 'autoroyal' ); ?></label>
						<input type="text" id="office_phone" name="office_phone" value="<?php echo esc_attr($office_phone); ?>" placeholder="" />

					</div>

					<div class="col-md-4">

						<label for="dealer_website" class="control-label"><?php esc_html_e('Website', 'autoroyal' ); ?></label>
						<input type="text" id="dealer_website" name="dealer_website" value="<?php echo esc_attr($dealer_website); ?>" placeholder="" />

					</div>

					<div class="col-md-8">

						<label for="dealer_address" class="control-label"><?php esc_html_e('Address', 'autoroyal' ); ?></label>
						<input type="text" id="vehicle_location_address" name="dealer_address" value="<?php echo esc_attr($dealer_address); ?>" placeholder="">

						<input type="hidden" id="vehicle_location_latitude" name="dealer_address_latitude" value="<?php echo esc_attr($dealer_address_latitude); ?>" />
						<input type="hidden" id="vehicle_location_longitude" name="dealer_address_longitude" value="<?php echo esc_attr($dealer_address_longitude); ?>" />

					</div>

					<div class="col-md-4 select-flag">

        				<?php 

        					$dealer_flag = get_user_meta( $user_id, 'dealer_flag', true );

        					$countries_new_array = array();
					        $countries_array = array("Afghanistan", "Albania", "Algeria", "American Samoa", "Andorra", "Angola", "Anguilla", "Antigua and Barbuda", "Argentina", "Armenia", "Aruba", "Australia", "Austria", "Azerbaijan", "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bermuda", "Bhutan", "Bolivia", "Bosnia and Herzegowina", "Botswana", "Brazil", "British Indian Ocean Territory", "Brunei Darussalam", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada", "Cape Verde", "Cayman Islands", "Central African Republic", "Chad", "Chile", "China", "Christmas Island", "Cocos (Keeling) Islands", "Colombia", "Comoros", "Congo", "Cook Islands", "Costa Rica", "Cote d'Ivoire", "Croatia (Hrvatska)", "Cuba", "Cyprus", "Czech Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "East Timor", "Ecuador", "Egypt", "El Salvador", "Equatorial Guinea", "Eritrea", "Estonia", "Ethiopia", "Falkland Islands (Malvinas)", "Fiji", "Finland", "France", "French Polynesia", "Gabon", "Gambia", "Georgia", "Germany", "Ghana", "Gibraltar", "Greece", "Greenland", "Grenada", "Guam", "Guatemala", "Guinea", "Guinea-Bissau", "Haiti", "Honduras", "Hong Kong", "Hungary", "Iceland", "India", "Indonesia", "Iran (Islamic Republic of)", "Iraq", "Ireland", "Israel", "Italy", "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "North Korea", "South Korea", "Kuwait", "Kyrgyzstan", "Lao", "Latvia", "Lebanon", "Lesotho", "Liberia", "Libyan Arab Jamahiriya", "Liechtenstein", "Lithuania", "Luxembourg", "Macau", "Macedonia", "Madagascar", "Malawi", "Malaysia", "Maldives", "Mali", "Mauritania", "Mauritius", "Mexico", "Micronesia, Federated States of", "Moldova, Republic of", "Monaco", "Mongolia", "Montserrat", "Morocco", "Mozambique", "Namibia", "Nauru", "Nepal", "Netherlands", "New Zealand", "Nicaragua", "Niger", "Nigeria", "Niue", "Norfolk Island", "Northern Mariana Islands", "Norway", "Oman", "Pakistan", "Palau", "Panama", "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Pitcairn", "Poland", "Portugal", "Puerto Rico", "Qatar", "Romania", "Russian Federation", "Rwanda", "Saint Lucia", "Saint Vincent and the Grenadines", "Samoa", "San Marino", "Saudi Arabia", "Senegal", "Serbia", "Seychelles", "Sierra Leone", "Singapore", "Slovakia (Slovak Republic)", "Slovenia", "Solomon Islands", "Somalia", "South Africa", "Spain", "Sri Lanka", "Sudan", "Suriname", "Swaziland", "Sweden", "Switzerland", "Syrian Arab Republic", "Taiwan, Province of China", "Tajikistan", "Tanzania, United Republic of", "Thailand", "Togo", "Tokelau", "Tonga", "Trinidad and Tobago", "Tunisia", "Turkey", "Turkmenistan", "Turks and Caicos Islands", "Tuvalu", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States", "Uruguay", "Uzbekistan", "Vanuatu", "Venezuela", "Vietnam", "Virgin Islands (British)", "Virgin Islands (U.S.)", "Yemen", "Zambia", "Zimbabwe");
					        $i = 0;
					        foreach ($countries_array as $country_array) {
					            $countries_new_array[$i][0] = $country_array;
					            $countries_new_array[$i][1] = sanitize_title($country_array);
					            $i++;
					        }

        				?>

        				<label><?php esc_html_e( 'Select Flag', 'autoroyal' ); ?></label>
        				<select required="required" name="flag" class="chosen-select">
	                        <option value=""><?php esc_html_e('None', 'autoroyal'); ?> </option>
	                        <?php foreach ($countries_new_array as $country) { ?>
	                        <option value="<?php echo sanitize_title($country[1]); ?>" <?php if( $country[1] == $dealer_flag ) { echo "selected"; } ?> style="background-image:url(<?php $flag = get_template_directory_uri().'/assets/images/flags/' . sanitize_title($country[1]) . '.svg'; echo esc_url($flag); ?>);"><?php echo esc_attr($country[0]); ?></option>
	                    	<?php } ?>
	                    </select>

        			</div>

					<div class="col-md-12">

						<div id="map-canvas"></div>

					</div>

					<div class="col-md-12">

						<label for="dealer_cover" class="control-label"><?php esc_html_e('Cover image', 'autoroyal' ); ?></label>

						<div class="dealer_cover_holder"><?php if(!empty($dealer_cover_image)) { ?><img class="image-holder" src="<?php echo esc_attr($dealer_cover_image); ?>" alt=""/><?php } ?></div>

						<div id="dealer_no_cover_image" href="#" class="btn btn-default <?php if(!empty($dealer_cover_image)) { ?>hide_btn<?php } ?>">
							<?php esc_html_e('Upload Image', 'autoroyal' ); ?>
							<input type="file" class="input-text dealer-cover-image-upload" multiple="" data-file_types="jpg|jpeg|gif|png" name="dealer-cover-image-upload" id="dealer-cover-image-upload" placeholder="">
						</div>

						<a id="dealer_with_cover_image" href="#" class="btn btn-default <?php if(!empty($dealer_cover_image)) { ?>show_btn<?php } ?>"><?php esc_html_e('Remove Image', 'autoroyal' ); ?></a>

						<input type="hidden" class="dealer_cover_image" name="dealer_cover_image" value="<?php if(!empty($dealer_cover_image)) { echo esc_attr($dealer_cover_image); } ?>" />

					</div>

					<div class="col-sm-6">

	                  	<label><?php esc_html_e( 'Password', 'autoroyal' ) ?> <sup>*</sup></label>
	                  	<input type="password" name="password" id="password" class="form-control" >
	                  	<label id="password-error" class="error" for="password"><?php esc_html_e( 'Password required.', 'autoroyal' ) ?></label>

	                </div>

	                <div class="col-sm-6">

	                  	<label><?php esc_html_e( 'Repet password', 'autoroyal' ) ?> <sup>*</sup></label>
	                  	<input type="password" name="repeat_password" id="repeat_password" class="form-control" >
	                  	<label id="repeat_password-error" class="error" for="repeat_password"><?php esc_html_e( "Password doesn't match.", 'autoroyal' ) ?></label>
	                  	
	                </div>

				</div>

			</fieldset>

			<fieldset class="autoroyal-last-fieldset">

					<div class="row">

						<div class="col-md-12">

							<input type="hidden" name="user_id" value="<?php echo esc_attr($user_id); ?>" />
												
							<input type="hidden" name="action" value="updateAccountFunction" />
							<?php wp_nonce_field( 'updateAccountFunction_html', 'updateAccountFunction_nonce' ); ?>

							<a id="autoroyal_update_account" href="#" class="btn btn-default"><?php esc_html_e( 'Update Account', 'autoroyal' ) ?></a>

						</div>

					</div>

				</fieldset>

		</div>	<!-- end review_options_pop -->

</form>