<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_car_types_func( $atts ) {

	extract( shortcode_atts( array(
        "amount" => "0",
    	"css" => "",
   	), $atts ) );

	ob_start();

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    $vehicles_search_url = "";
    $vehicles_search_url = get_option("autoroyal_search_vehicles_page_id");

	?>

    <div class="autoroyal-vechile-collections <?php echo esc_attr($css_class); ?>">

        <div class="row">

            <?php

            $args = array(
                'hierarchical' => 0,
                'orderby' => 'count',
                'order' => 'DESC',
                'number' => $amount,
            );

            $current = 0;
            $terms = get_terms( 'vehicle_body_style', $args );

            if ( $terms ) {

                foreach ( $terms as $term ) {

                    $current++;
                    $cat_cover = autoroyal_get_term_icon_url( $term->term_id, 'autoroyal-body-type' );
                    if(empty($cat_cover)) {
                        $cat_cover = get_template_directory_uri().'/assets/images/car-body-style.png';
                    }

                    ?>

                    <div class="col-xs-12 col-sm-6 col-lg-3 text-center">
                      
                        <div class="autoroyal-body-style-link">

                            <a href="<?php echo get_permalink( $vehicles_search_url ); ?>?body_style=<?php echo esc_attr($term->term_id); ?>">

                                <span class="autoroyal-body-style-count"><?php echo esc_attr($term->count); ?></span>

                                <img src="<?php echo esc_url($cat_cover); ?>" alt="" />

                                <span><?php echo esc_attr($term->name); ?></span>

                            </a>

                        </div>

                    </div>

                    <?php

                }

            }

        ?>
              
        </div>

    </div>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_car_types', 'autoroyal_car_types_func' );

vc_map( array(
  	'name' => esc_html__( 'Search by Body Style - Block', 'autoroyal' ),
	'base' => 'autoroyal_car_types',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Search by body style', 'autoroyal' ),
	'params' => array(
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Amount number of types', 'autoroyal' ),
            'param_name' => 'amount',
            'value' => "0",
            'description' => esc_html__( 'Amount of types to display (0 for all).', 'autoroyal' ),
        ),
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

