<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function autoroyal_minimal_search_func( $atts ) {

    extract( shortcode_atts( array(
        "css" => "",
    ), $atts ) );

	ob_start();

	$class_to_filter = '';
	$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' );
	$css_class = $class_to_filter;

    //
    $MODS = get_theme_mods();
    foreach(autoroyal_defaults() as $mod=>$def) {if(!isset($MODS[$mod])){$MODS[$mod]=$def;}}

    $vehicles_search_url = "";
    $vehicles_search_url = get_option("autoroyal_cars_page_id");

	?>

    <section class="bottom-search <?php echo esc_attr($css_class); ?>">
        <div class="container">
            <div class="row">
                <?php if(!empty($vehicles_search_url)) { ?>
                <form id="autoroyal-homepage-block-search-form" class="form-inline" action="<?php echo get_permalink( $vehicles_search_url ); ?>" method="GET">
              
                    <div class="col-sm-6 col-md-4 col-lg-3">
                        <div class="form-group">
                            <label for="cd-carmake"><?php esc_html_e('Make', 'autoroyal' ); ?></label>
                            <select name="make" class="cd-select js-example-basic-single select2-hidden-accessible" id="cd-carmake" style="width: 100%">
                                <option value="0"><?php esc_html_e('Any', 'autoroyal' ); ?></option>
                                <?php 

                                    $autoroyal_vehicles_query = autoroyal_vehicle_query();
                                    $total_cars_by_make = $autoroyal_vehicles_query["total_cars"];
                                    $make = "0";
                                    $model = "0";

                                    if( !empty($total_cars_by_make) ) {

                                        $total = count($total_cars_by_make);

                                        for( $i = 1; $i <= $total; ++$i ){

                                ?>
                                <option value="<?php echo esc_attr($total_cars_by_make[$i]['make_clean']); ?>" <?php selected( $total_cars_by_make[$i]['make_clean'], $make ); ?>><?php echo esc_attr($total_cars_by_make[$i]['make']); ?></option>
                                <?php

                                        }

                                    }

                                ?>
                            </select>

                            <script>

                                jQuery("document").ready(function(){

                                    // object literal holding data for option elements
                                    var Select_List_Data = {
                                        
                                        'model': { // name of associated select box
                                            
                                            // names match option values in controlling select box
                                            <?php 

                                                $total_cars_by_make = $autoroyal_vehicles_query["total_cars"];

                                                if( !empty($total_cars_by_make) ) {

                                                    $total = count($total_cars_by_make);

                                                    for( $i = 1; $i <= $total; ++$i ){

                                            ?>'<?php echo esc_attr($total_cars_by_make[$i]['make_clean']); ?>': {
                                                text: [<?php 

                                                            if( !empty($total_cars_by_make[$i]['model']) ) {

                                                                $total_models = count($total_cars_by_make[$i]['model']);

                                                                for( $j = 0; $j <= $total_models; ++$j ){

                                                                    if(!empty($total_cars_by_make[$i]['model'][$j])) {

                                                        ?>'<?php echo esc_attr($total_cars_by_make[$i]['model'][$j]); ?>',<?php
                                                                    }

                                                                }

                                                            }

                                                        ?>]
                                            },
                                           <?php

                                                    }

                                                }

                                            ?>
                                        
                                        }    
                                    };

                                    // removes all option elements in select box 
                                    // removeGrp (optional) boolean to remove optgroups
                                    function removeAllOptions(sel, removeGrp) {
                                        var len, groups, par;
                                        if (removeGrp) {
                                            groups = sel.getElementsByTagName('optgroup');
                                            len = groups.length;
                                            for (var i=len; i; i--) {
                                                sel.removeChild( groups[i-1] );
                                            }
                                        }
                                        
                                        len = sel.options.length;
                                        for (var i=len; i; i--) {
                                            par = sel.options[i-1].parentNode;
                                            par.removeChild( sel.options[i-1] );
                                        }
                                    }

                                    function appendDataToSelect(sel, obj) {

                                        var f = document.createDocumentFragment();
                                        var labels = [], group, opts;

                                        if(obj != '0') {
                                        
                                            function addOptions(obj) {
                                                var f = document.createDocumentFragment();
                                                var o;

                                                o = document.createElement('option');
                                                o.appendChild( document.createTextNode( '<?php esc_html_e('Any', 'autoroyal' ); ?>' ) );
                                                o.value = '0';
                                                $("#model_all").val( obj.text );
                                                f.appendChild(o);
                                                
                                                for (var i=0, len=obj.text.length; i<len; i++) {
                                                    o = document.createElement('option');
                                                    o.appendChild( document.createTextNode( obj.text[i] ) );
                                                    
                                                    o.value = obj.text[i];

                                                    if( o.value == '<?php echo esc_attr($model); ?>' ) {
                                                        o.setAttribute('selected', 'selected');
                                                    }
                                                    
                                                    f.appendChild(o);
                                                }
                                                
                                                return f;
                                            }
                                            
                                            if ( obj.text ) {
                                                opts = addOptions(obj);
                                                f.appendChild(opts);
                                            } else {
                                                for ( var prop in obj ) {
                                                    if ( obj.hasOwnProperty(prop) ) {
                                                        labels.push(prop);
                                                    }
                                                }
                                                
                                                for (var i=0, len=labels.length; i<len; i++) {
                                                    group = document.createElement('optgroup');
                                                    group.label = labels[i];
                                                    f.appendChild(group);
                                                    opts = addOptions(obj[ labels[i] ] );
                                                    group.appendChild(opts);
                                                }
                                            }

                                        } else {

                                            var f = document.createDocumentFragment();
                                            var o;

                                            o = document.createElement('option');
                                            o.appendChild( document.createTextNode( '<?php esc_html_e('Select a make', 'autoroyal' ); ?>' ) );
                                            o.value = '0';
                                            $("#model_all").val( "" );
                                            f.appendChild(o);

                                        }
                                        sel.appendChild(f);

                                        $('.chosen-select').trigger("chosen:updated");

                                    }

                                    $('select#cd-carmake').on('change', function(){

                                        var selected = $('select#cd-carmake option:selected').val();

                                        // name of associated select box
                                        var relName = 'model';
                                        
                                        // reference to associated select box 
                                        var relList = this.form.elements[ relName ];
                                        
                                        // get data from object literal based on selection in controlling select box (this.value)
                                        var obj = Select_List_Data[ relName ][ selected ];

                                        if(selected != '0') {
                                            
                                            // remove current option elements
                                            removeAllOptions(relList, true);
                                            
                                            // call function to add optgroup/option elements
                                            // pass reference to associated select box and data for new options
                                            appendDataToSelect(relList, obj);

                                        } else {

                                            // remove current option elements
                                            removeAllOptions(relList, true);
                                            
                                            // call function to add optgroup/option elements
                                            // pass reference to associated select box and data for new options
                                            appendDataToSelect(relList, '0');

                                        }

                                    });

                                })

                            </script>
                        </div>
                    </div>

                    <div class="col-sm-6 col-md-4 col-lg-3">
                        <div class="form-group">
                            <label for="cd-carmodel"><?php esc_html_e('Model', 'autoroyal' ); ?></label>
                            <select id="model" name="model" class="cd-select js-example-basic-single" style="width: 100%">
                                <option value="0"><?php esc_html_e('Select a make', 'autoroyal' ); ?></option>
                            </select>
                        </div>
                    </div>
                  
                    <div class="col-sm-6 col-md-4 col-lg-3 hidden">
                        <div class="form-group">
                            <label for="cd-fuel"><?php esc_html_e('Fuel type', 'autoroyal' ); ?></label>
                            <select class="cd-select js-example-basic-multiple select-fuel" name="fuel_type[]" multiple="multiple" id="cd-fuel" style="width: 100%;">
                                <?php

                                    $vehicle_fuel_types = $autoroyal_vehicles_query["fuel_type"];
                                    foreach ( $vehicle_fuel_types as $vehicle_fuel_types_item ) {

                                        $fuel_type_obj = get_term_by( 'id', $vehicle_fuel_types_item, 'vehicle_fuel_type' );
                                        $fuel_type_name = $fuel_type_obj->name;

                                        $option = '<option value="'. $vehicle_fuel_types_item .'">';
                                        $option .= $fuel_type_name;
                                        $option .= '</option>';

                                        echo $option;

                                    }

                                ?>
                            </select>
                        </div>
                      </div>

                      <div class="col-sm-6 col-md-4 col-lg-3 hidden">
                        
                        <div class="form-group custom-range">
                            <p>
                                <label for="priceUp"><?php esc_html_e('Price up to', 'autoroyal' ); ?> <span><?php esc_html_e('in thousands of', 'autoroyal' ); ?> <?php $currency = get_option("autoroyal_currency"); echo autoroyal_get_currency_symbol($currency); ?></span></label>
                                <input type="text" id="priceUp" name="price" readonly class="pull-left">
                            </p>
                            <div id="priceUpRange" class="pull-right"></div>
                            <div class="clearfix"></div>
                        </div>

                        <script>
                            jQuery("document").ready(function(){

                                $( "#priceUpRange" ).slider({
                                    range: "min",
                                    min: <?php echo esc_attr(floor($autoroyal_vehicles_query["vehicle_price_min"] / 1000)); ?>,
                                    max: <?php echo esc_attr(round($autoroyal_vehicles_query["vehicle_price_max"] / 1000)); ?>,
                                    value: <?php echo esc_attr(round($autoroyal_vehicles_query["vehicle_price_max"] / 1000)); ?>,
                                    slide: function( event, ui ) {
                                      $( "#priceUp" ).val( ui.value + "K" );
                                    }
                                });
                                $( "#priceUp" ).val( $( "#priceUpRange" ).slider( "value" ) + "K" );

                                $('#priceUpRange').draggable();

                            })
                        </script>

                    </div>

                    <div class="col-sm-6 col-md-4 col-lg-3">

                        <div class="form-group custom-range">
                            <p>
                                <label for="cd-registration"><?php esc_html_e('1st registration from', 'autoroyal' ); ?> <span><?php esc_html_e('year', 'autoroyal' ); ?></span></label>
                                <input type="text" id="cd-registration" name="vehicle_year_max" readonly class="pull-left">
                            </p>
                            <input type="hidden" id="regYearMin" value="<?php echo esc_attr($autoroyal_vehicles_query["vehicle_year_min"]); ?>">
                            <input type="hidden" id="regYearMax" value="<?php echo esc_attr($autoroyal_vehicles_query["vehicle_year_max"]); ?>">
                            <div id="registrationRange" class="pull-right"></div>
                        </div>

                        <script>
                            jQuery("document").ready(function(){

                                $( "#registrationRange" ).slider({
                                    range: "min",
                                    min: <?php echo esc_attr($autoroyal_vehicles_query["vehicle_year_min"]); ?>,
                                    max: <?php echo esc_attr($autoroyal_vehicles_query["vehicle_year_max"]); ?>,
                                    value: <?php echo esc_attr($autoroyal_vehicles_query["vehicle_year_max"]); ?>,
                                    slide: function( event, ui ) {
                                      $( "#cd-registration" ).val( ui.value );
                                    }
                                });
                                $( "#cd-registration" ).val( $( "#registrationRange" ).slider( "value" ) );

                                $('#registrationRange').draggable();

                            })
                        </script>

                    </div>

                    <div class="col-sm-6 col-md-4 col-lg-3 hidden">
                        <div class="form-group custom-range">
                            <p>
                                <label for="cd-mileage"><?php esc_html_e('Mileage up to', 'autoroyal' ); ?> <span><?php esc_html_e('in thousands of', 'autoroyal' ); ?> <?php $measurement_type = get_option("autoroyal_measurement_type"); if($measurement_type == "metric") { echo "km"; } else { echo "mi"; }; ?></span></label>
                                <input type="text" id="cd-mileage" name="mileage" readonly class="pull-left">
                            </p>
                            <div id="mileageRange" class="pull-right"></div>
                        </div>

                        <script>
                            jQuery("document").ready(function(){

                                $( "#mileageRange" ).slider({
                                    range: "min",
                                    min: "0",
                                    max: <?php echo esc_attr($autoroyal_vehicles_query["vehicle_mileages_max"] / 1000); ?>,
                                    value: <?php echo esc_attr($autoroyal_vehicles_query["vehicle_mileages_max"] / 1000); ?>,
                                    slide: function( event, ui ) {
                                      $( "#cd-mileage" ).val( ui.value + "K" );
                                    }
                                });
                                $( "#cd-mileage" ).val( $( "#mileageRange" ).slider( "value" ) + "K" );

                                $('#mileageRange').draggable();

                            })
                        </script>

                    </div>

                    <div class="col-sm-6 col-md-4 col-lg-3 hidden">
                        <div class="form-group" style="padding-top: 35px;">
                            <div class="custom-checkbox pull-left">
                                <label>
                                    <input type="checkbox" name="vehicle_condition" checked>
                                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                    <?php esc_html_e('Show new cars only', 'autoroyal' ); ?>
                                </label>
                            </div>
                        </div>
                    </div>
                  
                    <div class="col-sm-6 col-md-4 col-lg-3">
                        <div class="form-group">
                          <a href="#" class="btn btn-link pull-right" id="showOptions"><?php esc_html_e('More search options', 'autoroyal' ); ?></a>
                          <button type="submit" class="btn btn-default"><?php esc_html_e('Search through', 'autoroyal' ); ?>  <span id="cd-cars-nr-list"><?php echo autoroyal_get_total_cars_all_users(); ?></span> <?php esc_html_e('vehicles', 'autoroyal' ); ?></button>
                        </div>
                    </div>

                </form>
                <?php } ?>

            </div>
        </div>
    </section>

	<?php

	return ob_get_clean();

}
add_shortcode( 'autoroyal_minimal_search', 'autoroyal_minimal_search_func' );

vc_map( array(
  	'name' => esc_html__( 'Minimal Search', 'autoroyal' ),
	'base' => 'autoroyal_minimal_search',
	'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
	'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
	'description' => esc_html__( 'Minimal search', 'autoroyal' ),
	'params' => array(
        array(
			'type' => 'css_editor',
			'heading' => esc_html__( 'CSS box', 'autoroyal' ),
			'param_name' => 'css',
			'group' => esc_html__( 'Design Options', 'autoroyal' ),
		),
	),
));

