<?php

/**
 * The Shortcode
 */

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $images
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_gallery
 */

function faq_item_func( $atts, $content ) {

    extract( shortcode_atts( array(
        'title' => '',
    ), $atts ) );

    ob_start();

    $colapseid = uniqid();
    $headingid = uniqid();

    ?>

        <div class="card no-shadow mb-0">

            <div class="card-header" id="faq-<?php echo esc_attr($headingid); ?>">
                <h5 class="autoroyal-panel-title">
                    <button class="btn btn-link" data-toggle="collapse" data-target="#faq-<?php echo esc_attr($colapseid); ?>" aria-expanded="true" aria-controls="faq-<?php echo esc_attr($colapseid); ?>">
                        <?php if(!empty($title)) { echo esc_attr($title); } ?>
                        <i class="fas fa-minus"></i>
                        <i class="fas fa-plus"></i>
                    </button>
                </h5>
            </div>

            <div id="faq-<?php echo esc_attr($colapseid); ?>" class="collapse" aria-labelledby="faq-<?php echo esc_attr($headingid); ?>" data-parent="#accordion">
                <div class="card-body"><?php echo wp_kses($content, true); ?></div>
            </div>

        </div>

    <?php

    return ob_get_clean();

}
add_shortcode( 'faq_item', 'faq_item_func' );

vc_map( array(
    'name' => esc_html__( 'FAQ item', 'autoroyal' ),
    'base' => 'faq_item',
    'icon' => get_template_directory_uri().'/assets/images/vc-autoroyal-icon.png',
    'description' => esc_html__( 'Custom autoroyal faq item', 'autoroyal' ),
    'category' => esc_html__( 'autoRoyal', 'autoroyal' ),
    "content_element" => true,
    "as_child" => array('only' => 'autoroyal_slider'), 
    'params' => array(
        array(
            'type' => 'textfield',
            'heading' => esc_html__( 'Title', 'autoroyal' ),
            'param_name' => 'title',
            'admin_label' => true,
            'value' => '',
        ),
        array(
            'type' => 'textarea_html',
            'heading' => esc_html__( 'Content', 'autoroyal' ),
            'param_name' => 'content',
            'value' => '',
        ),
    ),
));

if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_faq_item extends WPBakeryShortCode {
    }
}

