<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Shortcode_Submit_Deal class.
 */
class autoroyal_Shortcode_Submit_Deal {

	/**
	 * Inventory message
	 *
	 * @access private
	 * @var string
	 */
	private $deal_submit_message = '';
	private $deal_submit_status = '0';
	private $deal_delete_status = '0';
	private $deal_id = '';

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'wp', array( $this, 'shortcode_submit_deal_action_handler' ) );
		add_shortcode( 'autoroyal_submit_deal', array( $this, 'autoroyal_submit_deal' ) );
	}

	/**
	 * Handle actions which need to be run before the shortcode e.g. post actions
	 */
	public function shortcode_submit_deal_action_handler() {
		global $post;

		if ( is_page() && strstr( $post->post_content, '[autoroyal_submit_deal' ) ) {
			$this->deal_submit_handler();
		}
	}

	/**
	 * Handles actions on autoroyal dashboard
	 */
	public function deal_submit_handler() {

		if ( ! empty( $_REQUEST['action'] ) && ! empty( $_REQUEST['_wpnonce'] ) && wp_verify_nonce( $_REQUEST['_wpnonce'], 'autoroyal_deal_actions' ) ) {

			$td_post_id = $_REQUEST['deal_id'];
			$action = $_REQUEST['action'];

			try {
				// Get deal
				$deal    = get_post( $td_post_id );

				// Check ownership
				if ( ! autoroyal_user_can_edit_car( $td_post_id ) ) {
					throw new Exception( __( 'Invalid ID', 'autoroyal' ) );
				}

				switch ( $action ) {
					case 'delete' :
						// Trash it
						wp_trash_post( $td_post_id );

						// Message
						$this->deal_submit_message = '<div class="car-manager-message">' . sprintf( __( '%s has been deleted', 'autoroyal' ), $deal->post_title ) . '</div>';
						$this->deal_delete_status = '1';

						break;
					default :
						do_action( 'autoroyal_deals_do_action_' . $action );
						break;
				}

				do_action( 'autoroyal_my_deal_do_action', $action, $td_post_id );

			} catch ( Exception $e ) {
				$this->deal_submit_message = '<div class="car-manager-error">' . $e->getMessage() . '</div>';
			}
		}

		if( 'POST' == $_SERVER['REQUEST_METHOD'] ) {

			if( isset( $_POST['submitDealFunction_nonce'] ) && wp_verify_nonce( $_POST['submitDealFunction_nonce'], 'submitDealFunction_html' ) ){

				// var_dump($_POST);

				$td_post_id = $_POST['deal_id'];
				$action = $_POST['action_name'];

				$deal_first_name = esc_attr( $_POST['deal_first_name'] );
				$deal_middle_name = esc_attr( $_POST['deal_middle_name'] );
				$deal_last_name = esc_attr( $_POST['deal_last_name'] );

				$deal_vehicle_id = esc_attr( $_POST['deal_vehicle_id'] );

				$deal_vehicle_year = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_year',true));
				$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
				$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
				$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));

				$postNewTitle = $deal_first_name . " " . $deal_middle_name . " " . $deal_last_name . " - " . $deal_vehicle_year ." " . $deal_vehicle_make . " " . $deal_vehicle_model . " " . $deal_vehicle_trim;

				if( !empty($td_post_id) AND ! autoroyal_user_can_edit_car( $td_post_id ) ) {

					$this->deal_submit_message = "<div class='car-manager-error'>" . __( 'Invalid ID', 'autoroyal' ). "</div>";
					$this->deal_submit_status = "1";

				} else {

					if( empty($td_post_id) ) {

						$my_post = array(
						  	'post_name'     => sanitize_title( $postNewTitle ),
						  	'post_title'    => $postNewTitle,
						  	'post_type'     => 'deal',
						  	'post_status'   => 'publish',
						);
						 
						// Insert the post into the database
						$td_post_id = wp_insert_post( $my_post );

						//
						$deal_first_name = esc_attr(get_post_meta($td_post_id, 'deal_first_name',true));
						$deal_middle_name = esc_attr(get_post_meta($td_post_id, 'deal_middle_name',true));
						$deal_last_name = esc_attr(get_post_meta($td_post_id, 'deal_last_name',true));
						
						$deal_vehicle_id = esc_attr(get_post_meta($td_post_id, 'deal_vehicle_id',true));

						$deal_vehicle_year = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_year',true));
						$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
						$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
						$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));

						$postNewTitle = $deal_first_name . " " . $deal_middle_name . " " . $deal_last_name . " - " . $deal_vehicle_year ." " . $deal_vehicle_make . " " . $deal_vehicle_model . " " . $deal_vehicle_trim;

						$my_post = array(
							'ID'            => $td_post_id,
						  	'post_name'     => sanitize_title( $postNewTitle ),
						  	'post_title'    => $postNewTitle,
						  	'post_type'     => 'deal',
						  	'post_status'   => 'publish',
						);

						wp_update_post( $my_post );

					} else {

						//
						$deal_first_name = esc_attr(get_post_meta($td_post_id, 'deal_first_name',true));
						$deal_middle_name = esc_attr(get_post_meta($td_post_id, 'deal_middle_name',true));
						$deal_last_name = esc_attr(get_post_meta($td_post_id, 'deal_last_name',true));

						$deal_vehicle_id = esc_attr(get_post_meta($td_post_id, 'deal_vehicle_id',true));

						$deal_vehicle_year = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_year',true));
						$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
						$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
						$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));

						$postNewTitle = $deal_first_name . " " . $deal_middle_name . " " . $deal_last_name . " - " . $deal_vehicle_year ." " . $deal_vehicle_make . " " . $deal_vehicle_model . " " . $deal_vehicle_trim;

						$my_post = array(
							'ID'            => $td_post_id,
						  	'post_name'     => sanitize_title( $postNewTitle ),
						  	'post_title'    => $postNewTitle,
						  	'post_type'     => 'deal',
						  	'post_status'   => 'publish',
						);

						wp_update_post( $my_post );

					}

					$this->deal_id = $td_post_id;

					// Deal Buyer Info
					update_post_meta($td_post_id, 'customer_type', sanitize_text_field($_POST['customer_type']));
					update_post_meta($td_post_id, 'existing_customer', sanitize_text_field($_POST['existing_customer']));

					update_post_meta($td_post_id, 'deal_first_name', sanitize_text_field($_POST['deal_first_name']));
					update_post_meta($td_post_id, 'deal_middle_name', sanitize_text_field($_POST['deal_middle_name']));
					update_post_meta($td_post_id, 'deal_last_name', sanitize_text_field($_POST['deal_last_name']));

					update_post_meta($td_post_id, 'deal_address_1', sanitize_text_field($_POST['deal_address_1']));
					update_post_meta($td_post_id, 'deal_address_2', sanitize_text_field($_POST['deal_address_2']));

					update_post_meta($td_post_id, 'deal_city', sanitize_text_field($_POST['deal_city']));
					update_post_meta($td_post_id, 'deal_state', sanitize_text_field($_POST['deal_state']));
					update_post_meta($td_post_id, 'deal_zip', sanitize_text_field($_POST['deal_zip']));

					update_post_meta($td_post_id, 'deal_home_phone', sanitize_text_field($_POST['deal_home_phone']));
					update_post_meta($td_post_id, 'deal_mobile_phone', sanitize_text_field($_POST['deal_mobile_phone']));
					update_post_meta($td_post_id, 'deal_work_phone', sanitize_text_field($_POST['deal_work_phone']));

					update_post_meta($td_post_id, 'deal_email', sanitize_text_field($_POST['deal_email']));
					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'deal_birth_date', sanitize_text_field($_POST['deal_birth_date']));
						update_post_meta($td_post_id, 'deal_social_security', sanitize_text_field($_POST['deal_social_security']));
					}

					update_post_meta($td_post_id, 'deal_driver_license_state', sanitize_text_field($_POST['deal_driver_license_state']));
					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'deal_driver_license_number', sanitize_text_field($_POST['deal_driver_license_number']));
					}
					update_post_meta($td_post_id, 'deal_driver_license_exp', sanitize_text_field($_POST['deal_driver_license_exp']));

					// Deal Co-Buyer Info
					update_post_meta($td_post_id, 'cobuyer_customer_type', sanitize_text_field($_POST['cobuyer_customer_type']));
					update_post_meta($td_post_id, 'cobuyer_existing_customer', sanitize_text_field($_POST['cobuyer_existing_customer']));

					update_post_meta($td_post_id, 'deal_cobuyer_first_name', sanitize_text_field($_POST['deal_cobuyer_first_name']));
					update_post_meta($td_post_id, 'deal_cobuyer_middle_name', sanitize_text_field($_POST['deal_cobuyer_middle_name']));
					update_post_meta($td_post_id, 'deal_cobuyer_last_name', sanitize_text_field($_POST['deal_cobuyer_last_name']));

					update_post_meta($td_post_id, 'deal_cobuyer_address_1', sanitize_text_field($_POST['deal_cobuyer_address_1']));
					update_post_meta($td_post_id, 'deal_cobuyer_address_2', sanitize_text_field($_POST['deal_cobuyer_address_2']));

					update_post_meta($td_post_id, 'deal_cobuyer_city', sanitize_text_field($_POST['deal_cobuyer_city']));
					update_post_meta($td_post_id, 'deal_cobuyer_state', sanitize_text_field($_POST['deal_cobuyer_state']));
					update_post_meta($td_post_id, 'deal_cobuyer_zip', sanitize_text_field($_POST['deal_cobuyer_zip']));

					update_post_meta($td_post_id, 'deal_cobuyer_home_phone', sanitize_text_field($_POST['deal_cobuyer_home_phone']));
					update_post_meta($td_post_id, 'deal_cobuyer_mobile_phone', sanitize_text_field($_POST['deal_cobuyer_mobile_phone']));
					update_post_meta($td_post_id, 'deal_cobuyer_work_phone', sanitize_text_field($_POST['deal_cobuyer_work_phone']));

					update_post_meta($td_post_id, 'deal_cobuyer_email', sanitize_text_field($_POST['deal_cobuyer_email']));
					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'deal_cobuyer_birth_date', sanitize_text_field($_POST['deal_cobuyer_birth_date']));
						update_post_meta($td_post_id, 'deal_cobuyer_social_security', sanitize_text_field($_POST['deal_cobuyer_social_security']));
					}

					update_post_meta($td_post_id, 'deal_cobuyer_driver_license_state', sanitize_text_field($_POST['deal_cobuyer_driver_license_state']));
					if( get_autoroyal_ssl_hide_forms() != "1" OR !empty( $_SERVER['HTTPS'] ) ) {
						update_post_meta($td_post_id, 'deal_cobuyer_driver_license_number', sanitize_text_field($_POST['deal_cobuyer_driver_license_number']));
					}
					update_post_meta($td_post_id, 'deal_cobuyer_driver_license_exp', sanitize_text_field($_POST['deal_cobuyer_driver_license_exp']));

					// Vehicle Information
					update_post_meta($td_post_id, 'deal_vehicle_id', sanitize_text_field($_POST['deal_vehicle_id']));
					$deal_vehicle_id = esc_attr(get_post_meta($td_post_id, 'deal_vehicle_id',true));
					$deal_vehicle_sku_own = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_stock',true));
					update_post_meta($td_post_id, 'deal_vehicle_sku', $deal_vehicle_sku_own);

					$price = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_price',true));
					$cost = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_cost',true));
					$profit = $price - $cost;
					update_post_meta($td_post_id, 'deal_vehicle_price', $price);
					update_post_meta($td_post_id, 'deal_vehicle_cost', $cost);
					update_post_meta($td_post_id, 'deal_vehicle_profit', $profit);

					$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
					update_post_meta($td_post_id, 'deal_vehicle_make', $deal_vehicle_make);
					
					$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
					update_post_meta($td_post_id, 'deal_vehicle_model', $deal_vehicle_model);

					$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));
					update_post_meta($td_post_id, 'deal_vehicle_trim', $deal_vehicle_trim);

					$date = strtotime($_POST['deal_sold_date']);
					update_post_meta( $deal_vehicle_id, '_sold_date', $date );
					update_post_meta( $deal_vehicle_id, '_sold', 1 );

					$format = get_option('date_format');
					$pfx_date = get_the_date( $format, $deal_vehicle_id ); 
					$sold = esc_attr(get_post_meta($deal_vehicle_id, '_sold_date',true));

					if(!empty($sold)) {
						$now = $sold;
					} else {
						$now = strtotime(date("Y-m-d H:i:s")); 
					}

					$days = ($now - strtotime($pfx_date)) / (60 * 60 * 24); 
					update_post_meta($td_post_id, 'deal_vehicle_age', $days);

					if( !empty($date) ) {
						$mypost = array();
						$mypost['ID'] = $td_post_id;
						$mypost['post_date'] = date("Y-m-d H:i:s", $date);
						wp_update_post($mypost);
					}

					//
					update_post_meta($td_post_id, 'deal_tradein_vehicle_year', sanitize_text_field($_POST['deal_vehicle_year']));
					update_post_meta($td_post_id, 'deal_tradein_vehicle_make', sanitize_text_field($_POST['deal_vehicle_make']));
					update_post_meta($td_post_id, 'deal_tradein_vehicle_model', sanitize_text_field($_POST['deal_vehicle_model']));
					update_post_meta($td_post_id, 'deal_tradein_vehicle_trim_id', sanitize_text_field($_POST['deal_vehicle_trim']));
					update_post_meta($td_post_id, 'deal_tradein_vehicle_trim_desc_init', sanitize_text_field($_POST['vehicle_trim_desc_init']));
					update_post_meta($td_post_id, 'deal_tradein_vehicle_make_desc_init', sanitize_text_field($_POST['vehicle_make_desc_init']));

					update_post_meta($td_post_id, 'deal_tradein_vehicle_vin', sanitize_text_field($_POST['deal_tradein_vehicle_vin']));
					update_post_meta($td_post_id, 'deal_tradein_vehicle_mileage', sanitize_text_field($_POST['deal_tradein_vehicle_mileage']));
					update_post_meta($td_post_id, 'deal_tradein_vehicle_color', sanitize_text_field($_POST['deal_tradein_vehicle_color']));

					update_post_meta($td_post_id, 'deal_tradein_allowance', sanitize_text_field($_POST['deal_tradein_allowance']));
					update_post_meta($td_post_id, 'deal_tradein_payoff', sanitize_text_field($_POST['deal_tradein_payoff']));
					update_post_meta($td_post_id, 'deal_tradein_payoff_good', sanitize_text_field($_POST['deal_tradein_payoff_good']));
					update_post_meta($td_post_id, 'deal_tradein_lien_holder_name', sanitize_text_field($_POST['deal_tradein_lien_holder_name']));
					update_post_meta($td_post_id, 'deal_tradein_lien_holder_addres_1', sanitize_text_field($_POST['deal_tradein_lien_holder_addres_1']));
					update_post_meta($td_post_id, 'deal_tradein_lien_holder_addres_2', sanitize_text_field($_POST['deal_tradein_lien_holder_addres_2']));
					update_post_meta($td_post_id, 'deal_tradein_lien_holder_city', sanitize_text_field($_POST['deal_tradein_lien_holder_city']));
					update_post_meta($td_post_id, 'deal_tradein_lien_holder_state', sanitize_text_field($_POST['deal_tradein_lien_holder_state']));
					update_post_meta($td_post_id, 'deal_tradein_lien_holder_zip', sanitize_text_field($_POST['deal_tradein_lien_holder_zip']));
					update_post_meta($td_post_id, 'deal_tradein_lien_holder_phone', sanitize_text_field($_POST['deal_tradein_lien_holder_phone']));
					update_post_meta($td_post_id, 'deal_tradein_lien_holder_acc_number', sanitize_text_field($_POST['deal_tradein_lien_holder_acc_number']));

					//
					update_post_meta($td_post_id, 'deal_sold_date', sanitize_text_field($_POST['deal_sold_date']));
					update_post_meta($td_post_id, 'deal_purchase_price', sanitize_text_field($_POST['deal_purchase_price']));
					update_post_meta($td_post_id, 'deal_trade_in_payoff', sanitize_text_field($_POST['deal_trade_in_payoff']));
					update_post_meta($td_post_id, 'deal_trade_in_allowance', sanitize_text_field($_POST['deal_trade_in_allowance']));
					update_post_meta($td_post_id, 'deal_total_price', sanitize_text_field($_POST['deal_purchase_price']));
					update_post_meta($td_post_id, 'deal_down_payment', sanitize_text_field($_POST['deal_down_payment']));
					update_post_meta($td_post_id, 'deal_total_balance_due', sanitize_text_field($_POST['deal_total_balance_due']));

					if(!empty($_POST['deal_payment_method'])) {
						$deal_payment_method = $_POST['deal_payment_method'];
					} else {
						$deal_payment_method = "";
					}
					wp_set_post_terms( $td_post_id, $deal_payment_method, "deal_payment_method", false );

					update_post_meta($td_post_id, 'deal_loan_amount', sanitize_text_field($_POST['deal_loan_amount']));
					update_post_meta($td_post_id, 'deal_interest_rate', sanitize_text_field($_POST['deal_interest_rate']));
					update_post_meta($td_post_id, 'deal_sales_tax', sanitize_text_field($_POST['deal_sales_tax']));
					update_post_meta($td_post_id, 'deal_sales_tax_fee', sanitize_text_field($_POST['deal_sales_tax_fee']));
					update_post_meta($td_post_id, 'deal_loan_term', sanitize_text_field($_POST['deal_loan_term']));
					update_post_meta($td_post_id, 'deal_loan_term_priod', sanitize_text_field($_POST['deal_loan_term_priod']));
					update_post_meta($td_post_id, 'deal_loan_payment_amount', sanitize_text_field($_POST['deal_loan_payment_amount']));
					update_post_meta($td_post_id, 'deal_loan_payment_final_amount', sanitize_text_field($_POST['deal_loan_payment_final_amount']));
					update_post_meta($td_post_id, 'deal_loan_payment_amount_period', sanitize_text_field($_POST['deal_loan_payment_amount_period']));

					update_post_meta($td_post_id, 'deal_profit', sanitize_text_field($_POST['deal_profit_hidden']));

					update_post_meta($td_post_id, 'deal_loan_final_date', sanitize_text_field($_POST['deal_loan_final_date']));
					update_post_meta($td_post_id, 'deal_loan_rate', sanitize_text_field($_POST['deal_loan_rate']));

					if( !empty($_POST['deal_new_schedule']) AND $_POST['deal_new_schedule'] == "on" ) {
						update_post_meta($td_post_id, 'deal_loan_payments_num', sanitize_text_field($_POST['deal_loan_payments_num']));
						update_post_meta($td_post_id, 'deal_loan_payments_period', sanitize_text_field($_POST['deal_loan_payments_period']));
						update_post_meta($td_post_id, 'deal_loan_payments', "");
						update_post_meta($td_post_id, 'deal_loan_payment_amount_x', $_POST['deal_loan_payment_amount_x']);
					} else {
						update_post_meta($td_post_id, 'deal_loan_payments', $_POST['deal_loan_payments']);
						update_post_meta($td_post_id, 'deal_loan_payment_amount_x', $_POST['deal_loan_payment_amount_x_old']);
					}

					update_post_meta($td_post_id, 'deal_loan_payoff_date', sanitize_text_field($_POST['deal_loan_payoff_date']));

					$deal_loan_payments = get_post_meta($td_post_id, 'deal_loan_payments',true);
					$deal_loan_payments_num = get_post_meta($td_post_id, 'deal_loan_payments_num',true);
					if(!empty($deal_loan_payments[0]['date'])) {
						$deal_loan_next_payments_date = $deal_loan_payments[0]['date'];
					} else {
						$deal_loan_next_payments_date = "";
					}

					for( $i = 0; $i < $deal_loan_payments_num; ++$i ){ 

						if(!empty($deal_loan_payments[$i]['paid'])) {

							if( $deal_loan_payments[$i]['paid'] == "on" ) {

								$deal_loan_next_payments_date = $deal_loan_payments[$i+1]['date'];

							}

						}

					}

					if(!empty($deal_loan_payments[$deal_loan_payments_num - 1]['paid'])) {

						if( $deal_loan_payments[$deal_loan_payments_num - 1]['paid'] == "on" ) {
							$deal_loan_next_payments_date = "done";
						}

					}

					if( !empty($_POST['deal_closed']) AND $_POST['deal_closed'] == "on"  ) {
						$deal_loan_next_payments_date = "done";
					}

					update_post_meta($td_post_id, 'deal_loan_next_payments_date', $deal_loan_next_payments_date);

					//
					$deal_first_name = esc_attr(get_post_meta($td_post_id, 'deal_first_name',true));
					$deal_middle_name = esc_attr(get_post_meta($td_post_id, 'deal_middle_name',true));
					$deal_last_name = esc_attr(get_post_meta($td_post_id, 'deal_last_name',true));

					$deal_vehicle_id = esc_attr(get_post_meta($td_post_id, 'deal_vehicle_id',true));

					$deal_vehicle_year = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_year',true));
					$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
					$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
					$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));

					$postNewTitle = $deal_first_name . " " . $deal_middle_name . " " . $deal_last_name . " - " . $deal_vehicle_year ." " . $deal_vehicle_make . " " . $deal_vehicle_model . " " . $deal_vehicle_trim;

					$dealVehicleName = $deal_vehicle_make . " " . $deal_vehicle_model . " " . $deal_vehicle_trim . " " . $deal_vehicle_year;
					update_post_meta($td_post_id, 'deal_vehicle_name', $dealVehicleName);

					$this->deal_submit_message = '<div class="car-manager-message">' . sprintf( __( '%s deal has been saved', 'autoroyal' ), $postNewTitle ) . '</div>';
					$this->deal_submit_status = "0";

				}

			}

		}

	}

	/**
	 * Shortcode which lists the logged in user's cars
	 */
	public function autoroyal_submit_deal( $atts ) {
		
		if ( ! is_user_logged_in() ) {
			ob_start();
			get_autoroyal_template( 'autoroyal-login.php' );
			return ob_get_clean();
		}

		// Enqueue styles
		wp_enqueue_style( 'jquery-ui' );
		wp_enqueue_style( 'bootstrap-select' );

		// Enqueue scripts
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'jquery-ui-autocomplete' );
		wp_enqueue_script( 'time-picker' );
		wp_enqueue_script( 'bootstrap-select' );

		ob_start();

		// If doing an action, show conditional content if needed....
		if ( ! empty( $_REQUEST['action'] ) ) {
			$action = sanitize_title( $_REQUEST['action'] );

			// Show alternative content if a plugin wants to
			if ( has_action( 'autoroyal_submit_deal_content_' . $action ) ) {
				do_action( 'autoroyal_submit_deal_content_' . $action, $atts );

				return ob_get_clean();
			}
		}

		echo $this->deal_submit_message;

		if($this->deal_submit_status == 0) {

			get_autoroyal_template( 'autoroyal-submit-deal.php', array( 'deal_id' => $this->deal_id ) );

		}

		return ob_get_clean();
	}

}

new autoroyal_Shortcode_Submit_Deal();
