<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Content class.
 */
class autoroyal_Deal_Post_Type {

	/**
	 * Constructor
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'register_deal_post_type' ), 0 );

		add_filter( 'the_deal_description', 'wptexturize'        );
		add_filter( 'the_deal_description', 'convert_smilies'    );
		add_filter( 'the_deal_description', 'convert_chars'      );
		add_filter( 'the_deal_description', 'wpautop'            );
		add_filter( 'the_deal_description', 'shortcode_unautop'  );
		add_filter( 'the_deal_description', 'prepend_attachment' );
		if ( ! empty( $GLOBALS['wp_embed'] ) ) {
			add_filter( 'the_deal_description', array( $GLOBALS['wp_embed'], 'run_shortcode' ), 8 );
			add_filter( 'the_deal_description', array( $GLOBALS['wp_embed'], 'autoembed' ), 8 );
		}

		add_filter( 'wp_insert_post_data', array( $this, 'fix_deal_post_name' ), '99', 2 );

	}

	/**
	 * register_deal_post_type function.
	 *
	 * @access public
	 * @return void
	 */
	public function register_deal_post_type() {
		
		if ( post_type_exists( "deal" ) )
			return;

		$admin_capability = 'manage_deals';

	    // Deal Method of Payment
	    $singular  = __( 'Method of Payment', 'autoroyal' );
		$plural    = __( 'Methods of Payment', 'autoroyal' );

		if ( current_theme_supports( 'deal-manager-templates' ) ) {
			$rewrite   = array(
				'slug'         => _x( 'deal-method-of-payment', 'deal status slug - resave permalinks after changing this', 'autoroyal' ),
				'with_front'   => false,
				'hierarchical' => true
			);
			$public    = true;
		} else {
			$rewrite   = false;
			$public    = false;
		}

		register_taxonomy( "deal_payment_method",
			apply_filters( 'register_taxonomy_deal_payment_meyhod_object_type', array( 'deal' ) ),
       	 	apply_filters( 'register_taxonomy_deal_payment_meyhod_args', array(
	            'hierarchical' 			=> true,
	            'update_count_callback' => '_update_post_term_count',
	            'label' 				=> $plural,
	            'labels' => array(
					'name'              => $plural,
					'singular_name'     => $singular,
					'menu_name'         => ucwords( $plural ),
					'search_items'      => sprintf( __( 'Search Method of Payment', 'autoroyal' ), $plural ),
					'all_items'         => sprintf( __( 'Method of Payment', 'autoroyal' ), $plural ),
					'parent_item'       => sprintf( __( 'Parent Method of Payment', 'autoroyal' ), $singular ),
					'parent_item_colon' => sprintf( __( 'Parent Method of Payment:', 'autoroyal' ), $singular ),
					'edit_item'         => sprintf( __( 'Edit Method of Payment', 'autoroyal' ), $singular ),
					'update_item'       => sprintf( __( 'Update Method of Payment', 'autoroyal' ), $singular ),
					'add_new_item'      => sprintf( __( 'Add New Method of Payment', 'autoroyal' ), $singular ),
					'new_item_name'     => sprintf( __( 'New Method of Payment', 'autoroyal' ),  $singular )
            	),
	            'show_ui' 				=> true,
	            'show_tagcloud'			=> false,
	            'public' 	     		=> $public,
	            'rewrite' 				=> $rewrite,
	        ) )
	    );

		// Taxonomies
	    $taxonomies = array(
			"deal_payment_method" => array(
				"Bank Loan",
				"Cash",
				"Personal Check",
				"Cashier's Check",
				"Wire Transfer",
				"Credit Card",
				"Company Check"
			)
		);

		$autoroyal_deals_installed_terms = get_option( 'autoroyal_deals_installed_terms' );

		if( !isset($autoroyal_deals_installed_terms) OR empty($autoroyal_deals_installed_terms) ) {

			foreach ( $taxonomies as $taxonomy => $terms ) {

				foreach ( $terms as $term ) {

					if( is_array( $term ) ) {

						if ( ! get_term_by( 'slug', sanitize_title( $term[0] ), $taxonomy ) ) {
							
							$submit_term = wp_insert_term( $term[0], $taxonomy );

							if ( is_wp_error( $submit_term ) ) {
							   	$error_string = $submit_term->get_error_message();
							   	echo '<div id="message" class="error"><p>' . $error_string . ' - ' . $taxonomy . ' - ' . $s . '</p></div>';
							}

							if ( ! is_wp_error( $submit_term ) ) {
							    // Get term_id, set default as 0 if not set
							    $term_id = isset( $submit_term['term_id'] ) ? $submit_term['term_id'] : 0;

							    foreach ( $term as $sub_term ) {

									if ( ! get_term_by( 'slug', sanitize_title( $sub_term ), $taxonomy ) ) {

										if( $term[0] != $sub_term ) {

											$submit_term = wp_insert_term( $sub_term, $taxonomy, array( 'parent' => $term_id) );

										}

									}

								}
							}

						};

					} else {
						
						if ( ! get_term_by( 'slug', sanitize_title( $term ), $taxonomy ) ) {
							
							$submit_term = wp_insert_term( $term, $taxonomy );

							if ( ! is_wp_error( $submit_term ) ) {
							    // Get term_id, set default as 0 if not set
							    $term_id = isset( $submit_term['term_id'] ) ? $submit_term['term_id'] : 0;
							}

							if ( is_wp_error( $submit_term ) ) {
							   	$error_string = $submit_term->get_error_message();
							   	echo '<div id="message" class="error"><p>' . $error_string . ' - ' . $taxonomy . ' - ' . $s . '</p></div>';
							}

						}

					}

				}

			}

			if( isset($submit_term['term_id']) && !is_wp_error($submit_term) ) {
	            update_option( 'autoroyal_deals_installed_terms', 1 );
	        }

		} 

	    /**
		 * Post types
		 */
		$singular  = __( 'Deal', 'autoroyal' );
		$plural    = __( 'Deals', 'autoroyal' );

		if ( current_theme_supports( 'deal-manager-templates' ) ) {
			$has_archive = _x( 'Deals', 'Post type archive slug - resave permalinks after changing this', 'autoroyal' );
		} else {
			$has_archive = false;
		}

		$rewrite     = array(
			'slug'       => _x( 'deal', 'deal permalink - resave permalinks after changing this', 'autoroyal' ),
			'with_front' => false,
			'feeds'      => true,
			'pages'      => false
		);

		register_post_type( "deal",
			apply_filters( "register_post_type_deal", array(
				'labels' => array(
					'name'			=> $plural,
					'singular_name' 	=> $singular,
					'menu_name'             => __( 'Deals', 'autoroyal' ),
					'all_items'             => sprintf( __( 'All Deals', 'autoroyal' ), $plural ),
					'add_new' 		=> __( 'Add New Deal', 'autoroyal' ),
					'add_new_item' 		=> sprintf( __( 'Add %s', 'autoroyal' ), $singular ),
					'edit' 			=> __( 'Edit', 'autoroyal' ),
					'edit_item' 		=> sprintf( __( 'Edit %s', 'autoroyal' ), $singular ),
					'new_item' 		=> sprintf( __( 'New %s', 'autoroyal' ), $singular ),
					'view' 			=> sprintf( __( 'View %s', 'autoroyal' ), $singular ),
					'view_item' 		=> sprintf( __( 'View %s', 'autoroyal' ), $singular ),
					'search_items' 		=> sprintf( __( 'Search %s', 'autoroyal' ), $plural ),
					'not_found' 		=> sprintf( __( 'No %s found', 'autoroyal' ), $plural ),
					'not_found_in_trash' 	=> sprintf( __( 'No %s found in trash', 'autoroyal' ), $plural ),
					'parent' 		=> sprintf( __( 'Parent %s', 'autoroyal' ), $singular ),
				),
				'description' => sprintf( __( 'This is where you can create and manage %s.', 'autoroyal' ), $plural ),
				'public' 				=> true,
				'show_ui' 				=> true,
				'capability_type' 		=> 'vehicle',
				'map_meta_cap'          => true,
				'publicly_queryable' 	=> true,
				'exclude_from_search' 	=> false,
				'hierarchical' 			=> false,
				'rewrite' 				=> $rewrite,
				'query_var' 			=> true,
				'supports' 				=> array( 'title', 'editor', 'custom-fields', 'publicize', 'thumbnail', 'author' ),
				'has_archive' 			=> $has_archive,
				'show_in_nav_menus' 	=> false
			) )
		);

		// Hide text editor in deal back end
		add_action('init', 'init_remove_editor_deal',100);
		function init_remove_editor_deal(){
			$post_type = 'deal';
			remove_post_type_support( $post_type, 'editor');
		}
	}

	/**
	 * Fix post name when wp_update_post changes it
	 * @param  array $data
	 * @return array
	 */
	public function fix_deal_post_name( $data, $postarr ) {

		global $post, $id;

	  	if( 'deal' == $data['post_type'] && isset($data['post_type']) ) {

	  		$id = $postarr['ID'];

			if($id) {

				$postID = $_POST['deal_id'];

				$deal_first_name = esc_attr( $_POST['deal_first_name'] );
				$deal_middle_name = esc_attr( $_POST['deal_middle_name'] );
				$deal_last_name = esc_attr( $_POST['deal_last_name'] );

				$deal_vehicle_id = esc_attr( $_POST['deal_vehicle_id'] );

				$deal_vehicle_year = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_year',true));
				$deal_vehicle_make = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_make_desc_init',true));
				$deal_vehicle_model = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_model',true));
				$deal_vehicle_trim = esc_attr(get_post_meta($deal_vehicle_id, 'vehicle_trim_desc_init',true));

				$deal_sold_date = esc_attr( $_POST['deal_sold_date'] );

				$postNewTitle = $deal_first_name . " " . $deal_middle_name . " " . $deal_last_name . " - " . $deal_vehicle_year ." " . $deal_vehicle_make . " " . $deal_vehicle_model . " " . $deal_vehicle_trim . " #" .$postID;

				$dealVehicleName = $deal_vehicle_make . " " . $deal_vehicle_model . " " . $deal_vehicle_trim . " " . $deal_vehicle_year;

				update_post_meta($postID, 'deal_vehicle_name', $dealVehicleName);

				$data['post_name'] = sanitize_title( $postNewTitle );
				$data['post_title'] = $postNewTitle; 
				if(!empty($deal_sold_date)) {
					$data['post_date'] = date("Y-m-d H:i:s", strtotime( $deal_sold_date ));
				}

			}

		}

	  	return $data; // Returns the modified data.

	}

}
