<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * autoRoyal_Settings class.
 */
class autoroyal_Settings {

	/**
	 * __construct function.
	 *
	 * @access public
	 * @return void
	 */
	public function __construct() {
		$this->settings_group = 'car';
		add_action( 'admin_init', array( $this, 'register_settings' ) );
	}

	/**
	 * init_settings function.
	 *
	 * @access protected
	 * @return void
	 */
	protected function init_settings() {
		
		// Prepare roles option
		$roles         = get_editable_roles();
		$account_roles = array();

		foreach ( $roles as $key => $role ) {
			if ( $key == 'administrator' ) {
				continue;
			}
			$account_roles[ $key ] = $role['name'];
		}

		$currency_code_options = get_autoroyal_currencies();

		foreach ( $currency_code_options as $code => $name ) {
			$currency_code_options[ $code ] = $name . ' (' . autoroyal_get_currency_symbol( $code ) . ')';
		}

		$this->settings = apply_filters( 'car_settings',
			array(
				'main_settings' => array(
					__( 'Main Settings', 'autoroyal' ),
					array(
						array(
							'name'       => 'autoroyal_webiste_type',
							'std'        => 'dealer',
							'label'      => __( 'Website Type', 'autoroyal' ),
							'type'       => 'select',
							'options' => array(
								'dealer'  => __( 'Dealership', 'autoroyal' ),
								'rentals'  => __( 'Rent A Car', 'autoroyal' ),
								'marketplace' => __( 'Automotive Marketplace', 'autoroyal' ),
								'rentals_dealer'  => __( 'Dealership & Rent A Car', 'autoroyal' ),
							)
						),
						array(
							'name'        => 'autoroyal_posts_per_page',
							'std'         => '9',
							'placeholder' => '',
							'label'       => __( 'Vehicles per page', 'autoroyal' ),
							'attributes'  => array()
						),
						array(
							'name'       => 'autoroyal_measurement_type',
							'std'        => 'metric',
							'label'      => __( 'System of Measurement', 'autoroyal' ),
							'type'       => 'select',
							'options' => array(
								'metric'  => __( 'Metric', 'autoroyal' ),
								'usa' => __( 'U.S.', 'autoroyal' ),
							)
						),
						array(
							'name'       => 'autoroyal_currency',
							'std'        => 'USD',
							'label'      => __( 'Currency', 'autoroyal' ),
							'type'       => 'select',
							'options'    => $currency_code_options
						),
						array(
							'name'       => 'autoroyal_currency_position',
							'std'        => 'left',
							'label'      => __( 'Currency Position', 'autoroyal' ),
							'type'       => 'select',
							'options' => array(
								'left'  => __( 'Left ($99.99)', 'autoroyal' ),
								'right' => __( 'Right (99.99$)', 'autoroyal' ),
								'left_space'  => __( 'Left with space ($ 99.99)', 'autoroyal' ),
								'right_space' => __( 'Right with space (99.99 $)', 'autoroyal' ),
							)
						),
						array(
							'name'        => 'autoroyal_thousand_separator',
							'std'         => ',',
							'placeholder' => '',
							'label'       => __( 'Thousand Separator', 'autoroyal' ),
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_decimal_separator',
							'std'         => '.',
							'placeholder' => '',
							'label'       => __( 'Decimal Separator', 'autoroyal' ),
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_price_num_decimals',
							'std'         => '0',
							'placeholder' => '',
							'label'       => __( 'Number of Decimals', 'autoroyal' ),
							'attributes'  => array()
						),
						array(
							'name'       => 'autoroyal_vehicle_forms',
							'std'        => '0',
							'label'      => __( 'Hide vehicle contact forms', 'autoroyal' ),
							'cb_label'   => __( 'Hide vehicle contact forms', 'autoroyal' ),
							'desc'       => __( 'Hide vehicle contact forms: Pre-Qualify, Test Drive Trade-In and Financial Application.', 'autoroyal' ),
							'type'       => 'checkbox',
							'attributes' => array()
						),
						array(
							'name'       => 'autoroyal_ssl_hide_forms',
							'std'        => '0',
							'label'      => __( 'SSL Verification', 'autoroyal' ),
							'cb_label'   => __( 'Verify SSL Certification', 'autoroyal' ),
							'desc'       => __( 'If enabled and missing https, sensitive fileds will be hidden.', 'autoroyal' ),
							'type'       => 'checkbox',
							'attributes' => array()
						),
						array(
							'name'        => 'autoroyal_googlemap_key',
							'std'         => '',
							'placeholder' => '',
							'label'       => __( 'Google Maps API Key', 'autoroyal' ),
							'attributes'  => array()
						),
					),
				),
				'contact_settings' => array(
					__( 'Contact Form', 'autoroyal' ),
					array(
						array(
							'name'        => 'autoroyal_contact_form_header_text',
							'std'         => __( 'Use the contact form to get in touch, whether you want to schedule for a test-drive, make an offer for this vehicle, trade-in your vehicle for this one or you want us to call you back.', 'autoroyal' ),
							'placeholder' => '',
							'label'       => __( 'Intro text', 'autoroyal' ),
							'type'        => 'textarea',
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_contact_form_thankyou_text',
							'std'         => __( 'Thank you for contacting us. We will get back to you shortly.', 'autoroyal' ),
							'placeholder' => '',
							'label'       => __( 'Thank you text', 'autoroyal' ),
							'type'        => 'textarea',
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_contact_form_name_error',
							'std'         => __( 'Please add a name.', 'autoroyal' ),
							'placeholder' => '',
							'label'       => __( 'Name error text', 'autoroyal' ),
							'type'        => 'textarea',
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_contact_form_email_error',
							'std'         => __( 'Please use a valid email.', 'autoroyal' ),
							'placeholder' => '',
							'label'       => __( 'Email error text', 'autoroyal' ),
							'type'        => 'textarea',
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_contact_form_phone_error',
							'std'         => __( 'Please add a phone number.', 'autoroyal' ),
							'placeholder' => '',
							'label'       => __( 'Phone error text', 'autoroyal' ),
							'type'        => 'textarea',
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_contact_form_default_message',
							'std'         => __( 'I am interested in getting a price quote for this vehicle. Please let me know at your earliest convenience the best price for this vehicle.', 'autoroyal' ),
							'placeholder' => '',
							'label'       => __( 'Default message text', 'autoroyal' ),
							'type'        => 'textarea',
							'attributes'  => array()
						),
					),
				),
				'car_pages' => array(
					__( 'Pages', 'autoroyal' ),
					array(
						array(
							'name' 		=> 'autoroyal_notifications_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Notifications Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_notifications] shortcode. This lets the plugin know where the notifications are located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_notifications_subscribers_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Notifications Subscribers Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_filter_subscriptions] shortcode. This lets the plugin know where the notifications subscribers are located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_active_adv_page_id',
							'std' 		=> '',
							'label' 	=> __( 'My Active Advertised Listings Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_active_adv] shortcode. This lets the plugin know where the active advertised listings are located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_upcoming_payments_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Upcoming Payments', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_upcoming_payments] shortcode. This lets the plugin know where the active advertised listings are located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_reports_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Sales & Reports Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_reports] shortcode. This lets the plugin know where the sales & reports are located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_account_funds_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Account Funds Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_account_funds] shortcode. This lets the plugin know where the account funds are located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_account_settings_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Account Settings Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_account_settings] shortcode. This lets the plugin know where the account settings are located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_compare_vehicles_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Compare Vehicles Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have selected "Compare Listings" page template.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_search_vehicles_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Search Vehicles Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_cars] shortcode. This lets the plugin know where the form is located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_search_rent_vehicles_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Search Vehicles For Rent Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_cars_rent] shortcode. This lets the plugin know where the form is located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_submit_car_form_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Add/Edit Vehicle Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_submit] shortcode. This lets the plugin know where the form is located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_dashboard_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Dealer Dashboard Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_dashboard] shortcode. This lets the plugin know where the dashboard is located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_inventory_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Dealer Inventory Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_inventory] shortcode. This lets the plugin know where the my inventory is located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_leads_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Dealer Leads Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_leads] shortcode. This lets the plugin know where my leads is located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_submit_lead_form_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Add/Edit Lead Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_submit_lead] shortcode. This lets the plugin know where the form is located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_deals_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Dealer Deals Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_deals] shortcode. This lets the plugin know where my deals are located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_submit_deal_form_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Add/Edit Deal Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_submit_deal] shortcode. This lets the plugin know where the form is located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_reservations_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Rent Reservations Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_reservations] shortcode. This lets the plugin know where my reservations are located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_submit_reservation_form_page_id',
							'std' 		=> '',
							'label' 	=> __( 'Add/Edit Reservation Page', 'autoroyal' ),
							'desc'		=> __( 'Select the page where you have placed the [autoroyal_submit_reservation] shortcode. This lets the plugin know where the form is located.', 'autoroyal' ),
							'type'      => 'page'
						),
						array(
							'name' 		=> 'autoroyal_submit_unreg_car_form_page_id',
							'std' 		=> '',
							'label' 	=> __( '"Submit Vehicle" Front-End.', 'autoroyal' ),
							'type'      => 'page'
						),
					)
				),
				'monetisation' => array(
					__( 'Monetisation', 'autoroyal' ),
					array(
						array(
							'name'       => 'autoroyal_enable_account_funds',
							'std'        => '0',
							'label'      => __( 'Account funds', 'autoroyal' ),
							'cb_label'   => __( 'Enable account funds', 'autoroyal' ),
							'desc'       => __( 'If enabled top-up funds form will be visible in dashboard.', 'autoroyal' ),
							'type'       => 'checkbox',
							'attributes' => array()
						),
						array(
							'name'        => 'autoroyal_account_funds_min_topup',
							'std'         => '0',
							'placeholder' => '',
							'label'       => __( 'Minimum Top-up', 'autoroyal' ),
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_account_funds_max_topup',
							'std'         => '',
							'placeholder' => __( 'n/a', 'autoroyal' ),
							'label'       => __( 'Maximum Top-up', 'autoroyal' ),
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_submit_listing_price',
							'std'         => '',
							'placeholder' => '1',
							'label'       => __( 'Submit listing fee', 'autoroyal' ),
							'desc'		  => __( 'One time fee. Will be deducted from account funds.', 'autoroyal' ),
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_promoted_listing_price',
							'std'         => '',
							'placeholder' => '1',
							'label'       => __( 'Promoted listing price', 'autoroyal' ),
							'desc'		  => __( 'Price per day. Will be deducted from account funds. Listing will be re-published every day and will appear among the first but after featured.', 'autoroyal' ),
							'attributes'  => array()
						),
						array(
							'name'        => 'autoroyal_featured_listing_price',
							'std'         => '',
							'placeholder' => '2',
							'label'       => __( 'Featured listing price', 'autoroyal' ),
							'desc'		  => __( 'Price per day. Will be deducted from account funds. Listing will appear first.', 'autoroyal' ),
							'attributes'  => array()
						),
					),
				),
			)
		);
	}

	/**
	 * register_settings function.
	 *
	 * @access public
	 * @return void
	 */
	public function register_settings() {
		$this->init_settings();

		foreach ( $this->settings as $section ) {
			foreach ( $section[1] as $option ) {
				if ( isset( $option['std'] ) )
					add_option( $option['name'], $option['std'] );
				register_setting( $this->settings_group, $option['name'] );
			}
		}
	}

	/**
	 * output function.
	 *
	 * @access public
	 * @return void
	 */
	public function output() {
		$this->init_settings();
		?>
		<div class="wrap autoroyal-settings-wrap">
			<form method="post" action="options.php">

				<?php settings_fields( $this->settings_group ); ?>

			    <h2 class="nav-tab-wrapper">
			    	<?php
			    		foreach ( $this->settings as $key => $section ) {
			    			echo '<a href="#settings-' . sanitize_title( $key ) . '" class="nav-tab">' . esc_html( $section[0] ) . '</a>';
			    		}
			    	?>
			    </h2>

				<?php
					if ( ! empty( $_GET['settings-updated'] ) ) {
						flush_rewrite_rules();
						echo '<div class="updated fade car-manager-updated"><p>' . __( 'Settings successfully saved', 'autoroyal' ) . '</p></div>';
					}

					foreach ( $this->settings as $key => $section ) {

						echo '<div id="settings-' . sanitize_title( $key ) . '" class="settings_panel">';

						echo '<table class="form-table">';

						foreach ( $section[1] as $option ) {

							$placeholder    = ( ! empty( $option['placeholder'] ) ) ? 'placeholder="' . $option['placeholder'] . '"' : '';
							$class          = ! empty( $option['class'] ) ? $option['class'] : '';
							$value          = get_option( $option['name'] );
							$option['type'] = ! empty( $option['type'] ) ? $option['type'] : '';
							$attributes     = array();

							if ( ! empty( $option['attributes'] ) && is_array( $option['attributes'] ) )
								foreach ( $option['attributes'] as $attribute_name => $attribute_value )
									$attributes[] = esc_attr( $attribute_name ) . '="' . esc_attr( $attribute_value ) . '"';

							echo '<tr valign="top" class="' . $class . '"><th scope="row"><label for="setting-' . $option['name'] . '">' . $option['label'] . '</a></th><td>';

							switch ( $option['type'] ) {

								case "checkbox" :

									?><label><input id="setting-<?php echo $option['name']; ?>" name="<?php echo $option['name']; ?>" type="checkbox" value="1" <?php echo implode( ' ', $attributes ); ?> <?php checked( '1', $value ); ?> /> <?php echo $option['cb_label']; ?></label><?php

									if ( !empty($option['desc']) )
										echo ' <p class="description">' . $option['desc'] . '</p>';

								break;
								case "textarea" :

									?><textarea id="setting-<?php echo $option['name']; ?>" class="large-text" cols="50" rows="3" name="<?php echo $option['name']; ?>" <?php echo implode( ' ', $attributes ); ?> <?php echo $placeholder; ?>><?php echo esc_textarea( $value ); ?></textarea><?php

									if ( !empty($option['desc']) )
										echo ' <p class="description">' . $option['desc'] . '</p>';

								break;
								case "select" :

									?><select id="setting-<?php echo $option['name']; ?>" class="regular-text" name="<?php echo $option['name']; ?>" <?php echo implode( ' ', $attributes ); ?>><?php
										foreach( $option['options'] as $key => $name )
											echo '<option value="' . esc_attr( $key ) . '" ' . selected( $value, $key, false ) . '>' . esc_html( $name ) . '</option>';
									?></select><?php

									if ( !empty($option['desc']) ) {
										echo ' <p class="description">' . $option['desc'] . '</p>';
									}

								break;
								case "page" :

									$args = array(
										'name'             => $option['name'],
										'id'               => $option['name'],
										'sort_column'      => 'menu_order',
										'sort_order'       => 'ASC',
										'show_option_none' => __( '--no page--', 'autoroyal' ),
										'echo'             => false,
										'selected'         => absint( $value )
									);

									echo str_replace(' id=', " data-placeholder='" . __( 'Select a page&hellip;', 'autoroyal' ) .  "' id=", wp_dropdown_pages( $args ) );

									if ( !empty($option['desc']) ) {
										echo ' <p class="description">' . $option['desc'] . '</p>';
									}

								break;
								case "password" :

									?><input id="setting-<?php echo $option['name']; ?>" class="regular-text" type="password" name="<?php echo $option['name']; ?>" value="<?php echo esc_attr( $value ); ?>" <?php echo implode( ' ', $attributes ); ?> <?php echo $placeholder; ?> /><?php

									if ( !empty($option['desc']) ) {
										echo ' <p class="description">' . $option['desc'] . '</p>';
									}

								break;
								case "number" :
									?><input id="setting-<?php echo $option['name']; ?>" class="regular-text" type="number" name="<?php echo $option['name']; ?>" value="<?php echo esc_attr( $value ); ?>" <?php echo implode( ' ', $attributes ); ?> <?php echo $placeholder; ?> /><?php

									if ( !empty($option['desc']) ) {
										echo ' <p class="description">' . $option['desc'] . '</p>';
									}
								break;
								case "" :
								case "input" :
								case "text" :
									?><input id="setting-<?php echo $option['name']; ?>" class="regular-text" type="text" name="<?php echo $option['name']; ?>" value="<?php echo esc_attr( $value ); ?>" <?php echo implode( ' ', $attributes ); ?> <?php echo $placeholder; ?> /><?php

									if ( !empty($option['desc']) ) {
										echo ' <p class="description">' . $option['desc'] . '</p>';
									}
								break;
								default :
									do_action( 'autoroyal_admin_field_' . $option['type'], $option, $attributes, $value, $placeholder );
								break;

							}

							echo '</td></tr>';
						}

						echo '</table></div>';

					}
				?>
				<p class="submit">
					<input type="submit" class="button-primary" value="<?php _e( 'Save Changes', 'autoroyal' ); ?>" />
				</p>
		    </form>
		</div>
		<script type="text/javascript">
			jQuery('.nav-tab-wrapper a').click(function() {
				jQuery('.settings_panel').hide();
				jQuery('.nav-tab-active').removeClass('nav-tab-active');
				jQuery( jQuery(this).attr('href') ).show();
				jQuery(this).addClass('nav-tab-active');
				return false;
			});
			jQuery('.nav-tab-wrapper a:first').click();
			jQuery('#setting-autoroyal_enable_registration').change(function(){
				if ( jQuery( this ).is(':checked') ) {
					jQuery('#setting-autoroyal_registration_role').closest('tr').show();
					jQuery('#setting-autoroyal_registration_username_from_email').closest('tr').show();
				} else {
					jQuery('#setting-autoroyal_registration_role').closest('tr').hide();
					jQuery('#setting-autoroyal_registration_username_from_email').closest('tr').hide();
				}
			}).change();
		</script>
		<?php
	}
}
