
jQuery(document).ready(function($) {


    jQuery("#overview-listing-yesterday-next:enabled").on( "click" , function( e ){
        e.preventDefault();
        
        if (e.target.disabled) { // or this.disabled
            return;
        }
        
        getData ( listing_yesterday_ajax_object.ajax_url, listing_yesterday_ajax_object.userId, listing_yesterday_ajax_object.userRole, listing_yesterday_ajax_object.startDate, listing_yesterday_ajax_object.endDate, listing_yesterday_ajax_object.linkStartDate, listing_yesterday_ajax_object.linkEndDate, listing_yesterday_ajax_object.visitorId, ++listing_yesterday_ajax_object.paged, listing_yesterday_ajax_object.totalCount, listing_yesterday_ajax_object.totalRowCount );
    });


    jQuery("#overview-listing-yesterday-previous:enabled").on( "click" , function( e ){
        e.preventDefault();
        
        if (e.target.disabled || listing_yesterday_ajax_object.paged == 1 ) { // or this.disabled
            return;
        }
        
        getData ( listing_yesterday_ajax_object.ajax_url, listing_yesterday_ajax_object.userId, listing_yesterday_ajax_object.userRole, listing_yesterday_ajax_object.startDate, listing_yesterday_ajax_object.endDate, listing_yesterday_ajax_object.linkStartDate, listing_yesterday_ajax_object.linkEndDate, listing_yesterday_ajax_object.visitorId, --listing_yesterday_ajax_object.paged, listing_yesterday_ajax_object.totalCount, listing_yesterday_ajax_object.totalRowCount );
    });

    function getData( ajax_url, userId, userRole, startDate, endDate, linkStartDate, linkEndDate, visitorId, paged, totalCount, totalRowCount )
    {
        jQuery('body').css('cursor', 'wait');
        jQuery(this).css('cursor', 'wait');

        var data = {
            'action':       'ct_getListingAjax',
            'userId':       userId,
            'userRole':     userRole,
            'startDate':    startDate,
            'visitorId':    visitorId,
            'endDate':      endDate,
            'paged':        paged,
            'totalCount':   totalCount,
            'totalRowCount':totalRowCount
        };


        jQuery.get( ajax_url, data, function(response) {

            if( response != "" ) {
                
                output = "";

                var arr = JSON.parse( response );
    

                for( x = 0; x < arr["item"].length; x++) {
                    output = output + "<tr><td><a href=\"?listing-id=" +  arr["item"][x]["listingId"] + "&startDate=" + linkStartDate + "&endDate=" + linkEndDate + "\">" + arr["item"][x]["title"] + "</a></td><td class=\"center\">" + arr["item"][x]["count"] + "</td></tr>";
                }
                

                if ( paged > 1 ) {
                    jQuery("#overview-listing-yesterday-previous").removeClass( "disabled" );
                    jQuery("#overview-listing-yesterday-previous").prop("disabled", false);
                } else {
                    jQuery("#overview-listing-yesterday-previous").addClass( "disabled" );
                    jQuery("#overview-listing-yesterday-previous").prop("disabled", true);
                }

                if ( ( paged * 10 ) >= totalRowCount ) {
                    jQuery("#overview-listing-yesterday-next").addClass( "disabled" );
                    jQuery("#overview-listing-yesterday-next").prop("disabled", true);
                } else {
                    jQuery("#overview-listing-yesterday-next").removeClass( "disabled" );
                    jQuery("#overview-listing-yesterday-next").prop("disabled", false);
                }

                jQuery("#overview-listing-yesterday-table").html( output ); 

                jQuery('body').css('cursor', 'default');
                jQuery(this).css('cursor', 'default');
        
            }
    
        });
    }

    
});