
jQuery(document).ready(function($) {


    jQuery("#overview-listing-today-next:enabled").on( "click" , function( e ){

        e.preventDefault();

        if (e.target.disabled) { // or this.disabled
            return;
        }

        getData ( listing_today_ajax_object.ajax_url, listing_today_ajax_object.userId, listing_today_ajax_object.userRole, listing_today_ajax_object.startDate, listing_today_ajax_object.endDate, listing_today_ajax_object.linkStartDate, listing_today_ajax_object.linkEndDate, listing_today_ajax_object.visitorId, ++listing_today_ajax_object.paged, listing_today_ajax_object.totalCount, listing_today_ajax_object.totalRowCount );
    });


    jQuery("#overview-listing-today-previous:enabled").on( "click" , function( e ){

        e.preventDefault();

        if (e.target.disabled || listing_today_ajax_object.paged == 1 ) { // or this.disabled
            return;
        }

        getData ( listing_today_ajax_object.ajax_url, listing_today_ajax_object.userId, listing_today_ajax_object.userRole, listing_today_ajax_object.startDate, listing_today_ajax_object.endDate, listing_today_ajax_object.linkStartDate, listing_today_ajax_object.linkEndDate, listing_today_ajax_object.visitorId,  --listing_today_ajax_object.paged, listing_today_ajax_object.totalCount, listing_today_ajax_object.totalRowCount );
    });
    

    function getData( ajax_url, userId, userRole, startDate, endDate, linkStartDate, linkEndDate, visitorId,paged, totalCount, totalRowCount )
    {
        jQuery('body').css('cursor', 'wait');
        jQuery(this).css('cursor', 'wait');

        var data = {
            'action':       'ct_getListingAjax',
            'userId':       userId,
            'userRole':     userRole,            
            'startDate':    startDate,
            'endDate':      endDate,
            'visitorId':    visitorId,
            'paged':        paged,
            'totalCount':   totalCount,
            'totalRowCount':totalRowCount
        };

        //alert( "ajax_url: " + ajax_url + "\r\nuserId: " + userId + "\r\nuserRole: " + userRole + "\r\nstartDate: " + startDate + "\r\nendDate: " + endDate + "\r\nlinkStartDate: " + linkStartDate + "\r\nlinkEndDate: " + linkEndDate + "\r\nvisitorId: " + visitorId + "\r\npaged: " + paged + "\r\ntotalCount: " + totalCount + "\r\ntotalRowCount: " + totalRowCount)

        jQuery.get( ajax_url, data, function(response) {

            if( response != "" ) {
                
                output = "";

                var arr = JSON.parse( response );
    

                for( x = 0; x < arr["item"].length; x++) {
                    output = output + "<tr><td><a href=\"?listing-id=" +  arr["item"][x]["listingId"] + "&startDate=" + linkStartDate + "&endDate=" + linkEndDate + "\">" + arr["item"][x]["title"] + "</a></td><td class=\"center\">" + arr["item"][x]["count"] + "</td></tr>";
                }
                

                if ( paged > 1 ) {
                    jQuery("#overview-listing-today-previous").removeClass( "disabled");
                    jQuery("#overview-listing-today-previous").prop("disabled", false);
                } else {
                    jQuery("#overview-listing-today-previous").addClass( "disabled");
                    jQuery("#overview-listing-today-previous").prop("disabled", true);
                }

                if ( ( paged * 10 ) >= totalRowCount ) {
                    jQuery("#overview-listing-today-next").addClass( "disabled");
                    jQuery("#overview-listing-today-next").prop("disabled", true);
                } else {
                    jQuery("#overview-listing-today-next").removeClass( "disabled");
                    jQuery("#overview-listing-today-next").prop("disabled", false);
                }

                jQuery("#overview-listing-today-table").html( output ); 

                jQuery('body').css('cursor', 'default');
                jQuery(this).css('cursor', 'default');
            }
    
        });
    }

    
});