
jQuery(document).ready(function($) {

    
    jQuery("#overview-download-today-next").on( "click" , function( e ){

        e.preventDefault();

        if (e.target.disabled) { // or this.disabled
            return;
        }

        getData ( download_today_ajax_object.ajax_url, download_today_ajax_object.userId, download_today_ajax_object.userRole, download_today_ajax_object.startDate, download_today_ajax_object.endDate, download_today_ajax_object.linkStartDate, download_today_ajax_object.linkEndDate, ++download_today_ajax_object.paged, download_today_ajax_object.totalCount, download_today_ajax_object.totalRowCount );
    });



    jQuery("#overview-download-today-previous:enabled").on( "click" , function( e ){

        e.preventDefault();

        if (e.target.disabled || download_today_ajax_object.paged == 1 ) { // or this.disabled
            return;
        }

        getData ( download_today_ajax_object.ajax_url, download_today_ajax_object.userId, download_today_ajax_object.userRole, download_today_ajax_object.startDate, download_today_ajax_object.endDate, download_today_ajax_object.linkStartDate, download_today_ajax_object.linkEndDate, --download_today_ajax_object.paged, download_today_ajax_object.totalCount, download_today_ajax_object.totalRowCount );
    });

    function getData( ajax_url, userId, userRole, startDate, endDate, linkStartDate, linkEndDate, paged, totalCount, totalRowCount )
    {
    
        //alert( "url: " + ajax_url + "\r\nuserId: " + userId + "\r\nuserRole: " + userRole + "\r\nstartDate: " + startDate + "\r\nendDate: " + endDate + "\r\nlinkStartDate: " + linkStartDate + "\r\nlinkEndDate: " + linkEndDate + "\r\npaged: " + paged + "\r\ntotalCount: " + totalCount + "\r\ntotalRowCount: " + totalCount);
        
        jQuery('body').css('cursor', 'wait');
        jQuery(this).css('cursor', 'wait');

        perPage = 10;

        var data = {
            'action':       'ct_getDownloadAjax',
            'userId':       userId,
            'userRole':     userRole,             
            'startDate':    startDate,
            'endDate':      endDate,
            'paged':        paged,
            'totalCount':   totalCount,
            'totalRowCount':totalRowCount
        };

        jQuery.get( ajax_url, data, function(response) {

            if( response != "" ) {
                
                output = "";

                var arr = JSON.parse( response );

                for( x = 0; x < arr["item"].length; x++) {
                    output = output + "<tr><td><a href=\"?listing-id=" +  arr["item"][x]["listingId"] + "&download-name=" +  arr["item"][x]["downloadName"] + "&startDate=" + linkStartDate + "&endDate=" + linkEndDate + "\">" + arr["item"][x]["downloadName"] + " [" + arr["item"][x]["title"] + "]</a></td><td>" + arr["item"][x]["count"] + "</td></tr>";
                }     


                if ( paged > 1 ) {
                    jQuery("#overview-download-today-previous").removeClass( "disabled" );
                    jQuery("#overview-download-today-previous").prop("disabled", false);
                } else {
                    jQuery("#overview-download-today-previous").addClass( "disabled" );
                    jQuery("#overview-download-today-previous").prop("disabled", true);
                }

                if ( ( paged * 10 ) >= totalRowCount ) {
                    jQuery("#overview-download-today-next").addClass( "disabled" );
                    jQuery("#overview-download-today-next").prop("disabled", true);
                } else {
                    jQuery("#overview-download-today-next").removeClass( "disabled" );
                    jQuery("#overview-download-today-next").prop("disabled", false);
                }



                jQuery("#overview-download-today-table").html( output ); 

                jQuery('body').css('cursor', 'default');
                jQuery(this).css('cursor', 'default');
            }
    
        });
    }

});