
jQuery(document).ready(function($) {


    jQuery( document ).on( "click" , ".ct-listing-paged", function( e ) {
        e.preventDefault();

        detail_listing_ajax_object.paged = jQuery(this).attr("data-paged");

        getData ( detail_listing_ajax_object.ajax_url, detail_listing_ajax_object.userId, detail_listing_ajax_object.userRole, detail_listing_ajax_object.listingId, detail_listing_ajax_object.startDate, detail_listing_ajax_object.endDate, detail_listing_ajax_object.visitorId, detail_listing_ajax_object.paged, detail_listing_ajax_object.totalCount );

    });  

    jQuery( document ).on( "click", "#detail-listing-next", function( e ) {
        
        e.preventDefault();
        getData ( detail_listing_ajax_object.ajax_url, detail_listing_ajax_object.userId, detail_listing_ajax_object.userRole, detail_listing_ajax_object.listingId, detail_listing_ajax_object.startDate, detail_listing_ajax_object.endDate, detail_listing_ajax_object.visitorId, ++detail_listing_ajax_object.paged, detail_listing_ajax_object.totalCount );
    
    });


    jQuery( document ).on( "click" , "#detail-listing-previous", function( e ) {

        e.preventDefault();
        getData ( detail_listing_ajax_object.ajax_url, detail_listing_ajax_object.userId, detail_listing_ajax_object.userRole, detail_listing_ajax_object.listingId, detail_listing_ajax_object.startDate, detail_listing_ajax_object.endDate, detail_listing_ajax_object.visitorId, --detail_listing_ajax_object.paged, detail_listing_ajax_object.totalCount );
    
    });

    function getPagination( totalItems, perPage, currentPage )
    {

        pages = parseInt( totalItems / perPage )
        if ( totalItems % perPage  > 0 ) {
            pages++;
        }


        //alert("pages: "  + pages + "\r\ncurrentPage: " + currentPage);

        if ( pages == 1 ) {
            return "";
        }

        out = "";

        if ( currentPage > 1 ) {
            out = "<li><a href=\"\" data-paged=\"" + (currentPage -1) + "\" id=\"detail-listing-previous\">Previous</a></li>";
        }

        className = "";
        if ( currentPage == 1 ) {
            className = " class=\"current\" ";
        }

        out = out + "<li " + className  + "><a href=\"\" data-paged=\"1\" class=\"ct-listing-paged\">1</a></li>";

        x = 2;
        for( x = 2; x <= ((pages<3)?pages:3); x++ ) {
            
            className = "";
            if ( currentPage == x ) {
                className = " class=\"current\" ";
            }

            out = out + "<li " + className  + "><a href=\"\" data-paged=\"" + x + "\" class=\"ct-listing-paged\">" + x +"</a></li>";
        }
        

        x--;
        if ( x < pages ) {
            y = pages - 2;
            if ( y <= (x + 1) ) {
                y = x + 1;
            } else {
                out = out + "<li>...</li>";
            }

            for( y = y; y <= pages; y++ ) {
                className = "";
                if ( currentPage == y ) {
                    className = " class=\"current\" ";
                }
    
                out = out + "<li " + className  + "><a href=\"\" data-paged=\"" + y + "\" class=\"ct-listing-paged\">" + y + "</a></li>";
            }
        }

        if ( currentPage < pages ) {
            out = out + "<li id=\"next-page-link\"><a href=\"\" data-paged=\"" + (currentPage + 1) + "\" id=\"detail-listing-next\">Next</a></li>";
        }

        out = out + "<div class=\"clear\"></div>";
        out = out + "</ul>";

        return out;
        
    }


    function getData( ajax_url, userId, userRole, listingId, startDate, endDate, visitorId, paged, totalCount )
    {
          
        //alert( "url: " + ajax_url + "\r\nuserId: " + userId + "\r\nuserRole: " + userRole + "\r\nstartDate: " + startDate + "\r\nendDate: " + endDate + "\r\nlistingId: " + listingId + "\r\nvisitorId: " + visitorId + "\r\npaged: " + paged + "\r\ntotalCount: " + totalCount);
        
    

        jQuery('body').css('cursor', 'wait');
        jQuery(this).css('cursor', 'wait');

        var data = {
            'action':       'ct_getListingDetailAjax',
            'userId':       userId,
            'userRole':     userRole,
            'visitorId':    visitorId,
            'startDate':    startDate,
            'endDate':      endDate,
            'paged':        paged,
            'listingId':    listingId,
            'totalCount':   totalCount
        };

        //alert("paged: " + paged + "\r\ntotalCount: " + totalCount );
        out = getPagination( totalCount, 10, paged );
        
        jQuery.get( ajax_url, data, function(response) {

            if( response != "" ) {
                
                output = "";

                var arr = JSON.parse( response );

                for( x = 0; x < arr["item"].length; x++) {
                    output = output + "<tr>";
                    
                    if ( visitorId > 0 ) {
                        output = output + "<td>";
                        output = output + arr["item"][x]["listingTitle"];
                        output = output + "</td>";
                    }    
                    
                    output = output + "<td>";
                    
                    if ( ! isNaN( arr["item"][x]["user"] ) ) {

                        role = arr["item"][x]["role"];
                        role = role.toLowerCase().replace(/\b[a-z]/g, function(letter) {
                            return letter.toUpperCase();
                        });

                        output = output + "<a href=\"./?listing-id=" + arr["item"][x]["listingId"] + "&startDate=" + startDate + "&endDate=" + endDate + "&visitorId=" + arr["item"][x]["user"] + "\">(" + arr["item"][x]["user"] + ") " + role + "</a>";
                                    
                    } else {
                        output = output + arr["item"][x]["user"];
                    }
                    

                    output = output + "</td><td>" +  arr["item"][x]["firstName"] + "</td><td>" +  arr["item"][x]["lastName"] + "</td><td><a href=\"mailto:" +  arr["item"][x]["email"] + "\" target=\"_blank\">" +  arr["item"][x]["email"] + "</a></td><td>" +  arr["item"][x]["mobile"] + "</td></tr>"; 
                }
                

                jQuery("#detail-listing-table").html( output ); 
                                
                jQuery('body').css('cursor', 'default');
                jQuery(this).css('cursor', 'default');
                jQuery(".pagination").html( out );
            }
    
        });
    }

    
});