<?php
/**
 * Template Name: Landing Page
 *
 * @package WP Pro Real Estate 7
 * @subpackage Template
 */

if (!empty($_GET['search-listings'])) {
    get_template_part('search-listings');
    return;
}
 
global $ct_options; 

$inside_page_title = get_post_meta($post->ID, "_ct_inner_page_title", true);
$top_page_margin = get_post_meta($post->ID, "_ct_top_page_margin", true);
$bottom_page_margin = get_post_meta($post->ID, "_ct_bottom_page_margin", true);

get_header();

while ( have_posts() ) : the_post();

// Don't show header and footer
echo '<style>
	.page-template-template-landing #topbar-wrap,
	.page-template-template-landing #header-wrap,
	.page-template-template-landing #header-search-wrap,
	.page-template-template-landing #footer-widgets,
	.page-template-template-landing footer { display: none;}
	</style>';

if($inside_page_title == "Yes") { 
	// Custom Page Header Background Image
	if(get_post_meta($post->ID, '_ct_page_header_bg_image', true) != '') {
		echo'<style type="text/css">';
		echo '#single-header { background: url(';
		echo get_post_meta($post->ID, '_ct_page_header_bg_image', true);
		echo ') no-repeat center center; background-size: cover;}';
		echo '</style>';
	} ?>

	<!-- Single Header -->
	<div id="single-header">
		<div class="dark-overlay">
			<div class="container">
				<h1 class="marT0 marB0"><?php the_title(); ?></h1>
				<?php if(get_post_meta($post->ID, '_ct_page_sub_title', true) != '') { ?>
					<h2 class="marT0 marB0"><?php echo get_post_meta($post->ID, "_ct_page_sub_title", true); ?></h2>
				<?php } ?>
			</div>
		</div>
	</div>
	<!-- //Single Header -->
<?php } ?>

<div id="page-content" class="container <?php if($top_page_margin != "No") { echo 'marT60'; } ?> <?php if($bottom_page_margin != "No") { echo 'padB60'; } ?>">
    
    <article class="col span_12">
        
		<?php the_content(); ?>
        
        <?php //wp_link_pages( array( 'before' => '<div class="page-link"><span>' . __( 'Pages:', 'contempo' ) . '</span>', 'after' => '</div>' ) ); ?>
        
        <?php endwhile; ?>
        
            <div class="clear"></div>

    </article>

<?php 
	echo '<div class="clear"></div>';
echo '</div>';

get_footer(); ?>