<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>

	<div class="autoroyal-front-dashboard">

        <div id="primary" class="content-area">

            <main id="main" class="site-main">

                <div class="autoroyal-page-title">

                    <div class="container">

                        <h2><?php the_title(); ?></h2>
                        
                    </div>

                </div>

                <div class="container">

                    <div class="row">

                        <div class="autoroyal-full-width-page col-md-12 autoroyal-woocommerce-page">

                            <div class="row justify-content-center">
                                
                                <?php if ( is_active_sidebar( 'shop' ) ) : ?>
                                    <div class="col-md-4 fantasy-themes-sidebar-width">
                                        <aside class="widget-area sidebar-1-area shop-area mb-2 card">
                                            <?php dynamic_sidebar( 'shop' ); ?>
                                        </aside>
                                    </div>
                                <?php endif; ?>

                                <div class="col-md-8 fantasy-themes-content-width">

                                    <?php while ( have_posts() ) : the_post(); ?>

										<?php wc_get_template_part( 'content', 'single-product' ); ?>

									<?php endwhile; // end of the loop. ?>

                                </div>

                            </div>

                        </div>

                    </div>

                </div>

            </main><!-- #main -->

        </div><!-- #primary -->

    </div>

<?php get_footer( 'shop' ); ?>
