<!DOCTYPE html>
<html>
	<head>

		<!-- Basic -->
		<meta charset="utf-8">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">	

		<title>Ana Gaby González – Comunicación y Alianzas para transformar al mundo</title>	

		<meta name="keywords" content="Onu, agenda 2030, objetivos de desarrollo sostenible, ODS, cambiar al mundo, desarrollo sustentable, Visionarios 2030, metas de desarrollo sostenible, gobierno de México, organización de las naciones unidas, " />
		<meta name="description" content="Somos la plataforma de comunicación que potencia la voz de los líderes mexicanos que están cambiando al mundo.">
		<meta name="author" content="LeadME Internet Marketing">

		<!-- Favicon -->
		<link rel="apple-touch-icon" sizes="180x180" href="archivos/favicon/apple-touch-icon.png">
		<link rel="icon" type="image/png" sizes="32x32" href="archivos/favicon/favicon-32x32.png">
		<link rel="icon" type="image/png" sizes="16x16" href="archivos/favicon/favicon-16x16.png">
		<link rel="manifest" href="archivos/favicon/site.webmanifest">
		<link rel="mask-icon" href="archivos/favicon/safari-pinned-tab.svg" color="#5bbad5">
		<meta name="msapplication-TileColor" content="#da532c">
		<meta name="theme-color" content="#ffffff">

		<!-- Mobile Metas -->
		<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1.0, shrink-to-fit=no">

		<!-- Vendor CSS -->
		<link rel="stylesheet" href="vendor/bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="vendor/fontawesome-free/css/all.min.css">
		<link rel="stylesheet" href="vendor/animate/animate.compat.css">
		<link rel="stylesheet" href="vendor/simple-line-icons/css/simple-line-icons.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.carousel.min.css">
		<link rel="stylesheet" href="vendor/owl.carousel/assets/owl.theme.default.min.css">
		<link rel="stylesheet" href="vendor/magnific-popup/magnific-popup.min.css">

        <!-- Theme CSS -->
		<link rel="stylesheet" href="css/theme.css">
		<link rel="stylesheet" href="css/theme-elements.css">

		<!-- Skin CSS -->
		<link id="skinCSS" rel="stylesheet" href="css/skins/skin-corporate-10.css">

		<!-- Theme Custom CSS -->
		<link rel="stylesheet" href="css/custom.css">
		<link rel="stylesheet" href="css/visionarios-person.css">

		<!-- Head Libs -->
		<script src="vendor/modernizr/modernizr.min.js"></script>

	</head>
	<body class="visionarioChangeFooter" data-plugin-page-transition>
		<div class="body headerWhite">
            <!-- Main header -->
			<?php include('main-header.php')?>
            <!-- End Main Header -->

			<div role="main" class="main">
				<!-- Slide -->
				<section class="section section-with-shape-divider border-0 py-0 m-0" id="slideVisionarioPerson">
					<div class="shape-divider shape-divider-bottom z-index-3" style="height: 136px;">
						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 136" preserveAspectRatio="xMinYMin">
							<path d="M 0 0.11 L 0 136 L 1920 136 L 1920 1.9 C 1650.0482 79.0955 1327.0648 134 980 134 C 615.6218 134 277.7878 84.5059 0 0.11 Z" fill="#c7212f"/>
						</svg>
					</div>
					<div class="owl-carousel owl-carousel-light owl-carousel-light-init-fadeIn owl-theme manual dots-inside dots-horizontal-center show-dots-hover show-dots-xs nav-style-1 nav-inside nav-inside-plus nav-primary nav-md nav-font-size-md show-nav-hover mb-0" data-plugin-options="{'autoplayTimeout': 9000, 'autoplay': false }" style="height: 100vh;">
						<div class="owl-stage-outer">
							<div class="owl-stage">

								<!-- Carousel Slide 1 -->
								<div class="owl-item position-relative" style="background-image: url(archivos/ficha-experto/Visionarios-2030-Ficha-Experto-VIP-Ana-Gaby-Banner.jpg); background-size: cover; background-position: center; height: 100vh;">
									<div class="container position-relative z-index-3 h-100">
										<div class="row justify-content-center align-items-center h-100">
											<div class="col-lg-9">
												<div class="d-flex flex-column align-items-center">
													<h1 class="position-relative text-color-light text-4 px-4 mb-2 appear-animation smallTitleSlide" data-appear-animation="fadeInDownShorter" data-plugin-options="{'minWindowWidth': 0}">
														<span class="position-absolute right-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
														<span class="">VISIONARIA </span>11.7 / 5.2
														<span class="position-absolute left-100pct top-50pct transform3dy-n50" style="background: var(--verde);width: 120px;height: 13px;"></span>
													</h1>
													<p class="text-4 text-center mb-0 titleSlide azul" ><span class="blanco">Ana Gaby </span> González</p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>

				<!-- Frase -->
				<section id="fraseInicioPersona" class="color1">
					<div class="container">
						<div class="row">
							<div class="col-md-9 mx-md-auto appear-animation maskUp appear-animation-visible" data-appear-animation="maskUp">
								<p class="text"><span class="blanco">«Trabajo para </span> <span class="naranja">construir ciudades más humanas y habitables,</span> 
                                <span class="blanco">que permitan estar bien a </span><span class="blanco cursive">niñas y mujeres».</span></p>
							</div>
						</div>
					</div>
				</section>
				<!-- End Frase -->

				<!-- Descripción Persona -->
				<section id="descriptionPersonVisionario" class="">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-7">
                                <div class="heading">
                                    <p class="title">ANA GABY GONZÁLEZ</p>
                                    <p class="subtitle">Visionaria 11.7 / 5.2</p>
                                </div>
                                <div class="description">
                                    <p class="text">Soy <span class="cursive">Ana Gaby González,</span> Maestra en Administración Pública por la Universidad de Columbia donde me especialicé en políticas públicas de desarrollo urbano y social con perspectiva de género.</p>
                                    <p class="text">Coordino las oficinas de representación en los estados en la Secretaría de Desarrollo Agrario, Territorial y Urbano (SEDATU), pertenezco al grupo Democracia Deliberada, y soy académica del Colmex, mi alma mater.</p>
                                    <p class="text">Desde niña he creído que, para “estar bien”, las mujeres merecen vivir en un ambiente seguro. </p>
                                    <p class="text">Mi lugar favorito es el espacio público, las calles y los parques. Me encanta viajar por el país para conocer nuestra diversidad y riqueza cultural, empezando por la comida. Me encanta hacer amigos y aliados.</p>
                                    <ul class="list">
                                        <p>Espacios de acción:</p>
                                        <li>Dirección general de Coordinación de Oficina de Representación en los estados en la Secretaría de Desarrollo Agrario, Territorial y Urbano, SEDATU</li>
                                        <li>Integrante del grupo político Democracia Deliberada</li>
                                        <li>Académica del Colmex</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <img class="img-fluid" src="archivos/ficha-experto/Visionarios-2030-Ficha-Experto-VIP-Ana-Gaby-color.jpg" alt="ANA GABY GONZÁLEZ">
                            </div>
                        </div>
                    </div>
                </section>
				<!-- End Descripcion Persona -->

                <!-- Trabajo Visionario -->
                <div id="trabajosVisionario" class="curved-border curved-border-top curved-morado">
                    <div class="container container-xl-custom">
                        <div class="row text-center text-lg-start rowProject">
                            <div class="col-lg-7 appear-animation" style="position: relative;" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
                                <p class="smallTitle">OBJETIVOS DE DESARROLLO SONTENIBLE</p>
                                <h2 class="title naranja">ODS 11.7 Ciudades y comunidades 
                                    sostenibles</h2>
                                <p class="mb-4 text">De aquí a 2030, proporcionar acceso universal a zonas verdes y espacios públicos seguros, inclusivos y accesibles, en particular para las mujeres y los niños.</p>
								<a href="#" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded">VER MÁS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
                            </div>
                            <div class="col-md-5 col-lg-5 px-2 mt-3 mt-lg-0 appear-animation boxImgRight" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
                                <img src="archivos/icons/S_SDG_Icons-01-11.jpeg" class="img-fluid work" alt=""/>
                            </div>
                        </div>
                        <div class="row text-center text-lg-start rowProject reverse pt-60">
                            <div class="col-lg-7 appear-animation order-2" style="position: relative;" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="200">
                                <p class="smallTitle">OBJETIVOS DE DESARROLLO SONTENIBLE</p>
                                <h2 class="title rojo">ODS 5.2 Igualdad de género</h2>
                                <p class="mb-4 text">Eliminar toda forma de violencia contra las mujeres y las niñas.</p>
								<a href="#" class="btn text-color-light px-4 py-2 btn-py-2 text-1 rounded">VER MÁS <i class="fa fa-arrow-right ms-2 ps-1 text-3"></i></a>
                            </div>
                            <div class="col-md-5 col-lg-5 px-2 mt-3 mt-lg-0 appear-animation boxImgLeft order-1" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="400">
                                <img src="archivos/icons/S_SDG_Icons-01-05.jpeg" class="img-fluid work" alt=""/>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End trabajo visionario -->

                <!-- Metas Visionario -->
                <section class="section bg-light section-with-shape-divider border-0 py-0 m-0">
                    <div class="shape-divider shape-divider-bottom z-index-3" style="height: 136px;">
						<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 1920 136" preserveAspectRatio="xMinYMin">
							<path d="M 0 0.11 L 0 136 L 1920 136 L 1920 1.9 C 1650.0482 79.0955 1327.0648 134 980 134 C 615.6218 134 277.7878 84.5059 0 0.11 Z" fill="#144a6b"/>
						</svg>
					</div>
                    <div class="container metas">
                        <div class="row justify-content-center">
                            <div class="col-lg-8 text-center">
                                <div class="overflow-hidden mb-3">
                                    <h2 class="title appear-animation" data-appear-animation="maskUp">Metas <span class="color1">2030</span></h2>
                                </div>
                            </div>
                        </div>
                        <div class="row justify-content-center pb-5">
                            <div class="col-md-7 col-lg-4 mb-5 mb-lg-0">
                                <div class="circular-bar appear-animation" data-appear-animation="fadeInLeftShorter" data-appear-animation-delay="600">
                                    <div class="circular-bar-chart" data-percent="100" data-plugin-options="{'barColor': '#c7212f'}">
                                        <span class="mt-2 percentNumber">100%</span>
                                    </div>
                                </div>
                                <div class="col text-center appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="900">
                                    <h4 class="titleNumber color1">2020</h4>
                                    <p class="px-3 text">Diseñar un modelo de parque central para las 74 zonas metropolitanas de México.</p>
                                </div>
                            </div>

                            <div class="col-md-7 col-lg-4 mb-5 mb-lg-0">
                                <div class="circular-bar appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="400">
                                    <div class="circular-bar-chart" data-percent="50" data-plugin-options="{'barColor': '#c7212f'}">
                                        <span class="mt-2 percentNumber">50%</span>
                                    </div>
                                </div>
                                <div class="col text-center appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="900">
                                    <h4 class="titleNumber color1">2025</h4>
                                    <p class="px-3 text">Plan de espacios públicos seguros para mujeres.</p>
                                </div>
                            </div>

                            <div class="col-md-7 col-lg-4">
                                <div class="circular-bar appear-animation" data-appear-animation="fadeInRightShorter" data-appear-animation-delay="600">
                                    <div class="circular-bar-chart" data-percent="25" data-plugin-options="{'barColor': '#c7212f'}">
                                        <span class="mt-2 percentNumber">25%</span>
                                    </div>
                                </div>
                                <div class="col text-center appear-animation" data-appear-animation="fadeIn" data-appear-animation-delay="900">
                                    <h4 class="titleNumber color1">2030</h4>
                                    <p class="px-3 text">Que las 74 zonas metropolitanas tengan un plan de parque central seguro, y fácil de replicar.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                
                <!-- End Metas Visionario -->

                <!-- Contacto Visionario -->
                <div id="contactoVisionario" class="" data-spy-offset="15">
                    <div class="">
                        <div class="container">
                            <div class="row">
                                <div class="col-lg-6 text-center pb-3 pb-lg-0 mb-5 mb-lg-0 border-right">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="row pb-5 mb-5">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'top', 'speed': 0.2, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-twitter icon color1"></i>
                                                        <h4 class="mb-0 titleLink">Twitter</h4>
                                                        <a href="#" class="mb-0 link">@anagonmx</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'bottom', 'speed': 0.2, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-facebook-f icon color1"></i>
                                                        <h4 class=" mb-0 titleLink">Facebook</h4>
                                                        <a href="https://www.facebook.com/anagonmx/" target="_blank" class="mb-0 link">facebook.com/anagonmx</a>
                                                    </div>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-6 pt-5">
                                            <div class="row pb-5 mb-5">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'bottom', 'speed': 0.1, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-linkedin-in icon color1"></i>
                                                        <h4 class="mb-0 titleLink">Linkedin</h4>
                                                        <a href="https://www.linkedin.com/in/anagonmx/" target="_blank" class="mb-0 link">linkedin.com/in/anagonmx</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col">
                                                    <div data-plugin-float-element data-plugin-options="{'startPos': 'bottom', 'speed': 0.1, 'isInsideSVG': true, 'transition': true, 'transitionDuration': 2000}">
                                                        <i class="fab fa-instagram icon color1"></i>
                                                        <h4 class="mb-0 titleLink">Instagram</h4>
                                                        <a href="https://www.instagram.com/anagonmx/" target="_blank" class="mb-0 link">@anagonmx</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-6 ps-lg-5 flexBox">
                                    <div class="heading">
                                        <p class="smallTitle">COMUNÍCATE</p>
                                        <p class="title">Contacto</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End Contacto Visionario -->

			</div>

			<?php include('footer.php')?>
		</div>

		<!-- Vendor -->
		<script src="vendor/jquery/jquery.min.js"></script>
		<script src="vendor/jquery.appear/jquery.appear.min.js"></script>
		<script src="vendor/jquery.easing/jquery.easing.min.js"></script>
		<script src="vendor/jquery.cookie/jquery.cookie.min.js"></script>
		<script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
		<script src="vendor/jquery.validation/jquery.validate.min.js"></script>
		<script src="vendor/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
		<script src="vendor/jquery.gmap/jquery.gmap.min.js"></script>
		<script src="vendor/lazysizes/lazysizes.min.js"></script>
		<script src="vendor/isotope/jquery.isotope.min.js"></script>
		<script src="vendor/owl.carousel/owl.carousel.min.js"></script>
		<script src="vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
		<script src="vendor/vide/jquery.vide.min.js"></script>
		<script src="vendor/vivus/vivus.min.js"></script>

		<!-- Theme Base, Components and Settings -->
		<script src="js/theme.js"></script>

		<!-- Current Page Vendor and Views -->
		<script src="js/views/view.contact.js"></script>

		<!-- Theme Custom -->
		<script src="js/custom.js"></script>

		<!-- Theme Initialization Files -->
		<script src="js/theme.init.js"></script>

	</body>
</html>
